/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mw.rfc.driver;

import com.sap.mw.jco.util.FastStringBuffer;
import com.sap.mw.rfc.api.RfcOptions;
import com.sap.mw.rfc.api.RfcRegisterInfo;
import com.sap.mw.rfc.driver.CpicDriver;
import com.sap.mw.rfc.engine.ConvIdMap;
import com.sap.mw.rfc.engine.RfcAcceptInfo;
import com.sap.mw.rfc.engine.RfcIoOpenCntl;
import com.sap.mw.rfc.engine.Trc;

public final class RfcTypeRegisterCpic
extends CpicDriver {
    public synchronized int listen(byte[] buffer, int bufsize, int[] bytes_read, int timeout) {
        int rc = 0;
        if (this.act_cntl.close_pending) {
            String text = "listen(RfcTypeRegisterCpic) :: Error : (close_pending)";
            if (this.act_cntl.trace) {
                Trc.ab_rfctrc(text);
            }
            Trc.criticalTrace(this.act_cntl, text);
            return 1;
        }
        ConvIdMap.remove(this.conv_id);
        rc = this.cosaccepttp(timeout);
        if (rc != 0) {
            return rc;
        }
        RfcIoOpenCntl exists_cntl = (RfcIoOpenCntl)ConvIdMap.put(this.conv_id, this.act_cntl);
        if (exists_cntl != null && exists_cntl.hrfc != this.act_cntl.hrfc) {
            String errMsg = new StringBuffer(128).append("ab_rfcaccept::accept returns ").append(ConvIdMap.convIdToString(this.conv_id)).append(" that is already using in hanlde ").append(exists_cntl.hrfc).append(". Try once more.").toString();
            Trc.criticalTrace(this.act_cntl.hrfc, errMsg);
            this.setMessageTRC(errMsg);
        }
        return this.coxread(buffer, bufsize, bytes_read, 0);
    }

    public int open(RfcOptions options) {
        return 1;
    }

    public RfcTypeRegisterCpic(RfcIoOpenCntl iocntl) {
        super(iocntl);
    }

    public synchronized int accept(RfcAcceptInfo acceptInfo) {
        RfcRegisterInfo register_info = (RfcRegisterInfo)acceptInfo;
        int[] reg_handle = new int[1];
        int rc = 0;
        this.accepted = false;
        this.deallocated = true;
        this.registered = true;
        this.tp_accepted = false;
        if (register_info.snc_mode) {
            this.act_cntl.snc = true;
        }
        FastStringBuffer gwhost = new FastStringBuffer(256);
        String sapRouter = register_info.saprouter;
        if (sapRouter != null && sapRouter.length() > 0) {
            gwhost.append(sapRouter);
            if (!sapRouter.endsWith("/H/")) {
                gwhost.append("/H/");
            }
        }
        gwhost.append(register_info.gwhost);
        rc = this.SAP_CMREGTP2(register_info.tpname, gwhost.toString(), register_info.gwserv, reg_handle, register_info.snc_myname, register_info.snc_lib, register_info.snc_qop, register_info.snc_mode);
        if (rc != 0) {
            this.registered = false;
            if (this.act_cntl.trace) {
                Trc.ab_rfctrc("accept(RfcTypeRegisterCpic) :: Error : " + rc);
            }
            this.get_rg_info("Connect to SAP gateway failed", register_info);
            return 5;
        }
        this.reg_handle = reg_handle[0];
        this.tOfLastIO = System.currentTimeMillis();
        this.accepted = false;
        this.cpic_waiting = false;
        return 0;
    }

    public synchronized int read(byte[] buffer, int bufsize, int[] bytes_read) {
        int wtime = -1;
        int rc = 0;
        if (this.act_cntl.close_pending) {
            if (this.act_cntl.trace) {
                Trc.ab_rfctrc("wflush(RFCTypeRegisterCpic) :: read : (close_pending)");
            }
            return 1;
        }
        rc = this.cosaccepttp(wtime);
        if (rc != 0) {
            return rc;
        }
        return this.coxread(buffer, bufsize, bytes_read, 0);
    }

    public synchronized int wflush() {
        int rc = 0;
        if (!this.deallocated && this.server_mode && this.act_cntl.unresp_call == 0 && !this.act_cntl.reg_exclusiv) {
            rc = this.CMDEAL(this.conv_id);
            if (rc != 0) {
                if (this.act_cntl.trace) {
                    Trc.ab_rfctrc("wflush(RFCTypeRegisterCpic) :: Error : " + Integer.toString(rc));
                }
                return rc;
            }
            this.deallocated = true;
            this.tp_accepted = false;
            this.act_cntl.identified = false;
        }
        return 0;
    }

    int cosaccepttp(int wtime) {
        if (!this.tp_accepted) {
            int wtime_cpic = wtime;
            int rc = 0;
            int[] rc_arr = new int[1];
            this.act_cntl.systnr = null;
            this.act_cntl.sysid = null;
            this.act_cntl.target = null;
            this.act_cntl.kernel_rel = null;
            this.act_cntl.partner_rel = null;
            this.act_cntl.partner_type = null;
            this.act_cntl.userid = null;
            this.act_cntl.cuserid = null;
            this.act_cntl.lang = null;
            this.act_cntl.mandt = null;
            this.act_cntl.th_client_id = null;
            this.deallocated = true;
            this.act_cntl.rfc_uuid_set = false;
            this.act_cntl.rfc_uuid = null;
            if (wtime == -1) {
                wtime_cpic = 300;
            }
            do {
                if ((rc = this.SAP_CMACCPTP(this.conv_id, this.reg_handle, wtime_cpic)) == 0) continue;
                if (rc == 10001) {
                    boolean iRc = false;
                    if (iRc) {
                        if (this.act_cntl.trace) {
                            Trc.ab_rfctrc("cosaccepttp :: Error : " + Integer.toString(rc));
                        }
                        return 1;
                    }
                    if (-1 == wtime) continue;
                    return -1;
                }
                this.registered = false;
                if (rc == 18) {
                    this.get_cpic_error("SAP_CMACCPTP");
                    return 23;
                }
                this.get_cpic_error("SAP_CMACCPTP");
                return 5;
            } while (wtime == -1 && rc == 10001);
            this.tOfLastIO = System.currentTimeMillis();
            this.accepted = true;
            this.deallocated = false;
            this.tp_accepted = true;
            this.server_mode = true;
            this.info(this.act_cntl.conv_id);
        }
        return 0;
    }

    private String get_rg_info(String text, RfcRegisterInfo register_info) {
        StringBuffer errbuf = new StringBuffer(128);
        String ptr = CpicDriver.SAP_CMPERR();
        String msg = null;
        this.clearMessage();
        errbuf.append(text);
        errbuf.append("\nConnect_PM  ");
        if (register_info.tpname != null) {
            errbuf.append("TPNAME=");
            errbuf.append(register_info.tpname);
        }
        if (register_info.gwhost != null) {
            errbuf.append(", GWHOST=");
            errbuf.append(register_info.gwhost);
        }
        if (register_info.gwserv != null) {
            errbuf.append(", GWSERV=");
            errbuf.append(register_info.gwserv);
        }
        if (register_info.saprouter != null) {
            errbuf.append(", SAPROUTER=");
            errbuf.append(register_info.saprouter);
        }
        errbuf.append('\n');
        if (ptr != null) {
            errbuf.append(ptr);
        } else {
            errbuf.append("No specific info available");
        }
        msg = errbuf.toString();
        this.setMessage(msg);
        return msg;
    }
}

