/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mw.rfc.driver;

import com.sap.mw.jco.util.FastStringBuffer;
import com.sap.mw.jco.util.SAPCharToByteConverter;
import com.sap.mw.jco.util.SAPConverters;
import com.sap.mw.rfc.api.RfcOptions;
import com.sap.mw.rfc.driver.CpicDriver;
import com.sap.mw.rfc.engine.GUID;
import com.sap.mw.rfc.engine.RfcAcceptInfo;
import com.sap.mw.rfc.engine.RfcIoOpenCntl;
import com.sap.mw.rfc.engine.Trc;
import java.io.UnsupportedEncodingException;
import java.util.Date;

public final class RfcTypeDirectCpic
extends CpicDriver {
    public synchronized int listen(byte[] buffer, int bufsize, int[] bytes_read, int timeout) {
        return this.coxread(buffer, bufsize, bytes_read, 1);
    }

    public synchronized int read(byte[] buffer, int bufsize, int[] bytes_read) {
        int rc = this.coxread(buffer, bufsize, bytes_read, 0);
        if (rc != 0) {
            this.tOfLastWIO = new Date();
        }
        return rc;
    }

    public synchronized int open(RfcOptions options) {
        int rc = 0;
        this.act_cntl.rfc_uuid = GUID.Factory.createGUID();
        this.act_cntl.rfc_uuid_set = true;
        if (this.act_cntl.trace) {
            Trc.ab_rfctrc("UUID: ab_coxopen create uuid:");
            Trc.ab_rfctrc(GUID.toString(this.act_cntl.rfc_uuid));
            Trc.ab_rfctrc("\n");
        }
        this.deallocated = true;
        this.registered = false;
        this.server_mode = false;
        if (options.getKind() == 'R') {
            byte[] com_head = this.get_com_head(0 != options.isTrace());
            this.act_cntl.signon = true;
            rc = this.ab_drvfill(com_head);
        } else {
            byte[] com_head = this.fill_logon(options);
            rc = this.ab_drvfill(com_head);
        }
        if (rc != 0) {
            return 1;
        }
        if (this.cox_cpic_init(options) != 0) {
            return 1;
        }
        rc = this.CMALLC(this.conv_id);
        if (rc != 0) {
            this.setMessageTRC(this.getErrorInfo("Connect from SAP gateway to RFC server failed", options));
            return 1;
        }
        this.info(this.act_cntl.conv_id);
        this.deallocated = false;
        return 0;
    }

    public byte[] fill_logon(RfcOptions options) {
        StringBuffer buf = new StringBuffer(75);
        char[] space = new String("                         ").toCharArray();
        buf.append("CONN");
        buf.append("CPIC");
        buf.append("1   ");
        buf.append("000");
        buf.append(options.getUser());
        buf.append(space, 0, Math.max(12 - options.getUser().length(), 0));
        buf.append(options.getPassword());
        buf.append(space, 0, Math.max(8 - options.getPassword().length(), 0));
        buf.append(options.getLanguage().toCharArray(), 0, 1);
        buf.append(" ");
        buf.append("%RFCCALL");
        if (0 != options.isTrace()) {
            buf.append("TRACE%%%%%%%%%%%%%%%%%%%%%%%%%");
        } else {
            buf.append("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
        }
        String buff = buf.toString();
        SAPCharToByteConverter myconv = SAPConverters.getSAPCharToByteConverter("0100");
        byte[] ebcdicbytes = myconv.convert(buff.toCharArray());
        return ebcdicbytes;
    }

    public int wflush() {
        if (this.deallocated || this.broken) {
            if (this.act_cntl.trace) {
                Trc.ab_rfctrc("wflush :: Error : (deallocated or broken)");
            }
            return 1;
        }
        return 0;
    }

    public RfcTypeDirectCpic(RfcIoOpenCntl iocntl) {
        super(iocntl);
    }

    public synchronized int accept(RfcAcceptInfo acceptInfo) {
        return 1;
    }

    protected int cox_cpic_init(RfcOptions options) {
        String proto = " ";
        int rc = 0;
        String gwhost_buf = "";
        String gwserv_buf = "";
        String lu_buf = "";
        String tp_buf = "";
        int cpic_trace = 0;
        if (options.getType() == 'A') {
            proto = CpicDriver.INT_SOCK_COMM;
            lu_buf = options.getAshost();
            tp_buf = new String("sapdp" + options.getSysnr());
            FastStringBuffer gwhost = new FastStringBuffer(256);
            String sapRouter = options.getSaprouter();
            if (sapRouter != null && sapRouter.length() > 0) {
                gwhost.append(sapRouter);
                if (!sapRouter.endsWith("/H/")) {
                    gwhost.append("/H/");
                }
            }
            if (options.getGwhost() == null) {
                gwhost.append(options.getAshost());
            } else {
                gwhost.append(options.getGwhost());
            }
            gwhost_buf = gwhost.toString();
            gwserv_buf = options.getGwserv() == null ? new String("33" + options.getSysnr()) : options.getGwserv();
        } else if (options.getType() == 'B') {
            int port2;
            String sapRouter;
            FastStringBuffer mshost;
            proto = CpicDriver.INT_SOCK_COMM;
            if (null == options.getMsserv()) {
                if (options.getR3name().length() == 4) {
                    options.setMsserv(new String(options.getR3name()));
                } else {
                    options.setMsserv(new String("sapms" + options.getR3name()));
                }
            }
            byte[] ipadr = new byte[100];
            int[] port = new int[1];
            byte[] sncname_app = new byte[1000];
            if (0 == options.getSnc_mode()) {
                mshost = new FastStringBuffer(256);
                sapRouter = options.getSaprouter();
                if (sapRouter != null && sapRouter.length() > 0) {
                    mshost.append(sapRouter);
                    if (!sapRouter.endsWith("/H/")) {
                        mshost.append("/H/");
                    }
                }
                mshost.append(options.getMshost());
                rc = this.get_MS(options.getGroup(), mshost.toString(), options.getMsserv(), ipadr, port);
                if (rc != 0) {
                    this.setMessageTRC(this.getErrorInfo("Connect to message server host failed", options));
                    return 1;
                }
            } else {
                mshost = new FastStringBuffer(256);
                sapRouter = options.getSaprouter();
                if (sapRouter != null && sapRouter.length() > 0) {
                    mshost.append(sapRouter);
                    if (!sapRouter.endsWith("/H/")) {
                        mshost.append("/H/");
                    }
                }
                mshost.append(options.getMshost());
                rc = this.get_MS_SNC(options.getGroup(), mshost.toString(), options.getMsserv(), options.getSnc_partnername(), sncname_app, ipadr, port);
                if (rc != 0) {
                    this.setMessageTRC(this.getErrorInfo("Connect to message server host failed", options));
                    return 1;
                }
                port2 = port[0] % 100;
                gwserv_buf = "sapgw" + (port2 < 10 ? "0" + port2 : "" + port2) + 's';
                try {
                    String snc_partnername_t = new String(sncname_app, "UTF8");
                    int end = snc_partnername_t.indexOf(0);
                    options.setSnc_partnername(snc_partnername_t.substring(0, end));
                }
                catch (UnsupportedEncodingException uee) {
                    // empty catch block
                }
            }
            try {
                gwhost_buf = new String(ipadr, "UTF8");
                int end = gwhost_buf.indexOf(0);
                gwhost_buf = gwhost_buf.substring(0, end);
            }
            catch (UnsupportedEncodingException uee) {
                // empty catch block
            }
            if (gwserv_buf.length() == 0) {
                gwserv_buf = gwserv_buf + port[0] % 10000 / 1000;
                gwserv_buf = gwserv_buf + (port[0] % 1000 / 100 + 1);
                gwserv_buf = gwserv_buf + port[0] % 100 / 10;
                if ((gwserv_buf = gwserv_buf + port[0] % 10).startsWith("sapgw")) {
                    gwserv_buf = gwserv_buf.charAt(7) == 's' ? "48" + gwserv_buf.charAt(5) + gwserv_buf.charAt(6) : "33" + gwserv_buf.charAt(5) + gwserv_buf.charAt(6);
                }
            }
            lu_buf = gwhost_buf;
            FastStringBuffer gwhost = new FastStringBuffer(256);
            sapRouter = options.getSaprouter();
            if (sapRouter != null && sapRouter.length() > 0) {
                gwhost.append(sapRouter);
                if (!sapRouter.endsWith("/H/")) {
                    gwhost.append("/H/");
                }
            }
            gwhost.append(lu_buf);
            gwhost_buf = gwhost.toString();
            if (port[0] > 0) {
                port2 = port[0] % 100;
                tp_buf = "sapdp" + (port2 < 10 ? "0" + port2 : "" + port2);
            } else {
                tp_buf = "";
            }
        } else if (options.getType() == 'E') {
            proto = CpicDriver.REG_SOCK_COMM;
            FastStringBuffer gwhost = new FastStringBuffer(256);
            String sapRouter = options.getSaprouter();
            if (sapRouter != null && sapRouter.length() > 0) {
                gwhost.append(sapRouter);
                if (!sapRouter.endsWith("/H/")) {
                    gwhost.append("/H/");
                }
            }
            gwhost.append(options.getGwhost());
            gwhost_buf = gwhost.toString();
            gwserv_buf = options.getGwserv() == null ? new String("33" + options.getSysnr()) : options.getGwserv();
            proto = CpicDriver.EXT_SOCK_COMM;
            lu_buf = options.getReg_host();
            tp_buf = options.getReg_path();
        } else if (options.getType() == 'R') {
            proto = CpicDriver.REG_SOCK_COMM;
            FastStringBuffer gwhost = new FastStringBuffer(256);
            String sapRouter = options.getSaprouter();
            if (sapRouter != null && sapRouter.length() > 0) {
                gwhost.append(sapRouter);
                if (!sapRouter.endsWith("/H/")) {
                    gwhost.append("/H/");
                }
            }
            gwhost.append(options.getGwhost());
            gwhost_buf = gwhost.toString();
            gwserv_buf = options.getGwserv() == null ? new String("33" + options.getSysnr()) : options.getGwserv();
            proto = CpicDriver.REG_SOCK_COMM;
            lu_buf = new String("");
            tp_buf = options.getReg_name();
        } else {
            proto = new String(" ");
        }
        if (0 != options.isTrace() || this.act_cntl.trace) {
            cpic_trace = 2;
        }
        if ((rc = this.SAP_CMINIT3(this.conv_id, options.getDestination(), lu_buf, tp_buf, gwhost_buf, gwserv_buf, proto, cpic_trace, options.getSnc_mode(), options.getSnc_qop(), options.getSnc_myname(), options.getSnc_partnername(), options.getSnc_lib(), rc)) != 0) {
            if (this.act_cntl.trace) {
                Trc.ab_rfctrc("cox_cpic_init :: Error : " + Integer.toString(rc));
            }
            this.setMessage(this.getErrorInfo("Connect to SAP gateway failed", options));
            return 1;
        }
        if (lu_buf.length() > 0 && (rc = this.CMSPLN(this.conv_id, lu_buf)) != 0) {
            if (this.act_cntl.trace) {
                Trc.ab_rfctrc("cox_cpic_init :: Error : " + Integer.toString(rc));
            }
            this.setMessage("Cannot set R/3 or Ext. Hostname");
            return 1;
        }
        return 0;
    }

    private String getErrorInfo(String message, RfcOptions options) {
        FastStringBuffer buffer = new FastStringBuffer(512);
        String cpicMessage = CpicDriver.SAP_CMPERR();
        buffer.append(message);
        buffer.append("\nConnect_PM  ").append(options.toString(true)).append('\n');
        buffer.append(cpicMessage == null || cpicMessage.length() == 0 ? "No specific info available" : cpicMessage);
        return buffer.toString();
    }
}

