/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mw.rfc.driver;

import com.sap.bc.proj.jstartup.JStartupNatives;
import com.sap.mw.jco.util.SAPByteToCharConverter;
import com.sap.mw.jco.util.SAPConverters;
import com.sap.mw.rfc.driver.RfcDriver;
import com.sap.mw.rfc.engine.RfcIoOpenCntl;
import com.sap.mw.rfc.engine.RfcUtilities;
import com.sap.mw.rfc.engine.Trc;
import java.util.Date;

public abstract class CpicDriver
extends RfcDriver {
    protected char[] lu;
    byte[] conv_id;
    protected int cm_retcode;
    protected int cm_data_received;
    protected int cm_status_received;
    protected int sysnr;
    long tOfLastIO;
    Date tOfLastWIO;
    protected boolean all_received;
    protected boolean cpic_waiting;
    protected boolean broken;
    protected boolean deallocated;
    protected boolean accepted;
    protected boolean server_mode;
    protected boolean registered;
    protected boolean tp_accepted;
    protected int reg_handle;
    private int[] cmData = new int[4];
    protected static final byte[] com_head = new byte[]{-39, -58, -61, -16, -16, -16, -16, -16, -16, -16, -16, -16};
    protected static final byte[] trace_com_head = new byte[]{-39, -58, -61, -16, -16, -16, -16, -16, -16, -16, -16, -29};
    protected static final byte[] ebcdic_trace = new byte[]{-29, -39, -63, -61, -59};
    protected static final byte[] ebcdic_conncpic = new byte[]{-61, -42, -43, -43, -61, -41, -55, -61};
    private static final byte[] appcfree = new byte[]{-58, -39, -59, -59};
    public static int SAP_CONV_ID_LN = 8;
    protected static final String INT_SOCK_COMM = new String("I");
    protected static final String REG_SOCK_COMM = new String("R");
    protected static final String EXT_SOCK_COMM = new String("E");
    protected static final int APCDUMMY_LN = 12;
    public static final int RFCOPT_RFCHOST_LN = 100;
    public static final int CM_OK = 0;
    public static final int CM_SAP_TIMEOUT_RETRY = 10001;
    public static final int CM_SEND_RECEIVED = 1;
    public static final int CM_DEALLOCATED_NORMAL = 18;
    public static final int CM_NO_DATA_RECEIVED = 0;
    public static final int COXREAD_WAIT = 0;
    public static final int COXREAD_NOBLOCK = 1;
    public static final int g_rfc_max_reg_idle = 300;
    static /* synthetic */ Class class$com$sap$mw$rfc$driver$CpicDriver;

    public int[] getCmData() {
        this.cmData[0] = this.cm_retcode;
        this.cmData[1] = this.cm_data_received;
        this.cmData[2] = this.cm_status_received;
        this.cmData[3] = this.sysnr;
        return this.cmData;
    }

    public void setCmData() {
        if (this.cmData == null) {
            return;
        }
        this.cm_retcode = this.cmData[0];
        this.cm_data_received = this.cmData[1];
        this.cm_status_received = this.cmData[2];
        this.sysnr = this.cmData[3];
    }

    public int devbuf() {
        return 16000;
    }

    public void wait(byte[] buffer, int bufsize, int[] bytes_read) {
        bytes_read[0] = 0;
    }

    protected CpicDriver(RfcIoOpenCntl iocntl) {
        super(iocntl);
        this.conv_id = new byte[SAP_CONV_ID_LN];
    }

    protected int deallocated_normal_ext(int data_received, byte[] buffer, int received_leng) {
        this.deallocated = true;
        this.act_cntl.close_pending = true;
        if (data_received == 0) {
            this.setMessageTRC("connection closed without message (CM_NO_DATA_RECEIVED)");
            return 1;
        }
        if (received_leng > 0) {
            int l = received_leng;
            int ptr = 0;
            if (received_leng >= 2 && buffer[received_leng - 2] == -1 && buffer[ptr + received_leng - 2] == -1) {
                this.setMessage("connection closed without message");
                return 0;
            }
            if (received_leng == 1 && buffer[ptr] == -1) {
                this.setMessage("connection closed without message");
                return 0;
            }
            if (received_leng >= appcfree.length && RfcUtilities.memcmp(buffer, 0, appcfree, 0, appcfree.length) == 0 && received_leng >= 12) {
                l -= 12;
                ptr += 12;
            }
            if (l > 0) {
                char[] text = null;
                SAPByteToCharConverter conv = SAPConverters.getSAPByteToCharConverter("0100");
                text = conv.convert(buffer, ptr, l - 1);
                if (text != null) {
                    String msg = new String(text);
                    this.setMessage(msg);
                }
            } else {
                this.clearMessage();
            }
            return 1;
        }
        this.setMessageTRC("connection closed without message");
        return 1;
    }

    protected int coxread(byte[] buffer, int bufsize, int[] bytes_read, int wait) {
        int d_rc;
        int rc = 0;
        int cm_org_data_received = 0;
        int input_size = 0;
        int input_ptr = 0;
        int received_leng = 0;
        int[] cm_data = new int[3];
        if (this.deallocated || this.broken) {
            if (this.act_cntl.trace) {
                Trc.ab_rfctrc("coxread :: Error : " + Integer.toString(10));
            }
            return 10;
        }
        rc = this.cpic_coxread(this.conv_id, wait, buffer, cm_data);
        if (rc == -1) {
            return rc;
        }
        this.cm_data_received = cm_data[0];
        this.cm_status_received = cm_data[1];
        received_leng = cm_data[2];
        cm_org_data_received = this.cm_data_received;
        this.all_received = this.cm_status_received == 1;
        this.cm_retcode = rc;
        ++this.cm_data_received;
        ++this.cm_status_received;
        if (rc != 0) {
            this.deallocated = true;
        }
        if (rc != 0 && rc != 18) {
            String msg = this.get_cpic_error("CMRCV");
            return 5;
        }
        if (rc == 18 && (d_rc = this.deallocated_normal_ext(cm_org_data_received, buffer, received_leng)) != 0) {
            if (this.act_cntl.trace) {
                Trc.ab_rfctrc("coxread :: Error : " + Integer.toString(10));
            }
            return 10;
        }
        input_size = Math.min(buffer.length, received_leng);
        input_ptr = 0;
        if (this.accepted) {
            this.accepted = false;
            if (RfcUtilities.memcmp(buffer, 0, ebcdic_conncpic, 0, Math.min(ebcdic_conncpic.length, input_size)) == 0) {
                if (input_size < 75) {
                    this.broken = true;
                    this.setMessageTRC("CPIC-CALL: 'CMRCV'\n no login data received\n");
                    if (this.act_cntl.trace) {
                        Trc.ab_rfctrc("coxread :: Error : " + Integer.toString(8));
                    }
                    return 8;
                }
                if (RfcUtilities.memcmp(buffer, 45, ebcdic_trace, 0, 5) == 0) {
                    this.act_cntl.trace = true;
                }
                input_size -= 75;
                input_ptr += 75;
            } else if (buffer[input_ptr] == 84 || buffer[input_ptr] == -29) {
                this.act_cntl.trace = true;
                ++input_ptr;
            }
        }
        bytes_read[0] = --input_size;
        if (input_size <= 0) {
            this.broken = true;
            this.setMessage("CPIC-CALL: 'CMRCV'\n" + this.getMessage() + '\n');
            if (this.act_cntl.trace) {
                Trc.ab_rfctrc("coxread :: Error : " + Integer.toString(8));
            }
            return 8;
        }
        if (input_ptr > 0) {
            System.arraycopy(buffer, input_ptr, buffer, 0, input_size);
        }
        this.tOfLastIO = System.currentTimeMillis();
        return 0;
    }

    public synchronized void close() {
        this.coxclose(this.conv_id, this.reg_handle, this.deallocated, this.registered);
        if (!this.deallocated) {
            this.deallocated = true;
        }
        if (this.registered) {
            this.registered = false;
        }
        this.tOfLastIO = System.currentTimeMillis();
    }

    public synchronized void abort() {
        this.coxabort(this.conv_id, this.reg_handle, this.deallocated, this.registered);
        if (!this.deallocated) {
            this.deallocated = true;
        }
        if (this.registered) {
            this.registered = false;
        }
        this.tOfLastIO = System.currentTimeMillis();
    }

    byte[] get_com_head(boolean trace) {
        if (trace) {
            return trace_com_head;
        }
        return com_head;
    }

    public synchronized int proto(int set_get, int proto) {
        if (set_get == 1) {
            this.server_mode = false;
            if (0 != (proto & 0x200)) {
                this.server_mode = true;
            }
        }
        return proto;
    }

    public int ab_drvfill(byte[] com_head) {
        int bufsize = com_head.length;
        boolean rc = false;
        if (this.act_cntl == null) {
            return 1;
        }
        if (this.act_cntl != null && this.act_cntl.m_bytes_free >= bufsize) {
            System.arraycopy(com_head, 0, this.act_cntl.m_buffer, 0, bufsize);
            this.act_cntl.m_buffer_ptr += bufsize;
            this.act_cntl.m_bytes_free -= bufsize;
            return 0;
        }
        return 1;
    }

    public synchronized int rflush() {
        byte[] buffer = new byte[1000];
        int req_leng = 0;
        int rc = 0;
        int received_leng = 0;
        if (this.deallocated || this.broken) {
            if (this.act_cntl.trace) {
                Trc.ab_rfctrc("rflush :: Error : (deallocated or broken)");
            }
            return 1;
        }
        if (!this.all_received) {
            do {
                int d_rc;
                int cm_org_data_received = 0;
                int[] rc_arr = new int[3];
                req_leng = buffer.length;
                rc = this.rflushCMRCV(this.conv_id, buffer, req_leng, rc_arr);
                this.cm_data_received = rc_arr[0];
                this.cm_status_received = rc_arr[1];
                received_leng = rc_arr[2];
                cm_org_data_received = this.cm_data_received++;
                if (rc != 0) {
                    this.deallocated = true;
                    this.get_cpic_error("CMRCV (Flush)");
                }
                if (rc != 0 && rc != 18) {
                    ++this.cm_status_received;
                    this.get_cpic_error("CMRCV");
                    return 5;
                }
                if (rc != 18 || (d_rc = this.deallocated_normal_ext(cm_org_data_received, buffer, received_leng)) == 0) continue;
                ++this.cm_status_received;
                this.tOfLastIO = System.currentTimeMillis();
                if (this.act_cntl.trace) {
                    Trc.ab_rfctrc("rflush :: Error : " + Integer.toString(d_rc));
                }
                return 10;
            } while (this.cm_status_received != 1);
            ++this.cm_status_received;
            this.all_received = true;
        }
        this.tOfLastIO = System.currentTimeMillis();
        return 0;
    }

    public synchronized int write(byte[] buffer, int buffersize, boolean last) {
        int rc = 0;
        if (this.deallocated || this.broken) {
            this.act_cntl.ab_rfcmsgset("CPIC-CALL: 'CMSEND'\n; connection closed\n");
            return 5;
        }
        rc = this.CMSEND(this.conv_id, buffer, buffersize);
        if (rc != 0) {
            this.deallocated = true;
            this.get_cpic_error("CMSEND");
            return 5;
        }
        this.tOfLastIO = System.currentTimeMillis();
        return 0;
    }

    public synchronized void info(byte[] info) {
        System.arraycopy(this.conv_id, 0, info, 0, SAP_CONV_ID_LN);
    }

    protected String get_cpic_error(String cpic_call) {
        String ptr = CpicDriver.SAP_CMPERR();
        String msg = null;
        msg = ptr != null ? new String("CPIC-CALL: " + cpic_call + '\n' + ptr) : new String("CPIC-CALL: " + cpic_call + '\n' + "No specific info available");
        if (null != this.act_cntl && this.act_cntl.trace) {
            Trc.ab_rfctrc("get_cpic_error :: Error : " + msg);
        }
        this.setMessage(msg);
        return msg;
    }

    public static native String getTraceFileName();

    public static synchronized native int INIT();

    protected int SAP_CMINIT3(byte[] conv_id, String sym_dest_name, String lu, String tp, String gw_host, String gw_serv, String prot, int cpic_trace, int snc_mode, int snc_qop, String snc_myname, String snc_partnername, String snc_lib, int return_code) {
        int rc = 0;
        if (this.act_cntl.trace) {
            StringBuffer text = new StringBuffer(256);
            Trc.TCpicNativeBegin("SAP_CMINIT3", this.act_cntl.hrfc, conv_id);
            text.append("    sym_dest_name: ");
            text.append(sym_dest_name);
            text.append("\n    lu: ");
            text.append(lu);
            text.append("\n    tp: ");
            text.append(tp);
            text.append("\n    gw_host: ");
            text.append(gw_host);
            text.append("\n    gw_serv: ");
            text.append(gw_serv);
            text.append("\n    prot: ");
            text.append(prot);
            text.append("\n    snc_mode: ");
            text.append(snc_mode);
            text.append("\n    snc_qop: ");
            text.append(snc_qop);
            text.append("\n    snc_myname: ");
            text.append(snc_myname);
            text.append("\n    snc_partnername: ");
            text.append(snc_partnername);
            text.append("\n    snc_lib: ");
            text.append(snc_lib);
            text.append("\n");
            Trc.ab_rfctrc(text.toString());
        }
        rc = CpicDriver.nativeSAP_CMINIT3(conv_id, sym_dest_name, lu, tp, gw_host, gw_serv, prot, cpic_trace, snc_mode, snc_qop, snc_myname, snc_partnername, snc_lib, return_code);
        if (this.act_cntl.trace) {
            Trc.TCpicNativeEnd("SAP_CMINIT3", this.act_cntl.hrfc, conv_id);
        }
        return rc;
    }

    private static native int nativeSAP_CMINIT3(byte[] var0, String var1, String var2, String var3, String var4, String var5, String var6, int var7, int var8, int var9, String var10, String var11, String var12, int var13);

    protected int get_MS(String group, String mshost, String msserv, byte[] ipadr, int[] port) {
        int rc = 0;
        if (this.act_cntl.trace) {
            StringBuffer text = new StringBuffer(256);
            Trc.TCpicNativeBegin("get_MS", this.act_cntl.hrfc, null);
            text.append("    group: ");
            text.append(group);
            text.append("\n    mshost: ");
            text.append(mshost);
            text.append("\n    msserv: ");
            text.append(msserv);
            text.append("\n");
            Trc.ab_rfctrc(text.toString());
        }
        rc = CpicDriver.nativeGet_MS(group, mshost, msserv, ipadr, port);
        if (this.act_cntl.trace) {
            Trc.ab_rfctrc("    rc : " + rc + "\n");
            Trc.TCpicNativeEnd("get_MS", this.act_cntl.hrfc, null);
        }
        return rc;
    }

    private static synchronized native int nativeGet_MS(String var0, String var1, String var2, byte[] var3, int[] var4);

    protected int get_MS_SNC(String group, String mshost, String msserv, String sncname_msg, byte[] sncname_app, byte[] ipadr, int[] port) {
        int rc = 0;
        if (this.act_cntl.trace) {
            StringBuffer text = new StringBuffer(256);
            text.append("    group: ");
            text.append(group);
            text.append("\n    mshost: ");
            text.append(mshost);
            text.append("\n    msserv: ");
            text.append(msserv);
            text.append("\n    sncname_msg: ");
            text.append(sncname_msg);
            text.append("\n");
            Trc.ab_rfctrc(text.toString());
            Trc.TCpicNativeBegin("get_MS_SNC", this.act_cntl.hrfc, null);
        }
        rc = CpicDriver.nativeGet_MS_SNC(group, mshost, msserv, sncname_msg, sncname_app, ipadr, port);
        if (this.act_cntl.trace) {
            Trc.ab_rfctrc("    rc : " + rc + "\n");
            Trc.TCpicNativeEnd("get_MS_SNC", this.act_cntl.hrfc, null);
        }
        return rc;
    }

    private static synchronized native int nativeGet_MS_SNC(String var0, String var1, String var2, String var3, byte[] var4, byte[] var5, int[] var6);

    protected int CMSPLN(byte[] conv_id, String lu_buf) {
        int rc = 0;
        if (this.act_cntl.trace) {
            Trc.TCpicNativeBegin("CMSPLN", this.act_cntl.hrfc, conv_id);
        }
        rc = CpicDriver.nativeCMSPLN(conv_id, lu_buf);
        if (this.act_cntl.trace) {
            Trc.TCpicNativeEnd("CMSPLN", this.act_cntl.hrfc, conv_id);
        }
        return rc;
    }

    private static native int nativeCMSPLN(byte[] var0, String var1);

    protected int CMALLC(byte[] conv_id) {
        int rc = 0;
        if (this.act_cntl.trace) {
            Trc.TCpicNativeBegin("CMALLC", this.act_cntl.hrfc, conv_id);
        }
        rc = CpicDriver.nativeCMALLC(conv_id);
        if (this.act_cntl.trace) {
            Trc.TCpicNativeEnd("CMALLC", this.act_cntl.hrfc, conv_id);
        }
        return rc;
    }

    private static native int nativeCMALLC(byte[] var0);

    protected void coxclose(byte[] conv_id, int reg_handle, boolean deallocated, boolean registered) {
        if (this.act_cntl.trace) {
            Trc.TCpicNativeBegin("coxclose", this.act_cntl.hrfc, conv_id);
        }
        CpicDriver.nativeCoxclose(conv_id, reg_handle, deallocated, registered);
        if (this.act_cntl.trace) {
            Trc.TCpicNativeEnd("coxclose", this.act_cntl.hrfc, conv_id);
        }
    }

    private static native void nativeCoxclose(byte[] var0, int var1, boolean var2, boolean var3);

    protected int CMSEND(byte[] conv_id, byte[] buffer, int buffersize) {
        int rc = 0;
        if (this.act_cntl.trace) {
            Trc.TCpicNativeBegin("CMSEND", this.act_cntl.hrfc, conv_id);
        }
        rc = CpicDriver.nativeCMSEND(conv_id, buffer, buffersize);
        if (this.act_cntl.trace) {
            Trc.TCpicNativeEnd("CMSEND", this.act_cntl.hrfc, conv_id);
        }
        return rc;
    }

    private static native int nativeCMSEND(byte[] var0, byte[] var1, int var2);

    protected int cpic_coxread(byte[] conv_id, int wait, byte[] cpic_buffer, int[] cm_data) {
        int rc = 0;
        if (this.act_cntl.trace) {
            Trc.TCpicNativeBegin("cpic_coxread", this.act_cntl.hrfc, conv_id);
        }
        rc = CpicDriver.nativeCpic_coxread(conv_id, wait, cpic_buffer, cm_data);
        if (this.act_cntl.trace) {
            Trc.TCpicNativeEnd("cpic_coxread", this.act_cntl.hrfc, conv_id);
        }
        return rc;
    }

    private static native int nativeCpic_coxread(byte[] var0, int var1, byte[] var2, int[] var3);

    protected static native String SAP_CMPERR();

    protected int SAP_CMREGTP2(String tpname, String gwhost, String gwserv, int[] reg_handle, String myname, String lib, byte qop, boolean snc_mode_on) {
        int rc = 0;
        if (this.act_cntl.trace) {
            Trc.TCpicNativeBegin("SAP_CMREGTP2", this.act_cntl.hrfc, null);
        }
        rc = CpicDriver.nativeSAP_CMREGTP2(tpname, gwhost, gwserv, reg_handle, myname, lib, qop, snc_mode_on);
        if (this.act_cntl.trace) {
            Trc.TCpicNativeEnd("SAP_CMREGTP2", this.act_cntl.hrfc, null);
        }
        return rc;
    }

    private static native int nativeSAP_CMREGTP2(String var0, String var1, String var2, int[] var3, String var4, String var5, byte var6, boolean var7);

    protected void coxabort(byte[] conv_id, int reg_handle, boolean deallocated, boolean registered) {
        if (this.act_cntl.trace) {
            Trc.TCpicNativeBegin("coxabort", this.act_cntl.hrfc, conv_id);
        }
        CpicDriver.nativeCoxabort(conv_id, reg_handle, deallocated, registered);
        if (this.act_cntl.trace) {
            Trc.TCpicNativeEnd("coxabort", this.act_cntl.hrfc, conv_id);
        }
    }

    private static native void nativeCoxabort(byte[] var0, int var1, boolean var2, boolean var3);

    protected int SAP_CMACCPTP(byte[] conv_id, int reg_handle, int wtime_cpic) {
        int rc = 0;
        rc = CpicDriver.nativeSAP_CMACCPTP(conv_id, reg_handle, wtime_cpic);
        return rc;
    }

    private static native int nativeSAP_CMACCPTP(byte[] var0, int var1, int var2);

    protected int rflushCMRCV(byte[] conv_id, byte[] buffer, int req_leng, int[] rc_arr) {
        int rc = 0;
        if (this.act_cntl.trace) {
            Trc.TCpicNativeBegin("rflushCMRCV", this.act_cntl.hrfc, conv_id);
        }
        rc = CpicDriver.nativeRflushCMRCV(conv_id, buffer, req_leng, rc_arr);
        if (this.act_cntl.trace) {
            Trc.TCpicNativeEnd("rflushCMRCV", this.act_cntl.hrfc, conv_id);
        }
        return rc;
    }

    private static native int nativeRflushCMRCV(byte[] var0, byte[] var1, int var2, int[] var3);

    protected int CMDEAL(byte[] conv_id) {
        int rc = 0;
        if (this.act_cntl.trace) {
            Trc.TCpicNativeBegin("CMDEAL", this.act_cntl.hrfc, conv_id);
        }
        rc = CpicDriver.nativeCMDEAL(conv_id);
        if (this.act_cntl.trace) {
            Trc.TCpicNativeEnd("CMDEAL", this.act_cntl.hrfc, conv_id);
        }
        return rc;
    }

    private static native int nativeCMDEAL(byte[] var0);

    public static native int nativeSncMode(byte[] var0);

    public static native String nativeSncPartnerName(byte[] var0);

    public static native int nativeSncPartnerAclKey(byte[] var0, byte[] var1);

    public static String CpicGetVersion() {
        int[] Vars = new int[2];
        int rc = CpicDriver.nativeCpicGetVersion(Vars);
        return Vars[0] + "." + Vars[1];
    }

    public static native int nativeCpicGetVersion(int[] var0);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        if (System.getProperty("jstartup.mode") != null) {
            try {
                JStartupNatives.registerNatives((Class)(class$com$sap$mw$rfc$driver$CpicDriver == null ? (class$com$sap$mw$rfc$driver$CpicDriver = CpicDriver.class$("com.sap.mw.rfc.driver.CpicDriver")) : class$com$sap$mw$rfc$driver$CpicDriver));
            }
            catch (Exception ex) {
                Trc.criticalTrace("Class initialization failed for " + (class$com$sap$mw$rfc$driver$CpicDriver == null ? (class$com$sap$mw$rfc$driver$CpicDriver = CpicDriver.class$("com.sap.mw.rfc.driver.CpicDriver")) : class$com$sap$mw$rfc$driver$CpicDriver).getName(), ex);
            }
            catch (Error e) {
                Trc.criticalTrace("Class initialization failed for " + (class$com$sap$mw$rfc$driver$CpicDriver == null ? (class$com$sap$mw$rfc$driver$CpicDriver = CpicDriver.class$("com.sap.mw.rfc.driver.CpicDriver")) : class$com$sap$mw$rfc$driver$CpicDriver).getName(), e);
            }
        }
    }
}

