/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mw.rfc.api;

import com.sap.mw.jco.util.FastStringBuffer;
import com.sap.mw.jco.util.Language;
import com.sap.mw.rfc.engine.Trc;
import com.sap.mw.rfc.exceptions.RfcException;
import java.util.Properties;

public final class RfcOptions {
    private String destination = null;
    private char type = (char)63;
    private char kind = (char)63;
    private String sysnr = null;
    private int trace = 0;
    private boolean debug_ext = false;
    private boolean logonCheck = true;
    private byte allocationType = (byte)3;
    private String ashost = null;
    private String gwhost = null;
    private String gwserv = null;
    private String saprouter = null;
    private String user = null;
    private String alias_user = null;
    private String client = null;
    private String language = null;
    private String password = null;
    private int pcs = 1;
    private String communication_cp = null;
    private String mysapsso2 = null;
    private boolean getsso2 = false;
    private String extid_data = null;
    private String extid_type = null;
    private String x509cert = null;
    private static final int RFC_SNC_MODE_OFF = 0;
    private static final int RFC_SNC_MODE_ON = 1;
    private int snc_mode = 0;
    private static final byte RFC_SNC_QOP_OPEN = 1;
    private static final byte RFC_SNC_QOP_INTEGRITY = 2;
    private static final byte RFC_SNC_QOP_PRIVACY = 3;
    private static final byte RFC_SNC_QOP_DEFAULT = 8;
    private static final byte RFC_SNC_QOP_MAX = 9;
    private int snc_qop = 8;
    private String snc_myname = null;
    private String snc_partnername = null;
    private String snc_lib = null;
    private String r3name = null;
    private String group = null;
    private String mshost = null;
    private String msserv = null;
    private String reg_name = null;
    private String reg_host = null;
    private String reg_path = null;
    private boolean isParametersCheckt = false;

    public void clear() {
        this.destination = null;
        this.type = (char)32;
        this.kind = (char)32;
        this.sysnr = null;
        this.trace = 0;
        this.debug_ext = false;
        this.ashost = null;
        this.gwhost = null;
        this.gwserv = null;
        this.saprouter = null;
        this.user = null;
        this.alias_user = null;
        this.client = null;
        this.language = null;
        this.password = null;
        this.pcs = 1;
        this.mysapsso2 = null;
        this.getsso2 = false;
        this.extid_data = null;
        this.extid_type = null;
        this.x509cert = null;
        this.snc_mode = 0;
        this.snc_qop = 8;
        this.snc_myname = null;
        this.snc_partnername = null;
        this.snc_lib = null;
        this.r3name = null;
        this.group = null;
        this.mshost = null;
        this.msserv = null;
        this.reg_name = null;
        this.reg_host = null;
        this.reg_path = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkLogonData() throws RfcException {
        if ('E' == this.type || 'R' == this.type) {
            this.user = "EXTERN";
            this.password = "EXTERN";
            this.language = "E";
            return;
        }
        if (null == this.client) {
            throw new RfcException(19, "'client' missing", 101, "RFC_ERROR_PROGRAM", 0L, true);
        }
        if (this.client.length() == 3) {
            if (this.client.equals("   ")) {
                this.client = "XXX";
            }
        } else {
            char d2;
            if (this.client.length() >= 3) throw new RfcException(19, "'client' needs to be a three digit number string", 101, "RFC_ERROR_PROGRAM", 0L, true);
            char d1 = this.client.length() != 0 ? (char)this.client.charAt(0) : (char)'0';
            char c = d2 = this.client.length() == 2 ? (char)this.client.charAt(1) : (char)'0';
            if (d1 < 48 || d1 > 57 || d2 < 48 || d2 > 57) throw new RfcException(19, "'client' needs to be a three digit number string", 101, "RFC_ERROR_PROGRAM", 0L, true);
            this.client = "0" + d1 + d2;
        }
        String newpassword = null;
        String newuser = null;
        String newalias = null;
        String newmysapsso2 = null;
        String newx509cert = null;
        if (null == this.user) {
            if (null != this.mysapsso2) {
                newmysapsso2 = this.getMysapsso2();
            } else if (null != this.x509cert) {
                newx509cert = this.x509cert;
            } else if (null != this.getAlias()) {
                newalias = this.getAlias();
            } else if (this.snc_mode != 1) {
                throw new RfcException(19, "'user' missing", 101, "RFC_ERROR_PROGRAM", 0L, true);
            }
        } else if (this.user.equalsIgnoreCase("$MYSAPSSO2$")) {
            if (null != this.password) {
                newmysapsso2 = this.password;
            } else {
                if (null == this.mysapsso2) throw new RfcException(19, "'mysapsso2' missing", 101, "RFC_ERROR_PROGRAM", 0L, true);
                newmysapsso2 = this.mysapsso2;
            }
        } else if (this.user.equalsIgnoreCase("$X509CERT$")) {
            if (null != this.password) {
                newx509cert = this.password;
            } else {
                if (null == this.x509cert) throw new RfcException(19, "'x509cert' missing", 101, "RFC_ERROR_PROGRAM", 0L, true);
                newx509cert = this.x509cert;
            }
        } else {
            int strlen = this.user.length();
            FastStringBuffer strBuf = new FastStringBuffer(strlen);
            int i = 0;
            while (i < strlen) {
                strBuf.append(Character.toUpperCase(this.user.charAt(i)));
                ++i;
            }
            newuser = strBuf.toString();
            if (this.password != null) {
                newpassword = this.password;
            } else if (this.snc_mode != 1) {
                throw new RfcException(19, "'password' missing", 101, "RFC_ERROR_PROGRAM", 0L, true);
            }
        }
        this.password = newpassword;
        this.user = newuser;
        this.alias_user = newalias;
        this.mysapsso2 = newmysapsso2;
        this.x509cert = newx509cert;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void checkParameters() throws RfcException {
        char digit;
        Character.toUpperCase(this.kind);
        if ('R' != this.kind && ' ' != this.kind) {
            throw new RfcException(19, this.kind == '?' ? "'kind' is missing" : "'kind' is wrong: '" + this.kind + "'", 101, "RFC_ERROR_PROGRAM", 0L, true);
        }
        if ('B' != this.type && 'E' != this.type && 'A' != this.type && 'R' != this.type && '3' != this.type && '2' != this.type && 'F' != this.type) {
            throw new RfcException(19, this.type == '?' ? "'type' is missing" : "'type' not supported: '" + this.type + "'", 101, "RFC_ERROR_PROGRAM", 0L, true);
        }
        switch (this.type) {
            case '3': {
                break;
            }
            case 'F': {
                this.ashost = "localhost";
                this.sysnr = System.getProperty("SAPSYSTEM");
                this.type = (char)65;
            }
            case 'A': {
                if (null == this.ashost) {
                    throw new RfcException(19, "'ashost' is missing", 101, "RFC_ERROR_PROGRAM", 0L, true);
                }
                if (null == this.gwhost) {
                    if (this.trace != 0) {
                        Trc.ab_rfctrc("WARNING: use ashost as gwhost\n");
                    }
                    this.gwhost = this.ashost;
                }
                if (null == this.sysnr) {
                    throw new RfcException(19, "'sysnr' is missing", 101, "RFC_ERROR_PROGRAM", 0L, true);
                }
                if (this.sysnr.length() != 2) {
                    if (this.sysnr.length() != 1) throw new RfcException(19, "'sysnr' needs to be a two digit number string", 101, "RFC_ERROR_PROGRAM", 0L, true);
                    digit = this.sysnr.charAt(0);
                    if (digit < '0' || digit > '9') throw new RfcException(19, "'sysnr' needs to be a two digit number string", 101, "RFC_ERROR_PROGRAM", 0L, true);
                    this.sysnr = "0" + digit;
                }
                if (null != this.gwserv) break;
                if (this.trace != 0) {
                    Trc.ab_rfctrc("WARNING: generated gwserv from system number\n");
                }
                this.gwserv = "sapgw" + this.sysnr;
                break;
            }
            case 'B': {
                if (null == this.mshost) {
                    throw new RfcException(19, "'mshost' missing", 101, "RFC_ERROR_PROGRAM", 0L, true);
                }
                if (null == this.r3name) {
                    throw new RfcException(19, "'r3name' missing", 101, "RFC_ERROR_PROGRAM", 0L, true);
                }
                if (null != this.group) break;
                this.group = "PUBLIC";
                break;
            }
            case 'E': 
            case 'R': {
                this.kind = (char)32;
                if (null == this.reg_host) {
                    if (this.gwhost == null || this.gwserv == null) throw new RfcException(19, "'tphost' missing", 101, "RFC_ERROR_PROGRAM", 0L, true);
                    this.type = (char)82;
                }
                if (this.type != 'R' && null == this.reg_name) {
                    throw new RfcException(19, "'tpname' missing", 101, "RFC_ERROR_PROGRAM", 0L, true);
                }
                this.reg_path = this.reg_name;
                break;
            }
            case '2': {
                throw new RfcException(19, "not Supportet yet", 101, "RFC_ERROR_PROGRAM", 0L, true);
            }
            default: {
                throw new RfcException(19, "'type' missing or wrong", 101, "RFC_ERROR_PROGRAM", 0L, true);
            }
        }
        this.checkLogonData();
        switch (this.snc_mode) {
            case 1: {
                if (-1 == this.snc_qop) {
                    throw new RfcException(19, "'snc_qop' missing or invalid", 101, "RFC_ERROR_PROGRAM", 0L, true);
                }
                if (null == this.snc_myname) {
                    this.snc_myname = " ";
                }
                if (null == this.snc_partnername) {
                    throw new RfcException(19, "'snc_partnername' missing", 101, "RFC_ERROR_PROGRAM", 0L, true);
                }
                if (null != this.snc_lib) break;
                throw new RfcException(19, "'snc_lib' missing", 101, "RFC_ERROR_PROGRAM", 0L, true);
            }
            case 0: {
                break;
            }
            default: {
                this.snc_mode = 0;
            }
        }
        if (this.pcs != 1 && this.pcs != 2) {
            throw new RfcException(19, "'pcs' missing or wrong", 101, "RFC_ERROR_PROGRAM", 0L, true);
        }
        if (this.communication_cp == null) return;
        if (this.communication_cp.length() > 4) {
            throw new RfcException(19, "'communication codepage' needs to be a 4 digit number string", 101, "RFC_ERROR_PROGRAM", 0L, true);
        }
        int i = 0;
        while (i < this.communication_cp.length()) {
            digit = this.communication_cp.charAt(i);
            if (digit < '0' || digit > '9') {
                throw new RfcException(19, "'communication codepage' needs to be a 4 digit number string", 101, "RFC_ERROR_PROGRAM", 0L, true);
            }
            ++i;
        }
    }

    public void setProperties(Properties prop, String prefix) throws RfcException {
        String reader = null;
        reader = this.getTrimmedProperty(prop, prefix, "kind");
        if (null != reader) {
            this.kind = reader.charAt(0);
        }
        if (null != (reader = this.getTrimmedProperty(prop, prefix, "type"))) {
            this.type = reader.charAt(0);
        }
        this.sysnr = this.getTrimmedProperty(prop, prefix, "sysnr");
        this.trace = 0;
        reader = this.getTrimmedProperty(prop, prefix, "trace");
        if (null != reader && reader.equals("1")) {
            this.trace = 1;
        }
        this.debug_ext = false;
        reader = this.getTrimmedProperty(prop, prefix, "debug_ext");
        this.debug_ext = this.toBoolean(reader);
        reader = this.getTrimmedProperty(prop, prefix, "lcheck");
        this.logonCheck = reader == null || this.toBoolean(reader);
        this.ashost = this.getTrimmedProperty(prop, prefix, "ashost");
        this.gwhost = this.getTrimmedProperty(prop, prefix, "gwhost");
        this.gwserv = this.getTrimmedProperty(prop, prefix, "gwserv");
        this.saprouter = this.getTrimmedProperty(prop, prefix, "saprouter");
        this.user = this.getRightTrimmedProperty(prop, prefix, "user");
        this.alias_user = this.getTrimmedProperty(prop, prefix, "alias_user");
        this.client = this.getTrimmedProperty(prop, prefix, "client");
        this.language = this.getTrimmedProperty(prop, prefix, "lang");
        if (this.language != null) {
            String tempLanguage = Language.getSAPLanguage(this.language);
            if (tempLanguage == null) {
                throw new RfcException(1, "Language '" + this.language + "' is not available", 101, "RFC_ERROR_PROGRAM", 0L, true);
            }
            this.language = tempLanguage;
        }
        this.password = this.getRightTrimmedProperty(prop, prefix, "passwd");
        reader = this.getTrimmedProperty(prop, prefix, "pcs");
        this.pcs = 1;
        if (null != reader) {
            this.pcs = Integer.parseInt(reader);
        }
        reader = this.getTrimmedProperty(prop, prefix, "getsso2");
        this.getsso2 = false;
        if (null != reader && 1 == Integer.parseInt(reader)) {
            this.getsso2 = true;
        }
        this.mysapsso2 = this.getTrimmedProperty(prop, prefix, "mysapsso2");
        reader = this.getTrimmedProperty(prop, prefix, "getsso2");
        this.getsso2 = this.toBoolean(reader);
        this.extid_data = this.getTrimmedProperty(prop, prefix, "extid_data");
        this.extid_type = this.getTrimmedProperty(prop, prefix, "extid_type");
        this.x509cert = this.getTrimmedProperty(prop, prefix, "x509cert");
        reader = this.getTrimmedProperty(prop, prefix, "snc_mode");
        this.snc_mode = this.toBoolean(reader) ? 1 : 0;
        reader = this.getTrimmedProperty(prop, prefix, "snc_qop");
        if (null != reader) {
            try {
                this.snc_qop = Integer.parseInt(reader);
            }
            catch (NumberFormatException nfe) {
                this.snc_qop = -1;
            }
        }
        this.snc_myname = this.getTrimmedProperty(prop, prefix, "snc_myname");
        this.snc_partnername = this.getTrimmedProperty(prop, prefix, "snc_partnername");
        this.snc_lib = this.getTrimmedProperty(prop, prefix, "snc_lib");
        this.r3name = this.getTrimmedProperty(prop, prefix, "r3name");
        this.group = this.getTrimmedProperty(prop, prefix, "group");
        this.mshost = this.getTrimmedProperty(prop, prefix, "mshost");
        this.msserv = this.getTrimmedProperty(prop, prefix, "msserv");
        this.reg_name = this.getTrimmedProperty(prop, prefix, "tpname");
        this.reg_host = this.getTrimmedProperty(prop, prefix, "tphost");
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean onlyConnectionInfo) {
        FastStringBuffer buf = new FastStringBuffer();
        buf.append("TYPE=").append(this.type);
        if (!onlyConnectionInfo) {
            if (this.user != null) {
                buf.append(" USER=\"").append(this.user);
            }
            if (this.alias_user != null) {
                buf.append(" ALIAS_USER=\"").append(this.alias_user);
            }
            if (this.password != null) {
                buf.append("\" PASSWD=**********");
            }
            buf.append(" CLIENT=").append(this.client);
            if (this.language != null) {
                buf.append(" LANG=").append(this.language);
            }
        }
        switch (this.type) {
            case '3': 
            case 'A': {
                buf.append(" ASHOST=").append(this.ashost).append(" SYSNR=").append(this.sysnr);
                if (this.gwhost == null) break;
                buf.append(" GWHOST=").append(this.gwhost).append(" GWSERV=").append(this.gwserv);
                break;
            }
            case 'B': {
                buf.append(" MSHOST=").append(this.mshost).append(" GROUP=").append(this.group).append(" R3NAME=").append(this.r3name);
                if (this.msserv == null) break;
                buf.append(" MSSERV=" + this.msserv);
                break;
            }
            case 'E': 
            case 'R': {
                buf.append(" GWHOST=").append(this.gwhost);
                buf.append(" GWSERV=").append(this.gwserv).append(" PROGID=").append(this.reg_name);
                break;
            }
        }
        if (this.saprouter != null) {
            buf.append(" SAPROUTER_STRING=").append(this.saprouter);
        }
        if (this.snc_mode == 1) {
            buf.append("SNC_MODE=1 SNC_QOP=").append(Integer.toString(this.snc_qop));
            if (this.snc_myname != null) {
                buf.append(" SNC_MYNAME=\"").append(this.snc_myname).append('\"');
            }
            if (this.snc_partnername != null) {
                buf.append(" SNC_PARTNERNAME=\"").append(this.snc_partnername).append('\"');
            }
        }
        if (!onlyConnectionInfo) {
            if (0 != this.isTrace()) {
                buf.append(" TRACE=" + this.isTrace());
            }
            if (this.isGetsso2()) {
                buf.append(" GETSSO2=true");
            }
            if (this.mysapsso2 != null) {
                buf.append(" MYSAPSSO2=\"").append(this.mysapsso2).append('\"');
            }
            if (this.x509cert != null) {
                buf.append(" X509CERT=\"").append(this.x509cert).append('\"');
            }
        }
        if (this.isDebug_ext()) {
            buf.append(" DEBUG_EXT=true");
        }
        buf.append(" PCS=").append(Integer.toString(this.pcs));
        return buf.toString();
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setKind(char kind) {
        this.kind = kind;
    }

    public char getKind() {
        return this.kind;
    }

    public void setSysnr(String sysnr) {
        this.sysnr = sysnr;
    }

    public String getSysnr() {
        return this.sysnr;
    }

    public void setAshost(String ashost) {
        this.ashost = ashost;
    }

    public String getAshost() {
        return this.ashost;
    }

    public void setTrace(int trace) {
        this.trace = trace;
    }

    public int isTrace() {
        return this.trace;
    }

    public void setGwhost(String gwhost) {
        this.gwhost = gwhost;
    }

    public String getGwhost() {
        return this.gwhost;
    }

    public void setGwserv(String gwserv) {
        this.gwserv = gwserv;
    }

    public String getGwserv() {
        return this.gwserv;
    }

    public void setSaprouter(String saprouter) {
        this.saprouter = saprouter;
    }

    public String getSaprouter() {
        return this.saprouter;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getUser() {
        return this.user;
    }

    public void setGetsso2(boolean getsso2) {
        this.getsso2 = getsso2;
    }

    public boolean isGetsso2() {
        return this.getsso2;
    }

    public void setExtid_data(String extid_data) {
        this.extid_data = extid_data;
    }

    public String getExtid_data() {
        return this.extid_data;
    }

    public void setExtid_type(String extid_type) {
        this.extid_type = extid_type;
    }

    public String getExtid_type() {
        return this.extid_type;
    }

    public void setX509cert(String x509cert) {
        this.x509cert = x509cert;
    }

    public String getX509cert() {
        return this.x509cert;
    }

    public void setSnc_mode(int snc_mode) {
        this.snc_mode = snc_mode;
    }

    public int getSnc_mode() {
        return this.snc_mode;
    }

    public void setSnc_myname(String snc_myname) {
        this.snc_myname = snc_myname;
    }

    public String getSnc_myname() {
        return this.snc_myname;
    }

    public void setSnc_qop(int snc_qop) {
        this.snc_qop = snc_qop;
    }

    public int getSnc_qop() {
        return this.snc_qop;
    }

    public void setSnc_partnername(String snc_partnername) {
        this.snc_partnername = snc_partnername;
    }

    public String getSnc_partnername() {
        return this.snc_partnername;
    }

    public void setSnc_lib(String snc_lib) {
        this.snc_lib = snc_lib;
    }

    public String getSnc_lib() {
        return this.snc_lib;
    }

    public void setR3name(String r3name) {
        this.r3name = r3name;
    }

    public String getR3name() {
        return this.r3name;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getGroup() {
        return this.group;
    }

    public void setMshost(String mshost) {
        this.mshost = mshost;
    }

    public String getMshost() {
        return this.mshost;
    }

    public void setMsserv(String msserv) {
        this.msserv = msserv;
    }

    public String getMsserv() {
        return this.msserv;
    }

    public void setReg_name(String reg_name) {
        this.reg_name = reg_name;
    }

    public String getReg_name() {
        return this.reg_name;
    }

    public void setReg_host(String reg_host) {
        this.reg_host = reg_host;
    }

    public String getReg_host() {
        return this.reg_host;
    }

    public void setReg_path(String reg_path) {
        this.reg_path = reg_path;
    }

    public String getReg_path() {
        return this.reg_path;
    }

    public void setDebug_ext(boolean debug_ext) {
        this.debug_ext = debug_ext;
    }

    public boolean isDebug_ext() {
        return this.debug_ext;
    }

    public void setType(char type) {
        this.type = type;
    }

    public char getType() {
        return this.type;
    }

    public void setMysapsso2(String mysapsso2) {
        this.mysapsso2 = mysapsso2;
    }

    public String getMysapsso2() {
        return this.mysapsso2;
    }

    public void setClient(String client) {
        this.client = client;
    }

    public String getClient() {
        return this.client;
    }

    public void setLanguage(String language) throws RfcException {
        String tempLanguage = Language.getSAPLanguage(language);
        if (tempLanguage == null) {
            throw new RfcException(1, "Language '" + language + "' is not available", 101, "RFC_ERROR_PROGRAM", 0L, true);
        }
        this.language = tempLanguage;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPcs(int pcs) {
        this.pcs = pcs;
    }

    public int getPcs() {
        return this.pcs;
    }

    public boolean executeLogonCheck() {
        return this.logonCheck;
    }

    public void setLogonCheck(boolean logonCheck) {
        this.logonCheck = logonCheck;
    }

    public byte getAllocationType() {
        return this.allocationType;
    }

    public void setAllocationType(byte b) {
        this.allocationType = b;
    }

    public void setAlias(String alias) {
        this.alias_user = alias;
    }

    public String getAlias() {
        return this.alias_user;
    }

    private String findProperty(Properties props, String prefix, String key) {
        String value = props.getProperty(prefix + key);
        if (value == null && (value = props.getProperty(key)) == null) {
            key = key.toUpperCase();
            value = props.getProperty(key);
        }
        return value;
    }

    protected boolean toBoolean(String arg) {
        if (arg == null) {
            return false;
        }
        return (arg = arg.trim().toLowerCase()).equals("1") || arg.equals("true") || arg.equals("yes");
    }

    protected String getRightTrimmedProperty(Properties props, String prefix, String key) {
        String value = this.findProperty(props, prefix, key);
        if (value != null && (value = this.rightTrim(value)).length() == 0) {
            value = null;
        }
        return value;
    }

    protected String getTrimmedProperty(Properties props, String prefix, String key) {
        String value = this.findProperty(props, prefix, key);
        if (value != null && (value = value.trim()).length() == 0) {
            value = null;
        }
        return value;
    }

    protected String rightTrim(String str) {
        if (str != null) {
            int last;
            int i = last = str.length() - 1;
            while (i >= 0 && str.charAt(i) <= ' ') {
                --i;
            }
            if (i < last) {
                str = str.substring(0, i + 1);
            }
        }
        return str;
    }

    public void setCommunication_cp(String communication_cp) {
        this.communication_cp = communication_cp;
    }

    public String getCommunication_cp() {
        return this.communication_cp;
    }
}

