/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mw.jco.util;

import com.sap.bc.proj.jstartup.JStartupNatives;
import com.sap.mw.jco.JCO;
import com.sap.mw.jco.util.BasicSAPConverter;
import com.sap.mw.jco.util.SAPByteToCharConverter;
import com.sap.mw.rfc.engine.Trc;

public class SAPNUCByteToCharConverter
extends BasicSAPConverter
implements SAPByteToCharConverter {
    private static final byte TYPE_UNKNOWN = 0;
    private static final byte TYPE_BYTELENGTHOFFSET_ARRAY = 1;
    private static final byte TYPE_BYTELENGTH_ARRAY = 2;
    private static final byte TYPE_BYTELENGTH1TOCHARLENGTH1_ARRAY = 3;
    private static final byte TYPE_BYTELENGTH2TOCHAROFFSET_ARRAY = 4;
    private static final byte TYPE_BYTELENGTH2TOCHAR_ARRAY = 5;
    private static final byte TYPE_BYTELENGTH3TOCHAROFFSET1_ARRAY = 6;
    private static final byte TYPE_BYTELENGTH3TOCHAROFFSET2_ARRAY = 7;
    private static final byte TYPE_BYTELENGTH3TOCHAR_ARRAY = 8;
    private char[] byteLengthOffset = null;
    private byte[] byteLength = null;
    private char[] byteLength1ToCharLength1 = null;
    private char[] byteLength2ToCharOffset = null;
    private char[] byteLength2ToChar = null;
    private char[] byteLength3ToCharOffset1 = null;
    private int[] byteLength3ToCharOffset2 = null;
    private char[] byteLength3ToChar = null;
    static /* synthetic */ Class class$com$sap$mw$jco$util$SAPNUCByteToCharConverter;

    protected static native int nativeInitializer();

    protected SAPNUCByteToCharConverter(String charEncoding) {
        super(charEncoding);
        if (charEncoding.startsWith("SAP")) {
            charEncoding = charEncoding.substring(3);
        }
        if (this.nativeInitialize(charEncoding) != 0) {
            throw new JCO.Exception(134, "JCO_ERROR_INITIALIZATION", "Could not initialize SAPByteToCharConverter for codepage " + charEncoding + ".");
        }
        this.initialize();
    }

    protected native int nativeInitialize(String var1);

    protected void initialize() {
        if (this.byteLength1ToCharLength1 != null) {
            int i = 32;
            while (i < 127) {
                if (this.byteLength1ToCharLength1[i] != i) break;
                ++i;
            }
            this.codepageType = i == 127 ? (byte)1 : (byte)2;
        }
    }

    protected void setByteArray(byte type, String version, byte[] array) {
        switch (type) {
            case 2: {
                if (!"1.0".equals(version)) break;
                this.byteLength = array;
                return;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            default: {
                return;
            }
        }
        throw new JCO.Exception(134, "JCO_ERROR_INITIALIZATION", "Could not initialize SAPByteToCharConverter for codepage " + this.charEncoding + ". SAP Java Connector runtime archive version " + version + " is required.");
    }

    protected void setCharArray(byte type, String version, char[] array) {
        switch (type) {
            case 1: {
                if (!"1.0".equals(version)) break;
                this.byteLengthOffset = array;
                return;
            }
            case 3: {
                if (!"1.0".equals(version)) break;
                this.byteLength1ToCharLength1 = array;
                return;
            }
            case 4: {
                if (!"1.0".equals(version)) break;
                this.byteLength2ToCharOffset = array;
                return;
            }
            case 5: {
                if (!"1.0".equals(version)) break;
                this.byteLength2ToChar = array;
                return;
            }
            case 6: {
                if (!"1.0".equals(version)) break;
                this.byteLength3ToCharOffset1 = array;
                return;
            }
            case 8: {
                if (!"1.0".equals(version)) break;
                this.byteLength3ToChar = array;
                return;
            }
            case 2: 
            case 7: {
                break;
            }
            default: {
                return;
            }
        }
        throw new JCO.Exception(134, "JCO_ERROR_INITIALIZATION", "Could not initialize SAPByteToCharConverter for codepage " + this.charEncoding + ". SAP Java Connector runtime archive version " + version + " is required.");
    }

    protected void setIntArray(byte type, String version, int[] array) {
        switch (type) {
            case 7: {
                if (!"1.0".equals(version)) break;
                this.byteLength3ToCharOffset2 = array;
                return;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                break;
            }
            default: {
                return;
            }
        }
        throw new JCO.Exception(134, "JCO_ERROR_INITIALIZATION", "Could not initialize SAPByteToCharConverter for codepage " + this.charEncoding + ". SAP Java Connector runtime archive version " + version + " is required.");
    }

    protected void setLongArray(byte type, String version, long[] array) {
        switch (type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            default: {
                return;
            }
        }
        throw new JCO.Exception(134, "JCO_ERROR_INITIALIZATION", "Could not initialize SAPByteToCharConverter for codepage " + this.charEncoding + ". SAP Java Connector runtime archive version " + version + " is required.");
    }

    protected void setShortArray(byte type, String version, short[] array) {
        switch (type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            default: {
                return;
            }
        }
        throw new JCO.Exception(134, "JCO_ERROR_INITIALIZATION", "Could not initialize SAPByteToCharConverter for codepage " + this.charEncoding + ". SAP Java Connector runtime archive version " + version + " is required.");
    }

    public int convert(byte[] in, int inBeginIndex, int inEndIndex, char[] out, int outBeginIndex, int outEndIndex) {
        int numBytes;
        if (in == null) {
            return 0;
        }
        if (inBeginIndex < 0) {
            return 0;
        }
        if (inBeginIndex >= in.length) {
            return 0;
        }
        if (inEndIndex >= in.length) {
            inEndIndex = in.length - 1;
        }
        if (inBeginIndex > inEndIndex) {
            return 0;
        }
        if (out == null) {
            return 0;
        }
        if (outBeginIndex < 0) {
            return 0;
        }
        if (outBeginIndex >= out.length) {
            return 0;
        }
        if (outEndIndex >= out.length) {
            outEndIndex = out.length - 1;
        }
        if (outBeginIndex > outEndIndex) {
            return 0;
        }
        int inIndex = inBeginIndex;
        int outIndex = outBeginIndex;
        if (inIndex < inEndIndex) {
            numBytes = this.byteLength[this.byteLengthOffset[in[inIndex] & 0xFF] | in[inIndex + 1] & 0xFF];
            if (inIndex + numBytes - 1 > inEndIndex) {
                numBytes = (byte)(inEndIndex - inIndex + 1);
            }
        } else {
            numBytes = 1;
        }
        block6: while (inIndex <= inEndIndex && outIndex <= outEndIndex) {
            switch (numBytes) {
                case 1: {
                    out[outIndex++] = this.byteLength1ToCharLength1[in[inIndex] & 0xFF];
                    ++inIndex;
                    break;
                }
                case 2: {
                    int tabIndex = (this.byteLength2ToCharOffset[in[inIndex] & 0xFF] | in[inIndex + 1] & 0xFF) << 1;
                    char outChar = this.byteLength2ToChar[tabIndex];
                    if (outChar < '\ud800' || outChar > '\udfff') {
                        if (outChar == '#') {
                            numBytes = 1;
                            continue block6;
                        }
                        if (outChar == '\uf8fc' && this.byteLength2ToChar[tabIndex + 1] != '\u0000') {
                            if (outIndex >= outEndIndex) {
                                inIndex = inEndIndex + 1;
                                continue block6;
                            }
                            out[outIndex++] = outChar;
                            outChar = this.byteLength2ToChar[tabIndex + 1];
                        }
                    } else {
                        if (outIndex >= outEndIndex) {
                            inIndex = inEndIndex + 1;
                            continue block6;
                        }
                        out[outIndex++] = outChar;
                        outChar = this.byteLength2ToChar[tabIndex + 1];
                    }
                    out[outIndex++] = outChar;
                    inIndex += 2;
                    break;
                }
                case 3: {
                    int tabIndex = (this.byteLength3ToCharOffset2[this.byteLength3ToCharOffset1[in[inIndex] & 0xFF] | in[inIndex + 1] & 0xFF] | in[inIndex + 2] & 0xFF) << 1;
                    char outChar = this.byteLength3ToChar[tabIndex];
                    if (outChar < '\ud800' || outChar > '\udfff') {
                        if (outChar == '#') {
                            numBytes = 2;
                            continue block6;
                        }
                        if (outChar == '\uf8fc' && this.byteLength3ToChar[tabIndex + 1] != '\u0000') {
                            if (outIndex >= outEndIndex) {
                                inIndex = inEndIndex + 1;
                                continue block6;
                            }
                            out[outIndex++] = outChar;
                            outChar = this.byteLength3ToChar[tabIndex + 1];
                        }
                    } else {
                        if (outIndex >= outEndIndex) {
                            inIndex = inEndIndex + 1;
                            continue block6;
                        }
                        out[outIndex++] = outChar;
                        outChar = this.byteLength3ToChar[tabIndex + 1];
                    }
                    out[outIndex++] = outChar;
                    inIndex += 3;
                    break;
                }
                case 4: {
                    if (in[inIndex] == 27) {
                        int sapIconChar1 = 0;
                        int sapIconChar2 = 0;
                        if (this.codepageType == 1 && in[inIndex + 1] == 44) {
                            sapIconChar1 = (char)(in[inIndex + 2] & 0xFF);
                            sapIconChar2 = (char)(in[inIndex + 3] & 0xFF);
                        } else if (this.codepageType == 2 && in[inIndex + 1] == 107) {
                            sapIconChar1 = this.byteLength1ToCharLength1[in[inIndex + 2] & 0xFF];
                            sapIconChar2 = this.byteLength1ToCharLength1[in[inIndex + 3] & 0xFF];
                        }
                        if (sapIconChar1 != 0 && (sapIconChar1 >= 48 && sapIconChar1 <= 57 || sapIconChar1 >= 65 && sapIconChar1 <= 90 || sapIconChar1 >= 97 && sapIconChar1 <= 122) && (sapIconChar2 >= 48 && sapIconChar2 <= 57 || sapIconChar2 >= 65 && sapIconChar2 <= 90 || sapIconChar2 >= 97 && sapIconChar2 <= 122)) {
                            if (outIndex + 1 >= outEndIndex) {
                                inIndex = inEndIndex + 1;
                                continue block6;
                            }
                            out[outIndex++] = 63741;
                            out[outIndex++] = sapIconChar1;
                            out[outIndex++] = sapIconChar2;
                            inIndex += 4;
                            break;
                        }
                    }
                    numBytes = 3;
                    continue block6;
                }
                default: {
                    numBytes = 4;
                    continue block6;
                }
            }
            if (inIndex < inEndIndex) {
                numBytes = this.byteLength[this.byteLengthOffset[in[inIndex] & 0xFF] | in[inIndex + 1] & 0xFF];
                if (inIndex + numBytes - 1 <= inEndIndex) continue;
                numBytes = (byte)(inEndIndex - inIndex + 1);
                continue;
            }
            numBytes = 1;
        }
        return outIndex - outBeginIndex;
    }

    public char[] convert(byte[] in, int inBeginIndex, int inEndIndex) {
        if (in == null) {
            return new char[0];
        }
        if (inBeginIndex < 0) {
            return new char[0];
        }
        if (inBeginIndex >= in.length) {
            return new char[0];
        }
        if (inEndIndex >= in.length) {
            inEndIndex = in.length - 1;
        }
        if (inBeginIndex > inEndIndex) {
            return new char[0];
        }
        int outLength = this.outLength(in, inBeginIndex, inEndIndex);
        char[] out = new char[outLength];
        this.convert(in, inBeginIndex, inEndIndex, out, 0, outLength - 1);
        return out;
    }

    public char[] convert(byte[] in) {
        if (in == null) {
            return new char[0];
        }
        int outLength = this.outLength(in, 0, in.length - 1);
        char[] out = new char[outLength];
        this.convert(in, 0, in.length - 1, out, 0, outLength - 1);
        return out;
    }

    public int outLength(byte[] in, int inBeginIndex, int inEndIndex) {
        int numBytes;
        if (in == null) {
            return 0;
        }
        if (inBeginIndex < 0) {
            return 0;
        }
        if (inBeginIndex >= in.length) {
            return 0;
        }
        if (inEndIndex >= in.length) {
            inEndIndex = in.length - 1;
        }
        if (inBeginIndex > inEndIndex) {
            return 0;
        }
        int outLength = 0;
        int inIndex = inBeginIndex;
        if (inIndex < inEndIndex) {
            numBytes = this.byteLength[this.byteLengthOffset[in[inIndex] & 0xFF] | in[inIndex + 1] & 0xFF];
            if (inIndex + numBytes - 1 > inEndIndex) {
                numBytes = (byte)(inEndIndex - inIndex + 1);
            }
        } else {
            numBytes = 1;
        }
        block6: while (inIndex <= inEndIndex) {
            switch (numBytes) {
                case 1: {
                    ++outLength;
                    ++inIndex;
                    break;
                }
                case 2: {
                    int tabIndex = (this.byteLength2ToCharOffset[in[inIndex] & 0xFF] | in[inIndex + 1] & 0xFF) << 1;
                    char outChar = this.byteLength2ToChar[tabIndex];
                    if (outChar < '\ud800' || outChar > '\udfff') {
                        if (outChar == '#') {
                            numBytes = 1;
                            continue block6;
                        }
                        if (outChar == '\uf8fc' && this.byteLength2ToChar[tabIndex + 1] != '\u0000') {
                            ++outLength;
                        }
                    } else {
                        ++outLength;
                    }
                    ++outLength;
                    inIndex += 2;
                    break;
                }
                case 3: {
                    int tabIndex = (this.byteLength3ToCharOffset2[this.byteLength3ToCharOffset1[in[inIndex] & 0xFF] | in[inIndex + 1] & 0xFF] | in[inIndex + 2] & 0xFF) << 1;
                    char outChar = this.byteLength3ToChar[tabIndex];
                    if (outChar < '\ud800' || outChar > '\udfff') {
                        if (outChar == '#') {
                            numBytes = 2;
                            continue block6;
                        }
                        if (outChar == '\uf8fc' && this.byteLength3ToChar[tabIndex + 1] != '\u0000') {
                            ++outLength;
                        }
                    } else {
                        ++outLength;
                    }
                    ++outLength;
                    inIndex += 3;
                    break;
                }
                case 4: {
                    if (in[inIndex] == 27) {
                        int sapIconChar1 = 0;
                        int sapIconChar2 = 0;
                        if (this.codepageType == 1 && in[inIndex + 1] == 44) {
                            sapIconChar1 = (char)(in[inIndex + 2] & 0xFF);
                            sapIconChar2 = (char)(in[inIndex + 3] & 0xFF);
                        } else if (this.codepageType == 2 && in[inIndex + 1] == 107) {
                            sapIconChar1 = this.byteLength1ToCharLength1[in[inIndex + 2] & 0xFF];
                            sapIconChar2 = this.byteLength1ToCharLength1[in[inIndex + 3] & 0xFF];
                        }
                        if (sapIconChar1 != 0 && (sapIconChar1 >= 48 && sapIconChar1 <= 57 || sapIconChar1 >= 65 && sapIconChar1 <= 90 || sapIconChar1 >= 97 && sapIconChar1 <= 122) && (sapIconChar2 >= 48 && sapIconChar2 <= 57 || sapIconChar2 >= 65 && sapIconChar2 <= 90 || sapIconChar2 >= 97 && sapIconChar2 <= 122)) {
                            outLength += 3;
                            inIndex += 4;
                            break;
                        }
                    }
                    numBytes = 3;
                    continue block6;
                }
                default: {
                    numBytes = 4;
                    continue block6;
                }
            }
            if (inIndex < inEndIndex) {
                numBytes = this.byteLength[this.byteLengthOffset[in[inIndex] & 0xFF] | in[inIndex + 1] & 0xFF];
                if (inIndex + numBytes - 1 <= inEndIndex) continue;
                numBytes = (byte)(inEndIndex - inIndex + 1);
                continue;
            }
            numBytes = 1;
        }
        return outLength;
    }

    public int outLength(byte[] in) {
        if (in == null) {
            return 0;
        }
        return this.outLength(in, 0, in.length - 1);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        if (System.getProperty("jstartup.mode") != null) {
            try {
                JStartupNatives.registerNatives((Class)(class$com$sap$mw$jco$util$SAPNUCByteToCharConverter == null ? (class$com$sap$mw$jco$util$SAPNUCByteToCharConverter = SAPNUCByteToCharConverter.class$("com.sap.mw.jco.util.SAPNUCByteToCharConverter")) : class$com$sap$mw$jco$util$SAPNUCByteToCharConverter));
                SAPNUCByteToCharConverter.nativeInitializer();
            }
            catch (Exception ex) {
                Trc.criticalTrace("Class initialization failed for " + (class$com$sap$mw$jco$util$SAPNUCByteToCharConverter == null ? (class$com$sap$mw$jco$util$SAPNUCByteToCharConverter = SAPNUCByteToCharConverter.class$("com.sap.mw.jco.util.SAPNUCByteToCharConverter")) : class$com$sap$mw$jco$util$SAPNUCByteToCharConverter).getName(), ex);
            }
            catch (Error e) {
                Trc.criticalTrace("Class initialization failed for " + (class$com$sap$mw$jco$util$SAPNUCByteToCharConverter == null ? (class$com$sap$mw$jco$util$SAPNUCByteToCharConverter = SAPNUCByteToCharConverter.class$("com.sap.mw.jco.util.SAPNUCByteToCharConverter")) : class$com$sap$mw$jco$util$SAPNUCByteToCharConverter).getName(), e);
            }
        }
    }
}

