/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mw.jco.util;

import com.sap.bc.proj.jstartup.JStartupNatives;
import com.sap.mw.jco.JCO;
import com.sap.mw.jco.util.SAPByteToCharConverter;
import com.sap.mw.jco.util.SAPCharToByteConverter;
import com.sap.mw.jco.util.SAPCharToNUCByteConverter;
import com.sap.mw.jco.util.SAPCharToUCBEByteConverter;
import com.sap.mw.jco.util.SAPCharToUCLEByteConverter;
import com.sap.mw.jco.util.SAPCharToUTF8ByteConverter;
import com.sap.mw.jco.util.SAPNUCByteToCharConverter;
import com.sap.mw.jco.util.SAPUCBEByteToCharConverter;
import com.sap.mw.jco.util.SAPUCLEByteToCharConverter;
import com.sap.mw.jco.util.SAPUTF8ByteToCharConverter;
import com.sap.mw.rfc.engine.Trc;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;

public abstract class SAPConverters {
    private static Hashtable m_SAPByteToCharConverters = new Hashtable(11);
    private static Hashtable m_SAPCharToByteConverters = new Hashtable(11);
    static /* synthetic */ Class class$com$sap$mw$jco$util$SAPConverters;

    public static native int nativeInitialize();

    public static SAPByteToCharConverter getSAPByteToCharConverter(String charEncoding) {
        SAPByteToCharConverter converter = (SAPByteToCharConverter)m_SAPByteToCharConverters.get(charEncoding);
        if (converter == null) {
            Hashtable hashtable = m_SAPByteToCharConverters;
            synchronized (hashtable) {
                converter = (SAPByteToCharConverter)m_SAPByteToCharConverters.get(charEncoding);
                if (converter == null) {
                    if (charEncoding != null) {
                        String lowerCharEncoding = charEncoding.toLowerCase();
                        if (lowerCharEncoding.indexOf("41") >= 0) {
                            if ("4102".equals(lowerCharEncoding) || "sap4102".equals(lowerCharEncoding)) {
                                converter = new SAPUCBEByteToCharConverter("SAP4102");
                            } else if ("4103".equals(lowerCharEncoding) || "sap4103".equals(lowerCharEncoding)) {
                                converter = new SAPUCLEByteToCharConverter("SAP4103");
                            } else if ("4110".equals(lowerCharEncoding) || "sap4110".equals(lowerCharEncoding)) {
                                converter = new SAPUTF8ByteToCharConverter("SAP4110");
                            }
                        } else if (lowerCharEncoding.startsWith("utf")) {
                            if ("utf-8".equals(lowerCharEncoding) || "utf8".equals(lowerCharEncoding)) {
                                converter = new SAPUTF8ByteToCharConverter("UTF-8");
                            } else if ("utf-16".equals(lowerCharEncoding) || "utf16".equals(lowerCharEncoding)) {
                                String endian = ((String)AccessController.doPrivileged(new PrivilegedAction(){

                                    public Object run() {
                                        String prop = System.getProperty("sun.cpu.endian");
                                        if (prop == null) {
                                            prop = System.getProperty("sun.io.unicode.encoding", "null");
                                        }
                                        return prop;
                                    }
                                })).toLowerCase();
                                converter = endian.indexOf("little") >= 0 ? new SAPUCLEByteToCharConverter("UTF-16LE") : new SAPUCBEByteToCharConverter("UTF-16BE");
                            } else if ("utf-16be".equals(lowerCharEncoding) || "utf16be".equals(lowerCharEncoding) || "utf-16 bigendian".equals(lowerCharEncoding)) {
                                converter = new SAPUCBEByteToCharConverter("UTF-16BE");
                            } else if ("utf-16le".equals(lowerCharEncoding) || "utf16le".equals(lowerCharEncoding) || "utf-16 littleendian".equals(lowerCharEncoding)) {
                                converter = new SAPUCLEByteToCharConverter("UTF-16LE");
                            }
                        } else if (lowerCharEncoding.startsWith("unicode")) {
                            if ("unicode".equals(lowerCharEncoding)) {
                                String endian = ((String)AccessController.doPrivileged(new PrivilegedAction(){

                                    public Object run() {
                                        String prop = System.getProperty("sun.cpu.endian");
                                        if (prop == null) {
                                            prop = System.getProperty("sun.io.unicode.encoding", "null");
                                        }
                                        return prop;
                                    }
                                })).toLowerCase();
                                converter = endian.indexOf("little") >= 0 ? new SAPUCLEByteToCharConverter("UnicodeLittle") : new SAPUCBEByteToCharConverter("UnicodeBig");
                            } else if ("unicodebig".equals(lowerCharEncoding) || "unicodebigunmarked".equals(lowerCharEncoding)) {
                                converter = new SAPUCBEByteToCharConverter("UnicodeBig");
                            } else if ("unicodelittle".equals(lowerCharEncoding) || "unicodelittleunmarked".equals(lowerCharEncoding)) {
                                converter = new SAPUCLEByteToCharConverter("UnicodeLittle");
                            }
                        } else if ("ascii".equals(lowerCharEncoding) || "6100".equals(lowerCharEncoding) || "sap6100".equals(lowerCharEncoding)) {
                            converter = new SAPNUCByteToCharConverter("SAP1100");
                        } else if ("ebcdic".equals(lowerCharEncoding)) {
                            converter = new SAPNUCByteToCharConverter("SAP0120");
                        }
                    }
                    if (converter == null) {
                        converter = new SAPNUCByteToCharConverter(charEncoding);
                    }
                    m_SAPByteToCharConverters.put(charEncoding, converter);
                }
            }
        }
        return converter;
    }

    public static SAPCharToByteConverter getSAPCharToByteConverter(String charEncoding) {
        SAPCharToByteConverter converter = (SAPCharToByteConverter)m_SAPCharToByteConverters.get(charEncoding);
        if (converter == null) {
            Hashtable hashtable = m_SAPCharToByteConverters;
            synchronized (hashtable) {
                converter = (SAPCharToByteConverter)m_SAPCharToByteConverters.get(charEncoding);
                if (converter == null) {
                    if (charEncoding != null) {
                        String lowerCharEncoding = charEncoding.toLowerCase();
                        if (lowerCharEncoding.indexOf("41") >= 0) {
                            if ("4102".equals(lowerCharEncoding) || "sap4102".equals(lowerCharEncoding)) {
                                converter = new SAPCharToUCBEByteConverter("SAP4102");
                            } else if ("4103".equals(lowerCharEncoding) || "sap4103".equals(lowerCharEncoding)) {
                                converter = new SAPCharToUCLEByteConverter("SAP4103");
                            } else if ("4110".equals(lowerCharEncoding) || "sap4110".equals(lowerCharEncoding)) {
                                converter = new SAPCharToUTF8ByteConverter("SAP4110");
                            }
                        } else if (lowerCharEncoding.startsWith("utf")) {
                            if ("utf-8".equals(lowerCharEncoding) || "utf8".equals(lowerCharEncoding)) {
                                converter = new SAPCharToUTF8ByteConverter("UTF-8");
                            } else if ("utf-16".equals(lowerCharEncoding) || "utf16".equals(lowerCharEncoding)) {
                                String endian = ((String)AccessController.doPrivileged(new PrivilegedAction(){

                                    public Object run() {
                                        String prop = System.getProperty("sun.cpu.endian");
                                        if (prop == null) {
                                            prop = System.getProperty("sun.io.unicode.encoding", "null");
                                        }
                                        return prop;
                                    }
                                })).toLowerCase();
                                converter = endian.indexOf("little") >= 0 ? new SAPCharToUCLEByteConverter("UTF-16LE") : new SAPCharToUCBEByteConverter("UTF-16BE");
                            } else if ("utf-16be".equals(lowerCharEncoding) || "utf16be".equals(lowerCharEncoding) || "utf-16 bigendian".equals(lowerCharEncoding)) {
                                converter = new SAPCharToUCBEByteConverter("UTF-16BE");
                            } else if ("utf-16le".equals(lowerCharEncoding) || "utf16le".equals(lowerCharEncoding) || "utf-16 littleendian".equals(lowerCharEncoding)) {
                                converter = new SAPCharToUCLEByteConverter("UTF-16LE");
                            }
                        } else if (lowerCharEncoding.startsWith("unicode")) {
                            if ("unicode".equals(lowerCharEncoding)) {
                                String endian = ((String)AccessController.doPrivileged(new PrivilegedAction(){

                                    public Object run() {
                                        String prop = System.getProperty("sun.cpu.endian");
                                        if (prop == null) {
                                            prop = System.getProperty("sun.io.unicode.encoding", "null");
                                        }
                                        return prop;
                                    }
                                })).toLowerCase();
                                converter = endian.indexOf("little") >= 0 ? new SAPCharToUCLEByteConverter("UnicodeLittle") : new SAPCharToUCBEByteConverter("UnicodeBig");
                            } else if ("unicodebig".equals(lowerCharEncoding) || "unicodebigunmarked".equals(lowerCharEncoding)) {
                                converter = new SAPCharToUCBEByteConverter("UnicodeBig");
                            } else if ("unicodelittle".equals(lowerCharEncoding) || "unicodelittleunmarked".equals(lowerCharEncoding)) {
                                converter = new SAPCharToUCLEByteConverter("UnicodeLittle");
                            }
                        } else if ("ascii".equals(lowerCharEncoding) || "6100".equals(lowerCharEncoding) || "sap6100".equals(lowerCharEncoding)) {
                            converter = new SAPCharToNUCByteConverter("SAP1100");
                        } else if ("ebcdic".equals(lowerCharEncoding)) {
                            converter = new SAPCharToNUCByteConverter("SAP0120");
                        }
                    }
                    if (converter == null) {
                        converter = new SAPCharToNUCByteConverter(charEncoding);
                    }
                    m_SAPCharToByteConverters.put(charEncoding, converter);
                }
            }
        }
        return converter;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        JCO.getProperties();
        if (System.getProperty("jstartup.mode") != null) {
            try {
                JStartupNatives.registerNatives((Class)(class$com$sap$mw$jco$util$SAPConverters == null ? (class$com$sap$mw$jco$util$SAPConverters = SAPConverters.class$("com.sap.mw.jco.util.SAPConverters")) : class$com$sap$mw$jco$util$SAPConverters));
                SAPConverters.nativeInitialize();
            }
            catch (Exception ex) {
                Trc.criticalTrace("Class initialization failed for " + (class$com$sap$mw$jco$util$SAPConverters == null ? (class$com$sap$mw$jco$util$SAPConverters = SAPConverters.class$("com.sap.mw.jco.util.SAPConverters")) : class$com$sap$mw$jco$util$SAPConverters).getName(), ex);
            }
            catch (Error e) {
                Trc.criticalTrace("Class initialization failed for " + (class$com$sap$mw$jco$util$SAPConverters == null ? (class$com$sap$mw$jco$util$SAPConverters = SAPConverters.class$("com.sap.mw.jco.util.SAPConverters")) : class$com$sap$mw$jco$util$SAPConverters).getName(), e);
            }
        }
    }
}

