/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mw.jco.util;

public final class FastStringBuffer {
    char[] buf;
    int capacity;
    int pos;

    public FastStringBuffer() {
        this(256);
    }

    public FastStringBuffer(int size) {
        this.capacity = size;
        this.buf = new char[size];
        this.pos = 0;
    }

    public void ensureCapacity(int capacity) {
        if (this.capacity < capacity) {
            do {
                this.capacity *= 2;
            } while (this.capacity < capacity);
            char[] newbuf = new char[this.capacity];
            System.arraycopy(this.buf, 0, newbuf, 0, this.pos);
            this.buf = newbuf;
        }
    }

    public void reset() {
        this.pos = 0;
    }

    public int length() {
        return this.pos;
    }

    public FastStringBuffer append(String value) {
        if (value == null) {
            return this;
        }
        int len = value.length();
        this.ensureCapacity(this.pos + len);
        value.getChars(0, len, this.buf, this.pos);
        this.pos += len;
        return this;
    }

    public FastStringBuffer append(char value) {
        this.ensureCapacity(this.pos + 1);
        this.buf[this.pos] = value;
        ++this.pos;
        return this;
    }

    public FastStringBuffer append(char[] value) {
        if (value == null) {
            return this;
        }
        return this.append(value, 0, value.length);
    }

    public FastStringBuffer append(int value) {
        return this.append(Integer.toString(value));
    }

    public FastStringBuffer append(long value) {
        return this.append(Long.toString(value));
    }

    public FastStringBuffer append(byte value) {
        return this.append(Byte.toString(value));
    }

    public FastStringBuffer append(char[] value, int offset, int len) {
        if (value == null) {
            return this;
        }
        this.ensureCapacity(this.pos + len);
        System.arraycopy(value, offset, this.buf, this.pos, len);
        this.pos += len;
        return this;
    }

    public String toString() {
        return new String(this.buf, 0, this.pos);
    }

    public char[] getBufferReference() {
        return this.buf;
    }
}

