/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mw.jco;

import com.sap.mw.jco.Converter;
import com.sap.mw.jco.JCO;
import com.sap.mw.rfc.api.IRfcParameter;
import java.io.UnsupportedEncodingException;

public class Parameter
implements IRfcParameter {
    JCO.ParameterList parameterList;
    int index;
    Converter converter;
    int numBytes;

    protected Parameter(JCO.ParameterList parameterList, int index) {
        this(parameterList, index, null);
    }

    protected Parameter(JCO.ParameterList parameterList, int index, Converter converter) {
        this.parameterList = parameterList;
        this.index = index;
        this.converter = converter;
        this.numBytes = 0;
    }

    public void setConverter(Converter converter) {
        this.converter = converter;
    }

    public String getName() {
        return this.parameterList.name[this.index];
    }

    public int getType() {
        return this.parameterList.type[this.index];
    }

    public byte[] getBytes() {
        byte[] ret = null;
        switch (this.parameterList.type[this.index]) {
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                ret = new byte[this.parameterList.length[this.index]];
                this.converter.decodeNumber(this.parameterList, ret, this.index, 0, this.parameterList.length[this.index]);
                break;
            }
            case 2: 
            case 4: {
                ret = new byte[this.parameterList.length[this.index]];
                this.converter.decodeBinary(this.parameterList, ret, this.index, 0, this.parameterList.length[this.index]);
                break;
            }
            case 0: 
            case 1: 
            case 3: 
            case 6: {
                ret = new byte[this.parameterList.length[this.index]];
                this.converter.decodeChar(this.parameterList, ret, this.index, 0, this.parameterList.length[this.index]);
                break;
            }
            case 29: {
                try {
                    String value = (String)this.parameterList.odata[this.parameterList.oindex[this.index]];
                    if (value == null) {
                        ret = new byte[1];
                    } else {
                        byte[] temp = value.getBytes("UTF8");
                        ret = new byte[temp.length + 1];
                        System.arraycopy(temp, 0, ret, 0, temp.length);
                    }
                    this.numBytes = ret.length;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
                break;
            }
            case 30: {
                ret = (byte[])this.parameterList.odata[this.parameterList.oindex[this.index]];
                if (ret == null) {
                    ret = new byte[]{};
                }
                this.numBytes = ret.length;
                break;
            }
            default: {
                ret = new byte[]{};
            }
        }
        return ret;
    }

    public void setBytes(byte[] rfcBytes) {
        switch (this.parameterList.type[this.index]) {
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                this.converter.encodeNumber(this.parameterList, rfcBytes, this.index, 0, rfcBytes.length);
                break;
            }
            case 2: 
            case 4: {
                this.converter.encodeBinary(this.parameterList, rfcBytes, this.index, 0, rfcBytes.length);
                break;
            }
            case 0: 
            case 1: 
            case 3: 
            case 6: {
                this.converter.encodeChar(this.parameterList, rfcBytes, this.index, 0, rfcBytes.length);
                break;
            }
            case 29: {
                try {
                    this.parameterList.odata[this.parameterList.oindex[this.index]] = new String(rfcBytes, 0, rfcBytes.length - 1, "UTF8");
                    this.numBytes = rfcBytes.length;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
                break;
            }
            case 30: {
                this.parameterList.odata[this.parameterList.oindex[this.index]] = rfcBytes;
                this.numBytes = rfcBytes.length;
                break;
            }
        }
        int n = this.index;
        this.parameterList.flags[n] = (byte)(this.parameterList.flags[n] & 0xFFFFFFF7);
    }

    public int getNumBytes() {
        switch (this.parameterList.type[this.index]) {
            case 29: 
            case 30: {
                return this.numBytes;
            }
        }
        return this.parameterList.length[this.index];
    }
}

