/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mw.jco;

import com.sap.mw.jco.Converter;
import com.sap.mw.jco.JCO;
import com.sap.mw.jco.StructureParameter;

public class FlatStructure
extends StructureParameter {
    JCO.Structure structure;
    Converter converter;

    protected FlatStructure(JCO.Structure structure, String name) {
        this(structure, name, 0, new byte[1]);
    }

    protected FlatStructure(JCO.Structure structure, String name, int index, byte[] flags) {
        this(structure, name, null, index, flags);
    }

    protected FlatStructure(JCO.Structure structure, String name, Converter converter, int index, byte[] flags) {
        super(name, index, flags);
        this.structure = structure;
        this.converter = converter;
    }

    public void setConverter(Converter converter) {
        this.converter = converter;
    }

    public int getType() {
        return 17;
    }

    public byte[] getBytes() {
        byte[] ret = new byte[this.structure.tab_length];
        int i = 0;
        while (i < this.structure.num_fields) {
            switch (this.structure.type[i]) {
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    this.converter.decodeNumber(this.structure, ret, i, this.structure.offset[i], this.structure.length[i]);
                    break;
                }
                case 2: 
                case 4: {
                    this.converter.decodeBinary(this.structure, ret, i, this.structure.offset[i], this.structure.length[i]);
                    break;
                }
                case 0: 
                case 1: 
                case 3: 
                case 6: {
                    this.converter.decodeChar(this.structure, ret, i, this.structure.offset[i], this.structure.length[i]);
                    break;
                }
            }
            ++i;
        }
        return ret;
    }

    public void setBytes(byte[] rfcBytes) {
        this.structure.ensureBufferCapacity();
        int i = 0;
        while (i < this.structure.num_fields && this.structure.offset[i] < rfcBytes.length) {
            switch (this.structure.type[i]) {
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    this.converter.encodeNumber(this.structure, rfcBytes, i, this.structure.offset[i], this.structure.length[i]);
                    break;
                }
                case 2: 
                case 4: {
                    this.converter.encodeBinary(this.structure, rfcBytes, i, this.structure.offset[i], this.structure.length[i]);
                    break;
                }
                case 0: 
                case 1: 
                case 3: 
                case 6: {
                    this.converter.encodeChar(this.structure, rfcBytes, i, this.structure.offset[i], this.structure.length[i]);
                    break;
                }
            }
            ++i;
        }
        int n = this.index;
        this.flags[n] = (byte)(this.flags[n] & 0xFFFFFFF7);
    }

    public JCO.Structure getStructure() {
        return this.structure;
    }

    public int getNumBytes() {
        return this.structure.tab_length;
    }
}

