/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mw.jco;

import com.sap.mw.jco.JCO;
import com.sap.mw.jco.StructureParameter;
import com.sap.mw.jco.XRfcParser;
import com.sap.mw.jco.util.FastBufferedWriter;
import com.sap.mw.jco.util.XRfcOutputStream;
import com.sap.mw.rfc.api.IRfcComplexParameter;
import com.sap.mw.rfc.engine.RfcIoOpenCntl;
import com.sap.mw.rfc.exceptions.RfcIoException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;

public class ComplexParameter
extends StructureParameter
implements IRfcComplexParameter {
    JCO.Record complexParameter;
    int numBytes;
    XRfcParser parser;

    protected ComplexParameter(JCO.Record complexParameter, String name, int index, byte[] flags) {
        super(name, index, flags);
        this.complexParameter = complexParameter;
        this.numBytes = 0;
    }

    public int getType() {
        return 42;
    }

    public byte[] getBytes() {
        String xmlData = JCO.Record.XMLWriter.createXMLDocument(this.complexParameter, this.name);
        try {
            byte[] xmlBytes = xmlData.getBytes("UTF8");
            this.numBytes = xmlBytes.length;
            return xmlBytes;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.numBytes = 0;
            return new byte[0];
        }
    }

    public void setBytes(byte[] rfcBytes) {
        this.complexParameter.ensureBufferCapacity();
        try {
            String xmlData = new String(rfcBytes, "UTF8");
            this.complexParameter.fromXML(xmlData);
            int n = this.index;
            this.flags[n] = (byte)(this.flags[n] & 0xFFFFFFF7);
            this.numBytes = rfcBytes.length;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public int getNumBytes() {
        return this.numBytes;
    }

    public void sendXmlDataStream(RfcIoOpenCntl act_cntl) throws RfcIoException {
        try {
            XRfcOutputStream xrfcStream = new XRfcOutputStream(act_cntl);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)xrfcStream, "UTF8");
            FastBufferedWriter buf = new FastBufferedWriter(osw, 14336);
            JCO.Record.XMLWriter.writeXMLDocument(this.complexParameter, this.name, buf);
            buf.close();
            this.numBytes = xrfcStream.getNumBytes();
        }
        catch (RfcIoException rioe) {
            throw rioe;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void receiveXmlDataFinished() {
        this.parser.setFinished();
    }

    public void setXmlBytes(byte[] xmlBytes) {
        this.parser.setBytes(xmlBytes);
        this.parser.parse();
        this.numBytes += xmlBytes.length;
    }

    public void receiveXmlDataStarted() {
        this.parser = new XRfcParser(this.complexParameter);
        this.numBytes = 0;
        int n = this.index;
        this.flags[n] = (byte)(this.flags[n] & 0xFFFFFFF7);
    }
}

