/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.runtime;

import com.sap.dictionary.runtime.DdException;
import com.sap.dictionary.runtime.ExType;
import com.sap.dictionary.runtime.IDataProvider;
import com.sap.dictionary.runtime.IDataType;
import com.sap.dictionary.runtime.IField;
import com.sap.dictionary.runtime.IStructure;
import com.sap.lcr.api.sapmodel.SAP_MsgServJCODestination;
import com.sap.tc.logging.Location;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public final class ProviderFactory {
    private static ISldConnectionSupplier theSldConnectionSupplier = null;
    private static final Location logger = Location.getLocation((String)(class$com$sap$dictionary$runtime$ProviderFactory == null ? (class$com$sap$dictionary$runtime$ProviderFactory = ProviderFactory.class$("com.sap.dictionary.runtime.ProviderFactory")) : class$com$sap$dictionary$runtime$ProviderFactory).getName());
    private static String theProviderName;
    private final Map logicalProviderMap = new HashMap();
    private final Map physicalProviderMap = new HashMap();
    private final Map logicalToPhysicalMap = new HashMap();
    private static final ProviderFactory theInstance;
    private static final String J2EE_SYSTEM_NAME = "SAPSYSTEMNAME";
    private static final String J2EE_HOST_NAME = "j2ee.dbhost";
    private static final String USE_PROPERTY_FILE = "ddic.provider.useProfile";
    private static String propertyFilePath;
    static /* synthetic */ Class class$com$sap$dictionary$runtime$ProviderFactory;
    static /* synthetic */ Class class$java$lang$String;

    public static void setSldCallack(ISldConnectionSupplier supplier) {
        if (theSldConnectionSupplier == null) {
            theSldConnectionSupplier = supplier;
        }
    }

    public static void main(String[] args) {
        try {
            theProviderName = "com.sap.dictionary.runtime.mdi.DataProviderTest";
            IDataProvider theProvider = null;
            theProvider = ProviderFactory.getProvider("DDICCache");
            IDataType theType = theProvider.getDataType("AAA_GRP", Locale.GERMAN);
            if (theType.isStructure()) {
                IStructure theStructure = (IStructure)theType;
                Iterator iter = theStructure.fieldIterator();
                while (iter.hasNext()) {
                    IField theField = (IField)iter.next();
                    System.out.println("Name : " + theField.getName());
                }
            }
            SAP_MsgServJCODestination destination = ProviderFactory.resolveLogicalNameToJCODestination("DDICCache");
            destination = ProviderFactory.resolveLogicalNameToJCODestination("DDICCache");
            System.out.println("Finished");
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    private static final ProviderFactory getInstance() {
        return theInstance;
    }

    private ProviderFactory() {
        propertyFilePath = System.getProperty(USE_PROPERTY_FILE);
    }

    public static final IDataProvider getProvider(String logicalSystemName) throws DdException {
        return ProviderFactory.getInstance().internalGetProvider(logicalSystemName);
    }

    private final IDataProvider internalGetProvider(String logicalSystemName) throws DdException {
        if (logicalSystemName == null) {
            if (logger.beLogged(400)) {
                logger.warningT("DataType Provider Factory called without supplying a logical system name");
            }
            throw new DdException("DataType Provider Factory called without supplying a logical system name");
        }
        IDataProvider provider = null;
        provider = (IDataProvider)this.logicalProviderMap.get(logicalSystemName);
        if (provider != null) {
            return provider;
        }
        Map map = this.logicalProviderMap;
        synchronized (map) {
            provider = (IDataProvider)this.logicalProviderMap.get(logicalSystemName);
            if (provider != null) {
                IDataProvider iDataProvider = provider;
                return iDataProvider;
            }
            SAP_MsgServJCODestination jcoDestination = ProviderFactory.resolveLogicalNameToJCODestination(logicalSystemName);
            if (jcoDestination == null) {
                String msg = "'" + logicalSystemName + "' not properly defined! " + "Unable to create Metadata connection for Dictionary Provider. Either the logical System Name " + "'" + logicalSystemName + "' has not been properly defined in the System Landscape Directory, " + "or you are not using a MsgServerDestination (AppServerDestinations are not permitted for Metadata connections)";
                if (logger.beLogged(400)) {
                    logger.warningT(msg);
                }
                throw new DdException(msg);
            }
            PhysicalBackendProviderKey thePhysicalKey = new PhysicalBackendProviderKey(jcoDestination);
            provider = (IDataProvider)this.physicalProviderMap.get(thePhysicalKey);
            if (provider != null) {
                this.logicalProviderMap.put(logicalSystemName, provider);
                IDataProvider iDataProvider = provider;
                return iDataProvider;
            }
            try {
                Class<?> dataProviderClass = Class.forName(theProviderName);
                Constructor<?> dataProviderConstructor = dataProviderClass.getConstructor(class$java$lang$String == null ? (class$java$lang$String = ProviderFactory.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = ProviderFactory.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = ProviderFactory.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = ProviderFactory.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = ProviderFactory.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = ProviderFactory.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = ProviderFactory.class$("java.lang.String")) : class$java$lang$String);
                Object[] args = new Object[]{jcoDestination.getLogonBCClient(), jcoDestination.getLogonUser(), jcoDestination.getLogonPwd(), jcoDestination.getLogonLanguage(), jcoDestination.getMsgServHost(), jcoDestination.getSAPSystemName(), jcoDestination.getLogonGroup()};
                provider = (IDataProvider)dataProviderConstructor.newInstance(args);
            }
            catch (ClassNotFoundException ex) {
                throw new DdException(ExType.OTHER, "failed to create provider: " + ex.getMessage(), ex);
            }
            catch (NoSuchMethodException ex) {
                throw new DdException(ExType.OTHER, "failed to create provider: " + ex.getMessage(), ex);
            }
            catch (InstantiationException ex) {
                throw new DdException(ExType.OTHER, "failed to create provider: " + ex.getMessage(), ex);
            }
            catch (IllegalAccessException ex) {
                throw new DdException(ExType.OTHER, "failed to create provider: " + ex.getMessage(), ex);
            }
            catch (InvocationTargetException ex) {
                String msg = ex.getMessage();
                if (msg == null && ex.getTargetException() != null) {
                    msg = ex.getTargetException().getMessage();
                }
                if (msg == null) {
                    msg = "<no message available>";
                }
                throw new DdException(ExType.OTHER, "failed to create provider: " + msg, ex);
            }
            if (provider == null) {
                if (logger.beLogged(400)) {
                    String PasswordHelper = new String();
                    if (jcoDestination.getLogonPwd() != null) {
                        if (jcoDestination.getLogonPwd().length() == 0) {
                            PasswordHelper = "<none>";
                        } else {
                            int idx = 0;
                            while (idx < jcoDestination.getLogonPwd().length()) {
                                PasswordHelper = PasswordHelper + "X";
                                ++idx;
                            }
                        }
                    } else {
                        PasswordHelper = "<null>";
                    }
                    logger.warningT("Unable to create Dictionary provider for " + logicalSystemName);
                    logger.warningT("Client : " + jcoDestination.getLogonBCClient());
                    logger.warningT("User : " + jcoDestination.getLogonUser());
                    logger.warningT("Pwd : " + PasswordHelper);
                    logger.warningT("Language" + jcoDestination.getLogonLanguage());
                    logger.warningT("Message Server" + jcoDestination.getMsgServHost());
                    logger.warningT("System" + jcoDestination.getSAPSystemName());
                    logger.warningT("Group" + jcoDestination.getLogonGroup());
                }
                String msg = "'" + logicalSystemName + "' not properly defined! " + "Unable to create Metadata connection for Dictionary Provider. Either the logical System Name " + "'" + logicalSystemName + "' has not been properly defined in the System Landscape Directory, " + "or you are not using a MsgServerDestination (AppServerDestinations are not permitted for Metadata connections)";
                throw new DdException(msg);
            }
            this.logicalProviderMap.put(logicalSystemName, provider);
            this.physicalProviderMap.put(thePhysicalKey, provider);
        }
        return provider;
    }

    public static final SAP_MsgServJCODestination resolveLogicalNameToJCODestination(String logicalSystemName) throws DdException {
        return ProviderFactory.getInstance().internalResolveLogicalNameToJCODestination(logicalSystemName);
    }

    private final SAP_MsgServJCODestination internalResolveLogicalNameToJCODestination(String logicalSystemName) throws DdException {
        SAP_MsgServJCODestination jcoDestination = null;
        Map map = this.logicalToPhysicalMap;
        synchronized (map) {
            if (propertyFilePath != null && propertyFilePath.length() > 0) {
                jcoDestination = new SAP_MsgServJCODestination("", "", "", "");
                try {
                    Properties properties = new Properties();
                    InputStream theStream = (class$com$sap$dictionary$runtime$ProviderFactory == null ? (class$com$sap$dictionary$runtime$ProviderFactory = ProviderFactory.class$("com.sap.dictionary.runtime.ProviderFactory")) : class$com$sap$dictionary$runtime$ProviderFactory).getClassLoader().getResourceAsStream(propertyFilePath);
                    properties.load(theStream);
                    jcoDestination.setLogonBCClient(properties.getProperty("Client"));
                    jcoDestination.setLogonUser(properties.getProperty("User"));
                    jcoDestination.setLogonPwd(properties.getProperty("Password"));
                    jcoDestination.setLogonLanguage(properties.getProperty("Language"));
                    jcoDestination.setMsgServHost(properties.getProperty("MessageServer"));
                    jcoDestination.setSAPSystemName(properties.getProperty("Systemname"));
                    jcoDestination.setLogonGroup(properties.getProperty("Group"));
                    SAP_MsgServJCODestination sAP_MsgServJCODestination = jcoDestination;
                    return sAP_MsgServJCODestination;
                }
                catch (IOException ex) {
                    if (logger.beLogged(400)) {
                        logger.warningT("Unable to read property file for provider connection information");
                    }
                    throw new DdException(ExType.OTHER, "Failed to resolve property file for physical backend: " + ex.getMessage(), ex);
                }
            }
            jcoDestination = (SAP_MsgServJCODestination)this.logicalToPhysicalMap.get(logicalSystemName);
            if (jcoDestination != null) {
                SAP_MsgServJCODestination sAP_MsgServJCODestination = jcoDestination;
                return sAP_MsgServJCODestination;
            }
            if (theSldConnectionSupplier == null) {
                throw new DdException("No connection supplier set. Cannot resolve logical system name " + logicalSystemName);
            }
            jcoDestination = new SAP_MsgServJCODestination("", "", "", "");
            theSldConnectionSupplier.fillSldConnection(logicalSystemName, jcoDestination);
            if (jcoDestination.getMsgServHost() == null || "".equals(jcoDestination.getMsgServHost())) {
                SAP_MsgServJCODestination sAP_MsgServJCODestination = null;
                return sAP_MsgServJCODestination;
            }
            SAP_MsgServJCODestination sAP_MsgServJCODestination = jcoDestination;
            return sAP_MsgServJCODestination;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Location.getLocation((String)"ID.com.sap.dictionary.runtime").infoT("$Id: //tc/DictionaryTypes/630_VAL_REL/src/_dictionary_runtime/java/com/sap/dictionary/runtime/ProviderFactory.java#3 $");
        theProviderName = "com.sap.dictionary.runtime.mdi.DataProvider";
        theInstance = new ProviderFactory();
        propertyFilePath = null;
    }

    private final class PhysicalBackendProviderKey {
        private String key = null;

        public PhysicalBackendProviderKey(SAP_MsgServJCODestination jcoDestination) {
            this.key = jcoDestination.getMsgServHost() + jcoDestination.getSAPSystemName();
        }

        public final boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PhysicalBackendProviderKey)) {
                return false;
            }
            PhysicalBackendProviderKey other = (PhysicalBackendProviderKey)o;
            return this.key.equals(other.key);
        }

        public final int hashCode() {
            return this.key.hashCode();
        }
    }

    public static interface ISldConnectionSupplier {
        public void fillSldConnection(String var1, SAP_MsgServJCODestination var2) throws DdException;
    }
}

