/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.runtime;

import com.sap.dictionary.runtime.DdCheckException;
import com.sap.dictionary.runtime.DdConstants;
import com.sap.dictionary.runtime.DdMsgHandler;
import com.sap.dictionary.runtime.DdRuntimeException;
import com.sap.dictionary.runtime.DdSimpleType;
import com.sap.dictionary.runtime.ExTexts;
import com.sap.dictionary.runtime.ExType;
import com.sap.dictionary.runtime.IDataProvider;
import com.sap.dictionary.runtime.StringUtil;
import com.sap.dictionary.runtime.XmlMap;
import com.sap.typeservices.ISimpleValueServices;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Locale;

public class DdTypeString
extends DdSimpleType
implements DdConstants {
    private int length = 0;
    private int minLength = 0;
    private int maxLength = 0;
    private XmlMap xmlMap = null;
    private String defaultValue = null;
    String enumClassName = null;
    Class enumClass = null;
    private boolean isNumeric = false;
    static /* synthetic */ Class class$java$lang$String;

    public DdTypeString(IDataProvider provider, Locale locale, XmlMap xmlMap) {
        super(provider, locale, xmlMap);
        this.xmlMap = xmlMap;
        XmlMap tmap = xmlMap.getXmlMap("SimpleType");
        this.isNumeric = tmap.getBoolean("isNumeric");
        XmlMap smap = tmap.getXmlMap("SchemaType");
        this.length = smap.getInt("length");
        this.minLength = smap.getInt("minLength");
        this.maxLength = smap.getInt("maxLength");
        XmlMap enumMap = tmap.getXmlMap("EnumerationValues");
        if (enumMap != null) {
            this.setEnum(enumMap.getAuthenticStringSet("EnumerationValue", "value"));
        }
        XmlMap emap = tmap.getXmlMap("ExternalRepresentation");
        this.defaultValue = emap.getString("defaultValue");
        HashMap hints = tmap.getStringMap("Hint", "softwareLanguage", "languageDataType");
        if (hints != null) {
            this.enumClassName = (String)hints.get("java");
            try {
                if (!this.enumClassName.equalsIgnoreCase("java.lang.String")) {
                    this.enumClass = provider.getClassLoader().loadClass(this.enumClassName);
                }
            }
            catch (ClassNotFoundException ex) {
                throw new DdRuntimeException(ExType.CLASS_NOT_FOUND, ex.getMessage());
            }
        }
    }

    public Class getAttributeClass() {
        if (this.enumClass != null) {
            return this.enumClass;
        }
        return class$java$lang$String == null ? (class$java$lang$String = DdTypeString.class$("java.lang.String")) : class$java$lang$String;
    }

    public String format(Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof String) {
            return this.format((String)value);
        }
        return value.toString();
    }

    public String format(String value) {
        if (value == null) {
            return "";
        }
        if (this.getFormat() != null && this.getFormat().equalsIgnoreCase("ALPHA")) {
            return StringUtil.ConversionExitAlphaOutput(value);
        }
        return value.toString();
    }

    public String formatOfDefaultValue() {
        if (this.defaultValue != null) {
            return this.format(this.defaultValue);
        }
        return null;
    }

    public Object parse(String value) throws ParseException {
        if (this.enumClass != null) {
            if (value.equalsIgnoreCase("")) {
                return null;
            }
            Method m = null;
            try {
                m = this.enumClass.getMethod("valueOf", class$java$lang$String == null ? (class$java$lang$String = DdTypeString.class$("java.lang.String")) : class$java$lang$String);
            }
            catch (NoSuchMethodException ex) {
                throw new DdRuntimeException(ExType.CLASS_NOT_FOUND, ex.getMessage());
            }
            try {
                return m.invoke(null, value);
            }
            catch (Exception ex) {
                if (ex instanceof InvocationTargetException) {
                    throw new ParseException(ex.getMessage(), 0);
                }
                throw new DdRuntimeException(ex.getMessage());
            }
        }
        return this.parseString(value);
    }

    public String parse(String value, String text) throws ParseException {
        return this.parseString(text);
    }

    public String parseString(String value) throws ParseException {
        if (value != null) {
            value.trim();
        }
        if (StringUtil.isEmpty(value)) {
            return null;
        }
        this.checkAfterParse(value);
        if (this.isNumeric() && !StringUtil.isNumericValue(value)) {
            throw new ParseException(DdMsgHandler.get(DdConstants.NO_NUMERIC_VALUE, new Object[]{value}), 0);
        }
        String format = this.getFormat();
        if (format != null && format.equalsIgnoreCase("ALPHA")) {
            int length = this.getMaxLength();
            if (length == 0) {
                length = this.getLength();
            }
            value = StringUtil.ConversionExitAlphaInput(value, length);
        }
        return value;
    }

    public boolean isValid(Object value) {
        if (value == null) {
            return super.isValidNull(value);
        }
        if (value instanceof String) {
            return this.isValid((String)value);
        }
        throw new IllegalArgumentException();
    }

    public boolean isValid(String value) {
        if (value == null) {
            return super.isValidNull(value);
        }
        return !(this.length != 0 && value.length() != this.length || this.minLength != 0 && value.length() < this.minLength || this.maxLength != 0 && value.length() > this.maxLength || !this.matchesPattern(value) || !this.matchesEnumeration(value));
    }

    public void checkValid(Object value) throws DdCheckException {
        if (value == null) {
            if (!super.isValidNull(value)) {
                throw new DdCheckException(DdConstants.NULL_NOT_VALID, new Object[0]);
            }
            return;
        }
        String stringValue = null;
        if (!(value instanceof String)) {
            if (this.enumClass != null) {
                if (!this.matchesEnumeration(value)) {
                    throw new DdCheckException(DdConstants.NO_ENUM_MATCHING, new Object[]{value.toString()});
                }
                return;
            }
            throw new DdCheckException(DdConstants.NOT_VALID, new Object[]{value.toString(), value.getClass().getName()});
        }
        stringValue = (String)value;
        if (this.isNumeric() && !StringUtil.isNumericValue(stringValue)) {
            throw new DdCheckException(DdConstants.NO_NUMERIC_VALUE, new Object[]{stringValue});
        }
        int maxExtLength = this.getMaxExternalLength();
        if (maxExtLength != 0 && stringValue.length() > maxExtLength) {
            throw new DdCheckException(DdConstants.WRONG_MAX_EXT_LENGTH_S, new Object[]{stringValue, new Integer(maxExtLength).toString()});
        }
        if (maxExtLength == 0) {
            if (this.length != 0 && stringValue.length() != this.length) {
                throw new DdCheckException(DdConstants.WRONG_FIXED_LENGTH_S, new Object[]{stringValue, new Integer(this.length).toString()});
            }
            if (this.minLength != 0 && stringValue.length() < this.minLength) {
                throw new DdCheckException(DdConstants.WRONG_MIN_LENGTH_S, new Object[]{stringValue, new Integer(this.minLength).toString()});
            }
            if (this.maxLength != 0 && stringValue.length() > this.maxLength) {
                throw new DdCheckException(DdConstants.WRONG_MAX_LENGTH_S, new Object[]{stringValue, new Integer(this.maxLength).toString()});
            }
        }
        if (!this.matchesPattern(stringValue)) {
            throw new DdCheckException(DdConstants.NO_PATTERN_MATCHING_S, new Object[]{value.toString(), this.getPattern()});
        }
        if (!this.matchesEnumeration(stringValue)) {
            throw new DdCheckException(DdConstants.NO_ENUM_MATCHING_S, new Object[]{value.toString()});
        }
    }

    private boolean matchesPattern(String value) {
        return true;
    }

    private boolean matchesEnumeration(Object value) throws DdCheckException {
        if (this.getEnum() == null) {
            return true;
        }
        if (value instanceof String) {
            return this.matchesEnumeration((String)value);
        }
        if (this.enumClass != null) {
            try {
                return this.enumClass == value.getClass();
            }
            catch (Exception ex) {
                throw new DdCheckException(ExType.CLASS_NOT_FOUND, (Throwable)ex, DdConstants.WRONG_CLASS, new Object[]{value.toString()});
            }
        }
        throw new IllegalArgumentException();
    }

    private boolean matchesEnumeration(String value) {
        ISimpleValueServices svServices;
        if (this.hasSVService() && (svServices = this.getSVServices()) != null) {
            return svServices.validate(value);
        }
        if (this.getEnum() == null) {
            return true;
        }
        return this.getEnum().isEmpty() || this.getEnum().contains(value);
    }

    public void setLength(int length) {
        if (this.isModifyAllowed()) {
            this.length = length;
        }
    }

    public void setMinLength(int minLength) {
        if (this.isModifyAllowed()) {
            this.minLength = minLength;
        }
    }

    public void setMaxLength(int maxLength) {
        if (this.isModifyAllowed()) {
            this.maxLength = maxLength;
        }
    }

    public int getLength() {
        return this.length;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public String toString() {
        return super.toString() + "  SchemaType" + "\n" + "    length               : " + this.length + "\n" + "    minLength            : " + this.minLength + "\n" + "    maxLength            : " + this.maxLength + "\n" + "  Enumeration" + "\n" + StringUtil.enumerationToString(this.getEnum(), this.getEnumerationTexts());
    }

    private void checkAfterParse(String value) throws ParseException {
        if (this.isValidationAfterParse() && !this.isValid(value)) {
            throw new ParseException(value + " " + ExTexts.get("002"), 0);
        }
    }

    public boolean isNumeric() {
        return this.isNumeric;
    }

    /*
     * Unable to fully structure code
     */
    private String escapeWhitespaces(String s) {
        t = "";
        i = 0;
        i = s.indexOf(" ", 0);
        if (i != -1) ** GOTO lbl9
        return s;
lbl-1000:
        // 1 sources

        {
            t = i == 0 ? t + "\\ " : t + s.substring(0, i) + "\\ ";
            s = s.substring(i + 1, s.length());
            i = s.indexOf(" ", 0);
lbl9:
            // 2 sources

            ** while (i > -1)
        }
lbl10:
        // 1 sources

        return t + s;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

