/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.runtime;

import com.sap.dictionary.runtime.DdConstants;
import com.sap.dictionary.runtime.DdMsgHandler;
import com.sap.dictionary.runtime.DdSimpleType;
import com.sap.dictionary.runtime.IDataProvider;
import com.sap.dictionary.runtime.StringUtil;
import com.sap.dictionary.runtime.XmlMap;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Locale;

public class DdTypeNumber
extends DdSimpleType {
    private static final Format XML_FORMATTER = NumberFormat.getInstance(Locale.US);
    DecimalFormat formatter = null;
    long minByte = new Byte(-128).longValue();
    long maxByte = new Byte(127).longValue();
    long minShort = new Short(Short.MIN_VALUE).longValue();
    long maxShort = new Short(Short.MAX_VALUE).longValue();
    long minInteger = new Integer(Integer.MIN_VALUE).longValue();
    long maxInteger = new Integer(Integer.MAX_VALUE).longValue();
    long minLong = new Long(Long.MIN_VALUE);
    long maxLong = new Long(Long.MAX_VALUE);
    private String numberExample = "";
    private String decimalExample = "";

    public DdTypeNumber(IDataProvider provider, Locale locale, XmlMap xmlMap) {
        super(provider, locale, xmlMap);
        this.setFormatter();
    }

    public String format(Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof Float) {
            return this.format((Float)value);
        }
        return this.formatter.format(value);
    }

    public String format(BigDecimal value) {
        if (value == null) {
            return "";
        }
        return this.formatter.format(value);
    }

    public String format(BigInteger value) {
        if (value == null) {
            return "";
        }
        return this.formatter.format(value);
    }

    public String format(Byte value) {
        if (value == null) {
            return "";
        }
        return this.formatter.format(value);
    }

    public String format(Double value) {
        if (value == null) {
            return "";
        }
        return this.formatter.format(value);
    }

    public String format(Float value) {
        if (value == null) {
            return "";
        }
        return this.formatter.format(new Double(value.toString()));
    }

    public String format(Integer value) {
        if (value == null) {
            return "";
        }
        return this.formatter.format(value);
    }

    public String format(Long value) {
        if (value == null) {
            return "";
        }
        return this.formatter.format(value);
    }

    public String format(Short value) {
        if (value == null) {
            return "";
        }
        return this.formatter.format(value);
    }

    public String format(byte value) {
        return this.formatter.format(new Byte(value));
    }

    public String format(double value) {
        return this.formatter.format(value);
    }

    public String format(float value) {
        return this.formatter.format(new Double(new Float(value).toString()));
    }

    public String format(int value) {
        return this.formatter.format(new Integer(value));
    }

    public String format(long value) {
        return this.formatter.format(value);
    }

    public String format(short value) {
        return this.formatter.format(new Short(value));
    }

    public Object parseObject(String text) throws ParseException {
        if (text.equals("")) {
            return null;
        }
        return this.formatter.parse(text);
    }

    public BigDecimal parseDecimal(String text) throws ParseException {
        if (text.equals("")) {
            return null;
        }
        ParsePosition pos = new ParsePosition(0);
        Number parseValue = this.formatter.parse(text, pos);
        if (text.length() > pos.getIndex()) {
            this.setDecimalExample();
            throw new ParseException(DdMsgHandler.get(DdConstants.ERROR_DURING_PARSE, new Object[]{this.decimalExample}), 0);
        }
        try {
            return new BigDecimal(parseValue.toString());
        }
        catch (NumberFormatException ex) {
            this.setDecimalExample();
            throw new ParseException(DdMsgHandler.get(DdConstants.ERROR_DURING_PARSE_NO_VALID, new Object[]{text, this.decimalExample}), 0);
        }
    }

    public BigInteger parseBigInteger(String text) throws ParseException {
        if (text.equals("")) {
            return null;
        }
        ParsePosition pos = new ParsePosition(0);
        Number parseValue = this.formatter.parse(text, pos);
        if (text.length() > pos.getIndex()) {
            throw new ParseException(DdMsgHandler.get(DdConstants.PARSE_ERROR_NO_BIG_INTEGER), 0);
        }
        return new BigInteger(new Integer(parseValue.intValue()).toString());
    }

    public Byte parseByteObject(String text) throws ParseException {
        if (text.equals("")) {
            return null;
        }
        ParsePosition pos = new ParsePosition(0);
        Number parseValue = this.formatter.parse(text, pos);
        if (text.length() > pos.getIndex()) {
            throw new ParseException(DdMsgHandler.get(DdConstants.PARSE_ERROR_UNALLOWED_CHARS, new Object[]{text}), 0);
        }
        if (parseValue instanceof Double) {
            throw new ParseException(DdMsgHandler.get(DdConstants.PARSE_ERROR_NO_INTEGER, new Object[]{Long.toString(this.minByte), Long.toString(this.maxByte)}), 0);
        }
        long parseValueLong = parseValue.longValue();
        if (parseValueLong < this.minByte || parseValueLong > this.maxByte) {
            throw new ParseException(DdMsgHandler.get(DdConstants.PARSE_ERROR_NO_INTEGER, new Object[]{Long.toString(this.minByte), Long.toString(this.maxByte)}), 0);
        }
        return new Byte(parseValue.byteValue());
    }

    public Double parseDoubleObject(String text) throws ParseException {
        if (text.equals("")) {
            return null;
        }
        ParsePosition pos = new ParsePosition(0);
        Number parseValue = this.formatter.parse(text, pos);
        if (text.length() > pos.getIndex()) {
            this.setNumberExample();
            throw new ParseException(DdMsgHandler.get(DdConstants.ERROR_DURING_PARSE, new Object[]{this.numberExample}), 0);
        }
        return new Double(parseValue.doubleValue());
    }

    public Float parseFloatObject(String text) throws ParseException {
        if (text.equals("")) {
            return null;
        }
        ParsePosition pos = new ParsePosition(0);
        Number parseValue = this.formatter.parse(text, pos);
        if (text.length() > pos.getIndex()) {
            this.setNumberExample();
            throw new ParseException(DdMsgHandler.get(DdConstants.ERROR_DURING_PARSE, new Object[]{this.numberExample}), 0);
        }
        return new Float(parseValue.floatValue());
    }

    public Integer parseInteger(String text) throws ParseException {
        if (text.equals("")) {
            return null;
        }
        ParsePosition pos = new ParsePosition(0);
        Number parseValue = this.formatter.parse(text, pos);
        if (text.length() > pos.getIndex()) {
            throw new ParseException(DdMsgHandler.get(DdConstants.PARSE_ERROR_UNALLOWED_CHARS, new Object[]{text}), 0);
        }
        if (parseValue instanceof Double) {
            throw new ParseException(DdMsgHandler.get(DdConstants.PARSE_ERROR_NO_INTEGER, new Object[]{Long.toString(this.minInteger), Long.toString(this.maxInteger)}), 0);
        }
        long parseValueLong = parseValue.longValue();
        if (parseValueLong < this.minInteger || parseValueLong > this.maxInteger) {
            throw new ParseException(DdMsgHandler.get(DdConstants.PARSE_ERROR_NO_INTEGER, new Object[]{Long.toString(this.minInteger), Long.toString(this.maxInteger)}), 0);
        }
        return new Integer(parseValue.intValue());
    }

    public Long parseLongObject(String text) throws ParseException {
        if (text.equals("")) {
            return null;
        }
        ParsePosition pos = new ParsePosition(0);
        Number parseValue = this.formatter.parse(text, pos);
        if (text.length() > pos.getIndex()) {
            throw new ParseException(DdMsgHandler.get(DdConstants.PARSE_ERROR_UNALLOWED_CHARS, new Object[]{text}), 0);
        }
        if (parseValue instanceof Double) {
            throw new ParseException(DdMsgHandler.get(DdConstants.PARSE_ERROR_NO_INTEGER, new Object[]{Long.toString(this.minLong), Long.toString(this.maxLong)}), 0);
        }
        return new Long(parseValue.longValue());
    }

    public Short parseShortObject(String text) throws ParseException {
        if (text.equals("")) {
            return null;
        }
        ParsePosition pos = new ParsePosition(0);
        Number parseValue = this.formatter.parse(text, pos);
        if (text.length() > pos.getIndex()) {
            throw new ParseException(DdMsgHandler.get(DdConstants.PARSE_ERROR_UNALLOWED_CHARS, new Object[]{text}), 0);
        }
        if (parseValue instanceof Double) {
            throw new ParseException(DdMsgHandler.get(DdConstants.PARSE_ERROR_NO_INTEGER, new Object[]{Long.toString(this.minShort), Long.toString(this.maxShort)}), 0);
        }
        long parseValueLong = parseValue.longValue();
        if (parseValueLong < this.minShort || parseValueLong > this.maxShort) {
            throw new ParseException(DdMsgHandler.get(DdConstants.PARSE_ERROR_NO_INTEGER, new Object[]{Long.toString(this.minShort), Long.toString(this.maxShort)}), 0);
        }
        return new Short(parseValue.shortValue());
    }

    public byte parseByte(String text) throws ParseException {
        if (text.equals("")) {
            throw new ParseException(DdMsgHandler.get(DdConstants.EMPTY_STRING_NOT_VALID), 0);
        }
        ParsePosition pos = new ParsePosition(0);
        Number parseValue = this.formatter.parse(text, pos);
        if (text.length() > pos.getIndex()) {
            throw new ParseException(DdMsgHandler.get(DdConstants.PARSE_ERROR_UNALLOWED_CHARS, new Object[]{text}), 0);
        }
        if (parseValue instanceof Double) {
            throw new ParseException(DdMsgHandler.get(DdConstants.PARSE_ERROR_NO_INTEGER, new Object[]{Long.toString(this.minByte), Long.toString(this.maxByte)}), 0);
        }
        long parseValueLong = parseValue.longValue();
        if (parseValueLong < this.minByte || parseValueLong > this.maxByte) {
            throw new ParseException(DdMsgHandler.get(DdConstants.PARSE_ERROR_NO_INTEGER, new Object[]{Long.toString(this.minByte), Long.toString(this.maxByte)}), 0);
        }
        return parseValue.byteValue();
    }

    public double parseDouble(String text) throws ParseException {
        if (text.equals("")) {
            throw new ParseException(DdMsgHandler.get(DdConstants.EMPTY_STRING_NOT_VALID), 0);
        }
        ParsePosition pos = new ParsePosition(0);
        Number parseValue = this.formatter.parse(text, pos);
        if (text.length() > pos.getIndex()) {
            this.setNumberExample();
            throw new ParseException(DdMsgHandler.get(DdConstants.ERROR_DURING_PARSE, new Object[]{this.numberExample}), 0);
        }
        return parseValue.doubleValue();
    }

    public float parseFloat(String text) throws ParseException {
        if (text.equals("")) {
            throw new ParseException(DdMsgHandler.get(DdConstants.EMPTY_STRING_NOT_VALID), 0);
        }
        ParsePosition pos = new ParsePosition(0);
        Number parseValue = this.formatter.parse(text, pos);
        if (text.length() > pos.getIndex()) {
            this.setNumberExample();
            throw new ParseException(DdMsgHandler.get(DdConstants.ERROR_DURING_PARSE, new Object[]{this.numberExample}), 0);
        }
        return parseValue.floatValue();
    }

    public int parseInt(String text) throws ParseException {
        if (text.equals("")) {
            throw new ParseException(DdMsgHandler.get(DdConstants.EMPTY_STRING_NOT_VALID), 0);
        }
        ParsePosition pos = new ParsePosition(0);
        Number parseValue = this.formatter.parse(text, pos);
        if (text.length() > pos.getIndex()) {
            throw new ParseException(DdMsgHandler.get(DdConstants.PARSE_ERROR_UNALLOWED_CHARS, new Object[]{text}), 0);
        }
        if (parseValue instanceof Double) {
            throw new ParseException(DdMsgHandler.get(DdConstants.PARSE_ERROR_NO_INTEGER, new Object[]{Long.toString(this.minInteger), Long.toString(this.maxInteger)}), 0);
        }
        long parseValueLong = parseValue.longValue();
        if (parseValueLong < this.minInteger || parseValueLong > this.maxInteger) {
            throw new ParseException(DdMsgHandler.get(DdConstants.PARSE_ERROR_NO_INTEGER, new Object[]{Long.toString(this.minInteger), Long.toString(this.maxInteger)}), 0);
        }
        return parseValue.intValue();
    }

    public long parseLong(String text) throws ParseException {
        if (text.equals("")) {
            throw new ParseException(DdMsgHandler.get(DdConstants.EMPTY_STRING_NOT_VALID), 0);
        }
        ParsePosition pos = new ParsePosition(0);
        Number parseValue = this.formatter.parse(text, pos);
        if (text.length() > pos.getIndex()) {
            throw new ParseException(DdMsgHandler.get(DdConstants.PARSE_ERROR_UNALLOWED_CHARS, new Object[]{text}), 0);
        }
        if (parseValue instanceof Double) {
            throw new ParseException(DdMsgHandler.get(DdConstants.PARSE_ERROR_NO_INTEGER, new Object[]{Long.toString(this.minLong), Long.toString(this.maxLong)}), 0);
        }
        return parseValue.longValue();
    }

    public short parseShort(String text) throws ParseException {
        if (text.equals("")) {
            throw new ParseException(DdMsgHandler.get(DdConstants.EMPTY_STRING_NOT_VALID), 0);
        }
        ParsePosition pos = new ParsePosition(0);
        Number parseValue = this.formatter.parse(text, pos);
        if (text.length() > pos.getIndex()) {
            throw new ParseException(DdMsgHandler.get(DdConstants.PARSE_ERROR_UNALLOWED_CHARS, new Object[]{text}), 0);
        }
        if (parseValue instanceof Double) {
            throw new ParseException(DdMsgHandler.get(DdConstants.PARSE_ERROR_NO_INTEGER, new Object[]{Long.toString(this.minShort), Long.toString(this.maxShort)}), 0);
        }
        long parseValueLong = parseValue.longValue();
        if (parseValueLong < this.minShort || parseValueLong > this.maxShort) {
            throw new ParseException(DdMsgHandler.get(DdConstants.PARSE_ERROR_NO_INTEGER, new Object[]{Long.toString(this.minShort), Long.toString(this.maxShort)}), 0);
        }
        return parseValue.shortValue();
    }

    public BigDecimal parse(BigDecimal value, String text) throws ParseException {
        return this.parseDecimal(text);
    }

    public BigInteger parse(BigInteger value, String text) throws ParseException {
        return this.parseBigInteger(text);
    }

    public Byte parse(Byte value, String text) throws ParseException {
        return this.parseByteObject(text);
    }

    public Double parse(Double value, String text) throws ParseException {
        return this.parseDoubleObject(text);
    }

    public Float parse(Float value, String text) throws ParseException {
        return this.parseFloatObject(text);
    }

    public Integer parse(Integer value, String text) throws ParseException {
        return this.parseInteger(text);
    }

    public Long parse(Long value, String text) throws ParseException {
        return this.parseLongObject(text);
    }

    public Short parse(Short value, String text) throws ParseException {
        return this.parseShortObject(text);
    }

    public byte parse(byte value, String text) throws ParseException {
        return this.parseByte(text);
    }

    public double parse(double value, String text) throws ParseException {
        return this.parseDouble(text);
    }

    public float parse(float value, String text) throws ParseException {
        return this.parseFloat(text);
    }

    public int parse(int intValue, String text) throws ParseException {
        return this.parseInt(text);
    }

    public long parse(long value, String text) throws ParseException {
        return this.parseLong(text);
    }

    public short parse(short value, String text) throws ParseException {
        return this.parseShort(text);
    }

    public Format getXmlFormatter() {
        return XML_FORMATTER;
    }

    public String getFormatTemplate() {
        return this.formatter.toLocalizedPattern();
    }

    public void setFormatter() {
        NumberFormat numberFormat = null;
        String format = this.getFormat();
        Locale locale = this.getLocale();
        if (locale != null) {
            if (locale.getLanguage().equalsIgnoreCase("xml")) {
                this.formatter = (DecimalFormat)this.getXmlFormatter();
                return;
            }
            numberFormat = NumberFormat.getNumberInstance(this.getLocale());
            this.formatter = (DecimalFormat)numberFormat;
            this.formatter.applyPattern("#,##0.###############################");
        } else {
            numberFormat = NumberFormat.getNumberInstance();
            this.formatter = (DecimalFormat)numberFormat;
        }
        if (format != null) {
            this.formatter.applyPattern(format);
        }
    }

    public boolean isNumeric() {
        return true;
    }

    protected void setNumberExample() {
        if (StringUtil.isEmpty(this.numberExample)) {
            NumberFormat numberFormat = NumberFormat.getNumberInstance(this.getLocale());
            DecimalFormat formatter = (DecimalFormat)numberFormat;
            formatter.applyPattern("#,##0.####");
            this.numberExample = formatter.format(new Double("-2733.34"));
        }
    }

    protected void setDecimalExample() {
        if (StringUtil.isEmpty(this.decimalExample)) {
            NumberFormat numberFormat = NumberFormat.getNumberInstance(this.getLocale());
            DecimalFormat formatter = (DecimalFormat)numberFormat;
            formatter.applyPattern("#,##0.####");
            this.decimalExample = formatter.format(new Double("-2733.34"));
        }
    }

    static {
        ((DecimalFormat)XML_FORMATTER).applyPattern("#.###############################");
    }
}

