/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.runtime;

import com.sap.dictionary.runtime.DdCheckException;
import com.sap.dictionary.runtime.DdConstants;
import com.sap.dictionary.runtime.DdTypeNumber;
import com.sap.dictionary.runtime.ExTexts;
import com.sap.dictionary.runtime.IDataProvider;
import com.sap.dictionary.runtime.StringUtil;
import com.sap.dictionary.runtime.XmlMap;
import com.sap.typeservices.ISimpleValueServices;
import java.text.ParseException;
import java.util.Locale;

public class DdTypeLong
extends DdTypeNumber
implements DdConstants {
    private Long minInclusive = null;
    private Long maxInclusive = null;
    private Long minExclusive = null;
    private Long maxExclusive = null;
    private long minInclusiveLong = 0L;
    private long maxInclusiveLong = 0L;
    private long minExclusiveLong = 0L;
    private long maxExclusiveLong = 0L;
    private Long defaultValue = null;

    public DdTypeLong(IDataProvider provider, Locale locale, XmlMap xmlMap) {
        super(provider, locale, xmlMap);
        XmlMap tmap = xmlMap.getXmlMap("SimpleType");
        XmlMap smap = tmap.getXmlMap("SchemaType");
        XmlMap emap = tmap.getXmlMap("ExternalRepresentation");
        XmlMap enumMap = tmap.getXmlMap("EnumerationValues");
        if (enumMap != null) {
            this.setEnum(enumMap.getLongSet("EnumerationValue", "value"));
        }
        this.minInclusive = smap.getLongObject("minInclusive");
        this.maxInclusive = smap.getLongObject("maxInclusive");
        this.minExclusive = smap.getLongObject("minExclusive");
        this.maxExclusive = smap.getLongObject("maxExclusive");
        this.defaultValue = emap.getLongObject("defaultValue");
        if (this.minInclusive != null) {
            this.minInclusiveLong = this.minInclusive;
        }
        if (this.maxInclusive != null) {
            this.maxInclusiveLong = this.maxInclusive;
        }
        if (this.minExclusive != null) {
            this.minExclusiveLong = this.minExclusive;
        }
        if (this.maxExclusive != null) {
            this.maxExclusiveLong = this.maxExclusive;
        }
    }

    public Class getAttributeClass() {
        return Long.TYPE;
    }

    public String formatOfDefaultValue() {
        if (this.defaultValue == null) {
            return "";
        }
        return this.format(this.defaultValue);
    }

    public Object parse(String text) throws ParseException {
        return new Long(this.parseLong(text));
    }

    public long parse(long value, String text) throws ParseException {
        return this.parseLong(text);
    }

    public long parseLong(String text) throws ParseException {
        long value = super.parseLong(text);
        this.checkAfterParse(value);
        return value;
    }

    public boolean isValid(Object value) {
        if (value == null) {
            return super.isValidNull(value);
        }
        if (value instanceof Long) {
            return this.isValid((Long)value);
        }
        throw new IllegalArgumentException();
    }

    public boolean isValid(long value) {
        return !(this.minInclusive != null && value < this.minInclusiveLong || this.maxInclusive != null && value > this.maxInclusiveLong || this.minExclusive != null && value <= this.minExclusiveLong || this.maxExclusive != null && value >= this.maxExclusiveLong || !this.matchesPattern(value) || !this.matchesEnumeration(value));
    }

    public void checkValid(Object value) throws DdCheckException {
        if (value == null) {
            if (!super.isValidNull(value)) {
                throw new DdCheckException(DdConstants.NULL_NOT_VALID, new Object[0]);
            }
            return;
        }
        if (!(value instanceof Long)) {
            throw new DdCheckException(DdConstants.NOT_VALID, new Object[]{value.toString(), value.getClass().getName()});
        }
        long longValue = (Long)value;
        int maxExtLength = this.getMaxExternalLength();
        if (maxExtLength != 0 && new Long(longValue).toString().length() > maxExtLength) {
            throw new DdCheckException(DdConstants.WRONG_MAX_EXT_LENGTH, new Object[]{value.toString(), new Integer(maxExtLength).toString()});
        }
        if (this.minInclusive != null && longValue < this.minInclusiveLong) {
            throw new DdCheckException(DdConstants.BIGGER_THAN_MIN_INCL, new Object[]{value.toString(), this.minInclusive.toString()});
        }
        if (this.maxInclusive != null && longValue > this.maxInclusiveLong) {
            throw new DdCheckException(DdConstants.SMALLER_THAN_MAX_INCL, new Object[]{value.toString(), this.maxInclusive.toString()});
        }
        if (this.minExclusive != null && longValue <= this.minExclusiveLong) {
            throw new DdCheckException(DdConstants.BIGGER_THAN_MIN_EXCL, new Object[]{value.toString(), this.minExclusive.toString()});
        }
        if (this.maxExclusive != null && longValue >= this.maxExclusiveLong) {
            throw new DdCheckException(DdConstants.SMALLER_THAN_MAX_EXCL, new Object[]{value.toString(), this.maxExclusive.toString()});
        }
        if (!this.matchesPattern(longValue)) {
            throw new DdCheckException(DdConstants.NO_PATTERN_MATCHING, new Object[]{value.toString(), this.getPattern()});
        }
        if (!this.matchesEnumeration(longValue)) {
            throw new DdCheckException(DdConstants.NO_ENUM_MATCHING, new Object[]{value.toString()});
        }
    }

    private boolean matchesPattern(long value) {
        return true;
    }

    private boolean matchesEnumeration(Object value) {
        if (this.getEnum() == null) {
            return true;
        }
        if (value instanceof Long) {
            return this.matchesEnumeration((Long)value);
        }
        throw new IllegalArgumentException();
    }

    private boolean matchesEnumeration(long value) {
        ISimpleValueServices svServices;
        if (this.hasSVService() && (svServices = this.getSVServices()) != null) {
            return svServices.validate((Object)new Long(value));
        }
        return this.getEnum() == null || this.getEnum().contains(new Long(value));
    }

    public void setMinInclusive(Object value) {
        if (this.isModifyAllowed()) {
            if (value == null) {
                this.minInclusive = null;
            } else if (value instanceof Long) {
                this.minInclusive = (Long)value;
                this.minInclusiveLong = this.minInclusive;
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    public void setMaxInclusive(Object value) {
        if (this.isModifyAllowed()) {
            if (value == null) {
                this.maxInclusive = null;
            } else if (value instanceof Long) {
                this.maxInclusive = (Long)value;
                this.maxInclusiveLong = this.maxInclusive;
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    public void setMinExclusive(Object value) {
        if (this.isModifyAllowed()) {
            if (value == null) {
                this.minExclusive = null;
            } else if (value instanceof Long) {
                this.minExclusive = (Long)value;
                this.minExclusiveLong = this.minExclusive;
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    public void setMaxExclusive(Object value) {
        if (this.isModifyAllowed()) {
            if (value == null) {
                this.maxExclusive = null;
            } else if (value instanceof Long) {
                this.maxExclusive = (Long)value;
                this.maxExclusiveLong = this.maxExclusive;
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    public Object getMinInclusive() {
        return this.minInclusive;
    }

    public Object getMaxInclusive() {
        return this.maxInclusive;
    }

    public Object getMinExclusive() {
        return this.minExclusive;
    }

    public Object getMaxExclusive() {
        return this.maxExclusive;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public String toString() {
        return super.toString() + "  SchemaType" + "\n" + "    minInclusive         : " + this.getMinInclusive() + "\n" + "    maxInclusive         : " + this.getMaxInclusive() + "\n" + "    minExclusive         : " + this.getMinExclusive() + "\n" + "    maxExclusive         : " + this.getMaxExclusive() + "\n" + StringUtil.enumerationToString(this.getEnum(), this.getEnumerationTexts());
    }

    private void checkAfterParse(long value) throws ParseException {
        if (this.isValidationAfterParse() && !this.isValid(value)) {
            throw new ParseException(value + " " + ExTexts.get("002"), 0);
        }
    }
}

