/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.runtime;

import com.sap.dictionary.runtime.DdCheckException;
import com.sap.dictionary.runtime.DdConstants;
import com.sap.dictionary.runtime.DdTypeNumber;
import com.sap.dictionary.runtime.ExTexts;
import com.sap.dictionary.runtime.IDataProvider;
import com.sap.dictionary.runtime.StringUtil;
import com.sap.dictionary.runtime.XmlMap;
import com.sap.typeservices.ISimpleValueServices;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Locale;

public class DdTypeDecimal
extends DdTypeNumber
implements DdConstants {
    private static final BigDecimal ONE = new BigDecimal(1.0);
    private int totalDigits = 0;
    private int fractionDigits = 0;
    private BigDecimal minInclusive = null;
    private BigDecimal maxInclusive = null;
    private BigDecimal minExclusive = null;
    private BigDecimal maxExclusive = null;
    private BigDecimal defaultValue = null;
    static /* synthetic */ Class class$java$math$BigDecimal;

    public DdTypeDecimal(IDataProvider provider, Locale locale, XmlMap xmlMap) {
        super(provider, locale, xmlMap);
        XmlMap tmap = xmlMap.getXmlMap("SimpleType");
        XmlMap smap = tmap.getXmlMap("SchemaType");
        XmlMap emap = tmap.getXmlMap("ExternalRepresentation");
        this.totalDigits = smap.getInt("totalDigits");
        this.fractionDigits = smap.getInt("fractionDigits");
        XmlMap enumMap = tmap.getXmlMap("EnumerationValues");
        if (enumMap != null) {
            this.setEnum(enumMap.getBigDecimalSet("EnumerationValue", "value"));
        }
        this.minInclusive = smap.getBigDecimal("minInclusive");
        this.maxInclusive = smap.getBigDecimal("maxInclusive");
        this.minExclusive = smap.getBigDecimal("minExclusive");
        this.maxExclusive = smap.getBigDecimal("maxExclusive");
        this.defaultValue = emap.getBigDecimal("defaultValue");
    }

    public Class getAttributeClass() {
        return class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = DdTypeDecimal.class$("java.math.BigDecimal")) : class$java$math$BigDecimal;
    }

    public String formatOfDefaultValue() {
        if (this.defaultValue == null) {
            return "";
        }
        return this.format(this.defaultValue);
    }

    public Object parse(String text) throws ParseException {
        if (text.equals("")) {
            return null;
        }
        return this.parseDecimal(text);
    }

    public BigDecimal parse(BigDecimal value, String text) throws ParseException {
        return this.parseDecimal(text);
    }

    public BigDecimal parseDecimal(String text) throws ParseException {
        BigDecimal value = super.parseDecimal(text);
        this.checkAfterParse(value);
        return value;
    }

    public void checkValid(Object value) throws DdCheckException {
        if (value == null) {
            if (!super.isValidNull(value)) {
                throw new DdCheckException(DdConstants.NULL_NOT_VALID, new Object[0]);
            }
            return;
        }
        BigDecimal decimalValue = null;
        if (!(value instanceof BigDecimal)) {
            throw new DdCheckException(DdConstants.NOT_VALID, new Object[]{value.toString(), value.getClass().getName()});
        }
        decimalValue = (BigDecimal)value;
        if (this.totalDigits > 0) {
            int scale = decimalValue.scale();
            if (decimalValue.movePointLeft(this.totalDigits - this.fractionDigits).abs().compareTo(ONE) > -1) {
                throw new DdCheckException(DdConstants.DECIMAL_VALUE_TO_BIG, new Object[]{value.toString(), new Integer(this.totalDigits).toString()});
            }
            if (scale > this.fractionDigits) {
                BigDecimal decimalOld = decimalValue;
                if ((decimalValue = decimalValue.setScale(this.fractionDigits, 6)).compareTo(decimalOld) != 0) {
                    throw new DdCheckException(DdConstants.PRECISION_TO_BIG, new Object[]{new Integer(scale).toString(), new Integer(this.fractionDigits).toString()});
                }
            }
        }
        if (this.minInclusive != null && decimalValue.compareTo(this.minInclusive) < 0) {
            throw new DdCheckException(DdConstants.BIGGER_THAN_MIN_INCL, new Object[]{value.toString(), this.minInclusive.toString()});
        }
        if (this.maxInclusive != null && decimalValue.compareTo(this.maxInclusive) > 0) {
            throw new DdCheckException(DdConstants.SMALLER_THAN_MAX_INCL, new Object[]{value.toString(), this.maxInclusive.toString()});
        }
        if (this.minExclusive != null && decimalValue.compareTo(this.minExclusive) <= 0) {
            throw new DdCheckException(DdConstants.BIGGER_THAN_MIN_EXCL, new Object[]{value.toString(), this.minExclusive.toString()});
        }
        if (this.maxExclusive != null && decimalValue.compareTo(this.maxExclusive) >= 0) {
            throw new DdCheckException(DdConstants.SMALLER_THAN_MAX_EXCL, new Object[]{value.toString(), this.maxExclusive.toString()});
        }
        if (!this.matchesPattern(decimalValue)) {
            throw new DdCheckException(DdConstants.NO_PATTERN_MATCHING, new Object[]{value.toString(), this.getPattern()});
        }
        if (!this.matchesEnumeration(decimalValue)) {
            throw new DdCheckException(DdConstants.NO_ENUM_MATCHING, new Object[]{value.toString()});
        }
    }

    private boolean matchesPattern(BigDecimal value) {
        return true;
    }

    private boolean matchesEnumeration(Object value) {
        if (this.getEnum() == null) {
            return true;
        }
        if (value instanceof BigDecimal) {
            return this.matchesEnumeration((BigDecimal)value);
        }
        throw new IllegalArgumentException();
    }

    private boolean matchesEnumeration(BigDecimal value) {
        ISimpleValueServices svServices;
        if (this.hasSVService() && (svServices = this.getSVServices()) != null) {
            return svServices.validate((Object)value);
        }
        return this.getEnum() == null || this.getEnum().contains(value);
    }

    public void setMinInclusive(Object value) {
        if (this.isModifyAllowed()) {
            if (value == null) {
                this.minInclusive = null;
            } else if (value instanceof BigDecimal) {
                this.minInclusive = (BigDecimal)value;
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    public void setMaxInclusive(Object value) {
        if (this.isModifyAllowed()) {
            if (value == null) {
                this.maxInclusive = null;
            } else if (value instanceof BigDecimal) {
                this.maxInclusive = (BigDecimal)value;
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    public void setMinExclusive(Object value) {
        if (this.isModifyAllowed()) {
            if (value == null) {
                this.minExclusive = null;
            } else if (value instanceof BigDecimal) {
                this.minExclusive = (BigDecimal)value;
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    public void setMaxExclusive(Object value) {
        if (this.isModifyAllowed()) {
            if (value == null) {
                this.maxExclusive = null;
            } else if (value instanceof BigDecimal) {
                this.maxExclusive = (BigDecimal)value;
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    public void setTotalDigits(int totalDigits) {
        if (this.isModifyAllowed()) {
            this.totalDigits = totalDigits;
        }
    }

    public void setFractionDigits(int fractionDigits) {
        if (this.isModifyAllowed()) {
            this.fractionDigits = fractionDigits;
        }
    }

    public int getTotalDigits() {
        return this.totalDigits;
    }

    public int getFractionDigits() {
        return this.fractionDigits;
    }

    public Object getMinInclusive() {
        return this.minInclusive;
    }

    public Object getMaxInclusive() {
        return this.maxInclusive;
    }

    public Object getMinExclusive() {
        return this.minExclusive;
    }

    public Object getMaxExclusive() {
        return this.maxExclusive;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public String toString() {
        return super.toString() + "  SchemaType" + "\n" + "    totalDigits          : " + this.totalDigits + "\n" + "    fractionDigits       : " + this.fractionDigits + "\n" + "    minInclusive         : " + this.getMinInclusive() + "\n" + "    maxInclusive         : " + this.getMaxInclusive() + "\n" + "    minExclusive         : " + this.getMinExclusive() + "\n" + "    maxExclusive         : " + this.getMaxExclusive() + "\n" + "    defaultValue         : " + this.defaultValue + "\n" + "  Enumeration" + "\n" + StringUtil.enumerationToString(this.getEnum(), this.getEnumerationTexts());
    }

    private void checkAfterParse(BigDecimal value) throws ParseException {
        if (this.isValidationAfterParse() && !this.isValid(value)) {
            throw new ParseException(value + " " + ExTexts.get("002"), 0);
        }
    }

    public boolean isValid(Object value) {
        if (value == null) {
            return super.isValidNull(value);
        }
        if (value instanceof BigDecimal) {
            return this.isValid((BigDecimal)value);
        }
        throw new IllegalArgumentException();
    }

    public boolean isValid(BigDecimal value) {
        if (value == null) {
            return super.isValidNull(value);
        }
        if (this.totalDigits > 0) {
            int scale = value.scale();
            if (value.movePointLeft(this.totalDigits - this.fractionDigits).abs().compareTo(ONE) > -1) {
                return false;
            }
            if (scale > this.fractionDigits) {
                BigDecimal decimalOld = value;
                if ((value = value.setScale(this.fractionDigits, 6)).compareTo(decimalOld) != 0) {
                    return false;
                }
            }
        }
        return !(this.minInclusive != null && value.compareTo(this.minInclusive) < 0 || this.maxInclusive != null && value.compareTo(this.maxInclusive) > 0 || this.minExclusive != null && value.compareTo(this.minExclusive) <= 0 || this.maxExclusive != null && value.compareTo(this.maxExclusive) >= 0 || !this.matchesPattern(value) || !this.matchesEnumeration(value));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

