/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.runtime;

import com.sap.dictionary.runtime.DdCheckException;
import com.sap.dictionary.runtime.DdConstants;
import com.sap.dictionary.runtime.DdSimpleType;
import com.sap.dictionary.runtime.ExTexts;
import com.sap.dictionary.runtime.IDataProvider;
import com.sap.dictionary.runtime.StringUtil;
import com.sap.dictionary.runtime.XmlMap;
import java.text.ParseException;
import java.util.Locale;

public class DdTypeBooleanObject
extends DdSimpleType
implements DdConstants {
    private Boolean defaultValue = null;
    private XmlMap xmlMap = null;
    static /* synthetic */ Class class$java$lang$Boolean;

    public DdTypeBooleanObject(IDataProvider provider, Locale locale, XmlMap xmlMap) {
        super(provider, locale, xmlMap);
        this.xmlMap = xmlMap;
        Object nextValue = null;
        XmlMap tmap = xmlMap.getXmlMap("SimpleType");
        XmlMap emap = tmap.getXmlMap("ExternalRepresentation");
        this.defaultValue = emap.getBooleanObject("defaultValue");
    }

    public Class getAttributeClass() {
        return class$java$lang$Boolean == null ? (class$java$lang$Boolean = DdTypeBooleanObject.class$("java.lang.Boolean")) : class$java$lang$Boolean;
    }

    public String format(Object value) {
        if (value == null) {
            return "";
        }
        return this.format(Boolean.TRUE.equals(value));
    }

    public String format(boolean value) {
        return new Boolean(value).toString();
    }

    public String format(Boolean value) {
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    public String formatOfDefaultValue() {
        return this.format(this.defaultValue);
    }

    public Object parse(String value) throws ParseException {
        if (value.equals("")) {
            return null;
        }
        return this.parseBooleanObject(value);
    }

    public Boolean parse(Boolean value, String text) throws ParseException {
        if (value.equals("")) {
            return null;
        }
        return this.parseBooleanObject(text);
    }

    public Boolean parseBooleanObject(String value) throws ParseException {
        if (value.equals("")) {
            return null;
        }
        if (value != null) {
            value.trim();
        }
        if (StringUtil.isEmpty(value)) {
            throw new ParseException(value + " " + ExTexts.get("002"), 0);
        }
        Boolean booleanObjectValue = new Boolean(value);
        this.checkAfterParse(booleanObjectValue);
        return booleanObjectValue;
    }

    public boolean isValid(Object value) {
        if (value == null) {
            return super.isValidNull(value);
        }
        if (value instanceof Boolean) {
            return true;
        }
        throw new IllegalArgumentException();
    }

    public boolean isValid(Boolean value) {
        if (value == null) {
            return super.isValidNull(value);
        }
        return true;
    }

    public void checkValid(Object value) throws DdCheckException {
        if (value == null) {
            if (!super.isValidNull(value)) {
                throw new DdCheckException(DdConstants.NULL_NOT_VALID, new Object[0]);
            }
            return;
        }
        if (value instanceof Boolean) {
            return;
        }
        throw new DdCheckException(DdConstants.NOT_VALID, new Object[]{value.toString(), value.getClass().getName()});
    }

    private boolean matchesPattern(Boolean value) {
        return true;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    private void checkAfterParse(Boolean value) throws ParseException {
        if (this.isValidationAfterParse() && !this.isValid(value)) {
            throw new ParseException(value + " " + ExTexts.get("002"), 0);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

