/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.runtime;

import com.sap.dictionary.runtime.DdDataType;
import com.sap.dictionary.runtime.DdException;
import com.sap.dictionary.runtime.DdField;
import com.sap.dictionary.runtime.DdStructure;
import com.sap.dictionary.runtime.ExType;
import com.sap.dictionary.runtime.IDataProvider;
import com.sap.dictionary.runtime.ISimpleType;
import com.sap.dictionary.runtime.IStructure;
import com.sap.dictionary.runtime.StringUtil;
import com.sap.dictionary.types.services.NamingService;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;

public class DdNameTranslator {
    private HashMap typeNameToFrontend;
    private HashMap typeNameToBackendInternal;
    private HashMap fieldNameToFrontend;
    private HashMap fieldNameToBackendInternal;
    private String packagePrefix;

    public DdNameTranslator(String name, Locale locale, IDataProvider frontendProvider) throws DdException {
        this(name, null, locale, frontendProvider);
    }

    public DdNameTranslator(String name, String backendName) throws DdException {
        this(name, backendName, null, null);
    }

    public DdNameTranslator(String name, String backendName, Locale locale, IDataProvider frontendProvider) throws DdException {
        String backendInternalName;
        String frontendName;
        DdDataType dataType;
        block14: {
            this.typeNameToFrontend = new HashMap();
            this.typeNameToBackendInternal = new HashMap();
            this.fieldNameToFrontend = new HashMap();
            this.fieldNameToBackendInternal = new HashMap();
            this.packagePrefix = "";
            dataType = null;
            frontendName = null;
            backendInternalName = null;
            if (frontendProvider != null) {
                try {
                    dataType = (DdDataType)frontendProvider.getDataType(name, locale);
                }
                catch (DdException ex) {
                    if (ex.getExType() == ExType.TYPE_NOT_FOUND) break block14;
                    throw ex;
                }
            }
        }
        if (dataType == null) {
            if (backendName != null && name != null) {
                frontendName = name;
                backendInternalName = NamingService.Structure.getABAPNameFromBackendName((String)backendName);
                this.typeNameToBackendInternal.put(frontendName, backendInternalName);
                this.typeNameToFrontend.put(backendInternalName, frontendName);
            }
            return;
        }
        backendName = null;
        if (dataType instanceof IStructure) {
            DdStructure struc = (DdStructure)dataType;
            backendName = struc.getBackendName();
            frontendName = struc.getName();
            if (backendName != null) {
                backendInternalName = NamingService.Structure.getABAPNameFromBackendName((String)backendName);
                this.typeNameToBackendInternal.put(frontendName, backendInternalName);
                this.typeNameToFrontend.put(backendInternalName, frontendName);
            }
            Iterator iter = struc.fieldIterator();
            DdField field = null;
            while (iter.hasNext()) {
                field = (DdField)iter.next();
                backendName = field.getBackendName();
                frontendName = field.getName();
                if (backendName != null) {
                    backendInternalName = NamingService.Field.getABAPNameFromBackendName((String)backendName);
                    this.fieldNameToBackendInternal.put(frontendName, backendInternalName);
                    this.fieldNameToFrontend.put(backendInternalName, frontendName);
                }
                try {
                    if (field.getNameOfType() == null) continue;
                    dataType = (DdDataType)frontendProvider.getDataType(field.getNameOfType(), locale);
                }
                catch (DdException ex) {
                    if (ex.getExType() == ExType.TYPE_NOT_FOUND) continue;
                    throw ex;
                }
                backendName = dataType.getBackendName();
                frontendName = dataType.getName();
                if (backendName == null) continue;
                backendInternalName = NamingService.Type.getABAPNameFromBackendName((String)backendName);
                this.typeNameToBackendInternal.put(frontendName, backendInternalName);
                this.typeNameToFrontend.put(backendInternalName, frontendName);
            }
        } else if (dataType instanceof ISimpleType) {
            backendName = dataType.getBackendName();
            frontendName = dataType.getName();
            if (backendName != null) {
                backendInternalName = NamingService.Structure.getABAPNameFromBackendName((String)backendName);
                this.typeNameToBackendInternal.put(frontendName, backendInternalName);
                this.typeNameToFrontend.put(backendInternalName, frontendName);
            }
        }
    }

    public DdNameTranslator(String packageName) {
        this.typeNameToFrontend = new HashMap();
        this.typeNameToBackendInternal = new HashMap();
        this.fieldNameToFrontend = new HashMap();
        this.fieldNameToBackendInternal = new HashMap();
        this.packagePrefix = "";
        if (!StringUtil.isEmptyAfterTrim(packageName)) {
            this.packagePrefix = packageName + ".";
        }
    }

    public static DdNameTranslator getDummyInstance() throws DdException {
        return new DdNameTranslator(null, null, null);
    }

    public String fieldNameToFrontend(String backendInternalName) {
        String newName = (String)this.fieldNameToFrontend.get(backendInternalName);
        if (newName != null) {
            return newName;
        }
        String backendName = NamingService.Field.getBackendNameFromABAPName((String)backendInternalName);
        return this.packagePrefix + NamingService.Field.getJavaNameFromBackendName((String)backendName);
    }

    public String fieldNameToBackendInternal(String frontendName) {
        String newName = (String)this.fieldNameToBackendInternal.get(frontendName);
        if (newName == null) {
            return frontendName;
        }
        return newName;
    }

    public String typeNameToFrontend(String backendInternalName) {
        String newName = (String)this.typeNameToFrontend.get(backendInternalName);
        if (newName != null) {
            return newName;
        }
        String backendName = NamingService.Type.getBackendNameFromABAPName((String)backendInternalName);
        return this.packagePrefix + NamingService.Type.getJavaNameFromBackendName((String)backendName);
    }

    public String typeNameToBackendInternal(String frontendName) {
        String newName = (String)this.typeNameToBackendInternal.get(frontendName);
        if (newName == null) {
            return frontendName;
        }
        return newName;
    }

    public String typeNameToBackend(String backendInternalName) {
        return NamingService.Type.getBackendNameFromABAPName((String)backendInternalName);
    }

    public String fieldNameToBackend(String backendInternalName) {
        return NamingService.Field.getBackendNameFromABAPName((String)backendInternalName);
    }
}

