/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.runtime;

import com.sap.dictionary.runtime.DdConstants;
import com.sap.dictionary.runtime.DdEnumValue;
import com.sap.dictionary.runtime.DdException;
import com.sap.dictionary.runtime.DdSimpleType;
import com.sap.dictionary.runtime.DdStructure;
import com.sap.dictionary.runtime.ExTexts;
import com.sap.dictionary.runtime.ExType;
import com.sap.dictionary.runtime.IDataProvider;
import com.sap.dictionary.runtime.IDataType;
import com.sap.dictionary.runtime.ISimpleType;
import com.sap.dictionary.runtime.StringUtil;
import com.sap.dictionary.runtime.XmlExtractor;
import com.sap.dictionary.runtime.XmlMap;
import com.sap.typeservices.ISimpleValueServices;
import com.sap.typeservices.ITextServices;
import com.sap.typeservices.STypeSVServices;
import com.sap.typeservices.STypeTextServices;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import org.xml.sax.InputSource;

public class DdJavaProvider
implements IDataProvider,
DdConstants {
    private ClassLoader cLoader = null;
    public static final String XML = "xml";
    public static final ClassLoader THIS_PROJECT_CLOADER = (class$com$sap$dictionary$runtime$DdJavaProvider == null ? (class$com$sap$dictionary$runtime$DdJavaProvider = DdJavaProvider.class$("com.sap.dictionary.runtime.DdJavaProvider")) : class$com$sap$dictionary$runtime$DdJavaProvider).getClassLoader();
    public static final DdJavaProvider THIS_PROJECT_JAVA_PROVIDER = new DdJavaProvider(THIS_PROJECT_CLOADER);
    private final Map dictTypes = Collections.synchronizedMap(new WeakHashMap());
    private static final String CURR_PACKAGE = "com.sap.dictionary.predefined.currency";
    private static final String QUAN_PACKAGE = "com.sap.dictionary.predefined.quantity";
    private static final String DEFAULT = "DEFAULT";
    static /* synthetic */ Class class$com$sap$dictionary$runtime$DdJavaProvider;
    static /* synthetic */ Class class$java$math$BigDecimal;

    public DdJavaProvider(ClassLoader cLoader) {
        this.cLoader = cLoader;
        if (cLoader == null) {
            this.cLoader = THIS_PROJECT_CLOADER;
        }
    }

    public IDataType getDataType(String name, Locale locale, Object providerInfo) throws DdException {
        return this.getDataType(name, locale);
    }

    public IDataType getDataType(String name, Locale locale) throws DdException {
        InputStream stream = null;
        IDataType dataType = this.getFromCache(name, locale);
        if (dataType != null) {
            return dataType;
        }
        String physicalName = name.replace('.', '/');
        stream = this.cLoader.getResourceAsStream(physicalName + ".gsimpletype");
        XmlExtractor extractor = new XmlExtractor();
        XmlMap typeMap = null;
        if (stream != null) {
            typeMap = extractor.map(new InputSource(stream));
            ISimpleType simple = DdSimpleType.makeNew(this, locale, typeMap);
            this.putIntoCache(simple);
            return simple;
        }
        stream = this.cLoader.getResourceAsStream(physicalName + ".gstructure");
        if (stream != null) {
            typeMap = extractor.map(new InputSource(stream));
            if (typeMap == null) {
                throw new DdException(DdConstants.DDIC_TYPE_DOES_NOT_EXIST, new Object[]{name});
            }
            DdStructure structure = new DdStructure(this, locale, typeMap);
            this.putIntoCache(structure);
            return structure;
        }
        throw new DdException(ExType.TYPE_NOT_FOUND, DdConstants.DDIC_TYPE_DOES_NOT_EXIST, new Object[]{name});
    }

    public void prepare(HashMap searchNames, Locale locale) throws DdException {
    }

    public ISimpleValueServices getValueService(ISimpleType simpleType) throws DdException {
        STypeSVServices svservices = null;
        String name = simpleType.getName();
        String prefix = StringUtil.getPackageName(name);
        String suffix = StringUtil.getUnqualifiedClassName(name);
        Locale loc = simpleType.getLocale();
        if (loc.getLanguage().equalsIgnoreCase(XML)) {
            loc = Locale.US;
        }
        List enumTexts = ((DdSimpleType)simpleType).getEnumerationTextsAsList();
        ArrayList<STypeSVServices.Entry> arrayList = null;
        String formattedValue = null;
        Object value = null;
        Iterator iter = null;
        if (enumTexts != null) {
            arrayList = new ArrayList<STypeSVServices.Entry>();
            iter = enumTexts.iterator();
            while (iter.hasNext()) {
                formattedValue = (String)((DdEnumValue)iter.next()).getKey();
                try {
                    value = ((DdSimpleType)simpleType).parseForEnum(formattedValue);
                    arrayList.add(new STypeSVServices.Entry(value, formattedValue));
                }
                catch (ParseException ex) {
                    throw new DdException(ExType.PARSE_ERROR, ex.getMessage(), ex);
                }
            }
        }
        svservices = new STypeSVServices(suffix, prefix, arrayList, loc, this.cLoader);
        return svservices;
    }

    public ITextServices getTextService(ISimpleType simpleType) throws DdException {
        STypeTextServices textservices = null;
        String name = simpleType.getName();
        String prefix = StringUtil.getPackageName(name);
        String suffix = StringUtil.getUnqualifiedClassName(name);
        Locale loc = simpleType.getLocale();
        if (loc.getLanguage().equalsIgnoreCase(XML)) {
            loc = Locale.US;
        }
        textservices = new STypeTextServices(suffix, prefix, loc, this.cLoader);
        return textservices;
    }

    public ISimpleType getCurrencyUnitType(String unitKey, Locale locale) throws DdException {
        ISimpleType unitType = null;
        try {
            unitType = (ISimpleType)THIS_PROJECT_JAVA_PROVIDER.getDataType("com.sap.dictionary.predefined.currency." + unitKey, locale);
        }
        catch (DdException ex) {
            if (ex.getExType() == ExType.TYPE_NOT_FOUND) {
                unitType = (ISimpleType)THIS_PROJECT_JAVA_PROVIDER.getDataType("com.sap.dictionary.predefined.currency.DEFAULT", locale);
            }
            throw ex;
        }
        if (unitType == null || unitType.getAssociatedClass() != (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = DdJavaProvider.class$("java.math.BigDecimal")) : class$java$math$BigDecimal)) {
            throw new DdException(ExType.FORMAT_ERROR, ExTexts.get("007"));
        }
        return unitType;
    }

    public ISimpleType getUnitOfMeasureType(String unitKey, Locale locale) throws DdException {
        String name = "com.sap.dictionary.predefined.quantity." + unitKey;
        ISimpleType unitType = (ISimpleType)THIS_PROJECT_JAVA_PROVIDER.getDataType(name, locale);
        return unitType;
    }

    public ClassLoader getClassLoader() {
        return this.cLoader;
    }

    IDataType getFromCache(String name, Locale locale) {
        HashMap typeMap = (HashMap)this.dictTypes.get(name);
        Object obj = null;
        if (typeMap != null) {
            obj = typeMap.get(locale);
        }
        if (obj != null) {
            return obj;
        }
        return null;
    }

    public IDataType getDataTypeFromCache(String name, Locale locale) {
        return this.getFromCache(name, locale);
    }

    void putIntoCache(IDataType dataType) {
        String name = dataType.getName();
        if (this.dictTypes.containsKey(name)) {
            ((HashMap)this.dictTypes.get(name)).put(dataType.getLocale(), dataType);
        } else {
            HashMap<Locale, IDataType> hm = new HashMap<Locale, IDataType>();
            hm.put(dataType.getLocale(), dataType);
            this.dictTypes.put(name, hm);
        }
    }

    public boolean needsTranslator() {
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

