/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.runtime;

import com.sap.dictionary.runtime.DdBroker;
import com.sap.dictionary.runtime.DdConstants;
import com.sap.dictionary.runtime.DdDictionary;
import com.sap.dictionary.runtime.DdException;
import com.sap.dictionary.runtime.IBroker;
import com.sap.dictionary.runtime.IDataProvider;
import com.sap.dictionary.runtime.ProviderFactory;
import com.sap.dictionary.runtime.XmlExtractor;
import com.sap.dictionary.runtime.XmlMap;
import com.sap.dictionary.types.services.IConfig;
import com.sap.tc.logging.Location;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.xml.sax.InputSource;

public class DdDictionaryPool
implements DdConstants {
    private final Map dictionaries = Collections.synchronizedMap(new HashMap());
    private final Map providers = Collections.synchronizedMap(new HashMap());
    private final Map logicalSystemNames = Collections.synchronizedMap(new HashMap());
    private static final TimeZone defaultTimeZone = TimeZone.getDefault();
    private static final Location loc = Location.getLocation((Class)(class$com$sap$dictionary$runtime$DdDictionaryPool == null ? (class$com$sap$dictionary$runtime$DdDictionaryPool = DdDictionaryPool.class$("com.sap.dictionary.runtime.DdDictionaryPool")) : class$com$sap$dictionary$runtime$DdDictionaryPool));
    private static final DdDictionaryPool pool = new DdDictionaryPool();
    static /* synthetic */ Class class$com$sap$dictionary$runtime$DdDictionaryPool;

    private DdDictionaryPool() {
        if (loc.beInfo()) {
            loc.infoT("TimeZone:", new Object[]{defaultTimeZone.toString()});
        }
    }

    public static DdDictionaryPool getInstance() {
        if (loc.beInfo()) {
            loc.infoT("TimeZone:", new Object[]{defaultTimeZone.toString()});
        }
        return pool;
    }

    public DdDictionary getDictionary(String name, ClassLoader classLoader, IConfig configuration) throws DdException {
        if (configuration == null) {
            return this.getDictionary(name, classLoader);
        }
        String logSystemName = this.getLogicalSystemName(name, classLoader);
        String newLogSystemName = configuration.getMappedLogicalSystemName(logSystemName);
        if (newLogSystemName == null) {
            return this.getDictionary(name, classLoader);
        }
        if (this.dictionaries.containsKey(name = name + ':' + newLogSystemName)) {
            return (DdDictionary)this.dictionaries.get(name);
        }
        IDataProvider provider = this.getProvider(newLogSystemName);
        DdDictionary ddic = new DdDictionary(name, newLogSystemName, provider);
        this.dictionaries.put(name, ddic);
        return ddic;
    }

    public DdDictionary getDictionary(String name, ClassLoader classLoader) throws DdException {
        if (this.dictionaries.containsKey(name)) {
            return (DdDictionary)this.dictionaries.get(name);
        }
        String logSystemName = this.getLogicalSystemName(name, classLoader);
        IDataProvider provider = this.getProvider(logSystemName);
        DdDictionary ddic = new DdDictionary(name, logSystemName, provider);
        this.dictionaries.put(name, ddic);
        return ddic;
    }

    public void setProvider(String logicalSystemName, IDataProvider provider) {
        this.providers.put(logicalSystemName, provider);
    }

    IDataProvider getProvider(String logSystemName) throws DdException {
        if (this.providers.containsKey(logSystemName)) {
            return (IDataProvider)this.providers.get(logSystemName);
        }
        IDataProvider provider = ProviderFactory.getProvider(logSystemName);
        if (provider != null) {
            this.setProvider(logSystemName, provider);
            return provider;
        }
        throw new DdException(DdConstants.PROVIDER_NOT_FOUND, new Object[]{logSystemName});
    }

    public String getLogicalSystemName(String ddicName, ClassLoader classLoader) throws DdException {
        if (this.logicalSystemNames.containsKey(ddicName)) {
            return (String)this.logicalSystemNames.get(ddicName);
        }
        String physicalName = ddicName.replace('.', '/');
        InputStream stream = null;
        stream = classLoader.getResourceAsStream(physicalName + ".gdictionary");
        if (stream != null) {
            XmlExtractor extractor = new XmlExtractor();
            XmlMap xmlMap = extractor.map(new InputSource(stream));
            XmlMap dictionaryMap = xmlMap.getXmlMap("dictionary");
            String logSystemName = dictionaryMap.getString("logicalSystemName");
            if (logSystemName == null) {
                throw new DdException(DdConstants.NO_DDIC_NAME, new Object[0]);
            }
            this.logicalSystemNames.put(ddicName, logSystemName);
            return logSystemName;
        }
        throw new DdException(DdConstants.LOGICAL_DDIC_DOES_NOT_EXIST, new Object[]{ddicName});
    }

    public IBroker createBroker(ClassLoader classLoader, Locale locale) throws DdException {
        return new DdBroker(classLoader, locale);
    }

    public IBroker createBroker(ClassLoader classLoader, Locale locale, IConfig configuration) throws DdException {
        return new DdBroker(classLoader, locale, configuration);
    }

    public boolean invalidateCache(String name) {
        return ((DdDictionary)this.dictionaries.get(name)).invalidateCache();
    }

    protected static TimeZone getDefaultTimeZone() {
        return defaultTimeZone;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

