/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.providers.ejbjar.env;

import com.tssap.j2ee.core.descriptor.EjbRefBase;
import com.tssap.j2ee.core.providers.ejbjar.EjbJarModelMetaInfo;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.util.extension.AbstractLinkProvider;

abstract class EjbRefBaseLinkProvider
extends AbstractLinkProvider {
    EjbRefBaseLinkProvider() {
    }

    protected UniqueName getClient(Entity link) {
        Entity ejb = link.getParent();
        if (ejb == null) {
            return null;
        }
        return ejb.getUniqueName();
    }

    protected UniqueName getSupplier(Entity link) {
        EjbRefBase ref = this.getRef(link.getUniqueName());
        String beanName = ref.getLinkTarget();
        String jarPath = ref.getLinkPathExt();
        if (jarPath != null) {
            return null;
        }
        Entity ejb = link.getParent();
        if (ejb == null) {
            return null;
        }
        Entity ejbJar = ejb.getParent();
        if (ejbJar == null) {
            return null;
        }
        Entity targetEjbEntity = EjbJarModelMetaInfo.getEjb(ejbJar, beanName);
        if (targetEjbEntity == null) {
            return null;
        }
        return targetEjbEntity.getUniqueName();
    }

    protected boolean canSetSupplier(Entity link, Element oldParticipant, Element newParticipant) {
        UniqueName uin = newParticipant.getUniqueName();
        if (!this.canReference(uin)) {
            return false;
        }
        String ejbName = EjbJarModelMetaInfo.getEjbName(uin);
        EjbRefBase ref = this.getRef(link.getUniqueName());
        if (ref == null) {
            return false;
        }
        return ref.canSetLinkTarget(ejbName);
    }

    protected void setSupplier(Entity link, Element oldParticipant, Element newParticipant) {
        UniqueName uin = newParticipant.getUniqueName();
        String ejbName = EjbJarModelMetaInfo.getEjbName(uin);
        EjbRefBase ref = this.getRef(link.getUniqueName());
        ref.setLinkTarget(ejbName);
        String refTarget = ref.getLinkTarget();
        boolean bl = refTarget == null ? ejbName != null : !refTarget.equals(ejbName);
        if (bl) {
            return;
        }
        if (EjbJarModelMetaInfo.isEntityBean(newParticipant.getUniqueName())) {
            ref.setType("Entity");
        } else if (EjbJarModelMetaInfo.isSessionBean(newParticipant.getUniqueName())) {
            ref.setType("Session");
        }
    }

    protected abstract EjbRefBase getRef(UniqueName var1);

    protected abstract boolean canReference(UniqueName var1);
}

