/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.providers.ejbjar.ad;

import com.tssap.j2ee.core.descriptor.SecurityRole;
import com.tssap.j2ee.core.ejbjar.EjbJar;
import com.tssap.j2ee.core.ejbjar.namegen.SecurityRoleNameGen;
import com.tssap.j2ee.core.providers.ejbjar.EjbJarModelMetaInfo;
import com.tssap.j2ee.internal.core.descriptor.AbstractDeltaProvider;
import com.tssap.j2ee.internal.core.providers.ejbjar.EjbJarModelAccess;
import com.tssap.j2ee.internal.core.providers.ejbjar.ad.AssemblyDescriptorModelAccess;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.extension.ChildrenProvider;
import com.tssap.selena.model.extension.EntityExistenceProvider;
import com.tssap.selena.model.extension.ExistenceProviderEx;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.EnumerationConverter;
import com.tssap.selena.model.util.extension.AbstractProvider;
import java.util.ArrayList;

public final class SecurityRoleProvider
extends AbstractProvider
implements EntityExistenceProvider,
ExistenceProviderEx,
ChildrenProvider {
    public boolean isDeleteProviderApplicable(Element element) {
        return EjbJarModelMetaInfo.isSecurityRole(element.getUniqueName());
    }

    public boolean isDeleted(Element element) {
        return AssemblyDescriptorModelAccess.getSecurityRole(this.getModel(), element.getUniqueName()) == null;
    }

    public boolean exists(UniqueName uin) {
        if (!EjbJarModelMetaInfo.isSecurityRole(uin)) {
            return false;
        }
        return AssemblyDescriptorModelAccess.getSecurityRole(this.getModel(), uin) != null;
    }

    private String genName(EjbJar ejbJar, String name) {
        SecurityRoleNameGen gen = new SecurityRoleNameGen(ejbJar);
        return gen.getUniqueName(name == null ? "role1" : name);
    }

    public boolean canCreateUniqueName(Entity parent, String shapeType, Entity template) {
        String description;
        String name;
        if (!"com.tssap.j2ee.core.ejbjar.SecurityRole".equals(shapeType)) {
            return false;
        }
        if (!EjbJarModelMetaInfo.isEjbJar(parent.getUniqueName())) {
            return false;
        }
        EjbJar ejbJar = EjbJarModelAccess.getEjbJar(this.getModel(), parent.getUniqueName());
        if (ejbJar == null || !ejbJar.isRecognized()) {
            return false;
        }
        if (template == null) {
            name = this.genName(ejbJar, null);
            description = null;
        } else {
            Object source = template.getObjectPropertyValue("$elementToClone");
            if (source instanceof Entity) {
                template = (Entity)source;
            }
            name = this.genName(ejbJar, template.getPropertyValue("$name"));
            description = template.getPropertyValue("description");
        }
        return ejbJar.getAssemblyDescriptor().canCreateSecurityRole(name, description);
    }

    public UniqueName createUniqueName(Entity parent, String shapeType, Entity template) {
        String description;
        String name;
        EjbJar ejbJar = EjbJarModelAccess.getEjbJar(this.getModel(), parent.getUniqueName());
        if (template == null) {
            name = this.genName(ejbJar, null);
            description = null;
        } else {
            Object source = template.getObjectPropertyValue("$elementToClone");
            if (source instanceof Entity) {
                template = (Entity)source;
            }
            name = this.genName(ejbJar, template.getPropertyValue("$name"));
            description = template.getPropertyValue("description");
        }
        SecurityRole role = ejbJar.getAssemblyDescriptor().createSecurityRole(name, description);
        if (role == null) {
            return null;
        }
        return EjbJarModelMetaInfo.getSecurityRole(ejbJar.getFile(), name);
    }

    public boolean canDelete(Element element) {
        SecurityRole role = AssemblyDescriptorModelAccess.getSecurityRole(this.getModel(), element.getUniqueName());
        return role != null && role.canDelete();
    }

    public void delete(Element element) {
        SecurityRole role = AssemblyDescriptorModelAccess.getSecurityRole(this.getModel(), element.getUniqueName());
        role.delete();
    }

    public boolean isChildrenProviderApplicable(Entity parent) {
        return EjbJarModelMetaInfo.isEjbJar(parent.getUniqueName());
    }

    public UniqueNameEnumeration children(Entity parent) {
        EjbJar ejbJar = EjbJarModelAccess.getEjbJar(this.getModel(), parent.getUniqueName());
        if (ejbJar == null || !ejbJar.isRecognized()) {
            return EmptyEnumeration.getUniqueNameEnumeration();
        }
        SecurityRole[] roles = ejbJar.getAssemblyDescriptor().getSecurityRoles();
        if (roles == null || roles.length == 0) {
            return EmptyEnumeration.getUniqueNameEnumeration();
        }
        ArrayList<UniqueName> uins = new ArrayList<UniqueName>(roles.length);
        int i = 0;
        while (i < roles.length) {
            SecurityRole role = roles[i];
            UniqueName uin = EjbJarModelMetaInfo.getSecurityRole(ejbJar.getFile(), role.getName());
            role.setUserData(AbstractDeltaProvider.DELTA_KEY, (Object)uin);
            uins.add(uin);
            ++i;
        }
        return EnumerationConverter.toUniqueNameEnumeration(uins.iterator());
    }
}

