/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.providers.ejbjar.ad;

import com.tssap.j2ee.core.descriptor.SecurityRole;
import com.tssap.j2ee.core.ejbjar.AssemblyDescriptor;
import com.tssap.j2ee.core.ejbjar.EjbJar;
import com.tssap.j2ee.core.ejbjar.MethodPermission;
import com.tssap.j2ee.core.providers.ejbjar.EjbJarModelMetaInfo;
import com.tssap.j2ee.core.utils.ArrayUtils;
import com.tssap.j2ee.internal.core.providers.ejbjar.EjbJarDeltaProvider;
import com.tssap.j2ee.internal.core.providers.ejbjar.ad.AssemblyDescriptorModelAccess;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.ElementEnumeration;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.extension.ChildrenProvider;
import com.tssap.selena.model.extension.DeleteProvider;
import com.tssap.selena.model.extension.EntityExistenceProvider;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.EnumerationConverter;
import com.tssap.selena.model.util.extension.AbstractProvider;
import java.util.ArrayList;

public final class MethodPermissionSecurityRoleProvider
extends AbstractProvider
implements EntityExistenceProvider,
DeleteProvider,
ChildrenProvider {
    public boolean isDeleteProviderApplicable(Element element) {
        return EjbJarModelMetaInfo.isMethodPermissionSecurityRoleLink(element.getUniqueName());
    }

    private boolean linkExists(UniqueName uin) {
        UniqueName roleUin = EjbJarModelMetaInfo.getSecurityRoleOfMethodPermissionSecurityRoleLink(uin);
        SecurityRole role = AssemblyDescriptorModelAccess.getSecurityRole(this.getModel(), roleUin);
        if (role == null) {
            return false;
        }
        UniqueName mpUin = EjbJarModelMetaInfo.getMethodPermissionOfMethodPermissionSecurityRoleLink(uin);
        MethodPermission mp = AssemblyDescriptorModelAccess.getMethodPermission(this.getModel(), mpUin);
        if (mp == null) {
            return false;
        }
        return ArrayUtils.contains((Object[])mp.getSecurityRoleNames(), (Object)role.getName());
    }

    public boolean isDeleted(Element element) {
        return !this.linkExists(element.getUniqueName());
    }

    public boolean exists(UniqueName uin) {
        if (!EjbJarModelMetaInfo.isMethodPermissionSecurityRoleLink(uin)) {
            return false;
        }
        return this.linkExists(uin);
    }

    private String readRoleName(Entity template) {
        ElementEnumeration roleEnum = template.participants("Supplier");
        if (!roleEnum.hasMoreElements()) {
            return null;
        }
        Element roleElement = roleEnum.next();
        UniqueName roleUin = roleElement.getUniqueName();
        if (!EjbJarModelMetaInfo.isSecurityRole(roleUin)) {
            return null;
        }
        SecurityRole role = AssemblyDescriptorModelAccess.getSecurityRole(this.getModel(), roleUin);
        if (role == null) {
            return null;
        }
        return role.getName();
    }

    public boolean canCreateUniqueName(Entity parent, String shapeType, Entity template) {
        String roleName;
        if (!"com.tssap.j2ee.core.ejbjar.SecurityRoleLink".equals(shapeType)) {
            return false;
        }
        if (!EjbJarModelMetaInfo.isMethodPermission(parent.getUniqueName())) {
            return false;
        }
        MethodPermission permission = AssemblyDescriptorModelAccess.getMethodPermission(this.getModel(), parent.getUniqueName());
        if (permission == null) {
            return false;
        }
        AssemblyDescriptor ad = (AssemblyDescriptor)permission.getParent();
        if (ad == null) {
            return false;
        }
        EjbJar ejbJar = (EjbJar)ad.getParent();
        if (ejbJar == null) {
            return false;
        }
        if (template == null) {
            return false;
        }
        Object pastedRole = template.getObjectPropertyValue("$pastedElement");
        Object source = template.getObjectPropertyValue("$elementToClone");
        if (source instanceof Entity) {
            template = (Entity)source;
        }
        if (pastedRole instanceof Entity) {
            roleName = ((Entity)pastedRole).getPropertyValue("$name");
        } else {
            roleName = template.getPropertyValue("roleLink");
            if (roleName == null) {
                roleName = template.getPropertyValue("$name");
            }
            if (roleName == null) {
                roleName = this.readRoleName(template);
            }
        }
        if (roleName == null || roleName.trim().length() == 0) {
            return false;
        }
        SecurityRole role = ad.getSecurityRole(roleName);
        if (role == null) {
            return false;
        }
        String[] roleNames = permission.getSecurityRoleNames();
        roleNames = ArrayUtils.addString((String[])roleNames, (String)roleName);
        return permission.canSetSecurityRoleNames(roleNames);
    }

    public UniqueName createUniqueName(Entity parent, String shapeType, Entity template) {
        String roleName;
        MethodPermission permission = AssemblyDescriptorModelAccess.getMethodPermission(this.getModel(), parent.getUniqueName());
        AssemblyDescriptor ad = (AssemblyDescriptor)permission.getParent();
        EjbJar ejbJar = (EjbJar)ad.getParent();
        Object pastedRole = template.getObjectPropertyValue("$pastedElement");
        Object source = template.getObjectPropertyValue("$elementToClone");
        if (source instanceof Entity) {
            template = (Entity)source;
        }
        if (pastedRole instanceof Entity) {
            roleName = ((Entity)pastedRole).getPropertyValue("$name");
        } else {
            roleName = template.getPropertyValue("roleLink");
            if (roleName == null) {
                roleName = template.getPropertyValue("$name");
            }
            if (roleName == null) {
                roleName = this.readRoleName(template);
            }
        }
        String[] roleNames = permission.getSecurityRoleNames();
        roleNames = ArrayUtils.addString((String[])roleNames, (String)roleName);
        permission.setSecurityRoleNames(roleNames);
        return EjbJarModelMetaInfo.getMethodPermissionSecurityRoleLink(ejbJar.getFile(), roleName, permission.getSyntheticName());
    }

    public boolean canDelete(Element element) {
        UniqueName uin = element.getUniqueName();
        uin = EjbJarModelMetaInfo.getSecurityRoleOfMethodPermissionSecurityRoleLink(uin);
        SecurityRole role = AssemblyDescriptorModelAccess.getSecurityRole(this.getModel(), uin);
        if (role == null) {
            return false;
        }
        uin = element.getUniqueName();
        uin = EjbJarModelMetaInfo.getMethodPermissionOfMethodPermissionSecurityRoleLink(uin);
        MethodPermission permission = AssemblyDescriptorModelAccess.getMethodPermission(this.getModel(), uin);
        if (permission == null) {
            return false;
        }
        String[] roleNames = permission.getSecurityRoleNames();
        roleNames = ArrayUtils.removeString((String[])roleNames, (String)role.getName());
        return permission.canSetSecurityRoleNames(roleNames);
    }

    public void delete(Element element) {
        UniqueName uin = element.getUniqueName();
        uin = EjbJarModelMetaInfo.getSecurityRoleOfMethodPermissionSecurityRoleLink(uin);
        SecurityRole role = AssemblyDescriptorModelAccess.getSecurityRole(this.getModel(), uin);
        uin = element.getUniqueName();
        uin = EjbJarModelMetaInfo.getMethodPermissionOfMethodPermissionSecurityRoleLink(uin);
        MethodPermission permission = AssemblyDescriptorModelAccess.getMethodPermission(this.getModel(), uin);
        String[] roleNames = permission.getSecurityRoleNames();
        roleNames = ArrayUtils.removeString((String[])roleNames, (String)role.getName());
        permission.setSecurityRoleNames(roleNames);
    }

    public boolean isChildrenProviderApplicable(Entity parent) {
        return EjbJarModelMetaInfo.isMethodPermission(parent.getUniqueName());
    }

    public UniqueNameEnumeration children(Entity parent) {
        MethodPermission permission = AssemblyDescriptorModelAccess.getMethodPermission(this.getModel(), parent.getUniqueName());
        if (permission == null) {
            return EmptyEnumeration.getUniqueNameEnumeration();
        }
        String[] roles = permission.getSecurityRoleNames();
        if (roles == null || roles.length == 0) {
            return EmptyEnumeration.getUniqueNameEnumeration();
        }
        AssemblyDescriptor ad = (AssemblyDescriptor)permission.getParent();
        EjbJar ejbJar = (EjbJar)ad.getParent();
        String permissionName = permission.getSyntheticName();
        ArrayList<UniqueName> uins = new ArrayList<UniqueName>(roles.length);
        int i = 0;
        while (i < roles.length) {
            uins.add(EjbJarModelMetaInfo.getMethodPermissionSecurityRoleLink(ejbJar.getFile(), roles[i], permissionName));
            ++i;
        }
        permission.setUserData((Object)EjbJarDeltaProvider.DELTA_KEY_SECURITY_ROLE, (Object)uins.toArray(new UniqueName[uins.size()]));
        return EnumerationConverter.toUniqueNameEnumeration(uins.iterator());
    }
}

