/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.providers.ejbjar.ad;

import com.tssap.j2ee.core.descriptor.SecurityRole;
import com.tssap.j2ee.core.ejbjar.AssemblyDescriptor;
import com.tssap.j2ee.core.ejbjar.EjbJar;
import com.tssap.j2ee.core.ejbjar.MethodPermission;
import com.tssap.j2ee.core.providers.ejbjar.EjbJarModelMetaInfo;
import com.tssap.j2ee.internal.core.providers.ejbjar.ad.AssemblyDescriptorModelAccess;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.util.extension.AbstractLinkProvider;

public final class MethodPermissionSecurityRoleLinkProvider
extends AbstractLinkProvider {
    public boolean isLinkProviderApplicable(Entity link) {
        return EjbJarModelMetaInfo.isMethodPermissionSecurityRoleLink(link.getUniqueName());
    }

    protected UniqueName getClient(Entity link) {
        UniqueName uin = EjbJarModelMetaInfo.getMethodPermissionOfMethodPermissionSecurityRoleLink(link.getUniqueName());
        MethodPermission permission = AssemblyDescriptorModelAccess.getMethodPermission(this.getModel(), uin);
        if (permission == null) {
            return null;
        }
        AssemblyDescriptor ad = (AssemblyDescriptor)permission.getParent();
        if (ad == null) {
            return null;
        }
        EjbJar ejbJar = (EjbJar)ad.getParent();
        if (ejbJar == null) {
            return null;
        }
        return EjbJarModelMetaInfo.getMethodPermission(ejbJar.getFile(), permission.getSyntheticName());
    }

    protected UniqueName getSupplier(Entity link) {
        UniqueName uin = EjbJarModelMetaInfo.getSecurityRoleOfMethodPermissionSecurityRoleLink(link.getUniqueName());
        SecurityRole role = AssemblyDescriptorModelAccess.getSecurityRole(this.getModel(), uin);
        if (role == null) {
            return null;
        }
        AssemblyDescriptor ad = (AssemblyDescriptor)role.getParent();
        if (ad == null) {
            return null;
        }
        EjbJar ejbJar = (EjbJar)ad.getParent();
        if (ejbJar == null) {
            return null;
        }
        return EjbJarModelMetaInfo.getSecurityRole(ejbJar.getFile(), role.getName());
    }

    protected boolean canSetSupplier(Entity link, Element oldParticipant, Element newParticipant) {
        if (!EjbJarModelMetaInfo.isSecurityRole(newParticipant.getUniqueName())) {
            return false;
        }
        SecurityRole role = AssemblyDescriptorModelAccess.getSecurityRole(this.getModel(), newParticipant.getUniqueName());
        if (role == null) {
            return false;
        }
        if (!EjbJarModelMetaInfo.isSecurityRole(oldParticipant.getUniqueName())) {
            return false;
        }
        SecurityRole oldRole = AssemblyDescriptorModelAccess.getSecurityRole(this.getModel(), oldParticipant.getUniqueName());
        if (oldRole == null) {
            return false;
        }
        UniqueName permissionUin = EjbJarModelMetaInfo.getMethodPermissionOfMethodPermissionSecurityRoleLink(link.getUniqueName());
        MethodPermission permission = AssemblyDescriptorModelAccess.getMethodPermission(this.getModel(), permissionUin);
        if (permission == null) {
            return false;
        }
        String[] roleNames = permission.getSecurityRoleNames();
        int i = 0;
        while (i < roleNames.length) {
            String roleName = roleNames[i];
            if (roleName.equals(role.getName())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void setSupplier(Entity link, Element oldParticipant, Element newParticipant) {
        SecurityRole role = AssemblyDescriptorModelAccess.getSecurityRole(this.getModel(), newParticipant.getUniqueName());
        SecurityRole oldRole = AssemblyDescriptorModelAccess.getSecurityRole(this.getModel(), oldParticipant.getUniqueName());
        UniqueName permissionUin = EjbJarModelMetaInfo.getMethodPermissionOfMethodPermissionSecurityRoleLink(link.getUniqueName());
        MethodPermission permission = AssemblyDescriptorModelAccess.getMethodPermission(this.getModel(), permissionUin);
        String[] roleNames = permission.getSecurityRoleNames();
        int i = 0;
        while (i < roleNames.length) {
            if (roleNames[i].equals(oldRole.getName())) {
                roleNames[i] = role.getName();
            }
            ++i;
        }
        permission.setSecurityRoleNames(roleNames);
    }
}

