/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.providers.ejbjar.ad;

import com.tssap.j2ee.core.ejbjar.EjbJar;
import com.tssap.j2ee.core.ejbjar.MethodPermission;
import com.tssap.j2ee.core.providers.ejbjar.EjbJarModelMetaInfo;
import com.tssap.j2ee.internal.core.descriptor.AbstractDeltaProvider;
import com.tssap.j2ee.internal.core.providers.ejbjar.EjbJarModelAccess;
import com.tssap.j2ee.internal.core.providers.ejbjar.ad.AssemblyDescriptorModelAccess;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.extension.ChildrenProvider;
import com.tssap.selena.model.extension.EntityExistenceProvider;
import com.tssap.selena.model.extension.ExistenceProviderEx;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.EnumerationConverter;
import com.tssap.selena.model.util.extension.AbstractProvider;
import java.util.ArrayList;

public final class MethodPermissionProvider
extends AbstractProvider
implements EntityExistenceProvider,
ExistenceProviderEx,
ChildrenProvider {
    public boolean isDeleteProviderApplicable(Element element) {
        return EjbJarModelMetaInfo.isMethodPermission(element.getUniqueName());
    }

    public boolean isDeleted(Element element) {
        return AssemblyDescriptorModelAccess.getMethodPermission(this.getModel(), element.getUniqueName()) == null;
    }

    public boolean exists(UniqueName uin) {
        if (!EjbJarModelMetaInfo.isMethodPermission(uin)) {
            return false;
        }
        return AssemblyDescriptorModelAccess.getMethodPermission(this.getModel(), uin) != null;
    }

    public boolean canCreateUniqueName(Entity parent, String shapeType, Entity template) {
        String description;
        String[] roles;
        if (!"com.tssap.j2ee.core.ejbjar.MethodPermission".equals(shapeType)) {
            return false;
        }
        if (!EjbJarModelMetaInfo.isEjbJar(parent.getUniqueName())) {
            return false;
        }
        EjbJar ejbJar = EjbJarModelAccess.getEjbJar(this.getModel(), parent.getUniqueName());
        if (ejbJar == null || !ejbJar.isRecognized()) {
            return false;
        }
        if (template == null) {
            roles = null;
            description = null;
        } else {
            Object rolesObj;
            Object source = template.getObjectPropertyValue("$elementToClone");
            if (source instanceof Entity) {
                template = (Entity)source;
            }
            roles = (rolesObj = template.getObjectPropertyValue("securityRoles")) instanceof String[] ? (String[])rolesObj : null;
            description = template.getPropertyValue("description");
        }
        return ejbJar.getAssemblyDescriptor().canCreateMethodPermission(roles, description);
    }

    public UniqueName createUniqueName(Entity parent, String shapeType, Entity template) {
        String description;
        String[] roles;
        EjbJar ejbJar = EjbJarModelAccess.getEjbJar(this.getModel(), parent.getUniqueName());
        if (template == null) {
            roles = null;
            description = null;
        } else {
            Object rolesObj;
            Object source = template.getObjectPropertyValue("$elementToClone");
            if (source instanceof Entity) {
                template = (Entity)source;
            }
            roles = (rolesObj = template.getObjectPropertyValue("securityRoles")) instanceof String[] ? (String[])rolesObj : null;
            description = template.getPropertyValue("description");
        }
        MethodPermission permission = ejbJar.getAssemblyDescriptor().createMethodPermission(roles, description);
        if (permission == null) {
            return null;
        }
        return EjbJarModelMetaInfo.getMethodPermission(ejbJar.getFile(), permission.getSyntheticName());
    }

    public boolean canDelete(Element element) {
        MethodPermission permission = AssemblyDescriptorModelAccess.getMethodPermission(this.getModel(), element.getUniqueName());
        return permission != null && permission.canDelete();
    }

    public void delete(Element element) {
        MethodPermission permission = AssemblyDescriptorModelAccess.getMethodPermission(this.getModel(), element.getUniqueName());
        permission.delete();
    }

    public boolean isChildrenProviderApplicable(Entity parent) {
        return EjbJarModelMetaInfo.isEjbJar(parent.getUniqueName());
    }

    public UniqueNameEnumeration children(Entity parent) {
        EjbJar ejbJar = EjbJarModelAccess.getEjbJar(this.getModel(), parent.getUniqueName());
        if (ejbJar == null || !ejbJar.isRecognized()) {
            return EmptyEnumeration.getUniqueNameEnumeration();
        }
        MethodPermission[] permissions = ejbJar.getAssemblyDescriptor().getMethodPermissions();
        if (permissions == null || permissions.length == 0) {
            return EmptyEnumeration.getUniqueNameEnumeration();
        }
        ArrayList<UniqueName> uins = new ArrayList<UniqueName>(permissions.length);
        int i = 0;
        while (i < permissions.length) {
            MethodPermission permission = permissions[i];
            UniqueName uin = EjbJarModelMetaInfo.getMethodPermission(ejbJar.getFile(), permission.getSyntheticName());
            permission.setUserData(AbstractDeltaProvider.DELTA_KEY, (Object)uin);
            uins.add(uin);
            ++i;
        }
        return EnumerationConverter.toUniqueNameEnumeration(uins.iterator());
    }
}

