/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.providers.ejbjar.ad;

import com.tssap.j2ee.core.ejbjar.ContainerTransaction;
import com.tssap.j2ee.core.ejbjar.EjbJar;
import com.tssap.j2ee.core.providers.ejbjar.EjbJarModelMetaInfo;
import com.tssap.j2ee.internal.core.descriptor.AbstractDeltaProvider;
import com.tssap.j2ee.internal.core.providers.ejbjar.EjbJarModelAccess;
import com.tssap.j2ee.internal.core.providers.ejbjar.ad.AssemblyDescriptorModelAccess;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.extension.ChildrenProvider;
import com.tssap.selena.model.extension.EntityExistenceProvider;
import com.tssap.selena.model.extension.ExistenceProviderEx;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.EnumerationConverter;
import com.tssap.selena.model.util.extension.AbstractProvider;
import java.util.ArrayList;

public final class ContainerTransactionProvider
extends AbstractProvider
implements EntityExistenceProvider,
ExistenceProviderEx,
ChildrenProvider {
    public boolean isDeleteProviderApplicable(Element element) {
        return EjbJarModelMetaInfo.isContainerTransaction(element.getUniqueName());
    }

    public boolean isDeleted(Element element) {
        return AssemblyDescriptorModelAccess.getContainerTransaction(this.getModel(), element.getUniqueName()) == null;
    }

    public boolean exists(UniqueName uin) {
        if (!EjbJarModelMetaInfo.isContainerTransaction(uin)) {
            return false;
        }
        return AssemblyDescriptorModelAccess.getContainerTransaction(this.getModel(), uin) != null;
    }

    public boolean canCreateUniqueName(Entity parent, String shapeType, Entity template) {
        String description;
        String attribute;
        if (!"com.tssap.j2ee.core.ejbjar.ContainerTransaction".equals(shapeType)) {
            return false;
        }
        if (!EjbJarModelMetaInfo.isEjbJar(parent.getUniqueName())) {
            return false;
        }
        EjbJar ejbJar = EjbJarModelAccess.getEjbJar(this.getModel(), parent.getUniqueName());
        if (ejbJar == null || !ejbJar.isRecognized()) {
            return false;
        }
        if (template == null) {
            attribute = "NotSupported";
            description = null;
        } else {
            Object source = template.getObjectPropertyValue("$elementToClone");
            if (source instanceof Entity) {
                template = (Entity)source;
            }
            attribute = template.getPropertyValue("transactionAttribute");
            description = template.getPropertyValue("description");
        }
        return ejbJar.getAssemblyDescriptor().canCreateContainerTransaction(attribute, description);
    }

    public UniqueName createUniqueName(Entity parent, String shapeType, Entity template) {
        String description;
        String attribute;
        EjbJar ejbJar = EjbJarModelAccess.getEjbJar(this.getModel(), parent.getUniqueName());
        if (template == null) {
            attribute = "NotSupported";
            description = null;
        } else {
            Object source = template.getObjectPropertyValue("$elementToClone");
            if (source instanceof Entity) {
                template = (Entity)source;
            }
            attribute = template.getPropertyValue("transactionAttribute");
            description = template.getPropertyValue("description");
        }
        ContainerTransaction transaction = ejbJar.getAssemblyDescriptor().createContainerTransaction(attribute, description);
        if (transaction == null) {
            return null;
        }
        return EjbJarModelMetaInfo.getContainerTransaction(ejbJar.getFile(), transaction.getSyntheticName());
    }

    public boolean canDelete(Element element) {
        ContainerTransaction transaction = AssemblyDescriptorModelAccess.getContainerTransaction(this.getModel(), element.getUniqueName());
        return transaction != null && transaction.canDelete();
    }

    public void delete(Element element) {
        ContainerTransaction transaction = AssemblyDescriptorModelAccess.getContainerTransaction(this.getModel(), element.getUniqueName());
        transaction.delete();
    }

    public boolean isChildrenProviderApplicable(Entity parent) {
        return EjbJarModelMetaInfo.isEjbJar(parent.getUniqueName());
    }

    public UniqueNameEnumeration children(Entity parent) {
        EjbJar ejbJar = EjbJarModelAccess.getEjbJar(this.getModel(), parent.getUniqueName());
        if (ejbJar == null || !ejbJar.isRecognized()) {
            return EmptyEnumeration.getUniqueNameEnumeration();
        }
        ContainerTransaction[] transactions = ejbJar.getAssemblyDescriptor().getContainerTransactions();
        if (transactions == null || transactions.length == 0) {
            return EmptyEnumeration.getUniqueNameEnumeration();
        }
        ArrayList<UniqueName> uins = new ArrayList<UniqueName>(transactions.length);
        int i = 0;
        while (i < transactions.length) {
            ContainerTransaction transaction = transactions[i];
            UniqueName uin = EjbJarModelMetaInfo.getContainerTransaction(ejbJar.getFile(), transaction.getSyntheticName());
            transaction.setUserData(AbstractDeltaProvider.DELTA_KEY, (Object)uin);
            uins.add(uin);
            ++i;
        }
        return EnumerationConverter.toUniqueNameEnumeration(uins.iterator());
    }
}

