/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.providers.ejbjar;

import com.tssap.j2ee.core.descriptor.EnterpriseBean;
import com.tssap.j2ee.core.descriptor.FakeDescriptorEntity;
import com.tssap.j2ee.core.descriptor.SecurityRole;
import com.tssap.j2ee.core.ejbjar.EjbJar;
import com.tssap.j2ee.core.providers.ejbjar.EjbJarModelMetaInfo;
import com.tssap.j2ee.internal.core.providers.ejbjar.EjbJarDeltaProvider;
import com.tssap.j2ee.internal.core.providers.ejbjar.EjbJarModelAccess;
import com.tssap.j2ee.internal.core.providers.ejbjar.ad.AssemblyDescriptorModelAccess;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.ElementEnumeration;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.extension.ChildrenProvider;
import com.tssap.selena.model.extension.EntityExistenceProvider;
import com.tssap.selena.model.extension.ExistenceProviderEx;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.SingleEnumeration;
import com.tssap.selena.model.util.extension.AbstractProvider;

public final class EjbSecurityRoleProvider
extends AbstractProvider
implements EntityExistenceProvider,
ExistenceProviderEx,
ChildrenProvider {
    public boolean isDeleteProviderApplicable(Element element) {
        return EjbJarModelMetaInfo.isEjbSecurityRoleLink(element.getUniqueName());
    }

    private boolean linkExists(UniqueName uin) {
        UniqueName roleUin = EjbJarModelMetaInfo.getSecurityRoleOfEjbSecurityRoleLink(uin);
        SecurityRole role = AssemblyDescriptorModelAccess.getSecurityRole(this.getModel(), roleUin);
        if (role == null) {
            return false;
        }
        EnterpriseBean bean = EjbJarModelAccess.getContainingEnterpriseBean(this.getModel(), uin);
        if (bean == null) {
            return false;
        }
        return role.getName().equals(bean.getSecurityIdentityRunAsRoleName());
    }

    public boolean isDeleted(Element element) {
        return !this.linkExists(element.getUniqueName());
    }

    public boolean exists(UniqueName uin) {
        if (!EjbJarModelMetaInfo.isEjbSecurityRoleLink(uin)) {
            return false;
        }
        return this.linkExists(uin);
    }

    private SecurityRole readLink(Entity template) {
        ElementEnumeration roleEnum = template.participants("Supplier");
        if (roleEnum == null || !roleEnum.hasMoreElements()) {
            return null;
        }
        Element roleElement = roleEnum.next();
        UniqueName roleUin = roleElement.getUniqueName();
        if (!EjbJarModelMetaInfo.isSecurityRole(roleUin)) {
            return new NoSecurityRole();
        }
        return AssemblyDescriptorModelAccess.getSecurityRole(this.getModel(), roleUin);
    }

    public boolean canCreateUniqueName(Entity parent, String shapeType, Entity template) {
        String link;
        if (!"com.tssap.j2ee.core.ejbjar.SecurityRoleLink".equals(shapeType)) {
            return false;
        }
        if (!EjbJarModelMetaInfo.isEjb(parent.getUniqueName())) {
            return false;
        }
        EnterpriseBean bean = EjbJarModelAccess.getEnterpriseBean(this.getModel(), parent.getUniqueName());
        if (bean == null) {
            return false;
        }
        EjbJar ejbJar = (EjbJar)bean.getParent();
        if (ejbJar == null) {
            return false;
        }
        if (template == null) {
            return false;
        }
        Object pastedRole = template.getObjectPropertyValue("$pastedElement");
        Object source = template.getObjectPropertyValue("$elementToClone");
        if (source instanceof Entity) {
            template = (Entity)source;
        }
        if (pastedRole instanceof Entity) {
            link = bean.getSecurityIdentityRunAsRoleName();
            if (link != null) {
                return false;
            }
            link = ((Entity)pastedRole).getPropertyValue("$name");
        } else {
            link = template.getPropertyValue("roleLink");
            if (link == null) {
                SecurityRole linkedRole = this.readLink(template);
                if (linkedRole instanceof NoSecurityRole) {
                    return false;
                }
                if (linkedRole != null) {
                    link = linkedRole.getName();
                }
            }
        }
        return bean.canSetSecurityIdentityRunAsRoleName(link);
    }

    public UniqueName createUniqueName(Entity parent, String shapeType, Entity template) {
        String link;
        EnterpriseBean bean = EjbJarModelAccess.getEnterpriseBean(this.getModel(), parent.getUniqueName());
        EjbJar ejbJar = (EjbJar)bean.getParent();
        Object pastedRole = template.getObjectPropertyValue("$pastedElement");
        Object source = template.getObjectPropertyValue("$elementToClone");
        if (source instanceof Entity) {
            template = (Entity)source;
        }
        if (pastedRole instanceof Entity) {
            link = ((Entity)pastedRole).getPropertyValue("$name");
        } else {
            link = template.getPropertyValue("roleLink");
            if (link == null) {
                SecurityRole linkedRole = this.readLink(template);
                if (linkedRole instanceof NoSecurityRole) {
                    return null;
                }
                if (linkedRole != null) {
                    link = linkedRole.getName();
                }
            }
        }
        bean.setSecurityIdentityRunAsRoleName(link);
        return EjbJarModelMetaInfo.getEjbSecurityRoleLink(ejbJar.getFile(), link, bean.getName());
    }

    public boolean canDelete(Element element) {
        EnterpriseBean bean = EjbJarModelAccess.getContainingEnterpriseBean(this.getModel(), element.getUniqueName());
        if (bean == null) {
            return false;
        }
        return bean.canSetSecurityIdentityRunAsRoleName(null);
    }

    public void delete(Element element) {
        EnterpriseBean bean = EjbJarModelAccess.getContainingEnterpriseBean(this.getModel(), element.getUniqueName());
        bean.setSecurityIdentityRunAsRoleName(null);
    }

    public boolean isChildrenProviderApplicable(Entity parent) {
        return EjbJarModelMetaInfo.isEjb(parent.getUniqueName());
    }

    public UniqueNameEnumeration children(Entity parent) {
        EnterpriseBean bean = EjbJarModelAccess.getEnterpriseBean(this.getModel(), parent.getUniqueName());
        if (bean == null) {
            return EmptyEnumeration.getUniqueNameEnumeration();
        }
        String roleName = bean.getSecurityIdentityRunAsRoleName();
        if (roleName == null || roleName.trim().length() == 0) {
            bean.setUserData((Object)EjbJarDeltaProvider.DELTA_KEY_SECURITY_ROLE, null);
            return EmptyEnumeration.getUniqueNameEnumeration();
        }
        EjbJar ejbJar = (EjbJar)bean.getParent();
        UniqueName roleUin = EjbJarModelMetaInfo.getSecurityRole(ejbJar.getFile(), roleName);
        SecurityRole role = AssemblyDescriptorModelAccess.getSecurityRole(this.getModel(), roleUin);
        if (role == null) {
            bean.setUserData((Object)EjbJarDeltaProvider.DELTA_KEY_SECURITY_ROLE, null);
            return EmptyEnumeration.getUniqueNameEnumeration();
        }
        UniqueName uin = EjbJarModelMetaInfo.getEjbSecurityRoleLink(ejbJar.getFile(), roleName, bean.getName());
        bean.setUserData((Object)EjbJarDeltaProvider.DELTA_KEY_SECURITY_ROLE, (Object)uin);
        return SingleEnumeration.createUniqueNameEnumeration((UniqueName)uin);
    }

    private static class NoSecurityRole
    extends FakeDescriptorEntity
    implements SecurityRole {
        private NoSecurityRole() {
        }

        public String getName() {
            return null;
        }

        public boolean canSetName(String name) {
            return false;
        }

        public void setName(String name) {
        }

        public String getDescription() {
            return null;
        }

        public boolean canSetDescription(String description) {
            return false;
        }

        public void setDescription(String description) {
        }
    }
}

