/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.providers.ejbjar;

import com.tssap.j2ee.core.descriptor.EnterpriseBean;
import com.tssap.j2ee.core.ejb.EjbProject;
import com.tssap.j2ee.core.ejb.IEnterpriseBean;
import com.tssap.j2ee.core.ejbjar.EjbJar;
import com.tssap.j2ee.core.ejbjar.EjbJarProject;
import com.tssap.j2ee.core.providers.ejb.EjbModelMetaInfo;
import com.tssap.j2ee.core.providers.ejbjar.EjbJarModelMetaInfo;
import com.tssap.j2ee.core.utils.UtilsPlugin;
import com.tssap.j2ee.internal.core.providers.ejbjar.EjbJarProvidersPlugin;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.providers.proxy.ProxyRule;
import com.tssap.selena.model.util.EnumerationConverter;
import com.tssap.selena.model.util.ModelUinSupport;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;

public class EjbProxyRule
implements ProxyRule {
    public UniqueNameEnumeration getProxies(Model proxyModel, Model sourceModel, UniqueName source) {
        if (!EjbModelMetaInfo.isEjb((UniqueName)source)) {
            return null;
        }
        String ejbClass = EjbModelMetaInfo.getEjbClassFqn((UniqueName)source);
        if (ejbClass == null || ejbClass.trim().length() == 0) {
            EjbJarProvidersPlugin.logWarning("Invalid ejb encountered [" + source + "] in model [" + sourceModel + "]");
            return null;
        }
        IProject sourceProject = ModelUinSupport.getProject((UniqueName)sourceModel.getUniqueName());
        if (sourceProject == null) {
            return null;
        }
        EjbProject ejbProject = EjbProject.getInstance((IProject)sourceProject);
        if (ejbProject == null) {
            return null;
        }
        IProject proxyProject = ModelUinSupport.getProject((UniqueName)proxyModel.getUniqueName());
        if (proxyProject == null) {
            return null;
        }
        EjbJarProject ejbJarProject = EjbJarProject.getInstance((IProject)proxyProject);
        if (ejbJarProject == null) {
            return null;
        }
        EjbJar[] ejbJars = ejbJarProject.getEjbJars();
        if (ejbJars == null || ejbJars.length == 0) {
            return null;
        }
        if (!UtilsPlugin.references((IProject)proxyProject, (IProject)sourceProject)) {
            return null;
        }
        ArrayList uins = new ArrayList();
        int i = 0;
        while (i < ejbJars.length) {
            this.addProxies(uins, ejbJars[i], sourceProject, ejbClass, sourceModel, source);
            ++i;
        }
        if (uins.isEmpty()) {
            return null;
        }
        return EnumerationConverter.toUniqueNameEnumeration(uins.iterator());
    }

    public void addProxies(List uins, EjbJar ejbJar, IProject ejbProject, String ejbClass, Model ejbModel, UniqueName ejbUin) {
        EnterpriseBean[] ejbs = ejbJar.getEnterpriseBeans();
        if (ejbs == null || ejbs.length == 0) {
            return;
        }
        UniqueName ejbJarUin = null;
        int i = 0;
        while (i < ejbs.length) {
            IProject ejbRefProjectRef;
            EjbProject ejbRefProject;
            IEnterpriseBean ejbRef;
            EnterpriseBean ejb = ejbs[i];
            if (ejb != null && (ejbRef = ejb.getReferencedBean()) != null && ejbRef.exists() && ejbClass.equals(ejbRef.getBeanClassName()) && (ejbRefProject = ejbRef.getEJBProject()) != null && (ejbRefProjectRef = ejbRefProject.getProject()) != null && ejbRefProjectRef.getName().equals(ejbProject.getName())) {
                if (ejbJarUin == null) {
                    ejbJarUin = EjbJarModelMetaInfo.getEjbJar(ejbJar.getFile());
                }
                UniqueName proxyUin = EjbJarModelMetaInfo.getEjb(ejbModel, ejbUin, ejbJarUin, ejb.getName());
                uins.add(proxyUin);
            }
            ++i;
        }
    }
}

