/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.providers.ejbjar;

import com.tssap.j2ee.core.descriptor.EnterpriseBean;
import com.tssap.j2ee.core.ejb.IEnterpriseBean;
import com.tssap.j2ee.core.ejb.IEntityBean;
import com.tssap.j2ee.core.ejb.IMessageDrivenBean;
import com.tssap.j2ee.core.ejb.ISessionBean;
import com.tssap.j2ee.core.ejbjar.EjbJar;
import com.tssap.j2ee.core.ejbjar.EntityBean;
import com.tssap.j2ee.core.ejbjar.context.EntityBeanContext;
import com.tssap.j2ee.core.ejbjar.context.MessageDrivenBeanContext;
import com.tssap.j2ee.core.ejbjar.context.SessionBeanContext;
import com.tssap.j2ee.core.ejbjar.namegen.EjbNameGen;
import com.tssap.j2ee.core.providers.ejb.EjbModelMetaInfo;
import com.tssap.j2ee.core.providers.ejbjar.EjbJarModelMetaInfo;
import com.tssap.j2ee.core.providers.ejbjar.context.EjbContextFactory;
import com.tssap.j2ee.core.providers.ejbjar.context.EjbDeployedContextFactory;
import com.tssap.j2ee.internal.core.descriptor.AbstractDeltaProvider;
import com.tssap.j2ee.internal.core.providers.ejbjar.EjbJarModelAccess;
import com.tssap.j2ee.internal.core.providers.ejbjar.EjbJarProvidersPlugin;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.extension.ChildrenProvider;
import com.tssap.selena.model.extension.EntityExistenceProvider;
import com.tssap.selena.model.extension.ExistenceProviderEx;
import com.tssap.selena.model.providers.proxy.ProxyMetaInfo;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.EnumerationConverter;
import com.tssap.selena.model.util.ModelUinSupport;
import com.tssap.selena.model.util.extension.AbstractProvider;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IType;

public final class EjbProxyProvider
extends AbstractProvider
implements EntityExistenceProvider,
ExistenceProviderEx,
ChildrenProvider {
    public boolean isDeleteProviderApplicable(Element element) {
        return EjbJarModelMetaInfo.isEjb(element.getUniqueName());
    }

    private boolean ejbExists(UniqueName uin) {
        EnterpriseBean ejb = EjbJarModelAccess.getEnterpriseBean(this.getModel(), uin);
        if (ejb == null) {
            return false;
        }
        Model ejbRefModel = EjbJarModelMetaInfo.getEjbModel(uin);
        if (ejbRefModel == null || ejbRefModel.isDeleted()) {
            return false;
        }
        Entity ejbRef = ejbRefModel.findEntity(EjbJarModelMetaInfo.getEjb(uin));
        if (ejbRef == null || ejbRef.isDeleted()) {
            return false;
        }
        IEnterpriseBean ejbCodeRef = ejb.getReferencedBean();
        if (ejbCodeRef == null || !ejbCodeRef.exists()) {
            return false;
        }
        UniqueName ejbCodeRefUin = EjbModelMetaInfo.getUniqueName((IEnterpriseBean)ejbCodeRef);
        return ejbRef.getUniqueName().equals(ejbCodeRefUin);
    }

    public boolean isDeleted(Element element) {
        return !this.ejbExists(element.getUniqueName());
    }

    public boolean exists(UniqueName uin) {
        if (!EjbJarModelMetaInfo.isEjb(uin)) {
            return false;
        }
        return this.ejbExists(uin);
    }

    private static boolean isEjbType(String shapeType) {
        if ("com.tssap.j2ee.core.ejb.EntityBean".equals(shapeType)) {
            return true;
        }
        if ("com.tssap.j2ee.core.ejb.SessionBean".equals(shapeType)) {
            return true;
        }
        return "com.tssap.j2ee.core.ejb.MessageDrivenBean".equals(shapeType);
    }

    private String getEjbName(Entity template, EjbJar ejbJar) {
        String name = template.getPropertyValue("$name");
        if (name == null) {
            name = template.getPropertyValue("ejbName");
        }
        if (name == null) {
            name = template.getPropertyValue("beanClass");
            if (name == null) {
                name = "ejb";
            } else {
                int doti = name.indexOf(46);
                if (doti >= 0) {
                    name = name.substring(doti + 1);
                }
            }
        }
        EjbNameGen eng = new EjbNameGen(ejbJar);
        return eng.getUniqueName(name);
    }

    private Boolean getLocalOption(Entity template) {
        Boolean local = null;
        String localProperty = template.getPropertyValue("local*");
        if (localProperty != null) {
            local = new Boolean(localProperty);
        }
        return local;
    }

    public boolean canCreateUniqueName(Entity parent, String shapeType, Entity template) {
        if (!EjbProxyProvider.isEjbType(shapeType)) {
            return false;
        }
        if (!EjbJarModelMetaInfo.isEjbJar(parent.getUniqueName())) {
            return false;
        }
        EjbJar ejbJar = EjbJarModelAccess.getEjbJar(this.getModel(), parent.getUniqueName());
        if (ejbJar == null) {
            return false;
        }
        if (template == null) {
            return true;
        }
        Entity ejbEntity = EjbJarModelMetaInfo.getSourceEjb(template);
        if (ejbEntity != null) {
            if (!EjbModelMetaInfo.isEjb((UniqueName)ejbEntity.getUniqueName())) {
                return false;
            }
            String name = this.getEjbName(template, ejbJar);
            Boolean local = this.getLocalOption(template);
            String type = ejbEntity.getPropertyValue("$metaclass");
            if ("com.tssap.j2ee.core.ejb.EntityBean".equals(type)) {
                EntityBeanContext context = EjbContextFactory.getInstance().getEntityBeanContext((Element)ejbEntity, name);
                return ejbJar.canCreateEntityBean(context, local);
            }
            if ("com.tssap.j2ee.core.ejb.SessionBean".equals(type)) {
                SessionBeanContext context = EjbContextFactory.getInstance().getSessionBeanContext((Element)ejbEntity, name);
                return ejbJar.canCreateSessionBean(context, local);
            }
            if ("com.tssap.j2ee.core.ejb.MessageDrivenBean".equals(type)) {
                MessageDrivenBeanContext context = EjbContextFactory.getInstance().getMessageDrivenBeanContext((Element)ejbEntity, name);
                return ejbJar.canCreateMessageDrivenBean(context);
            }
        } else {
            Object source = template.getObjectPropertyValue("$elementToClone");
            if (source instanceof Entity) {
                template = (Entity)source;
            }
            String name = this.getEjbName(template, ejbJar);
            String type = template.getPropertyValue("$metaclass");
            if ("com.tssap.j2ee.core.ejb.EntityBean".equals(type)) {
                EntityBeanContext context = EjbDeployedContextFactory.getInstance().getEntityBeanContext((Element)template, name);
                return ejbJar.canCreateEntityBean(context, null);
            }
            if ("com.tssap.j2ee.core.ejb.SessionBean".equals(type)) {
                SessionBeanContext context = EjbDeployedContextFactory.getInstance().getSessionBeanContext((Element)template, name);
                return ejbJar.canCreateSessionBean(context, null);
            }
            if ("com.tssap.j2ee.core.ejb.MessageDrivenBean".equals(type)) {
                MessageDrivenBeanContext context = EjbDeployedContextFactory.getInstance().getMessageDrivenBeanContext((Element)template, name);
                return ejbJar.canCreateMessageDrivenBean(context);
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public UniqueName createUniqueName(Entity parent, String shapeType, Entity template) {
        if (template == null || !this.canCreateUniqueName(parent, shapeType, template)) {
            return null;
        }
        EjbJar ejbJar = EjbJarModelAccess.getEjbJar(this.getModel(), parent.getUniqueName());
        if (!ejbJar.ensureSaved(true)) {
            return null;
        }
        EntityBean ejbRef = null;
        Entity ejbEntity = EjbJarModelMetaInfo.getSourceEjb(template);
        if (ejbEntity != null) {
            String name = this.getEjbName(template, ejbJar);
            Boolean local = this.getLocalOption(template);
            String type = ejbEntity.getPropertyValue("$metaclass");
            if ("com.tssap.j2ee.core.ejb.EntityBean".equals(type)) {
                EntityBeanContext context = EjbContextFactory.getInstance().getEntityBeanContext((Element)ejbEntity, name);
                ejbRef = ejbJar.createEntityBean(context, local);
            } else if ("com.tssap.j2ee.core.ejb.SessionBean".equals(type)) {
                SessionBeanContext context = EjbContextFactory.getInstance().getSessionBeanContext((Element)ejbEntity, name);
                ejbRef = ejbJar.createSessionBean(context, local);
            } else {
                if (!"com.tssap.j2ee.core.ejb.MessageDrivenBean".equals(type)) return null;
                MessageDrivenBeanContext context = EjbContextFactory.getInstance().getMessageDrivenBeanContext((Element)ejbEntity, name);
                ejbRef = ejbJar.createMessageDrivenBean(context);
            }
        } else {
            Object source = template.getObjectPropertyValue("$elementToClone");
            if (source instanceof Entity) {
                template = (Entity)source;
            }
            String name = this.getEjbName(template, ejbJar);
            String type = template.getPropertyValue("$metaclass");
            if ("com.tssap.j2ee.core.ejb.EntityBean".equals(type)) {
                EntityBeanContext context = EjbDeployedContextFactory.getInstance().getEntityBeanContext((Element)template, name);
                ejbRef = ejbJar.createEntityBean(context, null);
            } else if ("com.tssap.j2ee.core.ejb.SessionBean".equals(type)) {
                SessionBeanContext context = EjbDeployedContextFactory.getInstance().getSessionBeanContext((Element)template, name);
                ejbRef = ejbJar.createSessionBean(context, null);
            } else if ("com.tssap.j2ee.core.ejb.MessageDrivenBean".equals(type)) {
                MessageDrivenBeanContext context = EjbDeployedContextFactory.getInstance().getMessageDrivenBeanContext((Element)template, name);
                ejbRef = ejbJar.createMessageDrivenBean(context);
            }
        }
        if (ejbRef != null) return EjbJarModelAccess.getEnterpriseBeanUniqueName(ejbRef.getReferencedBean(), ejbRef.getName(), parent.getUniqueName());
        return null;
    }

    public boolean canDelete(Element element) {
        EnterpriseBean ejb = EjbJarModelAccess.getEnterpriseBean(this.getModel(), element.getUniqueName());
        return ejb != null && ejb.canDelete();
    }

    public void delete(Element element) {
        EjbJar ejbJar = EjbJarModelAccess.getEjbJar(this.getModel(), element.getParent().getUniqueName());
        if (!ejbJar.ensureSaved(true)) {
            return;
        }
        EnterpriseBean ejb = EjbJarModelAccess.getEnterpriseBean(this.getModel(), element.getUniqueName());
        ejb.delete();
    }

    public boolean isChildrenProviderApplicable(Entity parent) {
        return EjbJarModelMetaInfo.isEjbJar(parent.getUniqueName());
    }

    public UniqueNameEnumeration children(Entity parent) {
        EjbJar ejbJar = EjbJarModelAccess.getEjbJar(this.getModel(), parent.getUniqueName());
        if (ejbJar == null) {
            return EmptyEnumeration.getUniqueNameEnumeration();
        }
        EnterpriseBean[] ejbs = ejbJar.getEnterpriseBeans();
        if (ejbs == null || ejbs.length == 0) {
            return EmptyEnumeration.getUniqueNameEnumeration();
        }
        ArrayList<UniqueName> uins = new ArrayList<UniqueName>(ejbs.length);
        int i = 0;
        while (i < ejbs.length) {
            block8: {
                UniqueName source;
                IEnterpriseBean ejbRef;
                EnterpriseBean ejb;
                block10: {
                    String packageName;
                    String beanClassName;
                    block11: {
                        block9: {
                            IType beanClass;
                            ejb = ejbs[i];
                            ejbRef = ejb.getReferencedBean();
                            if (ejbRef == null || (beanClass = ejbRef.getBeanClass()) == null) break block8;
                            beanClassName = beanClass.getElementName();
                            packageName = beanClass.getPackageFragment().getElementName();
                            if (!(ejbRef instanceof IEntityBean)) break block9;
                            source = EjbModelMetaInfo.getEntityBeanUniqueName((String)packageName, (String)beanClassName);
                            break block10;
                        }
                        if (!(ejbRef instanceof ISessionBean)) break block11;
                        source = EjbModelMetaInfo.getSessionBeanUniqueName((String)packageName, (String)beanClassName);
                        break block10;
                    }
                    if (!(ejbRef instanceof IMessageDrivenBean)) break block8;
                    source = EjbModelMetaInfo.getMessageDrivenBeanUniqueName((String)packageName, (String)beanClassName);
                }
                IProject ejbProject = ejbRef.getEJBProject().getProject();
                Model sourceModel = ModelAccess.getModel((UniqueName)ModelUinSupport.createModelUin((String)ejbProject.getName()));
                if (sourceModel.findEntity(source) == null) {
                    EjbJarProvidersPlugin.logWarning("Ejb [" + ejb.getName() + "] not found");
                } else {
                    UniqueName uin = EjbJarModelMetaInfo.getEjb(sourceModel, source, parent.getUniqueName(), ejb.getName());
                    ProxyMetaInfo.bind((UniqueName)uin, (UniqueName)this.getModel().getUniqueName());
                    ejb.setUserData(AbstractDeltaProvider.DELTA_KEY, (Object)uin);
                    uins.add(uin);
                }
            }
            ++i;
        }
        return EnumerationConverter.toUniqueNameEnumeration(uins.iterator());
    }
}

