/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.providers.ejbjar;

import com.tssap.j2ee.core.providers.ejbjar.EjbJarModelMetaInfo;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.ElementEnumeration;
import com.tssap.selena.model.enum.StringEnumeration;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.extension.EntityExistenceProvider;
import com.tssap.selena.model.extension.LinkProvider;
import com.tssap.selena.model.providers.proxy.ProxyMetaInfo;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.EnumerationConverter;
import com.tssap.selena.model.util.extension.AbstractProvider;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public final class EjbParticipantsProvider
extends AbstractProvider
implements LinkProvider,
EntityExistenceProvider {
    private static final Set SUPPORTED_ROLES = new HashSet();

    private boolean isParticipant(UniqueName uin) {
        if (!ProxyMetaInfo.isProxyUniqueName((UniqueName)uin)) {
            return false;
        }
        UniqueName parent = ProxyMetaInfo.getParentUniqueName((UniqueName)uin);
        if (!EjbJarModelMetaInfo.isEjb(parent)) {
            return false;
        }
        UniqueName source = ProxyMetaInfo.getSourceUniqueName((UniqueName)uin);
        return "jdt".equals(source.getDomain());
    }

    private boolean isParticipantDeleted(UniqueName uin) {
        Element source = ProxyMetaInfo.getSourceElement((UniqueName)uin);
        return source == null || source.isDeleted();
    }

    public boolean isDeleteProviderApplicable(Element element) {
        return this.isParticipant(element.getUniqueName());
    }

    public boolean isDeleted(Element element) {
        return this.isParticipantDeleted(element.getUniqueName());
    }

    public boolean exists(UniqueName uin) {
        if (!this.isParticipant(uin)) {
            return false;
        }
        return !this.isParticipantDeleted(uin);
    }

    public boolean canCreateUniqueName(Entity parent, String shapeType, Entity template) {
        return false;
    }

    public UniqueName createUniqueName(Entity parent, String shapeType, Entity template) {
        return null;
    }

    public boolean canDelete(Element element) {
        return false;
    }

    public void delete(Element element) {
    }

    public boolean isLinkProviderApplicable(Entity link) {
        return EjbJarModelMetaInfo.isEjb(link.getUniqueName());
    }

    public StringEnumeration participantRoles(Entity link) {
        Entity source = ProxyMetaInfo.getSourceEntity((UniqueName)link.getUniqueName());
        if (source == null) {
            return EmptyEnumeration.getStringEnumeration();
        }
        StringEnumeration roles = source.participantRoles();
        if (!roles.hasMoreElements()) {
            return EmptyEnumeration.getStringEnumeration();
        }
        ArrayList<String> filtered = new ArrayList<String>();
        while (roles.hasMoreElements()) {
            String role = roles.next();
            if (!SUPPORTED_ROLES.contains(role)) continue;
            filtered.add(role);
        }
        return EnumerationConverter.toStringEnumeration(filtered.iterator());
    }

    public UniqueNameEnumeration participants(Entity link, String role) {
        Entity source = ProxyMetaInfo.getSourceEntity((UniqueName)link.getUniqueName());
        if (source == null) {
            return EmptyEnumeration.getUniqueNameEnumeration();
        }
        ElementEnumeration sourceps = source.participants(role);
        if (!sourceps.hasMoreElements()) {
            return EmptyEnumeration.getUniqueNameEnumeration();
        }
        UniqueName sourceModel = ProxyMetaInfo.getSourceModelUniqueName((UniqueName)link.getUniqueName());
        ArrayList<UniqueName> targetps = new ArrayList<UniqueName>();
        while (sourceps.hasMoreElements()) {
            Element sourcep = sourceps.next();
            UniqueName targetp = ProxyMetaInfo.getAutoProxyUniqueName((UniqueName)link.getUniqueName(), (UniqueName)sourceModel, (UniqueName)sourcep.getUniqueName());
            ProxyMetaInfo.bind((UniqueName)targetp, (UniqueName)this.getModel().getUniqueName());
            targetps.add(targetp);
        }
        return EnumerationConverter.toUniqueNameEnumeration(targetps.iterator());
    }

    public boolean canSetParticipant(Entity link, Element participant, String oldRole, String newRole) {
        return false;
    }

    public void setParticipant(Entity link, Element participant, String oldRole, String newRole) {
    }

    public boolean canSetParticipant(Entity link, String role, Element oldParticipant, Element newParticipant) {
        return false;
    }

    public void setParticipant(Entity link, String role, Element oldParticipant, Element newParticipant) {
    }

    static {
        SUPPORTED_ROLES.add("Bean Class");
        SUPPORTED_ROLES.add("Home Interface");
        SUPPORTED_ROLES.add("Remote Interface");
        SUPPORTED_ROLES.add("Local Home Interface");
        SUPPORTED_ROLES.add("Local Interface");
        SUPPORTED_ROLES.add("Primary Key Class");
    }
}

