/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.providers.ejbjar;

import com.tssap.j2ee.core.ejbjar.EjbJar;
import com.tssap.j2ee.core.ejbjar.EjbJarProject;
import com.tssap.j2ee.core.providers.ejbjar.EjbJarModelMetaInfo;
import com.tssap.j2ee.internal.core.descriptor.AbstractDeltaProvider;
import com.tssap.j2ee.internal.core.providers.ejbjar.EjbJarModelAccess;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.extension.ChildrenProvider;
import com.tssap.selena.model.extension.EntityExistenceProvider;
import com.tssap.selena.model.extension.ExistenceProviderEx;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.EnumerationConverter;
import com.tssap.selena.model.util.ModelUinSupport;
import com.tssap.selena.model.util.extension.AbstractProvider;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;

public final class EjbJarProvider
extends AbstractProvider
implements EntityExistenceProvider,
ExistenceProviderEx,
ChildrenProvider {
    public boolean isDeleteProviderApplicable(Element element) {
        return EjbJarModelMetaInfo.isEjbJar(element.getUniqueName());
    }

    public boolean isDeleted(Element element) {
        return EjbJarModelAccess.getEjbJar(this.getModel(), element.getUniqueName()) == null;
    }

    public boolean exists(UniqueName uin) {
        if (!EjbJarModelMetaInfo.isEjbJar(uin)) {
            return false;
        }
        return EjbJarModelAccess.getEjbJar(this.getModel(), uin) != null;
    }

    public boolean canCreateUniqueName(Entity parent, String shapeType, Entity template) {
        if (!"com.tssap.j2ee.core.ejbjar.EjbJar".equals(shapeType)) {
            return false;
        }
        if (!ModelUinSupport.isModelUin((UniqueName)parent.getUniqueName())) {
            return false;
        }
        if (!template.hasProperty("$file")) {
            return false;
        }
        String fileName = template.getPropertyValue("$file");
        if (!fileName.endsWith("ejb-jar.xml")) {
            return false;
        }
        IFile file = this.getProject().getFile(fileName);
        if (file.exists()) {
            return false;
        }
        IContainer container = file.getParent();
        if (!container.isAccessible()) {
            return false;
        }
        return EjbJarModelAccess.getEjbJar(this.getModel(), EjbJarModelMetaInfo.getEjbJar(file)) == null;
    }

    public UniqueName createUniqueName(Entity parent, String shapeType, Entity template) {
        IFile file = this.getProject().getFile(template.getPropertyValue("$file"));
        EjbJarProject.getInstance((IProject)this.getProject()).createEjbJar(file);
        return EjbJarModelMetaInfo.getEjbJar(file);
    }

    public boolean canDelete(Element element) {
        EjbJar ejbJar = EjbJarModelAccess.getEjbJar(this.getModel(), element.getUniqueName());
        return ejbJar != null && ejbJar.canDelete();
    }

    public void delete(Element element) {
        EjbJar ejbJar = EjbJarModelAccess.getEjbJar(this.getModel(), element.getUniqueName());
        ejbJar.delete();
    }

    public boolean isChildrenProviderApplicable(Entity parent) {
        return ModelUinSupport.isModelUin((UniqueName)parent.getUniqueName());
    }

    public UniqueNameEnumeration children(Entity parent) {
        EjbJarProject ejbJarProject = EjbJarProject.getInstance((IProject)this.getProject());
        if (ejbJarProject == null) {
            return EmptyEnumeration.getUniqueNameEnumeration();
        }
        EjbJar[] ejbJars = ejbJarProject.getEjbJars();
        if (ejbJars == null || ejbJars.length == 0) {
            return EmptyEnumeration.getUniqueNameEnumeration();
        }
        ArrayList<UniqueName> uins = new ArrayList<UniqueName>(ejbJars.length);
        int i = 0;
        while (i < ejbJars.length) {
            UniqueName uin = EjbJarModelMetaInfo.getEjbJar(ejbJars[i].getFile());
            ejbJars[i].setUserData(AbstractDeltaProvider.DELTA_KEY, (Object)uin);
            uins.add(uin);
            ++i;
        }
        return EnumerationConverter.toUniqueNameEnumeration(uins.iterator());
    }
}

