/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.providers.ejbjar;

import com.tssap.j2ee.core.descriptor.AbstractJ2eeDescriptorProject;
import com.tssap.j2ee.core.descriptor.DescriptorDocument;
import com.tssap.j2ee.core.descriptor.DescriptorEntity;
import com.tssap.j2ee.core.descriptor.EjbLocalRef;
import com.tssap.j2ee.core.descriptor.EjbRef;
import com.tssap.j2ee.core.descriptor.EnterpriseBean;
import com.tssap.j2ee.core.descriptor.SecurityRoleRef;
import com.tssap.j2ee.core.ejbjar.AssemblyDescriptor;
import com.tssap.j2ee.core.ejbjar.CmpField;
import com.tssap.j2ee.core.ejbjar.EjbJar;
import com.tssap.j2ee.core.ejbjar.EjbJarProject;
import com.tssap.j2ee.core.ejbjar.EjbRelation;
import com.tssap.j2ee.core.ejbjar.EjbRelationshipRole;
import com.tssap.j2ee.core.ejbjar.EntityBean;
import com.tssap.j2ee.core.ejbjar.MethodPermission;
import com.tssap.j2ee.core.ejbjar.Query;
import com.tssap.j2ee.core.providers.ejbjar.EjbJarModelMetaInfo;
import com.tssap.j2ee.core.utils.ArrayUtils;
import com.tssap.j2ee.internal.core.descriptor.AbstractDeltaProvider;
import com.tssap.j2ee.internal.core.providers.ejbjar.EjbJarModelAccess;
import com.tssap.j2ee.internal.core.providers.ejbjar.EjbJarUinSupport;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.util.delta.DefaultModelDeltaNode;
import com.tssap.selena.model.util.delta.ModelDeltaNodeKind;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;

public final class EjbJarDeltaProvider
extends AbstractDeltaProvider {
    public static final String DELTA_KEY_SECURITY_ROLE = AbstractDeltaProvider.DELTA_KEY + "Security";
    public static final String DELTA_KEY_EJB_SITE = AbstractDeltaProvider.DELTA_KEY + "EjbSite";
    private boolean myUpdateEjbSites;

    protected UniqueName getUniqueName(DescriptorEntity entity) {
        if (entity instanceof SecurityRoleRef || entity instanceof EjbLocalRef || entity instanceof EjbRef) {
            return null;
        }
        return EjbJarUinSupport.getUniqueName(entity);
    }

    protected UniqueName getParentUin(DescriptorEntity entity) {
        if (entity instanceof EjbJar) {
            return this.getModel().getUniqueName();
        }
        if (entity instanceof EjbRelation) {
            EjbRelation relation = (EjbRelation)entity;
            EntityBean ejb = relation.getRole1().getSourceEjb();
            if (ejb == null) {
                return null;
            }
            return EjbJarUinSupport.getUniqueName((EnterpriseBean)ejb);
        }
        return super.getParentUin(entity);
    }

    protected AbstractJ2eeDescriptorProject getJ2eeProject() {
        return EjbJarProject.getInstance((IProject)this.getProject());
    }

    protected DescriptorEntity getProvidedDescriptorEntity(DescriptorEntity entity) {
        if (entity instanceof EjbRelationshipRole) {
            return entity.getParent();
        }
        if (entity instanceof AssemblyDescriptor) {
            return entity.getParent();
        }
        return entity;
    }

    public void descriptorEntityAdded(DescriptorEntity entity) {
        if (entity instanceof EnterpriseBean) {
            this.myUpdateEjbSites = true;
        } else if (entity instanceof EjbRelation) {
            this.myUpdateEjbSites = true;
        } else {
            if (entity instanceof CmpField) {
                super.descriptorEntityChanged(entity);
                return;
            }
            if (entity instanceof Query) {
                super.descriptorEntityChanged(entity);
                return;
            }
            if (entity instanceof AssemblyDescriptor) {
                return;
            }
        }
        super.descriptorEntityAdded(entity);
    }

    public void descriptorEntityRemoved(DescriptorEntity entity) {
        if (entity instanceof EnterpriseBean) {
            this.myUpdateEjbSites = true;
        } else if (entity instanceof EjbRelation) {
            this.myUpdateEjbSites = true;
        } else {
            if (entity instanceof CmpField) {
                super.descriptorEntityChanged(entity);
                return;
            }
            if (entity instanceof Query) {
                super.descriptorEntityChanged(entity);
                return;
            }
            if (entity instanceof AssemblyDescriptor) {
                return;
            }
        }
        super.descriptorEntityRemoved(entity);
    }

    public void descriptorEntityChanged(DescriptorEntity entity) {
        if (entity instanceof EnterpriseBean) {
            this.processEjbChanged((EnterpriseBean)entity);
            this.myUpdateEjbSites = true;
        } else if (entity instanceof EjbRelationshipRole) {
            this.myUpdateEjbSites = true;
        } else if (entity instanceof EjbRelation) {
            this.myUpdateEjbSites = true;
        } else if (entity instanceof MethodPermission) {
            this.processMethodPermissionChanged((MethodPermission)entity);
        } else if (entity instanceof AssemblyDescriptor) {
            return;
        }
        super.descriptorEntityChanged(entity);
    }

    public void descriptorEntityTotallyChanged(DescriptorEntity entity) {
        if (entity instanceof EnterpriseBean) {
            this.processEjbChanged((EnterpriseBean)entity);
        } else if (entity instanceof EjbRelationshipRole) {
            this.myUpdateEjbSites = true;
        } else if (entity instanceof EjbRelation) {
            this.myUpdateEjbSites = true;
        } else if (entity instanceof AssemblyDescriptor) {
            return;
        }
        super.descriptorEntityTotallyChanged(entity);
    }

    public void commitDescriptorChanges(DescriptorDocument document) {
        if (this.myUpdateEjbSites && document instanceof EjbJar) {
            this.updateEjbSites((EjbJar)document);
            this.myUpdateEjbSites = false;
        }
        super.commitDescriptorChanges(document);
    }

    private void updateEjbSites(EjbJar ejbJar) {
        UniqueName[] oldEjbSites;
        int i;
        UniqueName ejbJarUin = EjbJarModelMetaInfo.getEjbJar(ejbJar.getFile());
        Object[] prevEjbSites = (UniqueName[])ejbJar.getUserData((Object)DELTA_KEY_EJB_SITE);
        UniqueName[] currEjbSites = null;
        EjbRelation[] relations = ejbJar.getEjbRelations();
        if (relations != null && relations.length > 0) {
            ArrayList<UniqueName> currEjbSitesList = new ArrayList<UniqueName>(relations.length);
            i = 0;
            while (i < relations.length) {
                EjbRelationshipRole role2;
                EjbRelation relation = relations[i];
                EjbRelationshipRole role1 = relation.getRole1();
                if (role1.getSourceEjb() != null && (role2 = relation.getRole2()).getSourceEjb() == null) {
                    UniqueName ejbSite = EjbJarModelMetaInfo.getEjbRelationEjbSite(ejbJar.getFile(), relation.getRole1().getSourceEjbName(), relation.getSyntheticName());
                    currEjbSitesList.add(ejbSite);
                }
                ++i;
            }
            if (!currEjbSitesList.isEmpty()) {
                currEjbSites = currEjbSitesList.toArray(new UniqueName[currEjbSitesList.size()]);
            }
        }
        ejbJar.setUserData((Object)DELTA_KEY_EJB_SITE, currEjbSites);
        this.dumpers((UniqueName[])prevEjbSites, currEjbSites);
        UniqueName[] newEjbSites = (UniqueName[])ArrayUtils.subtract(currEjbSites, (Object[])prevEjbSites);
        if (newEjbSites != null) {
            i = 0;
            while (i < newEjbSites.length) {
                EntityBean ejb;
                UniqueName ejbSite = newEjbSites[i];
                UniqueName ejbUin = null;
                EjbRelation relation = EjbJarModelAccess.getEjbRelation(this.getModel(), EjbJarModelMetaInfo.getEjbSiteEjbRelation(ejbSite));
                if (relation != null && (ejb = relation.getRole1().getSourceEjb()) != null) {
                    ejb.setUserData(AbstractDeltaProvider.DELTA_KEY, (Object)ejbSite);
                    ejbUin = EjbJarUinSupport.getUniqueName((EnterpriseBean)ejb);
                }
                this.addDeltaNode(this.getModel(), ejbJarUin, ejbSite, ejbUin, ModelDeltaNodeKind.NEW);
                if (relation != null) {
                    super.descriptorEntityChanged((DescriptorEntity)relation);
                }
                ++i;
            }
        }
        if ((oldEjbSites = (UniqueName[])ArrayUtils.subtract((Object[])prevEjbSites, currEjbSites)) != null) {
            int i2 = 0;
            while (i2 < oldEjbSites.length) {
                EntityBean ejb;
                UniqueName ejbSite = oldEjbSites[i2];
                UniqueName ejbUin = null;
                EjbRelation relation = EjbJarModelAccess.getEjbRelation(this.getModel(), EjbJarModelMetaInfo.getEjbSiteEjbRelation(ejbSite));
                if (relation != null && (ejb = relation.getRole1().getSourceEjb()) != null) {
                    ejb.setUserData(AbstractDeltaProvider.DELTA_KEY, (Object)ejbSite);
                    ejbUin = EjbJarUinSupport.getUniqueName((EnterpriseBean)ejb);
                }
                this.addDeltaNode(this.getModel(), ejbJarUin, ejbSite, ejbUin, ModelDeltaNodeKind.DELETED);
                if (relation != null) {
                    super.descriptorEntityChanged((DescriptorEntity)relation);
                }
                ++i2;
            }
        }
    }

    private void dumpers(UniqueName[] uins, UniqueName[] uins2) {
        int i;
        System.err.println("<-- ers -->");
        Thread.dumpStack();
        System.err.println("// 1");
        if (uins != null) {
            i = 0;
            while (i < uins.length) {
                System.err.println(uins[i]);
                ++i;
            }
        }
        System.err.println("// 2");
        if (uins2 != null) {
            i = 0;
            while (i < uins2.length) {
                System.err.println(uins2[i]);
                ++i;
            }
        }
        System.err.println("<-- xxx -->");
    }

    private void processEjbChanged(EnterpriseBean bean) {
        UniqueName parent = (UniqueName)bean.getUserData(AbstractDeltaProvider.DELTA_KEY);
        UniqueName prev = (UniqueName)bean.getUserData((Object)DELTA_KEY_SECURITY_ROLE);
        String roleName = bean.getSecurityIdentityRunAsRoleName();
        if (roleName == null || roleName.trim().length() == 0) {
            if (prev == null) {
                return;
            }
            bean.setUserData((Object)DELTA_KEY_SECURITY_ROLE, null);
            this.addDeltaNode(this.getModel(), parent, prev, ModelDeltaNodeKind.DELETED);
            return;
        }
        EjbJar ejbJar = (EjbJar)bean.getParent();
        UniqueName curr = EjbJarModelMetaInfo.getEjbSecurityRoleLink(ejbJar.getFile(), roleName, bean.getName());
        if (prev == null) {
            bean.setUserData((Object)DELTA_KEY_SECURITY_ROLE, (Object)curr);
            this.addDeltaNode(this.getModel(), parent, curr, ModelDeltaNodeKind.NEW);
            return;
        }
        if (prev.equals(curr)) {
            return;
        }
        bean.setUserData((Object)DELTA_KEY_SECURITY_ROLE, (Object)curr);
        DefaultModelDeltaNode node = this.addDeltaNode(this.getModel(), parent, curr, prev, ModelDeltaNodeKind.NEW);
        this.addDeltaNode(this.getModel(), node.getParentUniqueName(), prev, curr, ModelDeltaNodeKind.DELETED);
    }

    private void processMethodPermissionChanged(MethodPermission mp) {
        UniqueName[] added;
        UniqueName parent = (UniqueName)mp.getUserData(AbstractDeltaProvider.DELTA_KEY);
        AssemblyDescriptor ad = (AssemblyDescriptor)mp.getParent();
        EjbJar ejbJar = (EjbJar)ad.getParent();
        Object[] prevNames = (UniqueName[])mp.getUserData((Object)DELTA_KEY_SECURITY_ROLE);
        String[] roleNames = mp.getSecurityRoleNames();
        Object[] currNames = null;
        if (roleNames != null && roleNames.length > 0) {
            currNames = new UniqueName[roleNames.length];
            int i = 0;
            while (i < roleNames.length) {
                currNames[i] = EjbJarModelMetaInfo.getMethodPermissionSecurityRoleLink(ejbJar.getFile(), roleNames[i], mp.getSyntheticName());
                ++i;
            }
        }
        mp.setUserData((Object)DELTA_KEY_SECURITY_ROLE, currNames);
        UniqueName[] removed = (UniqueName[])ArrayUtils.subtract((Object[])prevNames, (Object[])currNames);
        if (removed != null && removed.length > 0) {
            int i = 0;
            while (i < removed.length) {
                this.addDeltaNode(this.getModel(), parent, removed[i], ModelDeltaNodeKind.DELETED);
                ++i;
            }
        }
        if ((added = (UniqueName[])ArrayUtils.subtract((Object[])currNames, (Object[])prevNames)) != null && added.length > 0) {
            int i = 0;
            while (i < added.length) {
                this.addDeltaNode(this.getModel(), parent, added[i], ModelDeltaNodeKind.NEW);
                ++i;
            }
        }
    }
}

