/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.providers.ejbjar;

import com.tssap.j2ee.core.descriptor.AbstractJ2eeDescriptorProject;
import com.tssap.j2ee.core.descriptor.DescriptorDocument;
import com.tssap.j2ee.core.descriptor.DescriptorEntity;
import com.tssap.j2ee.core.descriptor.EjbLocalRef;
import com.tssap.j2ee.core.descriptor.EjbRef;
import com.tssap.j2ee.core.descriptor.EnterpriseBean;
import com.tssap.j2ee.core.descriptor.SecurityRoleRef;
import com.tssap.j2ee.core.ejbjar.AssemblyDescriptor;
import com.tssap.j2ee.core.ejbjar.CmpField;
import com.tssap.j2ee.core.ejbjar.EjbJar;
import com.tssap.j2ee.core.ejbjar.EjbJarProject;
import com.tssap.j2ee.core.ejbjar.EjbRelation;
import com.tssap.j2ee.core.ejbjar.EjbRelationshipRole;
import com.tssap.j2ee.core.ejbjar.EntityBean;
import com.tssap.j2ee.core.ejbjar.MethodPermission;
import com.tssap.j2ee.core.ejbjar.Query;
import com.tssap.j2ee.core.providers.ejbjar.EjbJarModelMetaInfo;
import com.tssap.j2ee.core.utils.ArrayUtils;
import com.tssap.j2ee.internal.core.descriptor.AbstractDeferredDeltaProvider;
import com.tssap.j2ee.internal.core.descriptor.DescriptorChangesTracker;
import com.tssap.j2ee.internal.core.providers.ejbjar.EjbJarModelAccess;
import com.tssap.j2ee.internal.core.providers.ejbjar.EjbJarProvidersPlugin;
import com.tssap.j2ee.internal.core.providers.ejbjar.EjbJarUinSupport;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.util.delta.DefaultModelDeltaNode;
import com.tssap.selena.model.util.delta.ModelDeltaNodeKind;
import com.tssap.selena.model.util.delta.RootModelDeltaNode;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;

public final class EjbJarDeferredDeltaProvider
extends AbstractDeferredDeltaProvider {
    public static final String DELTA_KEY_SECURITY_ROLE = DescriptorChangesTracker.DELTA_KEY + "Security";
    public static final String DELTA_KEY_EJB_SITE = DescriptorChangesTracker.DELTA_KEY + "EjbSite";
    private boolean myUpdateEjbSites;

    protected UniqueName getUniqueName(DescriptorEntity entity) {
        if (entity instanceof SecurityRoleRef || entity instanceof EjbLocalRef || entity instanceof EjbRef) {
            return null;
        }
        return EjbJarUinSupport.getUniqueName(entity);
    }

    protected UniqueName getParentUin(DescriptorEntity entity) {
        if (entity instanceof EjbJar) {
            return this.getModel().getUniqueName();
        }
        if (entity instanceof EjbRelation) {
            EjbRelation relation = (EjbRelation)entity;
            EntityBean ejb = relation.getRole1().getSourceEjb();
            if (ejb == null) {
                return null;
            }
            return EjbJarUinSupport.getUniqueName((EnterpriseBean)ejb);
        }
        return super.getParentUin(entity);
    }

    protected AbstractJ2eeDescriptorProject getJ2eeProject() {
        return EjbJarProject.getInstance((IProject)this.getProject());
    }

    protected DescriptorEntity getProvidedDescriptorEntity(DescriptorEntity entity) {
        if (entity instanceof EjbRelationshipRole) {
            return entity.getParent();
        }
        if (entity instanceof AssemblyDescriptor) {
            return entity.getParent();
        }
        return entity;
    }

    protected DescriptorChangesTracker.ChangeRecord createChangeRecord(DescriptorEntity entity) {
        if (entity instanceof EnterpriseBean) {
            this.myUpdateEjbSites = true;
            EjbChangeRecord cr = new EjbChangeRecord();
            cr.mySecurityRoleOldUin = (UniqueName)entity.getUserData((Object)DELTA_KEY_SECURITY_ROLE);
            EnterpriseBean ejb = (EnterpriseBean)entity;
            String roleName = ejb.getSecurityIdentityRunAsRoleName();
            if (roleName != null) {
                EjbJar ejbJar = (EjbJar)ejb.getParent();
                cr.mySecurityRoleNewUin = EjbJarModelMetaInfo.getEjbSecurityRoleLink(ejbJar.getFile(), roleName, ejb.getName());
            }
            entity.setUserData((Object)DELTA_KEY_SECURITY_ROLE, (Object)cr.mySecurityRoleNewUin);
            return cr;
        }
        if (entity instanceof EjbRelation) {
            this.myUpdateEjbSites = true;
        } else if (entity instanceof EjbRelationshipRole) {
            this.myUpdateEjbSites = true;
        } else if (entity instanceof MethodPermission) {
            MethodPermissionChangeRecord cr = new MethodPermissionChangeRecord();
            cr.mySecurityRoleOldUins = (UniqueName[])entity.getUserData((Object)DELTA_KEY_SECURITY_ROLE);
            MethodPermission mp = (MethodPermission)entity;
            AssemblyDescriptor ad = (AssemblyDescriptor)mp.getParent();
            EjbJar ejbJar = (EjbJar)ad.getParent();
            String[] roleNames = mp.getSecurityRoleNames();
            if (roleNames != null && roleNames.length > 0) {
                cr.mySecurityRoleNewUins = new UniqueName[roleNames.length];
                int i = 0;
                while (i < roleNames.length) {
                    cr.mySecurityRoleNewUins[i] = EjbJarModelMetaInfo.getMethodPermissionSecurityRoleLink(ejbJar.getFile(), roleNames[i], mp.getSyntheticName());
                    ++i;
                }
            }
            mp.setUserData((Object)DELTA_KEY_SECURITY_ROLE, (Object)cr.mySecurityRoleNewUins);
            return cr;
        }
        return super.createChangeRecord(entity);
    }

    public void commitDescriptorChanges(DescriptorDocument document) {
        if (this.myUpdateEjbSites && document instanceof EjbJar) {
            EjbJar ejbJar = (EjbJar)document;
            this.updateEjbSites(ejbJar);
        }
        super.commitDescriptorChanges(document);
    }

    private void updateEjbSites(EjbJar ejbJar) {
        UniqueName[] oldEjbSites;
        int i;
        UniqueName ejbJarUin = EjbJarModelMetaInfo.getEjbJar(ejbJar.getFile());
        Object[] prevEjbSites = (UniqueName[])ejbJar.getUserData((Object)DELTA_KEY_EJB_SITE);
        UniqueName[] currEjbSites = null;
        EjbRelation[] relations = ejbJar.getEjbRelations();
        if (relations != null && relations.length > 0) {
            ArrayList<UniqueName> currEjbSitesList = new ArrayList<UniqueName>(relations.length);
            i = 0;
            while (i < relations.length) {
                EjbRelationshipRole role2;
                EjbRelation relation = relations[i];
                EjbRelationshipRole role1 = relation.getRole1();
                if (role1.getSourceEjb() != null && (role2 = relation.getRole2()).getSourceEjb() == null) {
                    UniqueName ejbSite = EjbJarModelMetaInfo.getEjbRelationEjbSite(ejbJar.getFile(), relation.getRole1().getSourceEjbName(), relation.getSyntheticName());
                    currEjbSitesList.add(ejbSite);
                }
                ++i;
            }
            if (!currEjbSitesList.isEmpty()) {
                currEjbSites = currEjbSitesList.toArray(new UniqueName[currEjbSitesList.size()]);
            }
        }
        ejbJar.setUserData((Object)DELTA_KEY_EJB_SITE, currEjbSites);
        UniqueName[] newEjbSites = (UniqueName[])ArrayUtils.subtract(currEjbSites, (Object[])prevEjbSites);
        if (newEjbSites != null) {
            i = 0;
            while (i < newEjbSites.length) {
                UniqueName ejbSite = newEjbSites[i];
                UniqueName ejbUin = null;
                EntityBean ejb = null;
                EjbRelation relation = EjbJarModelAccess.getEjbRelation(this.getModel(), EjbJarModelMetaInfo.getEjbSiteEjbRelation(ejbSite));
                if (relation == null) {
                    EjbJarProvidersPlugin.logWarning("Ejb relation does not exists for the new ejb site " + ejbSite);
                } else {
                    ejb = relation.getRole1().getSourceEjb();
                    if (ejb == null) {
                        EjbJarProvidersPlugin.logWarning("Source ejb does not exists for the new ejb site " + ejbSite);
                    } else {
                        ejb.setUserData(DescriptorChangesTracker.DELTA_KEY, (Object)ejbSite);
                        ejbUin = EjbJarUinSupport.getUniqueName((EnterpriseBean)ejb);
                        DescriptorChangesTracker.ChangeRecord cr = new DescriptorChangesTracker.ChangeRecord();
                        cr.myType = ModelDeltaNodeKind.NEW;
                        cr.myEntity = ejb;
                        cr.myOldUin = ejbUin;
                        cr.myNewUin = ejbSite;
                        cr.myParentUin = ejbJarUin;
                        this.queueDescriptorEntityChange(cr);
                        super.descriptorEntityChanged((DescriptorEntity)relation);
                    }
                }
                ++i;
            }
        }
        if ((oldEjbSites = (UniqueName[])ArrayUtils.subtract((Object[])prevEjbSites, currEjbSites)) != null) {
            int i2 = 0;
            while (i2 < oldEjbSites.length) {
                UniqueName ejbSite = oldEjbSites[i2];
                EjbRelation relation = EjbJarModelAccess.getEjbRelation(this.getModel(), EjbJarModelMetaInfo.getEjbSiteEjbRelation(ejbSite));
                UniqueName ejbUin = null;
                EntityBean ejb = null;
                if (relation != null && (ejb = relation.getRole1().getSourceEjb()) != null) {
                    ejb.setUserData(DescriptorChangesTracker.DELTA_KEY, (Object)ejbSite);
                    ejbUin = EjbJarUinSupport.getUniqueName((EnterpriseBean)ejb);
                }
                DescriptorChangesTracker.ChangeRecord cr = new DescriptorChangesTracker.ChangeRecord();
                cr.myType = ModelDeltaNodeKind.DELETED;
                cr.myEntity = ejb;
                cr.myOldUin = ejbUin;
                cr.myNewUin = ejbSite;
                cr.myParentUin = ejbJarUin;
                this.queueDescriptorEntityChange(cr);
                if (relation != null) {
                    super.descriptorEntityChanged((DescriptorEntity)relation);
                }
                ++i2;
            }
        }
    }

    private void dumpers(UniqueName[] uins, UniqueName[] uins2) {
        int i;
        System.err.println("<-- ers -->");
        Thread.dumpStack();
        System.err.println("// 1");
        if (uins != null) {
            i = 0;
            while (i < uins.length) {
                System.err.println(uins[i]);
                ++i;
            }
        }
        System.err.println("// 2");
        if (uins2 != null) {
            i = 0;
            while (i < uins2.length) {
                System.err.println(uins2[i]);
                ++i;
            }
        }
        System.err.println("<-- xxx -->");
    }

    protected void handleAddedDescriptorEntity(RootModelDeltaNode deltaRoot, DescriptorChangesTracker.ChangeRecord cr) {
        DescriptorEntity entity = cr.myEntity;
        if (entity instanceof CmpField) {
            super.handleChangedDescriptorEntity(deltaRoot, cr);
            return;
        }
        if (entity instanceof Query) {
            super.handleChangedDescriptorEntity(deltaRoot, cr);
            return;
        }
        if (entity instanceof AssemblyDescriptor) {
            return;
        }
        super.handleAddedDescriptorEntity(deltaRoot, cr);
    }

    protected void handleRemovedDescriptorEntity(RootModelDeltaNode deltaRoot, DescriptorChangesTracker.ChangeRecord cr) {
        DescriptorEntity entity = cr.myEntity;
        if (entity instanceof CmpField) {
            super.handleChangedDescriptorEntity(deltaRoot, cr);
            return;
        }
        if (entity instanceof Query) {
            super.handleChangedDescriptorEntity(deltaRoot, cr);
            return;
        }
        if (entity instanceof AssemblyDescriptor) {
            return;
        }
        super.handleRemovedDescriptorEntity(deltaRoot, cr);
    }

    protected void handleChangedDescriptorEntity(RootModelDeltaNode deltaRoot, DescriptorChangesTracker.ChangeRecord cr) {
        DescriptorEntity entity = cr.myEntity;
        if (entity instanceof EnterpriseBean) {
            if (cr instanceof EjbChangeRecord) {
                EjbChangeRecord xcr = (EjbChangeRecord)cr;
                this.handleChangedEjb(deltaRoot, xcr);
            } else {
                DescriptorChangesTracker.invalidChangeRecord((DescriptorChangesTracker.ChangeRecord)cr);
            }
        } else if (entity instanceof MethodPermission) {
            if (cr instanceof MethodPermissionChangeRecord) {
                MethodPermissionChangeRecord xcr = (MethodPermissionChangeRecord)cr;
                this.handleChangedMethodPermission(deltaRoot, xcr);
            } else {
                DescriptorChangesTracker.invalidChangeRecord((DescriptorChangesTracker.ChangeRecord)cr);
            }
        } else if (entity instanceof AssemblyDescriptor) {
            return;
        }
        super.handleChangedDescriptorEntity(deltaRoot, cr);
    }

    protected void handleTotallyChangedDescriptorEntity(RootModelDeltaNode deltaRoot, DescriptorChangesTracker.ChangeRecord cr) {
        DescriptorEntity entity = cr.myEntity;
        if (entity instanceof EnterpriseBean) {
            if (cr instanceof EjbChangeRecord) {
                EjbChangeRecord xcr = (EjbChangeRecord)cr;
                this.handleChangedEjb(deltaRoot, xcr);
            } else {
                DescriptorChangesTracker.invalidChangeRecord((DescriptorChangesTracker.ChangeRecord)cr);
            }
        } else if (entity instanceof AssemblyDescriptor) {
            return;
        }
        super.handleTotallyChangedDescriptorEntity(deltaRoot, cr);
    }

    private void handleChangedEjb(RootModelDeltaNode deltaRoot, EjbChangeRecord cr) {
        UniqueName parent = cr.myOldUin;
        UniqueName prev = cr.mySecurityRoleOldUin;
        UniqueName curr = cr.mySecurityRoleNewUin;
        if (curr == null) {
            if (prev == null) {
                return;
            }
            this.addDeltaNode(deltaRoot, this.getModel(), parent, prev, ModelDeltaNodeKind.DELETED);
            return;
        }
        if (prev == null) {
            this.addDeltaNode(deltaRoot, this.getModel(), parent, curr, ModelDeltaNodeKind.NEW);
            return;
        }
        if (prev.equals(curr)) {
            return;
        }
        DefaultModelDeltaNode node = this.addDeltaNode(deltaRoot, this.getModel(), parent, curr, prev, ModelDeltaNodeKind.NEW);
        this.addDeltaNode(deltaRoot, this.getModel(), node.getParentUniqueName(), prev, curr, ModelDeltaNodeKind.DELETED);
    }

    private void handleChangedMethodPermission(RootModelDeltaNode deltaRoot, MethodPermissionChangeRecord cr) {
        UniqueName[] added;
        UniqueName parent = cr.myOldUin;
        Object[] prevNames = cr.mySecurityRoleOldUins;
        Object[] currNames = cr.mySecurityRoleNewUins;
        UniqueName[] removed = (UniqueName[])ArrayUtils.subtract((Object[])prevNames, (Object[])currNames);
        if (removed != null && removed.length > 0) {
            int i = 0;
            while (i < removed.length) {
                this.addDeltaNode(deltaRoot, this.getModel(), parent, removed[i], ModelDeltaNodeKind.DELETED);
                ++i;
            }
        }
        if ((added = (UniqueName[])ArrayUtils.subtract((Object[])currNames, (Object[])prevNames)) != null && added.length > 0) {
            int i = 0;
            while (i < added.length) {
                this.addDeltaNode(deltaRoot, this.getModel(), parent, added[i], ModelDeltaNodeKind.NEW);
                ++i;
            }
        }
    }

    private static class MethodPermissionChangeRecord
    extends DescriptorChangesTracker.ChangeRecord {
        public UniqueName[] mySecurityRoleOldUins;
        public UniqueName[] mySecurityRoleNewUins;

        private MethodPermissionChangeRecord() {
        }

        public String toString() {
            StringBuffer s = new StringBuffer(super.toString());
            s.append(" ");
            s.append(DescriptorChangesTracker.toString((UniqueName[])this.mySecurityRoleOldUins));
            s.append(" -> ");
            s.append(DescriptorChangesTracker.toString((UniqueName[])this.mySecurityRoleNewUins));
            return s.toString();
        }
    }

    private static class EjbChangeRecord
    extends DescriptorChangesTracker.ChangeRecord {
        public UniqueName mySecurityRoleOldUin;
        public UniqueName mySecurityRoleNewUin;

        private EjbChangeRecord() {
        }

        public String toString() {
            StringBuffer s = new StringBuffer(super.toString());
            s.append(" ");
            s.append(this.mySecurityRoleOldUin);
            s.append(" -> ");
            s.append(this.mySecurityRoleNewUin);
            return s.toString();
        }
    }
}

