/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.providers.ejbjar;

import com.tssap.j2ee.core.providers.ejbjar.EjbJarModelMetaInfo;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.enum.EntityEnumeration;
import com.tssap.selena.model.enum.PropertyEnumeration;
import com.tssap.selena.model.extension.PropertyGetProvider;
import com.tssap.selena.model.util.EnumerationConverter;
import com.tssap.selena.model.util.PropertyAdapter;
import com.tssap.selena.model.util.extension.AbstractProvider;
import java.util.ArrayList;
import java.util.List;

public final class EjbInboundLinksProvider
extends AbstractProvider
implements PropertyGetProvider {
    public boolean isPropertyProviderApplicable(Element element, String propertyName) {
        if (!EjbJarModelMetaInfo.isEjb(element.getUniqueName())) {
            return false;
        }
        return "$inboundLinks".equals(propertyName);
    }

    public PropertyEnumeration properties(Element element) {
        ArrayList uins = new ArrayList();
        Entity ejbJar = element.getParent();
        if (ejbJar == null) {
            return null;
        }
        String ejbName = element.getPropertyValue("$name");
        if (ejbName == null) {
            return null;
        }
        this.addMethods(uins, ejbJar, element, ejbName);
        this.addRefs(uins, ejbJar, element, ejbName);
        return EnumerationConverter.toPropertyEnumeration(uins.iterator());
    }

    private boolean isMethodContainer(Entity entity) {
        if (EjbJarModelMetaInfo.isExcludeList(entity.getUniqueName())) {
            return true;
        }
        if (EjbJarModelMetaInfo.isMethodPermission(entity.getUniqueName())) {
            return true;
        }
        return EjbJarModelMetaInfo.isContainerTransaction(entity.getUniqueName());
    }

    private void addMethods(List uins, Entity ejbJar, Element ejb, String ejbName) {
        EntityEnumeration children = ejbJar.childEntities();
        while (children.hasMoreElements()) {
            Entity child = children.next();
            if (!this.isMethodContainer(child)) continue;
            EntityEnumeration methods = child.childEntities();
            while (methods.hasMoreElements()) {
                Entity method = methods.next();
                if (!EjbJarModelMetaInfo.isMethod(method.getUniqueName()) || !ejbName.equals(method.getPropertyValue("ejbName"))) continue;
                uins.add(new PropertyAdapter("$inboundLinks", method.getUniqueName().toString(), ejb));
            }
        }
    }

    private void addRefs(List uins, Entity ejbJar, Element ejb, String ejbName) {
        EntityEnumeration children = ejbJar.childEntities();
        while (children.hasMoreElements()) {
            Entity child = children.next();
            if (!EjbJarModelMetaInfo.isEjb(child.getUniqueName())) continue;
            EntityEnumeration refs = child.childEntities();
            while (refs.hasMoreElements()) {
                Entity ref = refs.next();
                if (!EjbJarModelMetaInfo.isEjbLocalRef(ref.getUniqueName()) && !EjbJarModelMetaInfo.isEjbRef(ref.getUniqueName())) continue;
                String linkPath = ref.getPropertyValue("ejbLinkPath");
                String linkTarget = ref.getPropertyValue("ejbLinkTarget");
                if (linkPath != null || !ejbName.equals(linkTarget)) continue;
                uins.add(new PropertyAdapter("$inboundLinks", ref.getUniqueName().toString(), ejb));
            }
        }
    }

    public PropertyEnumeration properties(Element element, String propertyName) {
        return this.properties(element);
    }

    public Property getProperty(Element element, String propertyName) {
        return null;
    }

    public String getPropertyValue(Element element, String propertyName) {
        return null;
    }

    public boolean hasProperty(Element element, String propertyName) {
        return false;
    }

    public boolean hasPropertyValue(Element element, String propertyName, String propertyValue) {
        return false;
    }
}

