/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.log_configurator.archive;

import com.sap.engine.services.log_configurator.archive.ArchivingTask;
import com.sap.engine.services.log_configurator.archive.TaskNumFilter;
import com.sap.tc.logging.FileLog;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.OverwriteLogfileEvent;
import java.io.File;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

public class Buffer {
    private static final Location location = Location.getLocation((Class)(class$com$sap$engine$services$log_configurator$archive$Buffer == null ? (class$com$sap$engine$services$log_configurator$archive$Buffer = Buffer.class$("com.sap.engine.services.log_configurator.archive.Buffer")) : class$com$sap$engine$services$log_configurator$archive$Buffer));
    private Hashtable tasksTable = new Hashtable();
    public static final String RENAMED_FILES_PREFIX = "_&&&_.";
    private long maxTaskNumber = -1L;
    private String tmpDir;
    static /* synthetic */ Class class$com$sap$engine$services$log_configurator$archive$Buffer;

    public Buffer(String tmpDir) {
        this.tmpDir = tmpDir;
    }

    public synchronized ArchivingTask getTask() {
        ArchivingTask task = null;
        while (this.tasksTable.size() <= 0) {
            try {
                this.wait();
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
        Enumeration keys = this.tasksTable.keys();
        while (keys.hasMoreElements()) {
            String pattern = keys.nextElement().toString();
            Vector tasks = (Vector)this.tasksTable.get(pattern);
            if (tasks == null || tasks.size() <= 0) continue;
            task = (ArchivingTask)tasks.get(0);
        }
        this.notifyAll();
        return task;
    }

    public synchronized void addTask(OverwriteLogfileEvent evt) {
        File newFile;
        FileLog fileLog = evt.getFileLog();
        int cnt = fileLog.getCnt();
        String pattern = fileLog.getPattern();
        List allFileNames = fileLog.calculateFileNames();
        Vector<ArchivingTask> tasks = (Vector<ArchivingTask>)this.tasksTable.get(pattern);
        if (tasks == null) {
            tasks = new Vector<ArchivingTask>();
        }
        String encodedPattern = URLEncoder.encode(pattern);
        ++this.maxTaskNumber;
        String newFileName = RENAMED_FILES_PREFIX + this.maxTaskNumber + ".0." + cnt + "." + encodedPattern;
        String fileName = fileLog.getPath();
        File oldFile = new File(fileName);
        boolean res = oldFile.renameTo(newFile = new File(this.tmpDir + newFileName));
        if (!res) {
            // empty if block
        }
        allFileNames.set(0, newFileName);
        ArchivingTask task = new ArchivingTask(new Vector(allFileNames), pattern, this.maxTaskNumber);
        tasks.add(task);
        this.tasksTable.put(pattern, tasks);
        this.notifyAll();
    }

    public synchronized void renameFile(OverwriteLogfileEvent evt) {
        FileLog fileLog = evt.getFileLog();
        String pattern = evt.getFileLog().getPattern();
        String fileName = fileLog.getPath();
        Vector tasks = (Vector)this.tasksTable.get(pattern);
        if (tasks == null) {
            return;
        }
        ArchivingTask lastTask = (ArchivingTask)tasks.elementAt(tasks.size() - 1);
        int fileIndex = fileLog.getIndex();
        ArchivingTask archivingTask = lastTask;
        synchronized (archivingTask) {
            if (lastTask.getCurrentlyArchivedItem() < fileIndex) {
                Vector targetFiles;
                String newFileName = RENAMED_FILES_PREFIX + lastTask.getNumber() + "." + fileIndex + "." + fileLog.getCnt() + "." + URLEncoder.encode(pattern);
                File oldFile = new File(fileName);
                File newFileP = new File(this.tmpDir + newFileName);
                boolean res = oldFile.renameTo(newFileP);
                if (!res) {
                    // empty if block
                }
                if ((targetFiles = lastTask.getTargetFiles()) != null && targetFiles.size() != 0 && targetFiles.indexOf(fileName) != -1) {
                    targetFiles.set(targetFiles.indexOf(fileName), newFileName);
                }
            } else if (lastTask.getCurrentlyArchivedItem() == fileIndex) {
                while (lastTask.getCurrentlyArchivedItem() == fileIndex) {
                    try {
                        lastTask.wait();
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                }
            }
        }
        this.notifyAll();
    }

    public synchronized void removeTask(ArchivingTask task) {
        String pattern = task.getPattern();
        long number = task.getNumber();
        Vector tasks = (Vector)this.tasksTable.get(pattern);
        if (tasks != null && tasks.size() > 0) {
            tasks.remove(0);
            File file = new File(this.tmpDir);
            File[] files = file.listFiles(new TaskNumFilter(RENAMED_FILES_PREFIX, pattern, number));
            int i = 0;
            while (i < files.length) {
                boolean res = files[i].delete();
                if (!res) {
                    // empty if block
                }
                ++i;
            }
        }
        if (this.tasksTable.get(pattern) == null || ((Vector)this.tasksTable.get(pattern)).size() == 0) {
            this.tasksTable.remove(pattern);
        }
        this.notifyAll();
    }

    public String getTmpDir() {
        return this.tmpDir;
    }

    public void rebuildTasksTable() {
        try {
            Hashtable<String, ArchivingTask> tmpTable = new Hashtable<String, ArchivingTask>();
            File file = new File(this.tmpDir);
            String[] renamedFiles = file.list();
            long max = -1L;
            int i = 0;
            while (i < renamedFiles.length) {
                ArchivingTask task;
                StringTokenizer tok = new StringTokenizer(renamedFiles[i], ".");
                String[] toks = new String[tok.countTokens()];
                int j = 0;
                while (j < toks.length) {
                    toks[j] = tok.nextToken();
                    ++j;
                }
                String taskNum = toks[1];
                String fileNum = toks[2];
                String cnt = toks[3];
                int pos = toks[0].length() + taskNum.length() + fileNum.length() + cnt.length() + 5;
                String encodedPattern = renamedFiles[i].substring(pos);
                String decodedPattern = URLDecoder.decode(encodedPattern);
                long num = Long.parseLong(taskNum);
                if (num > max) {
                    max = num;
                }
                if ((task = (ArchivingTask)tmpTable.get(taskNum)) == null) {
                    Collection allFileNames = FileLog.calculateFileNames((String)decodedPattern, (int)Integer.parseInt(cnt));
                    Vector<String> targetFiles = new Vector<String>(allFileNames);
                    targetFiles.setElementAt(renamedFiles[i], Integer.parseInt(fileNum));
                    ArchivingTask newTask = new ArchivingTask(targetFiles, decodedPattern, Long.parseLong(taskNum));
                    tmpTable.put(taskNum, newTask);
                } else {
                    task.addTargetFile(renamedFiles[i], Integer.parseInt(fileNum));
                }
                ++i;
            }
            Vector values = new Vector(tmpTable.values());
            int i2 = 0;
            while (i2 < values.size()) {
                ArchivingTask task = (ArchivingTask)values.get(i2);
                String pattern = task.getPattern();
                Vector<ArchivingTask> tasks = (Vector<ArchivingTask>)this.tasksTable.get(pattern);
                if (tasks == null) {
                    tasks = new Vector<ArchivingTask>();
                }
                tasks.add(task);
                this.tasksTable.put(pattern, tasks);
                ++i2;
            }
            this.maxTaskNumber = max;
        }
        catch (Exception e) {
            e.printStackTrace();
            location.logT(500, " Can't rebuild tasks table because of an exception: " + e.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

