/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.log_configurator.archive;

import com.sap.engine.frame.ServiceContext;
import com.sap.engine.frame.core.thread.ThreadSystem;
import com.sap.engine.services.log_configurator.archive.ArchivesFilter;
import com.sap.engine.services.log_configurator.archive.ArchivingThread;
import com.sap.engine.services.log_configurator.archive.Buffer;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.OverwriteLogfileEvent;
import com.sap.tc.logging.OverwriteLogfileListener;
import java.io.File;
import java.net.URLEncoder;

public class Archivator
implements OverwriteLogfileListener {
    private static final Location location = Location.getLocation((Class)(class$com$sap$engine$services$log_configurator$archive$Archivator == null ? (class$com$sap$engine$services$log_configurator$archive$Archivator = Archivator.class$("com.sap.engine.services.log_configurator.archive.Archivator")) : class$com$sap$engine$services$log_configurator$archive$Archivator));
    private static final String PROPERTY_NAME_ENABLED = "ArchiveOldLogFiles";
    private static final String PROPERTY_DIR_NAME = "ArchivesDirectory";
    public static final String RENAMED_FILES_PREFIX = "_&&&_.";
    private ServiceContext sc;
    private String dirName;
    private String tmpDir;
    private boolean isEnabled;
    private Buffer buffer;
    private static ArchivingThread archivingThread;
    private static String fileSeparator;
    static /* synthetic */ Class class$com$sap$engine$services$log_configurator$archive$Archivator;

    public Archivator(ServiceContext sc) {
        String enabledStr;
        this.sc = sc;
        this.dirName = sc.getServiceState().getProperty(PROPERTY_DIR_NAME, "./log/archive");
        new File(this.dirName).mkdirs();
        if (!this.dirName.endsWith("/") && !this.dirName.endsWith("\\")) {
            this.dirName = this.dirName + fileSeparator;
        }
        this.tmpDir = this.dirName + fileSeparator + "tmp";
        File tmpDirectory = new File(this.tmpDir);
        tmpDirectory.mkdirs();
        if (!this.tmpDir.endsWith("/") && !this.tmpDir.endsWith("\\")) {
            this.tmpDir = this.tmpDir + fileSeparator;
        }
        this.isEnabled = (enabledStr = sc.getServiceState().getProperty(PROPERTY_NAME_ENABLED, "ON")).equalsIgnoreCase("ON") || enabledStr.equalsIgnoreCase("YES") || enabledStr.equalsIgnoreCase("TRUE");
        this.buffer = new Buffer(this.tmpDir);
        this.buffer.rebuildTasksTable();
        if (archivingThread == null) {
            archivingThread = new ArchivingThread(this.buffer, this.dirName);
            ThreadSystem threadSystem = sc.getCoreContext().getThreadSystem();
            threadSystem.startThread((Runnable)archivingThread, true);
        }
    }

    public void handleEvent(OverwriteLogfileEvent evt) {
        if (!this.isEnabled) {
            return;
        }
        try {
            int fileNum = evt.getFileLog().getIndex();
            if (fileNum == 0) {
                this.buffer.addTask(evt);
            } else {
                this.buffer.renameFile(evt);
            }
        }
        catch (Exception e) {
            location.logT(500, " Archivator can't handle an overwrite event!");
        }
    }

    public String[] getArchiveFileNames(String pattern) {
        return Archivator.getArchiveFileNames(this.dirName, pattern);
    }

    public long getArchivesSize() {
        long size = 0L;
        File[] files = new File(this.dirName).listFiles();
        int i = files.length;
        while (--i >= 0) {
            File currFile = files[i];
            if (!currFile.getName().endsWith(".zip")) continue;
            size += currFile.length();
        }
        return size / 1024L;
    }

    public String getArchiveLogDirectory() {
        return new File(this.dirName).getAbsolutePath();
    }

    public static String[] getArchiveFileNames(String archiveLogDirectory, String pattern) {
        String plainPattern = URLEncoder.encode(pattern);
        String[] allArchives = new File(archiveLogDirectory).list(new ArchivesFilter(plainPattern));
        if (allArchives != null) {
            int i = 0;
            while (i < allArchives.length) {
                allArchives[i] = archiveLogDirectory + fileSeparator + allArchives[i];
                ++i;
            }
        }
        return allArchives;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        fileSeparator = System.getProperty("file.separator");
    }
}

