/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.log_configurator.admin.shell;

import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.lib.logging.descriptors.LogConfiguration;
import com.sap.engine.lib.logging.descriptors.LogControllerDescriptor;
import com.sap.engine.lib.logging.descriptors.LogDestinationDescriptor;
import com.sap.engine.lib.logging.descriptors.LogFormatterDescriptor;
import com.sap.engine.services.log_configurator.admin.LogConfigurator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;

public final class LogEditCommand
implements Command {
    public static final String COMMAND_NAME = "LOG_EDIT";
    public static final String COMMAND_GROUP = "LOG";
    public static final String HELP_MESSAGE = "\nReconfigures previously registered objects in the logging service.\n\nUsage: LOG_EDIT [-? | -H]  [-C | -D | -F OID]\n\n  -? | -H          Displays this Help Message.\n  -C | -D | -F     Specifies the type of the object that is going\n                   to be edited as log(C)ontroler, log (D)estination\n                   or (F)ormatter respectively.\n  OID              ID of the object that is going to be edited.\n\nThe OID identifier must represent a valid Name for the logging service.\nOne can use the LOG_LIST command to retrieve the current logging settings\nor the LOG_CREATE command to add a new object to the existing configuration.\nNote that only \"named\" objects can be edited (name is case sensitive) and\nthat this operation will affect all the users of the corresponding object.\n";
    private static final byte EDIT_CFG_POS = 0;
    private static final byte REMOVE_CFG_POS = 1;
    private LogConfigurator logConfigurator = null;

    public LogEditCommand(LogConfigurator logConfigurator) {
        this.logConfigurator = logConfigurator;
    }

    public String getName() {
        return COMMAND_NAME;
    }

    public String getGroup() {
        return COMMAND_GROUP;
    }

    public String getHelpMessage() {
        return HELP_MESSAGE;
    }

    public String[] getSupportedShellProviderNames() {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        PrintStream out = new PrintStream(os, true);
        PrintStream err = new PrintStream(env.getErrorStream(), true);
        try {
            switch (params.length) {
                case 1: {
                    String argument = params[0].toUpperCase();
                    if (argument.equals("-?") || argument.equals("-H")) {
                        out.println(HELP_MESSAGE);
                        return;
                    }
                    if (!(argument.equals("-C") || argument.equals("-D") || argument.equals("-F"))) {
                        err.println();
                        err.println("LOG_EDIT command is used with incorrect argument: " + params[0] + " !!!");
                        err.println("Use: LOG_EDIT -? for Help.");
                        err.println();
                        return;
                    }
                    err.println();
                    err.println("Required argument is missing !!!");
                    err.println("Use: LOG_EDIT -? for Help.");
                    err.println();
                    return;
                }
                case 2: {
                    String argument = params[0].toUpperCase();
                    LogConfiguration[] cfg = new LogConfiguration[]{new LogConfiguration(), new LogConfiguration()};
                    BufferedReader in = new BufferedReader(new InputStreamReader(is));
                    if (argument.equals("-C")) {
                        LogControllerDescriptor controller = this.logConfigurator.getLogControllerDescriptor(params[1]);
                        if (controller == null) {
                            err.println();
                            err.println("A log controller with name \"" + params[1] + "\" does NOT exist !!!");
                            err.println("Use LOG_CREATE command to create such object,");
                            err.println("or type \"LOG_EDIT -?\" for help on this command.");
                            err.println();
                            return;
                        }
                        this.editLogController(in, out, controller, cfg);
                    } else if (argument.equals("-D")) {
                        LogDestinationDescriptor destination = this.logConfigurator.getLogDescriptor(params[1]);
                        if (destination == null) {
                            err.println();
                            err.println("A log destination with name \"" + params[1] + "\" does NOT exist !!!");
                            err.println("Use LOG_CREATE command to create such object,");
                            err.println("or type \"LOG_EDIT -?\" for help on this command.");
                            err.println();
                            return;
                        }
                        this.editLogDestination(in, out, destination, cfg);
                    } else {
                        if (!argument.equals("-F")) {
                            err.println();
                            err.println("LOG_EDIT command is used with incorrect argument: " + params[0] + " !!!");
                            err.println("Use: LOG_EDIT -? for Help.");
                            err.println();
                            return;
                        }
                        LogFormatterDescriptor formatter = this.logConfigurator.getFormatterDescriptor(params[1]);
                        if (formatter == null) {
                            err.println();
                            err.println("A log formatter with name \"" + params[1] + "\" does NOT exist !!!");
                            err.println("Use LOG_CREATE command to create such object,");
                            err.println("or type \"LOG_EDIT -?\" for help on this command.");
                            err.println();
                            return;
                        }
                        LogEditCommand.editLogFormatter(in, out, formatter, cfg[0]);
                    }
                    out.println();
                    out.println("Store this configuration for future use ? (Y/N)");
                    out.println();
                    if (in.readLine().trim().equalsIgnoreCase("n")) {
                        this.logConfigurator.applyConfiguration(cfg[0], cfg[1]);
                    } else {
                        this.logConfigurator.applyAndStoreConfiguration(cfg[0], cfg[1]);
                    }
                    out.println();
                    out.println("The operation completed successfully.");
                    out.println();
                    return;
                }
            }
            err.println();
            err.println("LOG_EDIT command is used with incorrect number of arguments !!!");
            err.println("Use: LOG_EDIT -? for Help.");
            err.println();
            return;
        }
        catch (Exception exc) {
            err.println();
            err.println("  The following Exception has occurred: " + exc.toString());
            err.println();
        }
    }

    private static void editLogFormatter(BufferedReader in, PrintStream out, LogFormatterDescriptor formatter, LogConfiguration cfg) throws IOException {
        if ("TraceFormatter".equals(formatter.getType())) {
            out.println();
            out.println("Please type a new pattern for the formatter,");
            out.println("or simply press Enter to reset it to the defaults.");
            out.println();
            String attrib = in.readLine().trim();
            if (attrib.equals("")) {
                attrib = null;
            }
            formatter.setPattern(attrib);
            cfg.addLogFormatter(formatter);
        } else {
            out.println();
            out.println("Nothing could be configured for this log formatter.");
            out.println();
        }
    }

    private void editLogDestination(BufferedReader in, PrintStream out, LogDestinationDescriptor destination, LogConfiguration[] cfg) throws IOException {
        String attrib = null;
        out.println();
        out.println("Please type a new effective severity value for the destination,");
        out.println("or simply press Enter to use the defaults. The severity should");
        out.println("be any of the following strings:");
        out.println("  ALL, DEBUG, PATH, INFO, WARNING, ERROR, FATAL, MIN, MAX, GROUP, NONE");
        out.println();
        attrib = in.readLine().trim();
        if (attrib.equals("")) {
            attrib = "ALL";
        }
        destination.setEffectiveSeverity(attrib);
        cfg[0].addLogDestination(destination);
    }

    private void editLogController(BufferedReader in, PrintStream out, LogControllerDescriptor controller, LogConfiguration[] cfg) throws IOException {
        String attrib = null;
        out.println();
        out.println("Please type a new effective severity value for this controller,");
        out.println("or simply press Enter to use the defaults. The severity should");
        out.println("be any of the following strings:");
        out.println("  ALL, DEBUG, PATH, INFO, WARNING, ERROR, FATAL, MIN, MAX, GROUP, NONE");
        out.println();
        attrib = in.readLine().trim();
        if (attrib.equals("")) {
            attrib = "NONE";
        }
        controller.setEffectiveSeverity(attrib);
        cfg[0].addLogController(controller);
    }
}

