/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.log_configurator.admin.shell;

import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.lib.logging.StandardConsoleLog;
import com.sap.engine.services.log_configurator.admin.LogConfigurator;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Log;
import com.sap.tc.logging.LogController;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;

public final class LogDumpsCommand
implements Command {
    public static final String COMMAND_NAME = "LOG_DUMPS";
    public static final String COMMAND_GROUP = "LOG";
    public static final String HELP_MESSAGE = "\nEnables or disables additional console output for a specified log controller.\n\nUsage: LOG_DUMPS [-? | -H]  [OID]  [ON | OFF]\n\n  -? | -H         Displays this Help Message.\n  OID             ID of the log controller that is going to be debugged.\n  ON | OFF        Turns the additional console output ON or OFF.\n\nThe OID identifier must represent a valid Name for the logging service.\nOne can use the LOG_LIST command to obtain information about the existing\ncontrollers. Note that if this log controller already has an associated\nlog destination of type ConsoleLog some messages may be displayed twice.\nAlso keep in mind the hierarchy of the log controllers. If neither \"ON\"\nnor \"OFF\" is specified then the current status is shown. If no OID is\ngiven then a \"global\" configuration is assumed.\n";
    private static final String GLOBAL_NAME = "GLOBAL";
    private static final String DEBUG_SUFFIX = "_CONSOLE_DUMPS";
    private LogConfigurator logConfigurator = null;

    public LogDumpsCommand(LogConfigurator logConfigurator) {
        this.logConfigurator = logConfigurator;
    }

    public String getName() {
        return COMMAND_NAME;
    }

    public String getGroup() {
        return COMMAND_GROUP;
    }

    public String getHelpMessage() {
        return HELP_MESSAGE;
    }

    public String[] getSupportedShellProviderNames() {
        return null;
    }

    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        PrintStream out = new PrintStream(os, true);
        PrintStream err = new PrintStream(env.getErrorStream(), true);
        switch (params.length) {
            case 0: {
                out.println("\nThe \"global\" additional console output is currently " + LogDumpsCommand.dumpsStatus(null) + ".\n");
                return;
            }
            case 1: {
                String argument = params[0].toUpperCase();
                if (argument.equals("-?") || argument.equals("-H")) {
                    out.println(HELP_MESSAGE);
                } else if (argument.equals("ON")) {
                    LogDumpsCommand.enableDumps(null);
                    out.println("\nThe \"global\" additional console output has been enabled.\n");
                } else if (argument.equals("OFF")) {
                    LogDumpsCommand.disableDumps(null);
                    out.println("\nThe \"global\" additional console output has been disabled.\n");
                } else {
                    LogController controller = this.logConfigurator.getLogController(params[0]);
                    if (controller != null) {
                        out.println("\nThe additional console output for the log controller with name");
                        out.println("\"" + params[0] + "\" is currently " + LogDumpsCommand.dumpsStatus(controller) + ".\n");
                    } else {
                        err.println();
                        err.println("A log controller with name \"" + params[0] + "\" does NOT exist !!!");
                        err.println("Use: LOG_DUMPS -? for Help.");
                        err.println();
                    }
                }
                return;
            }
            case 2: {
                LogController controller = this.logConfigurator.getLogController(params[0]);
                if (controller != null) {
                    if (params[1].equalsIgnoreCase("ON")) {
                        LogDumpsCommand.enableDumps(controller);
                        out.println("\nThe additional console output for the log controller with name");
                        out.println("\"" + params[0] + "\" has been enabled.\n");
                    } else if (params[1].equalsIgnoreCase("OFF")) {
                        LogDumpsCommand.disableDumps(controller);
                        out.println("\nThe additional console output for the log controller with name");
                        out.println("\"" + params[0] + "\" has been disabled.\n");
                    } else {
                        err.println();
                        err.println("LOG_DUMPS command is used with incorrect argument: " + params[1] + " !!!");
                        err.println("Use: LOG_DUMPS -? for Help.");
                        err.println();
                    }
                } else {
                    err.println();
                    err.println("A log controller with name \"" + params[0] + "\" does NOT exist !!!");
                    err.println("Use: LOG_DUMPS -? for Help.");
                    err.println();
                }
                return;
            }
        }
        err.println();
        err.println("LOG_DUMPS command is used with incorrect number of arguments !!!");
        err.println("Use: LOG_DUMPS -? for Help.");
        err.println();
    }

    private static final void enableDumps(LogController controller) {
        String consoleName = null;
        if (controller == null) {
            controller = Location.getRoot();
            consoleName = "GLOBAL_CONSOLE_DUMPS";
        } else {
            consoleName = controller.getName() + DEBUG_SUFFIX;
        }
        Log[] dests = controller.getLogs().toArray(new Log[0]);
        int i = dests.length;
        while (--i >= 0) {
            if (!(dests[i] instanceof StandardConsoleLog) || !consoleName.equals(dests[i].getLogName())) continue;
            return;
        }
        StandardConsoleLog consoleDumps = new StandardConsoleLog();
        consoleDumps.setLogName(consoleName);
        controller.addLog((Log)consoleDumps);
    }

    private static final void disableDumps(LogController controller) {
        String consoleName = null;
        if (controller == null) {
            controller = Location.getRoot();
            consoleName = "GLOBAL_CONSOLE_DUMPS";
        } else {
            consoleName = controller.getName() + DEBUG_SUFFIX;
        }
        Log[] dests = controller.getLogs().toArray(new Log[0]);
        int i = dests.length;
        while (--i >= 0) {
            if (!(dests[i] instanceof StandardConsoleLog) || !consoleName.equals(dests[i].getLogName())) continue;
            controller.removeLog(dests[i]);
            return;
        }
    }

    private static final String dumpsStatus(LogController controller) {
        String consoleName = null;
        if (controller == null) {
            controller = Location.getRoot();
            consoleName = "GLOBAL_CONSOLE_DUMPS";
        } else {
            consoleName = controller.getName() + DEBUG_SUFFIX;
        }
        Log[] dests = controller.getLogs().toArray(new Log[0]);
        int i = dests.length;
        while (--i >= 0) {
            if (!(dests[i] instanceof StandardConsoleLog) || !consoleName.equals(dests[i].getLogName())) continue;
            return "ON";
        }
        return "OFF";
    }
}

