/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.log_configurator.admin.shell;

import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.log_configurator.admin.Archivator;
import com.sap.engine.services.log_configurator.admin.LogConfigurator;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;

public class ArchiveCommand
implements Command {
    private LogConfigurator logConfigurator;

    public ArchiveCommand(LogConfigurator logConfigurator) {
        this.logConfigurator = logConfigurator;
    }

    public void exec(Environment environment, InputStream input, OutputStream output, String[] params) {
        String archiveDir = "./log/archive/";
        if (params != null && params.length > 0 && !(archiveDir = params[0].replace('\\', '/')).endsWith("/")) {
            archiveDir = archiveDir + '/';
        }
        PrintStream out = new PrintStream(output, true);
        out.println();
        new Archivator(this.logConfigurator).archive(this.logConfigurator.getCurrentConfiguration().getLogDestinations(), true, archiveDir, true, out, new PrintStream(environment.getErrorStream(), true));
        out.println();
    }

    public String getGroup() {
        return "LOG";
    }

    public String getHelpMessage() {
        return "Usage: ARCHIVE [path] - create archive for all log files\r\n       [path] - the path to new archive. Default path is './log/archive/'";
    }

    public String getName() {
        return "LOG_ARCHIVE";
    }

    public String[] getSupportedShellProviderNames() {
        return new String[]{"InQMyShell"};
    }
}

