/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.log_configurator.admin.gui;

import com.sap.engine.lib.logging.descriptors.LogConfiguration;
import com.sap.engine.lib.logging.descriptors.LogControllerDescriptor;
import com.sap.engine.lib.util.ArrayObject;
import com.sap.tc.logging.Severity;
import javax.swing.table.AbstractTableModel;

public class RelativeControllersModel
extends AbstractTableModel {
    protected static final byte NAME_COLUMN = 0;
    protected static final byte MIN_COLUMN = 1;
    protected static final byte MAX_COLUMN = 2;
    protected static final byte EFF_COLUMN = 3;
    protected ArrayObject tableValues = new ArrayObject();
    protected Object[] cashValues = this.tableValues.toArray();
    protected LogConfiguration config;
    protected String controllerName;

    public void setLogConfiguration(LogConfiguration config, String name) {
        this.config = config;
        this.controllerName = name;
    }

    public int getColumnCount() {
        return 4;
    }

    public int getRowCount() {
        return this.cashValues.length;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex >= 0 && columnIndex < 3) {
            return ((Object[])this.cashValues[rowIndex])[columnIndex];
        }
        if (columnIndex == 3) {
            return this.getEffValue(rowIndex);
        }
        return null;
    }

    private String getEffValue(int rowIndex) {
        String min;
        int parentSeverity = this.config.calculateRelativeSeverity(LogControllerDescriptor.getParentName((String)this.controllerName), (String)((Object[])this.cashValues[rowIndex])[0]);
        if (parentSeverity < Severity.parse((String)(min = (String)((Object[])this.cashValues[rowIndex])[1]))) {
            return min;
        }
        String max = (String)((Object[])this.cashValues[rowIndex])[2];
        if (parentSeverity < Severity.parse((String)max)) {
            return Severity.toString((int)parentSeverity);
        }
        return max;
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 1: {
                ((Object[])this.cashValues[rowIndex])[1] = aValue;
                ((Object[])this.cashValues[rowIndex])[3] = this.getEffValue(rowIndex);
                if (Severity.parse((String)((String)((Object[])this.cashValues[rowIndex])[2])) < Severity.parse((String)((String)aValue))) {
                    ((Object[])this.cashValues[rowIndex])[2] = aValue;
                }
                this.refresh();
                break;
            }
            case 2: {
                ((Object[])this.cashValues[rowIndex])[2] = aValue;
                ((Object[])this.cashValues[rowIndex])[3] = this.getEffValue(rowIndex);
                if (Severity.parse((String)((String)((Object[])this.cashValues[rowIndex])[1])) > Severity.parse((String)((String)aValue))) {
                    ((Object[])this.cashValues[rowIndex])[1] = aValue;
                }
                this.refresh();
                break;
            }
            case 3: {
                ((Object[])this.cashValues[rowIndex])[1] = aValue;
                ((Object[])this.cashValues[rowIndex])[2] = aValue;
                this.refresh();
            }
        }
    }

    public int addElement(Object[] value) {
        String max;
        String min;
        int i = 0;
        while (i < this.cashValues.length) {
            if (((Object[])this.cashValues[i])[0].equals(value[0])) {
                return i;
            }
            ++i;
        }
        int parentSeverity = this.config.calculateRelativeSeverity(LogControllerDescriptor.getParentName((String)this.controllerName), (String)value[0]);
        value[3] = parentSeverity < Severity.parse((String)(min = (String)value[1])) ? min : (parentSeverity < Severity.parse((String)(max = (String)value[2])) ? Severity.toString((int)parentSeverity) : max);
        this.tableValues.addElement((Object)value);
        this.refresh();
        return this.cashValues.length - 1;
    }

    public void removeElementAt(int index) {
        this.tableValues.removeElement(this.cashValues[index]);
        this.refresh();
    }

    public void clear() {
        this.tableValues.clear();
        this.refresh();
    }

    public void setAllData(Object[] data) {
        this.tableValues.clear();
        int i = 0;
        while (i < data.length) {
            Object[] row = (Object[])data[i];
            this.tableValues.addElement((Object)new Object[]{row[0], row[1], row[2], row[3]});
            ++i;
        }
        this.refresh();
    }

    public Object[] getAllData() {
        return this.cashValues;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex != 0;
    }

    protected void refresh() {
        this.cashValues = this.tableValues.toArray();
        this.fireTableDataChanged();
    }
}

