/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.log_configurator.admin.gui;

import com.sap.engine.lib.logging.descriptors.LogConfiguration;
import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public abstract class LogControllersTreeModel
extends DefaultTreeModel {
    public static final String ROOT_CATEGORY = "ROOT CATEGORY";
    public static final String ROOT_LOCATION = "ROOT LOCATION";
    protected DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getRoot();

    public LogControllersTreeModel(String rootName) {
        super(new DefaultMutableTreeNode(rootName));
    }

    public void clear() {
        this.removeAll(this.root);
    }

    private void removeAll(DefaultMutableTreeNode fromNode) {
        Enumeration<TreeNode> children = fromNode.children();
        while (children.hasMoreElements()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
            this.removeAll(child);
            this.fireTreeNodesRemoved(this, fromNode.getPath(), new int[]{fromNode.getIndex(child)}, new Object[]{child});
            fromNode.remove(child);
        }
    }

    public void add(String name) {
        if (name.equals(ROOT_LOCATION) || name.equals(ROOT_CATEGORY)) {
            return;
        }
        Object[] path = this.nameToStringPath(name);
        DefaultMutableTreeNode rootNode = this.root;
        int i = 1;
        while (i < path.length) {
            rootNode = this.insert(rootNode, (String)path[i]);
            ++i;
        }
    }

    private DefaultMutableTreeNode insert(DefaultMutableTreeNode parentNode, String newName) {
        int i = 0;
        while (i < parentNode.getChildCount()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)parentNode.getChildAt(i);
            int compare = ((String)child.getUserObject()).compareTo(newName);
            if (compare == 0) {
                this.nodeChanged(child);
                return child;
            }
            if (compare > 0) {
                DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(newName, true);
                parentNode.insert(newNode, i);
                this.fireTreeNodesInserted(this, parentNode.getPath(), new int[]{i}, new Object[]{newNode});
                return newNode;
            }
            ++i;
        }
        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(newName);
        parentNode.add(newNode);
        this.fireTreeNodesInserted(this, parentNode.getPath(), new int[]{parentNode.getChildCount() - 1}, new Object[]{newNode});
        return newNode;
    }

    protected abstract Object[] nameToStringPath(String var1);

    public Object[] nameToPath(String name) {
        Object[] result = this.nameToStringPath(name);
        result[0] = this.root;
        try {
            int i = 1;
            while (i < result.length) {
                Enumeration<TreeNode> children = ((DefaultMutableTreeNode)result[i - 1]).children();
                while (children.hasMoreElements()) {
                    DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
                    if (!child.getUserObject().equals(result[i])) continue;
                    result[i] = child;
                    break;
                }
                ++i;
            }
        }
        catch (ClassCastException e) {
            return new Object[0];
        }
        return result;
    }

    public String pathToName(Object[] path) {
        if (path.length < 1) {
            return null;
        }
        return this.pathToName(path, path.length);
    }

    protected abstract String pathToName(Object[] var1, int var2);

    public void remove(LogConfiguration logConfig, DefaultMutableTreeNode node) {
        while (node != this.root) {
            if (node.isLeaf() && !logConfig.containsLogController(this.pathToName(node.getPath()))) {
                DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
                this.fireTreeNodesRemoved(this, parent.getPath(), new int[]{parent.getIndex(node)}, new Object[]{node});
                parent.remove(node);
                node = parent;
                continue;
            }
            return;
        }
    }
}

