/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.log_configurator.admin.gui;

import com.sap.engine.lib.logging.descriptors.LogControllerDescriptor;
import com.sap.engine.services.log_configurator.admin.LogConfiguratorListener;
import com.sap.engine.services.log_configurator.admin.gui.GeneralLogControllerRuntime;
import com.sap.engine.services.rmi_p4.P4RemoteObject;
import java.rmi.RemoteException;

public class LogConfiguratorListenerImpl
extends P4RemoteObject
implements LogConfiguratorListener,
Runnable {
    private GeneralLogControllerRuntime main;
    private Thread thisThread;
    private boolean started;
    private long version;

    public LogConfiguratorListenerImpl(GeneralLogControllerRuntime main) {
        this.main = main;
        this.started = false;
    }

    public void configurationChanged(long newVersion) throws RemoteException {
        if (this.started) {
            this.thisThread.interrupt();
            try {
                this.thisThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.version = newVersion;
        this.started = true;
        this.thisThread = new Thread(this);
        this.thisThread.start();
    }

    public void stateChanged(byte state, String parent, String[] descriptors) throws RemoteException {
        int i = 0;
        while (i < descriptors.length) {
            LogControllerDescriptor lcd = this.main.descr.getLogController(descriptors[i]);
            if (lcd != null) {
                lcd.setStateOwner(parent);
                lcd.setState(state);
            }
            this.main.repaint();
            ++i;
        }
    }

    public void run() {
        try {
            this.main.setRefreshable(this.version, true);
            Object var2_1 = null;
            this.started = false;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.started = false;
            throw throwable;
        }
    }

    public void freeResourses() {
        this.main = null;
    }
}

