/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.log_configurator.admin.gui;

import com.sap.engine.lib.logging.descriptors.LogConfiguration;
import com.sap.engine.services.log_configurator.admin.gui.CategoriesPanel;
import com.sap.engine.services.log_configurator.admin.gui.ListValues;
import com.sap.engine.services.log_configurator.admin.gui.LocationsPanel;
import com.sap.engine.services.log_configurator.admin.gui.LogControllerPanelLogical;
import com.sap.engine.services.log_configurator.admin.gui.LogDestinationPanelLogical;
import com.sap.engine.services.log_configurator.admin.gui.LogFormatterPanelLogical;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GeneralLogControllerPanel
extends JPanel
implements ChangeListener {
    protected JTabbedPane theTab = new JTabbedPane();
    protected Frame mainFrame;
    protected LocationsPanel locations = null;
    protected CategoriesPanel categories = null;
    protected LogDestinationPanelLogical logDestination = null;
    protected LogFormatterPanelLogical logFormatter = null;
    protected LogConfiguration descr = new LogConfiguration();
    protected LogConfiguration addEditElements = new LogConfiguration();
    protected LogConfiguration removedElements = new LogConfiguration();
    protected JPanel lastSelected = null;

    public GeneralLogControllerPanel(boolean areTabsUp, boolean hasIcons) {
        super(new BorderLayout());
        if (areTabsUp) {
            this.theTab.setTabPlacement(1);
        } else {
            this.theTab.setTabPlacement(3);
        }
        this.theTab.addChangeListener(this);
        this.locations = new LocationsPanel(this.mainFrame, hasIcons, this);
        this.categories = new CategoriesPanel(this.mainFrame, hasIcons, this);
        this.logDestination = new LogDestinationPanelLogical(this.mainFrame, hasIcons, this);
        this.logFormatter = new LogFormatterPanelLogical(hasIcons);
        this.setAdvancedMode(false);
        this.add((Component)this.theTab, "Center");
    }

    public GeneralLogControllerPanel(Frame frame, boolean areTabsUp, boolean hasIcons) {
        this(areTabsUp, hasIcons);
        this.setFrame(frame);
    }

    public void init(int madeFromConstant) {
    }

    public void clear() {
        this.locations.clear();
        this.categories.clear();
        this.logDestination.clear();
        this.logFormatter.clear();
    }

    public int isCorrect() {
        return 0;
    }

    public void commitChange() {
        this.locations.commitChange();
        this.categories.commitChange();
        this.logDestination.commitChange();
        this.logFormatter.commitChange();
        if (!(this.descr == null || this.descr.getLogControllers() != null && this.descr.getLogControllers().length != 0 || this.descr.getLogDestinations() != null && this.descr.getLogDestinations().length != 0 || this.descr.getLogFormatters() != null && this.descr.getLogFormatters().length != 0)) {
            this.descr = null;
        }
    }

    public void setLoader(ClassLoader loader) {
    }

    public LogConfiguration getDescriptor() {
        this.commitChange();
        return this.descr;
    }

    public long getVersion() {
        return this.descr.getVersion();
    }

    public void setDescriptor(LogConfiguration descr, LogConfiguration addEditElements, LogConfiguration removedElements) {
        this.descr = descr;
        this.addEditElements = addEditElements;
        this.removedElements = removedElements;
        if (this.descr == null) {
            this.descr = new LogConfiguration();
        }
        if (this.addEditElements == null) {
            this.addEditElements = new LogConfiguration();
        }
        if (this.removedElements == null) {
            this.removedElements = new LogConfiguration();
        }
        if (this.locations != null) {
            this.locations.setDescriptor(this.descr, this.addEditElements, this.removedElements);
        }
        if (this.categories != null) {
            this.categories.setDescriptor(this.descr, this.addEditElements, this.removedElements);
        }
        if (this.logDestination != null) {
            this.logDestination.setDescriptor(this.descr, this.addEditElements, this.removedElements);
        }
        if (this.logFormatter != null) {
            this.logFormatter.setDescriptor(this.descr, this.addEditElements, this.removedElements);
        }
    }

    public void stateChanged(ChangeEvent e) {
        if (this.descr == null) {
            this.descr = new LogConfiguration();
        }
        if (this.lastSelected != null) {
            if (this.lastSelected instanceof LogControllerPanelLogical) {
                LogControllerPanelLogical controller = (LogControllerPanelLogical)this.lastSelected;
                controller.valueChanged(null);
            } else if (this.lastSelected instanceof LogDestinationPanelLogical) {
                LogDestinationPanelLogical destination = (LogDestinationPanelLogical)this.lastSelected;
                destination.valueChanged(null);
                destination.commitChange();
            } else if (this.lastSelected instanceof LogFormatterPanelLogical) {
                LogFormatterPanelLogical formatter = (LogFormatterPanelLogical)this.lastSelected;
                formatter.valueChanged(null);
                formatter.commitChange();
            }
        }
        this.lastSelected = (JPanel)this.theTab.getSelectedComponent();
        if (this.lastSelected != null) {
            if (this.lastSelected instanceof LogControllerPanelLogical) {
                ((LogControllerPanelLogical)this.lastSelected).setDescriptor(this.descr, this.addEditElements, this.removedElements);
            } else if (this.lastSelected instanceof LogDestinationPanelLogical) {
                ((LogDestinationPanelLogical)this.lastSelected).setDescriptor(this.descr, this.addEditElements, this.removedElements);
            } else if (this.lastSelected instanceof LogFormatterPanelLogical) {
                ((LogFormatterPanelLogical)this.lastSelected).setDescriptor(this.descr, this.addEditElements, this.removedElements);
            }
        }
    }

    public void setFrame(Frame frame) {
        this.mainFrame = frame;
        if (this.locations != null) {
            this.locations.setFrame(frame);
        }
        if (this.categories != null) {
            this.categories.setFrame(frame);
        }
        if (this.logDestination != null) {
            this.logDestination.setFrame(frame);
        }
    }

    public void changeSelectedPanel(ListValues lv) {
        if (lv.getType() == 0) {
            this.theTab.setSelectedComponent(this.logDestination);
            this.logDestination.setSelectedDestination(lv);
        } else {
            this.theTab.setSelectedComponent(this.logFormatter);
            this.logFormatter.setSelectedFormatter(lv);
        }
    }

    public void repaint() {
        super.repaint();
        if (this.categories != null && this.categories.isVisible()) {
            this.categories.logTree.repaint();
        }
        if (this.locations != null && this.locations.isVisible()) {
            this.locations.logTree.repaint();
        }
    }

    public void setAdvancedMode(boolean isModeAdvanced) {
        Component pos = this.theTab.getSelectedComponent();
        this.theTab.removeAll();
        this.theTab.addTab("Categories", this.categories);
        this.theTab.addTab("Locations", this.locations);
        if (isModeAdvanced) {
            this.theTab.addTab("Destinations", this.logDestination);
            this.theTab.addTab("Formatters", this.logFormatter);
        }
        this.categories.setAdvancedMode(isModeAdvanced);
        this.locations.setAdvancedMode(isModeAdvanced);
        try {
            this.theTab.setSelectedComponent(pos);
        }
        catch (Exception e) {
            this.theTab.setSelectedIndex(0);
        }
    }

    public void setChangeStatePossible(boolean possible) {
        this.locations.setChangeStatePossible(possible);
        this.categories.setChangeStatePossible(possible);
    }

    public void setResetToDefaultVisible(boolean visible) {
        this.locations.setResetToDefaultVisible(visible);
        this.categories.setResetToDefaultVisible(visible);
    }

    public boolean isChanged() {
        return this.addEditElements.getLogControllers().length > 0 || this.addEditElements.getLogDestinations().length > 0 || this.addEditElements.getLogFormatters().length > 0 || this.removedElements.getLogControllers().length > 0 || this.removedElements.getLogDestinations().length > 0 || this.removedElements.getLogFormatters().length > 0;
    }

    public LogConfiguration getAddEditElements() {
        return this.addEditElements;
    }

    public LogConfiguration getRemovedElements() {
        return this.removedElements;
    }
}

