/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.log_configurator.admin.gui;

import com.sap.engine.lib.logging.descriptors.LogConfiguration;
import com.sap.engine.lib.logging.descriptors.LogDestinationDescriptor;
import com.sap.engine.lib.util.ArrayInt;
import com.sap.engine.services.log_configurator.admin.gui.ArchiveDlgCellEditor;
import com.sap.engine.services.log_configurator.admin.gui.ArchiveDlgCellRenderer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.TableColumn;

public class ArchiveDialog
extends JDialog
implements ActionListener {
    private static final String OK_CMD = "OK";
    private static final String CANCEL_CMD = "CANCEL";
    private JTextField dirName = new JTextField("./log/archive/");
    private JCheckBox defaultTraces;
    private JTable table;
    private JButton okBtn;
    private JButton cancelBtn;
    private boolean modalResult = false;
    private LogDestinationDescriptor[] destinations;

    public ArchiveDialog(Frame mainFrame, LogConfiguration config) {
        super(mainFrame, "Logs to archive", true);
        this.destinations = config.getLogDestinations();
        this.init();
    }

    private void init() {
        ((Component)this).setSize(500, 300);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        ((Component)this).setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        this.defaultTraces = new JCheckBox("Add default traces", true);
        Object[][] values = new Object[this.destinations.length][1];
        int i = 0;
        while (i < this.destinations.length) {
            values[i][0] = new Boolean(true);
            ++i;
        }
        this.table = new JTable(values, new Object[]{"Log Destinations"});
        TableColumn column = this.table.getColumnModel().getColumn(0);
        column.setCellRenderer(new ArchiveDlgCellRenderer(this.destinations));
        column.setCellEditor(new ArchiveDlgCellEditor(this.destinations));
        JScrollPane scroll = new JScrollPane(this.table);
        scroll.setBorder(BorderFactory.createEtchedBorder());
        this.cancelBtn = new JButton("Cancel");
        this.cancelBtn.setActionCommand(CANCEL_CMD);
        this.cancelBtn.addActionListener(this);
        this.okBtn = new JButton(OK_CMD);
        this.okBtn.setActionCommand(OK_CMD);
        this.okBtn.addActionListener(this);
        this.okBtn.setPreferredSize(this.cancelBtn.getPreferredSize());
        JPanel downBtnPanel = new JPanel(new FlowLayout(1, 50, 0));
        downBtnPanel.add(this.okBtn);
        downBtnPanel.add(this.cancelBtn);
        JPanel contentPane = new JPanel(new GridBagLayout());
        int i2 = 0;
        contentPane.add((Component)new JLabel("Archive directory:"), new GridBagConstraints(0, i2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        contentPane.add((Component)this.dirName, new GridBagConstraints(1, i2, 1, 1, 0.1, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        contentPane.add((Component)this.defaultTraces, new GridBagConstraints(0, ++i2, 2, 1, 0.1, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        contentPane.add((Component)scroll, new GridBagConstraints(0, ++i2, 2, 1, 0.1, 0.1, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        contentPane.add((Component)downBtnPanel, new GridBagConstraints(0, ++i2, 2, 1, 0.1, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        super.setContentPane(contentPane);
        this.modalResult = false;
        contentPane.getInputMap(1).put(KeyStroke.getKeyStroke("ESCAPE"), CANCEL_CMD);
        contentPane.getActionMap().put(CANCEL_CMD, new AbstractAction(){

            public void actionPerformed(ActionEvent event) {
                ArchiveDialog.this.actionPerformed(new ActionEvent(this, 0, ArchiveDialog.CANCEL_CMD));
            }
        });
    }

    public boolean getModalResult() {
        return this.modalResult;
    }

    public boolean isDefaultTracesSelected() {
        return this.defaultTraces.isSelected();
    }

    public String getArchiveDirectory() {
        String result = this.dirName.getText().trim();
        if (result.equals("")) {
            result = "./log/archive/";
        }
        return result;
    }

    public String[] getSelectedDestinationNames() {
        ArrayInt index = new ArrayInt();
        int i = 0;
        while (i < this.destinations.length) {
            if (((Boolean)this.table.getModel().getValueAt(i, 0)).booleanValue()) {
                index.add(i);
            }
            ++i;
        }
        int[] indexes = index.toArray();
        String[] result = new String[indexes.length];
        int i2 = 0;
        while (i2 < indexes.length) {
            result[i2] = this.destinations[i2].toString();
            ++i2;
        }
        return result;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals(OK_CMD)) {
            this.modalResult = true;
            ((Component)this).setVisible(false);
        } else if (e.getActionCommand().equals(CANCEL_CMD)) {
            ((Component)this).setVisible(false);
        }
    }

    public void valueChanged(ListSelectionEvent e) {
    }
}

