/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.log_configurator.admin.gui;

import com.sap.engine.gui.SimpleListPanel;
import com.sap.engine.lib.logging.descriptors.LogConfiguration;
import com.sap.engine.lib.logging.descriptors.LogDestinationDescriptor;
import com.sap.engine.lib.logging.descriptors.LogFormatterDescriptor;
import com.sap.engine.lib.util.HashMapObjectByte;
import com.sap.engine.services.log_configurator.admin.gui.AdvanceDialog;
import com.sap.engine.services.log_configurator.admin.gui.GeneralLogControllerPanel;
import com.sap.engine.services.log_configurator.admin.gui.ListRenderer;
import com.sap.engine.services.log_configurator.admin.gui.ListValues;
import com.sap.engine.services.log_configurator.admin.gui.LogDestinationNewPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;

public class AdvanceListPanel
extends SimpleListPanel
implements ItemListener {
    private GeneralLogControllerPanel mainPanel;
    private AdvanceDialog advanceDialog = null;
    public int type;
    private HashMapObjectByte additionalInfo = new HashMapObjectByte();
    private JComboBox comboBox = null;
    private boolean hasIcons = false;
    private JButton describeButton;
    private JButton newButton;
    private String DESCRIBE_CMD = "DESCRIBE_CMD";
    private String NEW_CMD = "NEW_CMD";
    private boolean advancedMode = false;

    public AdvanceListPanel(String title, Frame frame, int type, boolean hasIcons, GeneralLogControllerPanel mainPanel) {
        super(title, "Add", "Remove", "Edit");
        this.setParentComponent(frame);
        this.type = type;
        this.hasIcons = hasIcons;
        this.mainPanel = mainPanel;
        this.init(hasIcons);
    }

    private void init(boolean hasIcons) {
        Component[] comps = ((Container)((Object)this)).getComponents();
        int i = 0;
        while (i < comps.length) {
            if (comps[i] instanceof JScrollPane) {
                ((Container)((Object)this)).remove(comps[i]);
                ((Container)((Object)this)).add(comps[i], new GridBagConstraints(0, 0, 1, 5, 0.1, 0.1, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
                break;
            }
            ++i;
        }
        this.describeButton = new JButton("Describe");
        this.describeButton.setActionCommand(this.DESCRIBE_CMD);
        this.describeButton.addActionListener((ActionListener)((Object)this));
        ((Container)((Object)this)).add(this.describeButton, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.newButton = new JButton("New");
        this.newButton.setActionCommand(this.NEW_CMD);
        this.newButton.addActionListener((ActionListener)((Object)this));
        ((Container)((Object)this)).add(this.newButton, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
        if (hasIcons) {
            this.theList.setCellRenderer(new ListRenderer());
        }
        this.setEnabled(false, false, false, false);
        this.describeButton.setEnabled(false);
        this.newButton.setEnabled(false);
        this.newButton.setVisible(this.type == 0);
    }

    private ListValues getListValue(Object descr) {
        if (descr != null) {
            if (this.type == 0) {
                return new ListValues((LogDestinationDescriptor)descr, 0);
            }
            if (this.type == 1) {
                return new ListValues((LogFormatterDescriptor)descr, 1);
            }
        }
        return null;
    }

    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (actionCommand.equals(this.NEW_CMD)) {
            LogDestinationNewPanel destPanel = new LogDestinationNewPanel(false);
            while (JOptionPane.showConfirmDialog((Component)((Object)this), destPanel, "New destination", 2, 3) == 0) {
                String newName = destPanel.getName();
                if (newName == null || newName.trim().equals("")) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "Can not create destination without name!", "Error", 0);
                    continue;
                }
                if (this.mainPanel.descr.containsLogDetination(newName)) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "Destination '" + newName + "' already exists!", "Error", 0);
                    continue;
                }
                String newType = destPanel.getType();
                if (newType == null || newType.trim().equals("")) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "Can not create destination without type!", "Error", 0);
                    continue;
                }
                String newPattern = destPanel.getPattern();
                if (newType.equalsIgnoreCase("FileLog") && (newPattern == null || newPattern.trim().equals(""))) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "Can not create File Log without pattern!", "Error", 0);
                    continue;
                }
                LogDestinationDescriptor destination = new LogDestinationDescriptor();
                destination.setName(newName);
                destination.setType(newType);
                destination.setPattern(newPattern);
                destination.setLimit(destPanel.getLimit());
                destination.setCount(destPanel.getCount());
                this.mainPanel.addEditElements.addLogDestination(destination);
                this.mainPanel.descr.addLogDestination(destination);
                this.additionalInfo.put((Object)destination, (byte)0);
                ListValues lv = new ListValues(destination, 0);
                this.listModel.addElement(lv);
                this.theList.setSelectedValue(lv, true);
                return;
            }
        } else if (actionCommand.equals("ADD_CMD")) {
            this.advanceDialog.setVisible(true);
            Object[] temp = this.advanceDialog.getDescriptors();
            if (temp != null) {
                int i = 0;
                while (i < temp.length) {
                    if (this.type == 0) {
                        this.additionalInfo.put((Object)((ListValues)temp[i]).getLogDestination(), this.advanceDialog.getAdditionalInfo());
                    }
                    this.listModel.addElement(temp[i]);
                    this.theList.setSelectedValue(temp[i], true);
                    ++i;
                }
            }
        } else if (actionCommand.equals("EDIT_CMD")) {
            if (!this.theList.isSelectionEmpty()) {
                ListValues currentElement = (ListValues)this.listModel.getElementAt(this.theList.getSelectedIndex());
                if (this.type == 0) {
                    LogDestinationDescriptor destination = currentElement.getLogDestination();
                    if (destination.getName() == null) {
                        JComboBox<Object> types = new JComboBox<Object>(new Object[]{"ConsoleLog"});
                        types.setEditable(true);
                        types.setSelectedItem(destination.getType());
                        if (JOptionPane.showConfirmDialog((Component)((Object)this), types, "Edit anonymous destination", 2, 3) == 0) {
                            String newType = (String)types.getSelectedItem();
                            if (newType == null || newType.trim().equals("")) {
                                JOptionPane.showMessageDialog((Component)((Object)this), "Can not create destination without type!", "Error", 0);
                            } else {
                                byte logType = this.additionalInfo.get((Object)destination);
                                this.additionalInfo.remove((Object)destination);
                                this.listModel.removeElementAt(this.theList.getSelectedIndex());
                                destination = new LogDestinationDescriptor();
                                destination.setType(newType);
                                this.additionalInfo.put((Object)destination, logType);
                                this.listModel.addElement(new ListValues(destination, 0));
                            }
                        }
                    } else {
                        this.mainPanel.changeSelectedPanel(currentElement);
                    }
                } else if (this.type == 1) {
                    LogFormatterDescriptor formatter = currentElement.getLogFormatter();
                    if (formatter.getName() == null) {
                        JComboBox<Object> types = null;
                        types = new JComboBox<Object>(new Object[]{"ListFormatter", "TraceFormatter", "XMLFormatter"});
                        types.setEditable(true);
                        types.setSelectedItem(formatter.getType());
                        if (JOptionPane.showConfirmDialog((Component)((Object)this), types, "Edit anonymous formatter", 2, 3) == 0) {
                            this.listModel.clear();
                            formatter = new LogFormatterDescriptor();
                            formatter.setType((String)types.getSelectedItem());
                            this.listModel.addElement(new ListValues(formatter, 1));
                        }
                    } else if (this.advancedMode) {
                        this.mainPanel.changeSelectedPanel(currentElement);
                    } else {
                        JOptionPane.showMessageDialog((Component)((Object)this), "In simple mode edit is availble only for anonymous formatters.", "Warning", 2);
                    }
                }
            }
        } else if (actionCommand.equals("REMOVE_CMD")) {
            if (this.type == 0) {
                this.additionalInfo.remove((Object)((ListValues)this.listModel.getElementAt(this.theList.getSelectedIndex())).getLogDestination());
            }
            super.actionPerformed(e);
        } else if (actionCommand.equals(this.DESCRIBE_CMD) && !this.theList.isSelectionEmpty()) {
            if (this.type == 0) {
                LogDestinationDescriptor destination = ((ListValues)this.listModel.getElementAt(this.theList.getSelectedIndex())).getLogDestination();
                String description = null;
                description = destination.getName() == null ? "Name: Anonymous\nType: " + destination.getType() : "Name: " + destination.getName() + "\n" + "Type: " + destination.getType() + "\n" + "Severity: " + destination.getEffectiveSeverity() + "\n" + "Encoding: " + destination.getEncoding();
                if (destination.getType() != null && destination.getType().equalsIgnoreCase("FileLog")) {
                    description = description + "\nPattern: " + destination.getPattern() + "\n" + "Limit: " + destination.getLimit() + "\n" + "Count: " + destination.getCount();
                }
                JOptionPane.showMessageDialog(this.parentComponent, description, "Destination description", 1);
            } else if (this.type == 1) {
                LogFormatterDescriptor formatter = ((ListValues)this.listModel.getElementAt(this.theList.getSelectedIndex())).getLogFormatter();
                String description = null;
                description = formatter.getName() == null ? "Name: Anonymous\nType: " + formatter.getType() : "Name: " + formatter.getName() + "\n" + "Type: " + formatter.getType();
                if (formatter.getType() != null && formatter.getType().equalsIgnoreCase("TraceFormatter")) {
                    description = description + "\nPattern: " + formatter.getPattern();
                }
                JOptionPane.showMessageDialog(this.parentComponent, description, "Formatter description", 1);
            }
        }
        this.setButtonsEnabled();
    }

    public void setParentComponent(Component parentComponent) {
        super.setParentComponent(parentComponent);
        this.advanceDialog = new AdvanceDialog((Frame)parentComponent, this.type, this.hasIcons);
        this.advanceDialog.setFrame((Frame)parentComponent);
    }

    public void initList(Object[] arr) {
        this.listModel.removeAllElements();
        if (arr != null) {
            ListValues listValues = null;
            int i = 0;
            while (i < arr.length) {
                listValues = this.getListValue(arr[i]);
                if (listValues != null) {
                    this.listModel.addElement(listValues);
                }
                ++i;
            }
        }
    }

    public void initList(HashMapObjectByte arr) {
        this.listModel.removeAllElements();
        if (arr != null) {
            ListValues listValues = null;
            Object[] keys = arr.getAllKeys();
            int i = 0;
            while (i < keys.length) {
                listValues = this.getListValue(keys[i]);
                if (listValues != null) {
                    this.listModel.addElement(listValues);
                    this.additionalInfo.put(keys[i], arr.get(keys[i]));
                }
                ++i;
            }
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        super.valueChanged(e);
        if (this.type == 0) {
            if (!this.theList.isSelectionEmpty()) {
                this.setAssociationType(this.additionalInfo.get((Object)((ListValues)this.listModel.getElementAt(this.theList.getSelectedIndex())).getLogDestination()));
                this.comboBox.setEnabled(true);
                this.comboBox.addItemListener(this);
            } else {
                this.setAssociationType(-1);
                this.comboBox.removeItemListener(this);
                this.comboBox.setEnabled(false);
            }
        }
        this.setButtonsEnabled();
    }

    public void setAssociationType(int value) {
        if (this.comboBox != null) {
            this.comboBox.setSelectedIndex(value);
        }
    }

    private void setButtonsEnabled() {
        if (!this.theList.isSelectionEmpty()) {
            this.describeButton.setEnabled(true);
            this.newButton.setEnabled(true);
            if (this.type == 0) {
                this.setEnabled(true, true, true, true);
            } else if (this.type == 1) {
                if (this.listModel.size() != 0) {
                    this.setEnabled(true, false, true, true);
                } else {
                    this.setEnabled(true, true, true, true);
                }
            }
        } else {
            this.describeButton.setEnabled(false);
            this.describeButton.setEnabled(false);
            this.newButton.setEnabled(true);
            if (this.type == 0) {
                this.setEnabled(true, true, false, false);
            } else if (this.type == 1) {
                if (this.listModel.size() != 0) {
                    this.setEnabled(true, false, false, false);
                } else {
                    this.setEnabled(true, true, false, false);
                }
            }
        }
    }

    public void setDescriptor(LogConfiguration descr) {
        if (this.advanceDialog != null) {
            this.advanceDialog.setDescriptor(descr);
        }
    }

    public Object getDescriptor() {
        try {
            if (this.type == 0) {
                HashMapObjectByte descr = null;
                if (this.listModel.size() != 0) {
                    descr = new HashMapObjectByte(this.listModel.size());
                    Enumeration elements = this.listModel.elements();
                    while (elements.hasMoreElements()) {
                        LogDestinationDescriptor currentDestination = ((ListValues)elements.nextElement()).getLogDestination();
                        descr.put((Object)currentDestination, this.additionalInfo.get((Object)currentDestination));
                    }
                }
                return descr;
            }
            if (this.type == 1) {
                LogFormatterDescriptor descr = null;
                if (this.listModel.size() != 0) {
                    descr = ((ListValues)this.listModel.elementAt(0)).getLogFormatter();
                }
                return descr;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return null;
    }

    public void setEnabled(boolean flag) {
        if (flag) {
            this.setButtonsEnabled();
        } else {
            super.setEnabled(false);
        }
        this.newButton.setEnabled(flag);
    }

    public void setComboBox(JComboBox comboBox) {
        this.comboBox = comboBox;
    }

    public void setAdvancetMode(boolean advancedMode) {
        this.advancedMode = advancedMode;
        this.newButton.setVisible(!advancedMode && this.type == 0);
    }

    public void itemStateChanged(ItemEvent ie) {
        int selectedComboBoxIndex = this.comboBox.getSelectedIndex();
        int listSelectedIndex = this.theList.getSelectedIndex();
        if (listSelectedIndex != -1) {
            this.additionalInfo.put((Object)((ListValues)this.listModel.getElementAt(listSelectedIndex)).getLogDestination(), (byte)selectedComboBoxIndex);
        }
    }
}

