/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.log_configurator.admin;

import com.sap.engine.frame.ServiceContext;
import com.sap.engine.frame.cluster.ClusterContext;
import com.sap.engine.frame.cluster.message.MessageAnswer;
import com.sap.engine.frame.cluster.message.MessageContext;
import com.sap.engine.frame.cluster.message.MessageListener;
import com.sap.engine.frame.state.ManagementListener;
import com.sap.engine.lib.logging.StandardConsoleLog;
import com.sap.engine.lib.logging.descriptors.LogConfiguration;
import com.sap.engine.lib.logging.descriptors.LogControllerDescriptor;
import com.sap.engine.lib.logging.descriptors.LogDestinationDescriptor;
import com.sap.engine.lib.logging.descriptors.LogFormatterDescriptor;
import com.sap.engine.lib.logging.descriptors.PersistenceAdapter;
import com.sap.engine.lib.util.ArrayObject;
import com.sap.engine.lib.util.EnumerationInt;
import com.sap.engine.lib.util.HashMapIntObject;
import com.sap.engine.lib.util.HashMapObjectByte;
import com.sap.engine.lib.util.HashMapObjectObject;
import com.sap.engine.lib.util.Set;
import com.sap.engine.services.log_configurator.admin.Archivator;
import com.sap.engine.services.log_configurator.admin.LogConfiguratorListener;
import com.sap.engine.services.log_configurator.admin.LogConfiguratorManagementInterface;
import com.sap.engine.services.log_configurator.admin.LogManagerWrapper;
import com.sap.engine.services.log_configurator.admin.LogXMLParser;
import com.sap.engine.services.log_configurator.admin.PersistenceAdapterExt;
import com.sap.sql.trace.SQLTrace;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.FileLog;
import com.sap.tc.logging.Filter;
import com.sap.tc.logging.Formatter;
import com.sap.tc.logging.ListFormatter;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Log;
import com.sap.tc.logging.LogController;
import com.sap.tc.logging.Severity;
import com.sap.tc.logging.TraceFormatter;
import com.sap.tc.logging.XMLFormatter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class LogConfigurator
implements LogConfiguratorManagementInterface,
MessageListener {
    private static final Location TRACER = Location.getLocation((Class)(class$com$sap$engine$services$log_configurator$admin$LogConfigurator == null ? (class$com$sap$engine$services$log_configurator$admin$LogConfigurator = LogConfigurator.class$("com.sap.engine.services.log_configurator.admin.LogConfigurator")) : class$com$sap$engine$services$log_configurator$admin$LogConfigurator));
    private static final ClassLoader LOADER = (class$com$sap$engine$services$log_configurator$admin$LogConfigurator == null ? (class$com$sap$engine$services$log_configurator$admin$LogConfigurator = LogConfigurator.class$("com.sap.engine.services.log_configurator.admin.LogConfigurator")) : class$com$sap$engine$services$log_configurator$admin$LogConfigurator).getClassLoader();
    private static final byte[] EMPTY_MESSAGE_BODY = new byte[0];
    private static final int EMPTY_MESSAGE_BODY_LENGTH = EMPTY_MESSAGE_BODY.length;
    private static final byte APPLY_AND_STORE_MESSAGE = 0;
    private static final byte APPLY_MESSAGE = 1;
    private static final byte RESET_MESSAGE = 2;
    private final LogConfiguration mainConfiguration;
    private final PersistenceAdapter userDefinedAdapter;
    private final MessageContext messageContext;
    private final LogManagerWrapper logManager;
    private final HashMapIntObject listeners;
    private final byte clusterNodeType;
    private boolean noLogging = false;
    private long configVersion = 0L;
    private int nextListenerId = 0;
    private Object dbFilter = null;
    private Method dbFilterEnableMethod = null;
    private Method dbFilterDisableMethod = null;
    private final ArrayObject awaitingDbFilter = new ArrayObject();
    private com.sap.engine.services.log_configurator.archive.Archivator archivator;
    static /* synthetic */ Class class$com$sap$engine$services$log_configurator$admin$LogConfigurator;
    static /* synthetic */ Class array$Ljava$lang$String;

    public LogConfigurator(ServiceContext serviceContext, ClusterContext clusterContext, com.sap.engine.services.log_configurator.archive.Archivator archivator) {
        this.userDefinedAdapter = new PersistenceAdapterExt(serviceContext.getServiceState().getPersistentContainer());
        this.logManager = new LogManagerWrapper(serviceContext.getCoreContext().getCoreMonitor());
        this.clusterNodeType = clusterContext.getClusterMonitor().getCurrentParticipant().getType();
        this.mainConfiguration = this.logManager.getLogConfiguration();
        this.messageContext = clusterContext.getMessageContext();
        this.listeners = new HashMapIntObject();
        this.archivator = archivator;
        this.setDatabaseFilter(this.logManager.getDatabaseFilter());
        this.applyConfiguration(LogXMLParser.extractConfiguration(this.userDefinedAdapter, null));
    }

    public synchronized boolean existsLog(String name) {
        return this.mainConfiguration.containsLogDetination(name);
    }

    public synchronized boolean existsFormatter(String name) {
        return this.mainConfiguration.containsLogFormatter(name);
    }

    public synchronized boolean existsLogController(String name) {
        return this.mainConfiguration.containsLogController(name);
    }

    public Log getLog(String name) {
        LogDestinationDescriptor descriptor;
        LogConfigurator logConfigurator = this;
        synchronized (logConfigurator) {
            descriptor = this.mainConfiguration.getLogDestination(name);
        }
        if (descriptor != null) {
            return descriptor.getRealLog();
        }
        return null;
    }

    public FileLog getDefaultTraceFile() {
        return this.logManager.getDefaultTraceFile();
    }

    public Formatter getFormatter(String name) {
        LogFormatterDescriptor descriptor;
        LogConfigurator logConfigurator = this;
        synchronized (logConfigurator) {
            descriptor = this.mainConfiguration.getLogFormatter(name);
        }
        if (descriptor != null) {
            return descriptor.getRealFormatter();
        }
        return null;
    }

    public LogController getLogController(String name) {
        LogControllerDescriptor descriptor;
        LogConfigurator logConfigurator = this;
        synchronized (logConfigurator) {
            descriptor = this.mainConfiguration.getLogController(name);
        }
        if (descriptor != null) {
            name = descriptor.getName();
            if (name.startsWith("/")) {
                return Category.getCategory((String)name);
            }
            return Location.getLocation((String)name);
        }
        return null;
    }

    public LogDestinationDescriptor getLogDescriptor(String name) {
        LogDestinationDescriptor result;
        LogConfigurator logConfigurator = this;
        synchronized (logConfigurator) {
            result = this.mainConfiguration.getLogDestination(name);
        }
        if (result != null) {
            result = (LogDestinationDescriptor)result.clone();
        }
        return result;
    }

    public LogFormatterDescriptor getFormatterDescriptor(String name) {
        LogFormatterDescriptor result;
        LogConfigurator logConfigurator = this;
        synchronized (logConfigurator) {
            result = this.mainConfiguration.getLogFormatter(name);
        }
        if (result != null) {
            result = (LogFormatterDescriptor)result.clone();
        }
        return result;
    }

    public LogControllerDescriptor getLogControllerDescriptor(String name) {
        LogControllerDescriptor result;
        LogConfigurator logConfigurator = this;
        synchronized (logConfigurator) {
            result = this.mainConfiguration.getLogController(name);
        }
        if (result != null) {
            result = (LogControllerDescriptor)result.clone();
        }
        return result;
    }

    public void listLogsNames(PrintStream out) {
        Object[] logDestinations;
        LogConfigurator logConfigurator = this;
        synchronized (logConfigurator) {
            logDestinations = this.mainConfiguration.getLogDestinationsNames();
        }
        Arrays.sort(logDestinations);
        out.println("\n  ********* Log Destinations *********\n");
        int i = 0;
        while (i < logDestinations.length) {
            out.println("  " + (String)logDestinations[i]);
            ++i;
        }
        out.println("\n  ************************************\n");
    }

    public void listFormattersNames(PrintStream out) {
        Object[] logFormatters;
        LogConfigurator logConfigurator = this;
        synchronized (logConfigurator) {
            logFormatters = this.mainConfiguration.getLogFormattersNames();
        }
        Arrays.sort(logFormatters);
        out.println("\n  ********** Log Formatters **********\n");
        int i = 0;
        while (i < logFormatters.length) {
            out.println("  " + (String)logFormatters[i]);
            ++i;
        }
        out.println("\n  ************************************\n");
    }

    public void listLogControllersNames(PrintStream out) {
        Object[] logControllers;
        LogConfigurator logConfigurator = this;
        synchronized (logConfigurator) {
            logControllers = this.mainConfiguration.getLogControllersNames();
        }
        Arrays.sort(logControllers);
        out.println("\n  ********** LogControllers **********\n");
        int i = 0;
        while (i < logControllers.length) {
            out.println("  " + (String)logControllers[i]);
            ++i;
        }
        out.println("\n  ************************************\n");
    }

    private void printFormatter(LogFormatterDescriptor formatter, PrintStream out, String offset) {
        out.println(offset + formatter.toString());
        String type = formatter.getType();
        if (type != null) {
            out.println(offset + "  type = " + type);
            if ("TraceFormatter".equals(type)) {
                out.println(offset + "  pattern = " + formatter.getPattern());
            }
        }
    }

    private void printLog(LogDestinationDescriptor destination, PrintStream out, String offset) {
        out.println(offset + destination.toString());
        out.println(offset + "  type = " + destination.getType());
        String encoding = destination.getEncoding();
        if (encoding != null) {
            out.println(offset + "  encoding = " + encoding);
        }
        out.println(offset + "  effective severity = " + destination.getEffectiveSeverity());
        if (destination.getType().equalsIgnoreCase("FileLog")) {
            out.println(offset + "  pattern = " + destination.getPattern());
            out.println(offset + "  limit = " + destination.getLimit());
            out.println(offset + "  count = " + destination.getCount());
        }
        Object[] filters = destination.getFilters();
        Arrays.sort(filters);
        int j = 0;
        while (j < filters.length) {
            out.println(offset + "  filter No " + j + " = " + (String)filters[j]);
            ++j;
        }
        out.print(offset + "  Formatter:");
        this.printFormatter(destination.getFormatter(), out, offset + "  ");
    }

    private void printController(LogControllerDescriptor controller, PrintStream out) {
        out.println("  " + controller.getName());
        String attrib = controller.getBundleName();
        if (attrib != null) {
            out.println("    ResourceBundle name = " + attrib);
        }
        out.println("    minimum severity = " + controller.getMinSeverity());
        out.println("    maximum severity = " + controller.getMaxSeverity());
        out.println("    effective severity = " + Severity.toString((int)this.mainConfiguration.calculateEffectiveSeverity(controller.getName())));
        out.println("    has a DatabaseLog = " + controller.hasDBLog());
        Object[] filters = controller.getFilters();
        Arrays.sort(filters);
        int j = 0;
        while (j < filters.length) {
            out.println("    filter No " + j + " = " + (String)filters[j]);
            ++j;
        }
        HashMapObjectByte associations = controller.getAssociatedDestinations();
        Object[] destinations = new LogDestinationDescriptor[associations.size()];
        destinations = (LogDestinationDescriptor[])associations.getAllKeys(destinations, 0);
        Arrays.sort(destinations);
        int l = 0;
        while (l < destinations.length) {
            switch (associations.get(destinations[l])) {
                case 2: {
                    out.print("    Local log:");
                    break;
                }
                case 0: {
                    out.print("    Log:");
                    break;
                }
                case 1: {
                    out.print("    Private log:");
                }
            }
            this.printLog((LogDestinationDescriptor)destinations[l], out, "    ");
            ++l;
        }
    }

    public synchronized void listLogs(String[] names, PrintStream out) {
        out.println("\n  ********* Log Destinations *********\n");
        if (names == null) {
            Object[] descriptors = this.mainConfiguration.getLogDestinations();
            Arrays.sort(descriptors);
            int i = 0;
            while (i < descriptors.length) {
                this.printLog((LogDestinationDescriptor)descriptors[i], out, "  ");
                ++i;
            }
        } else {
            Arrays.sort(names);
            int i = 0;
            while (i < names.length) {
                this.printLog(this.mainConfiguration.getLogDestination(names[i]), out, "  ");
                ++i;
            }
        }
        out.println("\n  ************************************\n");
    }

    public synchronized void listFormatters(String[] names, PrintStream out) {
        out.println("\n  ********** Log Formatters **********\n");
        if (names == null) {
            Object[] formatters = this.mainConfiguration.getLogFormatters();
            Arrays.sort(formatters);
            int i = 0;
            while (i < formatters.length) {
                this.printFormatter((LogFormatterDescriptor)formatters[i], out, "  ");
                ++i;
            }
        } else {
            Arrays.sort(names);
            int i = 0;
            while (i < names.length) {
                this.printFormatter(this.mainConfiguration.getLogFormatter(names[i]), out, "  ");
                ++i;
            }
        }
        out.println("\n  ************************************\n");
    }

    public synchronized void listLogControllers(String[] names, PrintStream out) {
        out.println("\n  ********** LogControllers **********\n");
        if (names == null) {
            Object[] controllers = this.mainConfiguration.getLogControllers();
            Arrays.sort(controllers);
            int i = 0;
            while (i < controllers.length) {
                this.printController((LogControllerDescriptor)controllers[i], out);
                ++i;
            }
        } else {
            Arrays.sort(names);
            int i = 0;
            while (i < names.length) {
                if (names[i].equalsIgnoreCase("Root Location")) {
                    this.printController(this.mainConfiguration.getLogController(""), out);
                } else if (names[i].equalsIgnoreCase("Root Category")) {
                    this.printController(this.mainConfiguration.getLogController("/"), out);
                } else {
                    this.printController(this.mainConfiguration.getLogController(names[i]), out);
                }
                ++i;
            }
        }
        out.println("\n  ************************************\n");
    }

    private static LogConfiguration getConfigurationToSave(PersistenceAdapter adapter, String prefix, HashMapObjectObject repository) {
        LogConfiguration result = (LogConfiguration)repository.get((Object)adapter);
        if (result == null) {
            try {
                result = new LogXMLParser().parse(adapter, prefix);
            }
            catch (Exception e) {
                TRACER.traceThrowableT(500, "Failed to obtain the logging configuration for component \"" + prefix + "\"!", (Throwable)e);
            }
            if (result == null) {
                result = new LogConfiguration();
            }
            repository.put((Object)adapter, (Object)result);
        }
        return result;
    }

    private static LogConfiguration getCommonConfigurationToSave(PersistenceAdapterExt adapter, String prefix, HashMapObjectObject repository) {
        LogConfiguration result = (LogConfiguration)repository.get((Object)adapter);
        if (result == null) {
            try {
                result = new LogXMLParser().parse(adapter.getCommonPersistentEntryStream(), adapter, prefix);
            }
            catch (Exception e) {
                TRACER.traceThrowableT(500, "Failed to obtain the common logging configuration for component \"" + prefix + "\"!", (Throwable)e);
            }
            if (result == null) {
                result = new LogConfiguration();
            }
            repository.put((Object)adapter, (Object)result);
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private synchronized long adjustConfiguration(LogConfiguration addEditCfg, LogConfiguration removeCfg, boolean save, boolean clusterWide) {
        block122: {
            commonSettingsMap = save != false && clusterWide != false ? new HashMapObjectObject() : null;
            v0 = settingsMap = save != false ? new HashMapObjectObject() : null;
            if (removeCfg != null) {
                names = removeCfg.enumerateFormattersNames();
                while (names.hasMoreElements()) {
                    name = (String)names.nextElement();
                    deleteLFD = (LogFormatterDescriptor)this.mainConfiguration.removeLogFormatter(name);
                    if (deleteLFD == null || !save || (adapter = deleteLFD.getPersistenceAdapter()) == null) continue;
                    LogConfigurator.getConfigurationToSave(adapter, deleteLFD.getPrefix(), settingsMap).removeLogFormatter(name);
                    if (!clusterWide) continue;
                    LogConfigurator.getCommonConfigurationToSave((PersistenceAdapterExt)adapter, deleteLFD.getPrefix(), commonSettingsMap).removeLogFormatter(name);
                }
                names = removeCfg.enumerateDestinationsNames();
                while (names.hasMoreElements()) {
                    name = (String)names.nextElement();
                    deleteLDD = (LogDestinationDescriptor)this.mainConfiguration.removeLogDestination(name);
                    if (deleteLDD == null) continue;
                    deleteLDD.getRealLog().close();
                    if (!save) continue;
                    adapter = deleteLDD.getPersistenceAdapter();
                    if (addEditCfg != null && (ldd = addEditCfg.getLogDestination(name)) != null) {
                        ldd.setPersistenceAdapter(adapter);
                    }
                    if (adapter == null) continue;
                    LogConfigurator.getConfigurationToSave(adapter, deleteLDD.getPrefix(), settingsMap).removeLogDestination(name);
                    if (!clusterWide) continue;
                    LogConfigurator.getCommonConfigurationToSave((PersistenceAdapterExt)adapter, deleteLDD.getPrefix(), commonSettingsMap).removeLogDestination(name);
                }
                removedNames = removeCfg.getLogControllersNames();
                i = removedNames.length;
                while (--i >= 0) {
                    deleteLCD = (LogControllerDescriptor)this.mainConfiguration.removeLogController(removedNames[i]);
                    if (deleteLCD == null) continue;
                    realController = removedNames[i].startsWith("/") != false ? Category.getCategory((String)removedNames[i]) : Location.getLocation((String)removedNames[i]);
                    realController.setEffectiveSeverity();
                    realController.removeFilters();
                    destinationDescriptors = deleteLCD.getDestinations();
                    j = destinationDescriptors.length;
                    while (--j >= 0) {
                        dst = destinationDescriptors[j].getRealLog();
                        realController.removeLog(dst);
                    }
                    if (!save) continue;
                    adapter = deleteLCD.getPersistenceAdapter();
                    if (addEditCfg != null && (lcd = addEditCfg.getLogController(removedNames[i])) != null) {
                        lcd.setPersistenceAdapter(adapter);
                    }
                    if (adapter == null) continue;
                    LogConfigurator.getConfigurationToSave(adapter, null, settingsMap).removeLogController(removedNames[i]);
                    if (!clusterWide) continue;
                    LogConfigurator.getCommonConfigurationToSave((PersistenceAdapterExt)adapter, null, commonSettingsMap).removeLogController(removedNames[i]);
                }
                if (removedNames.length != 0) {
                    this.disableDbFiltering(removedNames);
                }
            }
            if (addEditCfg == null) break block122;
            formatterDescriptors = addEditCfg.getLogFormatters();
            i = formatterDescriptors.length;
            while (--i >= 0) {
                lfd = this.mainConfiguration.getLogFormatter(formatterDescriptors[i].toString());
                if (lfd == null) {
                    lfd = formatterDescriptors[i].getPersistenceAdapter() != null ? new LogFormatterDescriptor(formatterDescriptors[i].getPersistenceAdapter()) : new LogFormatterDescriptor(this.userDefinedAdapter);
                    lfd.setName(formatterDescriptors[i].getName());
                    lfd.setPrefix(formatterDescriptors[i].getPrefix());
                    this.mainConfiguration.addLogFormatter(lfd);
                }
                if ((formatterType = formatterDescriptors[i].getType()) == null || "".equals(formatterType)) {
                    formatterType = "TraceFormatter";
                }
                if (lfd.getRealFormatter() instanceof TraceFormatter && formatterType.equals(lfd.getType())) {
                    pattern = formatterDescriptors[i].getPattern();
                    if (pattern == null) {
                        pattern = LogFormatterDescriptor.DEFAULT_TRACEFORMATTER_PATTERN;
                    }
                    ((TraceFormatter)lfd.getRealFormatter()).setPattern(pattern);
                    lfd.setPattern(formatterDescriptors[i].getPattern());
                } else {
                    formatter = null;
                    lfd.setType(formatterType);
                    if ("TraceFormatter".equalsIgnoreCase(formatterType)) {
                        pattern = formatterDescriptors[i].getPattern();
                        if (pattern != null && !pattern.equals("")) {
                            formatter = new TraceFormatter(pattern);
                            lfd.setPattern(pattern);
                        } else {
                            formatter = new TraceFormatter();
                        }
                    } else if (formatterType.equalsIgnoreCase("XMLFormatter")) {
                        formatter = new XMLFormatter();
                    } else if (formatterType.equalsIgnoreCase("ListFormatter")) {
                        formatter = new ListFormatter();
                    } else {
                        try {
                            formatter = (Formatter)LogConfigurator.LOADER.loadClass(formatterType).newInstance();
                        }
                        catch (Exception e) {
                            this.mainConfiguration.removeLogFormatter(lfd.toString());
                            continue;
                        }
                    }
                    lfd.setRealFormatter((Formatter)formatter);
                    destinations = this.mainConfiguration.getLogDestinations();
                    j = destinations.length;
                    while (--j >= 0) {
                        if (destinations[j].getFormatter() != lfd) continue;
                        destinations[j].getRealLog().setFormatter((Formatter)formatter);
                    }
                }
                if (!save || (adapter = lfd.getPersistenceAdapter()) == null) continue;
                LogConfigurator.getConfigurationToSave(adapter, lfd.getPrefix(), settingsMap).addLogFormatter(lfd);
                if (!clusterWide) continue;
                LogConfigurator.getCommonConfigurationToSave((PersistenceAdapterExt)adapter, lfd.getPrefix(), commonSettingsMap).addLogFormatter(lfd);
            }
            destinationDescriptors = addEditCfg.getLogDestinations();
            i = destinationDescriptors.length;
            while (--i >= 0) {
                ldd = this.mainConfiguration.getLogDestination(destinationDescriptors[i].toString());
                if (ldd == null) {
                    ldd = destinationDescriptors[i].getPersistenceAdapter() != null ? new LogDestinationDescriptor(destinationDescriptors[i].getPersistenceAdapter()) : new LogDestinationDescriptor(this.userDefinedAdapter);
                    ldd.setName(destinationDescriptors[i].getName());
                    ldd.setPrefix(destinationDescriptors[i].getPrefix());
                    this.mainConfiguration.addLogDestination(ldd);
                }
                log = null;
                if (destinationDescriptors[i].getType().equals(ldd.getType()) && (!ldd.getType().equalsIgnoreCase("FileLog") || destinationDescriptors[i].getPattern().equals(ldd.getPattern()) && destinationDescriptors[i].getLimit() == ldd.getLimit() && destinationDescriptors[i].getCount() == ldd.getCount())) {
                    log = ldd.getRealLog();
                } else {
                    logType = destinationDescriptors[i].getType();
                    ldd.setType(logType);
                    if (logType.equals("FileLog")) {
                        ldd.setPattern(destinationDescriptors[i].getPattern());
                        if (destinationDescriptors[i].getLimit() != 0 && destinationDescriptors[i].getCount() != 0) {
                            log = new FileLog(destinationDescriptors[i].getPattern(), destinationDescriptors[i].getLimit(), destinationDescriptors[i].getCount());
                            ldd.setLimit(destinationDescriptors[i].getLimit());
                            ldd.setCount(destinationDescriptors[i].getCount());
                        } else {
                            log = new FileLog(destinationDescriptors[i].getPattern());
                            destinationDescriptors[i].setCount(0);
                            destinationDescriptors[i].setLimit(0);
                        }
                    } else if (logType.equals("ConsoleLog")) {
                        log = new StandardConsoleLog();
                        ldd.setPattern(null);
                        ldd.setLimit(0);
                        ldd.setCount(0);
                    } else {
                        try {
                            log = (Log)LogConfigurator.LOADER.loadClass(logType).newInstance();
                        }
                        catch (Exception e) {
                            this.mainConfiguration.removeLogDestination(ldd.toString());
                            continue;
                        }
                    }
                    oldLog = ldd.getRealLog();
                    if (oldLog != null) {
                        oldLog.close();
                        controllers = this.mainConfiguration.getLogControllers();
                        j = controllers.length;
                        while (--j >= 0) {
                            if (!controllers[j].containsDestination(ldd)) continue;
                            name = controllers[j].getName();
                            realController = name.startsWith("/") != false ? Category.getCategory((String)name) : Location.getLocation((String)name);
                            realController.removeLog(oldLog);
                            switch (controllers[j].getAssociationType(ldd)) {
                                case 2: {
                                    realController.addLocalLog(log);
                                    break;
                                }
                                case 0: {
                                    realController.addLog(log);
                                    break;
                                }
                                case 1: {
                                    realController.addPrivateLog(log);
                                }
                            }
                        }
                    }
                    ldd.setRealLog(log);
                }
                ldd.setEncoding(destinationDescriptors[i].getEncoding());
                if (destinationDescriptors[i].getEncoding() != null) {
                    log.setEncoding(destinationDescriptors[i].getEncoding());
                }
                ldd.setEffectiveSeverity(destinationDescriptors[i].getEffectiveSeverityInt());
                log.setEffectiveSeverity(destinationDescriptors[i].getEffectiveSeverityInt());
                formatterDescriptor = destinationDescriptors[i].getFormatter();
                if (formatterDescriptor != null) {
                    if (formatterDescriptor.getName() == null) {
                        anonym = new LogFormatterDescriptor();
                        formatterType = formatterDescriptor.getType();
                        anonym.setType(formatterType);
                        formatter = null;
                        if (formatterType.equalsIgnoreCase("TraceFormatter")) {
                            if (formatterDescriptor.getPattern() != null) {
                                formatter = new TraceFormatter(formatterDescriptor.getPattern());
                                anonym.setPattern(LogFormatterDescriptor.DEFAULT_TRACEFORMATTER_PATTERN);
                            } else {
                                formatter = new TraceFormatter();
                            }
                        } else if (formatterType.equalsIgnoreCase("XMLFormatter")) {
                            formatter = new XMLFormatter();
                        } else if (formatterType.equalsIgnoreCase("ListFormatter")) {
                            formatter = new ListFormatter();
                        } else {
                            try {
                                formatter = (Formatter)LogConfigurator.LOADER.loadClass(formatterType).newInstance();
                            }
                            catch (Exception exc) {
                                anonym = null;
                            }
                        }
                        if (formatter != null && anonym != null) {
                            anonym.setRealFormatter((Formatter)formatter);
                            ldd.setFormatter(anonym);
                            log.setFormatter((Formatter)formatter);
                        }
                    } else {
                        lfd = this.mainConfiguration.getLogFormatter(formatterDescriptor.toString());
                        ldd.setFormatter(lfd);
                        if (lfd != null) {
                            log.setFormatter(lfd.getRealFormatter());
                        }
                    }
                } else {
                    anonym = new LogFormatterDescriptor();
                    f = null;
                    if (ldd.getType().equalsIgnoreCase("ConsoleLog")) {
                        anonym.setType("TraceFormatter");
                        anonym.setPattern(LogFormatterDescriptor.DEFAULT_TRACEFORMATTER_PATTERN);
                        f = new TraceFormatter();
                    } else {
                        anonym.setType("ListFormatter");
                        f = new ListFormatter();
                    }
                    anonym.setRealFormatter((Formatter)f);
                    ldd.setFormatter(anonym);
                    log.setFormatter((Formatter)f);
                }
                filters = destinationDescriptors[i].getFilters();
                j = filters.length;
                while (--j >= 0) {
                    if (ldd.containsFilter(filters[j])) continue;
                    try {
                        log.addFilter((Filter)LogConfigurator.LOADER.loadClass(filters[j]).newInstance());
                        ldd.addFilter(filters[j]);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (!save || (adapter = ldd.getPersistenceAdapter()) == null) continue;
                LogConfigurator.getConfigurationToSave(adapter, ldd.getPrefix(), settingsMap).addLogDestination(ldd);
                if (!clusterWide) continue;
                LogConfigurator.getCommonConfigurationToSave((PersistenceAdapterExt)adapter, ldd.getPrefix(), commonSettingsMap).addLogDestination(ldd);
            }
            controllerDescriptors = addEditCfg.getLogControllers();
            removedFromFilter = new ArrayObject();
            addedToFilter = new ArrayObject();
            i = controllerDescriptors.length;
            while (--i >= 0) {
                block126: {
                    block125: {
                        block124: {
                            block123: {
                                name = controllerDescriptors[i].getName();
                                lcd = this.mainConfiguration.getLogController(name);
                                if (lcd == null) {
                                    lcd = controllerDescriptors[i].getPersistenceAdapter() != null ? new LogControllerDescriptor(controllerDescriptors[i].getPersistenceAdapter()) : new LogControllerDescriptor(this.userDefinedAdapter);
                                    lcd.setName(name);
                                    this.mainConfiguration.addLogController(lcd);
                                    if (!controllerDescriptors[i].hasDBLog()) {
                                        addedToFilter.add((Object)name);
                                        lcd.setDBLog(false);
                                    }
                                } else {
                                    oldDbLogValue = lcd.hasDBLog();
                                    if (oldDbLogValue != (newDbLogValue = controllerDescriptors[i].hasDBLog())) {
                                        if (oldDbLogValue) {
                                            addedToFilter.add((Object)name);
                                        } else {
                                            removedFromFilter.add((Object)name);
                                        }
                                        lcd.setDBLog(newDbLogValue);
                                    }
                                }
                                realController = null;
                                relativeNames = controllerDescriptors[i].getRelativeControllersNames();
                                if (!name.startsWith("/")) break block123;
                                realController = realCategory = Category.getCategory((String)name);
                                if (relativeNames.length <= 0) break block124;
                                min = controllerDescriptors[i].getMinRelativeSeverity(relativeNames[0]);
                                max = controllerDescriptors[i].getMaxRelativeSeverity(relativeNames[0]);
                                lcd.setMinRelativeSeverity(relativeNames[0], min);
                                lcd.setMaxRelativeSeverity(relativeNames[0], max);
                                if (this.noLogging) break block124;
                                realCategory.setMinimumSeverity(Location.getLocation((String)relativeNames[0]), min);
                                realCategory.setMaximumSeverity(Location.getLocation((String)relativeNames[0]), max);
                                break block124;
                            }
                            realLocation = Location.getLocation((String)name);
                            realController = realLocation;
                            j = 0;
                            while (j < relativeNames.length) {
                                min = controllerDescriptors[i].getMinRelativeSeverity(relativeNames[j]);
                                max = controllerDescriptors[i].getMaxRelativeSeverity(relativeNames[j]);
                                lcd.setMinRelativeSeverity(relativeNames[j], min);
                                lcd.setMaxRelativeSeverity(relativeNames[j], max);
                                if (!this.noLogging) {
                                    realLocation.setMinimumSeverity(Category.getCategory((String)relativeNames[j]), min);
                                    realLocation.setMaximumSeverity(Category.getCategory((String)relativeNames[j]), max);
                                }
                                ++j;
                            }
                        }
                        lcd.setBundleName(controllerDescriptors[i].getBundleName());
                        realController.setResourceBundleName(controllerDescriptors[i].getBundleName());
                        lcd.setMinSeverity(controllerDescriptors[i].getMinSeverityInt());
                        lcd.setMaxSeverity(controllerDescriptors[i].getMaxSeverityInt());
                        state = controllerDescriptors[i].getState();
                        lcd.setState(state);
                        lcd.setStateOwner(controllerDescriptors[i].getStateOwner());
                        if (this.noLogging || state == -1) {
                            realController.setEffectiveSeverity(701);
                        } else if (state == 1) {
                            realController.setEffectiveSeverity(0);
                        } else {
                            realController.setMinimumSeverity(controllerDescriptors[i].getMinSeverityInt());
                            realController.setMaximumSeverity(controllerDescriptors[i].getMaxSeverityInt());
                        }
                        filters = controllerDescriptors[i].getFilters();
                        j = filters.length;
                        while (--j >= 0) {
                            if (lcd.containsFilter(filters[j])) continue;
                            try {
                                realController.addFilter((Filter)LogConfigurator.LOADER.loadClass(filters[j]).newInstance());
                                lcd.addFilter(filters[j]);
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                        associatedDestinations = controllerDescriptors[i].getAssociatedDestinations();
                        destinations = new LogDestinationDescriptor[associatedDestinations.size()];
                        destinations = (LogDestinationDescriptor[])associatedDestinations.getAllKeys(destinations, 0);
                        excludedController = true;
                        if (!(realController instanceof Location) || !this.logManager.singleTraceFileIsForced()) break block125;
                        excludedController = this.logManager.isSingleTraceFileExcluded(realController.getName());
                        if (excludedController) {
                            realController.removeLog((Log)this.logManager.getDefaultTraceFile());
                        }
                        j = destinations.length;
                        while (--j >= 0) {
                            block120: {
                                log = null;
                                ldd = destinations[j];
                                if (ldd.getName() != null) ** GOTO lbl339
                                destinationType = ldd.getType();
                                if ("ConsoleLog".equalsIgnoreCase(destinationType)) {
                                    log = new StandardConsoleLog();
                                } else {
                                    try {
                                        log = (Log)LogConfigurator.LOADER.loadClass(destinationType).newInstance();
                                        break block120;
                                    }
                                    catch (Exception e) {
                                        continue;
                                    }
lbl339:
                                    // 1 sources

                                    ldd = this.mainConfiguration.getLogDestination(ldd.toString());
                                    log = ldd.getRealLog();
                                    if (!excludedController && log instanceof FileLog) continue;
                                }
                            }
                            if (log == null || ldd == null) continue;
                            ldd.setRealLog(log);
                            assType = associatedDestinations.get(destinations[j]);
                            lcd.addDestination((LogDestinationDescriptor)ldd, assType);
                            switch (assType) {
                                case 2: {
                                    realController.addLocalLog(log);
                                    break;
                                }
                                case 0: {
                                    realController.addLog(log);
                                    break;
                                }
                                case 1: {
                                    realController.addPrivateLog(log);
                                }
                            }
                        }
                        break block126;
                    }
                    j = destinations.length;
                    while (--j >= 0) {
                        block121: {
                            log = null;
                            ldd = destinations[j];
                            if (ldd.getName() != null) ** GOTO lbl373
                            destinationType = ldd.getType();
                            if ("ConsoleLog".equalsIgnoreCase(destinationType)) {
                                log = new StandardConsoleLog();
                            } else {
                                try {
                                    log = (Log)LogConfigurator.LOADER.loadClass(destinationType).newInstance();
                                    break block121;
                                }
                                catch (Exception e) {
                                    continue;
                                }
lbl373:
                                // 1 sources

                                ldd = this.mainConfiguration.getLogDestination(ldd.toString());
                                log = ldd.getRealLog();
                            }
                        }
                        if (log == null || ldd == null) continue;
                        ldd.setRealLog(log);
                        assType = associatedDestinations.get(destinations[j]);
                        lcd.addDestination((LogDestinationDescriptor)ldd, assType);
                        switch (assType) {
                            case 2: {
                                realController.addLocalLog(log);
                                break;
                            }
                            case 0: {
                                realController.addLog(log);
                                break;
                            }
                            case 1: {
                                realController.addPrivateLog(log);
                            }
                        }
                    }
                }
                if (!save || (adapter = lcd.getPersistenceAdapter()) == null) continue;
                configToSave = LogConfigurator.getConfigurationToSave(adapter, null, settingsMap);
                descrFromXml = (LogControllerDescriptor)configToSave.removeLogController(lcd.getName());
                descrToSave = lcd;
                if (!excludedController && descrFromXml != null) {
                    descrToSave = (LogControllerDescriptor)lcd.clone();
                    destsFromXml = descrFromXml.getDestinations();
                    j = destsFromXml.length;
                    while (--j >= 0) {
                        if (!"FileLog".equals(destsFromXml[j].getType())) continue;
                        descrToSave.addDestination(destsFromXml[j], descrFromXml.getAssociationType(destsFromXml[j]));
                    }
                }
                configToSave.addLogController(descrToSave);
                if (!clusterWide) continue;
                configToSave = LogConfigurator.getCommonConfigurationToSave((PersistenceAdapterExt)adapter, null, commonSettingsMap);
                descrFromXml = (LogControllerDescriptor)configToSave.removeLogController(lcd.getName());
                descrToSave = lcd;
                if (!excludedController && descrFromXml != null) {
                    descrToSave = (LogControllerDescriptor)lcd.clone();
                    destsFromXml = descrFromXml.getDestinations();
                    j = destsFromXml.length;
                    while (--j >= 0) {
                        if (!"FileLog".equals(destsFromXml[j].getType())) continue;
                        descrToSave.addDestination(destsFromXml[j], descrFromXml.getAssociationType(destsFromXml[j]));
                    }
                }
                configToSave.addLogController(descrToSave);
            }
            if (removedFromFilter.size() != 0) {
                removedNames = new String[removedFromFilter.size()];
                removedFromFilter.copyInto(removedNames);
                this.disableDbFiltering((String[])removedNames);
            }
            if (addedToFilter.size() != 0) {
                addedNames = new String[addedToFilter.size()];
                addedToFilter.copyInto(addedNames);
                this.enableDbFiltering((String[])addedNames);
            }
        }
        if (save) {
            adapters = (PersistenceAdapterExt[])settingsMap.getAllKeys((Object[])new PersistenceAdapterExt[settingsMap.size()]);
            i = adapters.length;
            while (--i >= 0) {
                config = (LogConfiguration)settingsMap.get((Object)adapters[i]);
                try {
                    out = new ByteArrayOutputStream();
                    LogXMLParser.writeToXml(out, config, false);
                    adapters[i].setPersistentEntryStream(new ByteArrayInputStream(out.toByteArray()));
                }
                catch (Exception e) {
                    LogConfigurator.TRACER.traceThrowableT(500, "Failed to update the logging configuration for a certain component!", (Throwable)e);
                }
            }
            if (clusterWide) {
                adapters = (PersistenceAdapterExt[])commonSettingsMap.getAllKeys((Object[])new PersistenceAdapterExt[commonSettingsMap.size()]);
                i = adapters.length;
                while (--i >= 0) {
                    config = (LogConfiguration)commonSettingsMap.get((Object)adapters[i]);
                    try {
                        out = new ByteArrayOutputStream();
                        LogXMLParser.writeToXml(out, config, false);
                        adapters[i].setCommonPersistentEntryStream(new ByteArrayInputStream(out.toByteArray()));
                    }
                    catch (Exception e) {
                        LogConfigurator.TRACER.traceThrowableT(500, "Failed to update the common logging configuration for a certain component!", (Throwable)e);
                    }
                }
            }
        }
        if (clusterWide) {
            try {
                message = this.serialize(addEditCfg, removeCfg);
                messageType = save != false ? 0 : 1;
                this.messageContext.send(-1, this.clusterNodeType, messageType, message, 0, message.length);
            }
            catch (Exception exc) {
                LogConfigurator.TRACER.traceThrowableT(500, "Failed to distribute configuration change request!", (Throwable)exc);
            }
        }
        return this.getNextVersion();
    }

    private long getNextVersion() {
        ++this.configVersion;
        this.configVersion &= Long.MAX_VALUE;
        HashMapIntObject hashMapIntObject = this.listeners;
        synchronized (hashMapIntObject) {
            EnumerationInt listenersKeys = this.listeners.keys();
            Enumeration elements = this.listeners.elements();
            while (elements.hasMoreElements()) {
                try {
                    ((LogConfiguratorListener)elements.nextElement()).configurationChanged(this.configVersion);
                    listenersKeys.nextElement();
                }
                catch (RemoteException rexc) {
                    TRACER.traceThrowableT(500, "Failed to notify one of the listeners for changed log configuration!", (Throwable)rexc);
                    this.listeners.remove(listenersKeys.nextElement());
                }
            }
        }
        return this.configVersion;
    }

    public synchronized long unconfigure(LogConfiguration configuration) {
        if (configuration == null) {
            return this.configVersion;
        }
        String[] names = configuration.getLogFormattersNames();
        int i = names.length;
        while (--i >= 0) {
            this.mainConfiguration.removeLogFormatter(names[i]);
        }
        names = configuration.getLogDestinationsNames();
        int i2 = names.length;
        while (--i2 >= 0) {
            LogDestinationDescriptor dstDescr = (LogDestinationDescriptor)this.mainConfiguration.removeLogDestination(names[i2]);
            if (dstDescr == null) continue;
            dstDescr.getRealLog().close();
        }
        names = configuration.getLogControllersNames();
        int i3 = names.length;
        while (--i3 >= 0) {
            this.removeLogController(names[i3]);
        }
        return this.getNextVersion();
    }

    private void removeLogController(String name) {
        LogControllerDescriptor controllerDescriptor = (LogControllerDescriptor)this.mainConfiguration.removeLogController(name);
        if (controllerDescriptor != null) {
            Category realController = name.startsWith("/") ? Category.getCategory((String)name) : Location.getLocation((String)name);
            realController.setEffectiveSeverity();
            realController.removeFilters();
            LogDestinationDescriptor[] destinationDescriptors = controllerDescriptor.getDestinations();
            int j = destinationDescriptors.length;
            while (--j >= 0) {
                Log dst = destinationDescriptors[j].getRealLog();
                realController.removeLog(dst);
            }
        }
    }

    public synchronized LogConfiguration getCurrentConfiguration() {
        return this.mainConfiguration;
    }

    public LogConfiguration getDefaultConfiguration() {
        return this.getDefaultConfiguration(false, true, false);
    }

    public LogConfiguration resetToDefaultConfiguration() {
        return this.getDefaultConfiguration(true, false, true);
    }

    /*
     * Unable to fully structure code
     */
    private synchronized LogConfiguration getDefaultConfiguration(boolean resetCurrent, boolean leaveClusterWideChanges, boolean distribute) {
        block9: {
            adaptersMap = new HashMapObjectObject();
            defaultConfiguration = resetCurrent != false ? new LogConfiguration(this.configVersion + 1L) : new LogConfiguration();
            elements = this.mainConfiguration.enumerateLogControllers();
            while (elements.hasMoreElements()) {
                descriptor = (LogControllerDescriptor)elements.nextElement();
                adapter = descriptor.getPersistenceAdapter();
                prefix = this.findPrefix(descriptor);
                if (prefix == null) {
                    prefix = "";
                }
                adaptersMap.put((Object)adapter, (Object)prefix);
            }
            adapters = adaptersMap.keys();
            elements = adaptersMap.elements();
            if (!resetCurrent) ** GOTO lbl45
            while (adapters.hasMoreElements()) {
                adapter = (PersistenceAdapterExt)adapters.nextElement();
                adapter.removePersistentEntryStream(leaveClusterWideChanges == false);
                componentConfiguration = LogXMLParser.extractConfiguration(adapter, (String)elements.nextElement());
                if (componentConfiguration == null) continue;
                defaultConfiguration.addLogConfiguration(componentConfiguration);
            }
            if (distribute) {
                try {
                    this.messageContext.send(-1, this.clusterNodeType, 2, LogConfigurator.EMPTY_MESSAGE_BODY, 0, LogConfigurator.EMPTY_MESSAGE_BODY_LENGTH);
                }
                catch (Exception exc) {
                    LogConfigurator.TRACER.traceThrowableT(500, "Failed to distribute configuration reset request!", (Throwable)exc);
                }
            }
            Location.getRoot().resetAll();
            Category.getRoot().resetAll();
            elements = this.mainConfiguration.enumerateLogDestinations();
            while (elements.hasMoreElements()) {
                ((LogDestinationDescriptor)elements.nextElement()).getRealLog().close();
            }
            defaultTraceFile = this.logManager.getDefaultTraceFile();
            if (defaultTraceFile != null) {
                Location.getRoot().addLog((Log)defaultTraceFile);
            }
            this.mainConfiguration.clear();
            this.applyConfiguration(defaultConfiguration);
            break block9;
lbl-1000:
            // 1 sources

            {
                adapter = (PersistenceAdapter)adapters.nextElement();
                defaultConfiguration.addLogConfiguration(new LogXMLParser().parse(adapter.getDefaultPersistentEntryStream(), adapter, (String)elements.nextElement()));
lbl45:
                // 2 sources

                ** while (adapters.hasMoreElements())
            }
        }
        return defaultConfiguration;
    }

    public LogControllerDescriptor getDefaultConfigurationPerController(String logControllerName) {
        try {
            LogControllerDescriptor oldDescriptor = this.mainConfiguration.getLogController(logControllerName);
            PersistenceAdapter persistenceAdapter = oldDescriptor.getPersistenceAdapter();
            InputStream input = persistenceAdapter.getDefaultPersistentEntryStream();
            LogConfiguration defaultConfiguration = new LogXMLParser().parse(input, persistenceAdapter, this.findPrefix(oldDescriptor));
            input.close();
            LogControllerDescriptor result = defaultConfiguration.getLogController(logControllerName);
            if (!logControllerName.startsWith("/") && this.logManager.singleTraceFileIsForced() && !this.logManager.isSingleTraceFileExcluded(logControllerName)) {
                LogDestinationDescriptor[] dests = result.getDestinations();
                int j = dests.length;
                while (--j >= 0) {
                    if (!"FileLog".equals(dests[j].getType())) continue;
                    result.removeDestination(dests[j]);
                }
            }
            return result;
        }
        catch (Exception exc) {
            TRACER.traceThrowableT(200, "Failed to obtain default configuration for log controller \"" + logControllerName + "\"!", (Throwable)exc);
            return null;
        }
    }

    private String findPrefix(LogControllerDescriptor controller) {
        Enumeration logs = controller.getAssociatedDestinations().keys();
        if (logs.hasMoreElements()) {
            return ((LogDestinationDescriptor)logs.nextElement()).getPrefix();
        }
        return null;
    }

    public void registerManagementListener(ManagementListener managementListener) {
    }

    public int registerListener(LogConfiguratorListener listener) {
        HashMapIntObject hashMapIntObject = this.listeners;
        synchronized (hashMapIntObject) {
            this.listeners.put(this.nextListenerId, (Object)listener);
            int n = this.nextListenerId++;
            return n;
        }
    }

    public void unregisterListener(int listenerID) {
        HashMapIntObject hashMapIntObject = this.listeners;
        synchronized (hashMapIntObject) {
            this.listeners.remove(listenerID);
        }
    }

    public synchronized void enableLogging() {
        if (this.noLogging) {
            LogControllerDescriptor[] controllers = this.mainConfiguration.getLogControllers();
            int i = 0;
            while (i < controllers.length) {
                String name = controllers[i].getName();
                String[] relativeNames = controllers[i].getRelativeControllersNames();
                if (name.startsWith("/")) {
                    Category realCategory = Category.getCategory((String)name);
                    realCategory.setMinimumSeverity(controllers[i].getMinSeverityInt());
                    realCategory.setMaximumSeverity(controllers[i].getMaxSeverityInt());
                    if (relativeNames.length > 0) {
                        realCategory.setMinimumSeverity(Location.getLocation((String)relativeNames[0]), controllers[i].getMinRelativeSeverity(relativeNames[0]));
                        realCategory.setMaximumSeverity(Location.getLocation((String)relativeNames[0]), controllers[i].getMaxRelativeSeverity(relativeNames[0]));
                    }
                } else {
                    Location realLocation = Location.getLocation((String)name);
                    realLocation.setMinimumSeverity(controllers[i].getMinSeverityInt());
                    realLocation.setMaximumSeverity(controllers[i].getMaxSeverityInt());
                    int j = 0;
                    while (j < relativeNames.length) {
                        if (!this.noLogging) {
                            realLocation.setMinimumSeverity(Category.getCategory((String)relativeNames[j]), controllers[i].getMinRelativeSeverity(relativeNames[j]));
                            realLocation.setMaximumSeverity(Category.getCategory((String)relativeNames[j]), controllers[i].getMaxRelativeSeverity(relativeNames[j]));
                        }
                        ++j;
                    }
                }
                ++i;
            }
            this.noLogging = false;
        }
    }

    public synchronized void disableLogging() {
        if (this.noLogging) {
            return;
        }
        LogControllerDescriptor[] controllers = this.mainConfiguration.getLogControllers();
        int i = 0;
        while (i < controllers.length) {
            String name = controllers[i].getName();
            String[] relativeNames = controllers[i].getRelativeControllersNames();
            if (name.startsWith("/")) {
                Category realCategory = Category.getCategory((String)name);
                realCategory.setEffectiveSeverity(701);
                if (relativeNames.length > 0) {
                    realCategory.setEffectiveSeverity(Location.getLocation((String)relativeNames[0]), 701);
                }
            } else {
                Location realLocation = Location.getLocation((String)name);
                realLocation.setEffectiveSeverity(701);
                int j = 0;
                while (j < relativeNames.length) {
                    if (!this.noLogging) {
                        realLocation.setEffectiveSeverity(Category.getCategory((String)relativeNames[j]), 701);
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.noLogging = true;
    }

    public synchronized boolean isLoggingDisabled() {
        return this.noLogging;
    }

    public boolean isSQLTrace() {
        return SQLTrace.isOn();
    }

    public void setSQLTrace(boolean newStatus) {
        if (newStatus) {
            SQLTrace.onJ2ee();
        } else {
            SQLTrace.off();
        }
    }

    public synchronized String[] getLogControllersNames() {
        return this.mainConfiguration.getLogControllersNames();
    }

    public synchronized String[] getPhysicalNames() {
        int i;
        List fileNames;
        LogDestinationDescriptor[] destinations = this.mainConfiguration.getLogDestinations();
        Set names = new Set(destinations.length);
        int j = destinations.length;
        while (--j >= 0) {
            Log realLog = destinations[j].getRealLog();
            if (!(realLog instanceof FileLog)) continue;
            fileNames = ((FileLog)realLog).calculateFileNames();
            i = fileNames.size();
            while (--i >= 0) {
                names.add(fileNames.get(i));
            }
        }
        FileLog defaultTraceFile = this.logManager.getDefaultTraceFile();
        if (defaultTraceFile != null) {
            fileNames = defaultTraceFile.calculateFileNames();
            i = fileNames.size();
            while (--i >= 0) {
                names.add(fileNames.get(i));
            }
        }
        return (String[])names.toArray((Object[])new String[names.size()]);
    }

    public long getFileSize(String fileName) {
        return new File(fileName).length();
    }

    public synchronized int getLoggedCount(String controllerName) {
        LogController controller = this.getLogController(controllerName);
        if (controller == null) {
            return 0;
        }
        return controller.getLoggedCount();
    }

    public void unregisterLogController(String name) {
        this.mainConfiguration.removeLogController(name);
        this.getNextVersion();
    }

    public void unregisterLog(String name) {
        this.mainConfiguration.removeLogDestination(name);
        this.getNextVersion();
    }

    public void unregisterFormatter(String name) {
        this.mainConfiguration.removeLogFormatter(name);
        this.getNextVersion();
    }

    private void addNameAndAdapter(LogConfiguration configuration, String componentName, PersistenceAdapter adapter) {
        if (configuration == null) {
            return;
        }
        LogFormatterDescriptor[] lfd = configuration.getLogFormatters();
        int i = 0;
        while (i < lfd.length) {
            lfd[i].setPersistenceAdapter(adapter);
            lfd[i].setPrefix(componentName);
            ++i;
        }
        LogDestinationDescriptor[] ldd = configuration.getLogDestinations();
        int i2 = 0;
        while (i2 < ldd.length) {
            ldd[i2].setPersistenceAdapter(adapter);
            ldd[i2].setPrefix(componentName);
            ++i2;
        }
        LogControllerDescriptor[] lcd = configuration.getLogControllers();
        int i3 = 0;
        while (i3 < lcd.length) {
            ldd[i3].setPersistenceAdapter(adapter);
            ++i3;
        }
    }

    public String archive(String[] names, boolean defaultTracesSelected, String archiveDir) {
        LogDestinationDescriptor[] ldd = new LogDestinationDescriptor[names.length];
        int i = names.length;
        while (--i >= 0) {
            ldd[i] = this.mainConfiguration.getLogDestination(names[i]);
        }
        return new Archivator(this).archive(ldd, defaultTracesSelected, archiveDir, false, null, null);
    }

    public long applyConfiguration(Properties properties) {
        LogConfiguration configuration = null;
        try {
            configuration = LogConfiguration.readFromProperties((Properties)properties);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.adjustConfiguration(configuration, null, false, false);
    }

    public long applyConfiguration(String configurationFileName) {
        LogConfiguration configuration = null;
        try {
            configuration = new LogXMLParser().parse(new FileInputStream(configurationFileName));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.adjustConfiguration(configuration, null, false, false);
    }

    public long applyConfiguration(LogConfiguration configuration) {
        return this.adjustConfiguration(configuration, null, false, false);
    }

    public long applyConfiguration(LogConfiguration addEditCfg, LogConfiguration removeCfg) {
        return this.adjustConfiguration(addEditCfg, removeCfg, false, false);
    }

    public long applyConfiguration(LogConfiguration addEditCfg, LogConfiguration removeCfg, String componentName, PersistenceAdapter adapter) {
        this.addNameAndAdapter(addEditCfg, componentName, adapter);
        this.addNameAndAdapter(removeCfg, componentName, adapter);
        return this.adjustConfiguration(addEditCfg, removeCfg, false, false);
    }

    public long applyAndStoreConfiguration(LogConfiguration configuration) {
        return this.adjustConfiguration(configuration, null, true, false);
    }

    public long applyAndStoreConfiguration(LogConfiguration addEditCfg, LogConfiguration removeCfg) {
        return this.adjustConfiguration(addEditCfg, removeCfg, true, false);
    }

    public long applyConfiguration(LogConfiguration newSettings, LogConfiguration removedSettings, boolean clusterWide) {
        return this.adjustConfiguration(newSettings, removedSettings, false, clusterWide);
    }

    public long applyAndStoreConfiguration(LogConfiguration newSettings, LogConfiguration removedSettings, boolean clusterWide) {
        return this.adjustConfiguration(newSettings, removedSettings, true, clusterWide);
    }

    public long modifyDefaultConfiguration(LogConfiguration newSettings, LogConfiguration removedSettings) {
        return this.modifyDefaultConfiguration(newSettings, removedSettings, true);
    }

    public synchronized long modifyDefaultConfiguration(LogConfiguration newSettings, LogConfiguration removedSettings, boolean applyToCurrent) {
        LogConfiguration configToSave;
        PersistenceAdapter adapter;
        Enumeration elements;
        HashMapObjectObject settingsToSave = new HashMapObjectObject();
        if (removedSettings != null) {
            elements = removedSettings.enumerateLogFormatters();
            while (elements.hasMoreElements()) {
                LogFormatterDescriptor deleteLFD = (LogFormatterDescriptor)elements.nextElement();
                adapter = deleteLFD.getPersistenceAdapter();
                if (adapter == null && (deleteLFD = this.mainConfiguration.getLogFormatter(deleteLFD.toString())) != null) {
                    adapter = deleteLFD.getPersistenceAdapter();
                }
                if (adapter == null || (configToSave = LogConfigurator.getDefaultConfigurationToSave(adapter, deleteLFD.getPrefix(), settingsToSave)) == null) continue;
                configToSave.removeLogFormatter(deleteLFD.toString());
            }
            elements = removedSettings.enumerateLogDestinations();
            while (elements.hasMoreElements()) {
                LogDestinationDescriptor deleteLDD = (LogDestinationDescriptor)elements.nextElement();
                adapter = deleteLDD.getPersistenceAdapter();
                if (adapter == null && (deleteLDD = this.mainConfiguration.getLogDestination(deleteLDD.toString())) != null) {
                    adapter = deleteLDD.getPersistenceAdapter();
                }
                if (adapter == null || (configToSave = LogConfigurator.getDefaultConfigurationToSave(adapter, deleteLDD.getPrefix(), settingsToSave)) == null) continue;
                configToSave.removeLogDestination(deleteLDD.toString());
            }
            elements = removedSettings.enumerateLogControllers();
            while (elements.hasMoreElements()) {
                LogControllerDescriptor deleteLCD = (LogControllerDescriptor)elements.nextElement();
                adapter = deleteLCD.getPersistenceAdapter();
                if (adapter == null && (deleteLCD = this.mainConfiguration.getLogController(deleteLCD.getName())) != null) {
                    adapter = deleteLCD.getPersistenceAdapter();
                }
                if (adapter == null || (configToSave = LogConfigurator.getDefaultConfigurationToSave(adapter, null, settingsToSave)) == null) continue;
                configToSave.removeLogController(deleteLCD.getName());
            }
        }
        if (newSettings != null) {
            elements = newSettings.enumerateLogFormatters();
            while (elements.hasMoreElements()) {
                LogFormatterDescriptor lfd = (LogFormatterDescriptor)elements.nextElement();
                adapter = lfd.getPersistenceAdapter();
                if (adapter == null) {
                    LogFormatterDescriptor elfd = this.mainConfiguration.getLogFormatter(lfd.toString());
                    if (elfd != null) {
                        adapter = elfd.getPersistenceAdapter();
                    }
                    if (adapter == null) {
                        adapter = this.userDefinedAdapter;
                    }
                }
                if ((configToSave = LogConfigurator.getDefaultConfigurationToSave(adapter, lfd.getPrefix(), settingsToSave)) == null) continue;
                configToSave.addLogFormatter(lfd);
            }
            elements = newSettings.enumerateLogDestinations();
            while (elements.hasMoreElements()) {
                LogDestinationDescriptor ldd = (LogDestinationDescriptor)elements.nextElement();
                adapter = ldd.getPersistenceAdapter();
                if (adapter == null) {
                    LogDestinationDescriptor eldd = this.mainConfiguration.getLogDestination(ldd.toString());
                    if (eldd != null) {
                        adapter = eldd.getPersistenceAdapter();
                    }
                    if (adapter == null) {
                        adapter = this.userDefinedAdapter;
                    }
                }
                if ((configToSave = LogConfigurator.getDefaultConfigurationToSave(adapter, ldd.getPrefix(), settingsToSave)) == null) continue;
                configToSave.addLogDestination(ldd);
            }
            elements = newSettings.enumerateLogControllers();
            while (elements.hasMoreElements()) {
                LogControllerDescriptor lcd = (LogControllerDescriptor)elements.nextElement();
                adapter = lcd.getPersistenceAdapter();
                if (adapter == null) {
                    LogControllerDescriptor elcd = this.mainConfiguration.getLogController(lcd.getName());
                    if (elcd != null) {
                        adapter = elcd.getPersistenceAdapter();
                    }
                    if (adapter == null) {
                        adapter = this.userDefinedAdapter;
                    }
                }
                if ((configToSave = LogConfigurator.getDefaultConfigurationToSave(adapter, null, settingsToSave)) == null) continue;
                configToSave.addLogController(lcd);
            }
        }
        PersistenceAdapterExt[] adapters = (PersistenceAdapterExt[])settingsToSave.getAllKeys((Object[])new PersistenceAdapterExt[settingsToSave.size()]);
        int i = adapters.length;
        while (--i >= 0) {
            LogConfiguration config = (LogConfiguration)settingsToSave.get((Object)adapters[i]);
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                LogXMLParser.writeToXml(out, config, false);
                adapters[i].setDefaultPersistentEntryStream(new ByteArrayInputStream(out.toByteArray()));
            }
            catch (Exception e) {
                TRACER.traceThrowableT(500, "Failed to update the default logging configuration for a certain component!", (Throwable)e);
            }
        }
        return applyToCurrent ? this.adjustConfiguration(newSettings, removedSettings, false, true) : -1L;
    }

    private static LogConfiguration getDefaultConfigurationToSave(PersistenceAdapter adapter, String prefix, HashMapObjectObject repository) {
        LogConfiguration result = (LogConfiguration)repository.get((Object)adapter);
        if (result == null) {
            try {
                result = new LogXMLParser().parse(adapter.getDefaultPersistentEntryStream(), adapter, prefix);
                repository.put((Object)adapter, (Object)result);
            }
            catch (Exception e) {
                TRACER.traceThrowableT(500, "Failed to obtain the default logging configuration for component \"" + prefix + "\"!", (Throwable)e);
            }
        }
        return result;
    }

    public void setDatabaseFilter(Object dbFilter) {
        try {
            ArrayObject arrayObject = this.awaitingDbFilter;
            synchronized (arrayObject) {
                this.dbFilterEnableMethod = dbFilter.getClass().getDeclaredMethod("enableFiltering", array$Ljava$lang$String == null ? (array$Ljava$lang$String = LogConfigurator.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
                this.dbFilterDisableMethod = dbFilter.getClass().getDeclaredMethod("disableFiltering", array$Ljava$lang$String == null ? (array$Ljava$lang$String = LogConfigurator.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
                this.dbFilter = dbFilter;
                if (this.awaitingDbFilter.size() != 0) {
                    Object[] awaitingNames = new String[this.awaitingDbFilter.size()];
                    this.awaitingDbFilter.copyInto(awaitingNames);
                    this.awaitingDbFilter.clear();
                    this.awaitingDbFilter.trimToSize();
                    this.dbFilterEnableMethod.invoke(dbFilter, new Object[]{awaitingNames});
                } else {
                    this.awaitingDbFilter.trimToSize();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void enableDbFiltering(String[] targets) {
        try {
            ArrayObject arrayObject = this.awaitingDbFilter;
            synchronized (arrayObject) {
                if (this.dbFilter == null) {
                    this.awaitingDbFilter.addAll((Object[])targets);
                } else {
                    this.dbFilterEnableMethod.invoke(this.dbFilter, new Object[]{targets});
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void disableDbFiltering(String[] targets) {
        try {
            ArrayObject arrayObject = this.awaitingDbFilter;
            synchronized (arrayObject) {
                if (this.dbFilter == null) {
                    int i = targets.length;
                    while (--i >= 0) {
                        this.awaitingDbFilter.remove((Object)targets[i]);
                    }
                } else {
                    this.dbFilterDisableMethod.invoke(this.dbFilter, new Object[]{targets});
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String archiveAllLogs(String archiveFileName, String fileLogsZipPath, String[] fileLogPatterns, boolean includeDefaultTraceFile) {
        try {
            FileLog defaultTraceFile;
            ZipOutputStream zout = new ZipOutputStream(new FileOutputStream(archiveFileName));
            String result = "";
            byte[] buffer = new byte[1024];
            if (includeDefaultTraceFile && (defaultTraceFile = this.logManager.getDefaultTraceFile()) != null) {
                result = result + LogConfigurator.addToZip(defaultTraceFile, fileLogsZipPath, zout, buffer);
            }
            LogDestinationDescriptor[] destinations = this.mainConfiguration.getLogDestinations();
            int i = destinations.length;
            block2: while (--i >= 0) {
                Log dst = destinations[i].getRealLog();
                if (!(dst instanceof FileLog)) continue;
                String pattern = destinations[i].getPattern();
                int j = fileLogPatterns.length;
                while (--j >= 0) {
                    if (!pattern.equals(fileLogPatterns[j])) continue;
                    result = result + LogConfigurator.addToZip((FileLog)dst, fileLogsZipPath, zout, buffer);
                    continue block2;
                }
            }
            zout.close();
            return result;
        }
        catch (Exception e) {
            TRACER.traceThrowableT(500, "Failed to create archive file \"" + archiveFileName + "\"!", (Throwable)e);
            return "Failed to create archive file \"" + archiveFileName + "\" due to: " + e;
        }
    }

    private static String addToZip(FileLog dst, String zipEntryPrefix, ZipOutputStream zout, byte[] buffer) {
        String result = "";
        List fileNames = dst.calculateFileNames();
        int i = fileNames.size();
        while (--i >= 0) {
            String fileName = (String)fileNames.get(i);
            try {
                File f = new File(fileName);
                if (f.length() == 0L) continue;
                FileInputStream in = new FileInputStream(f);
                zout.putNextEntry(new ZipEntry(zipEntryPrefix + f.getPath()));
                int bytesRead = 0;
                while ((bytesRead = in.read(buffer)) != -1) {
                    zout.write(buffer, 0, bytesRead);
                }
                in.close();
            }
            catch (Exception e) {
                TRACER.traceThrowableT(500, "Failed to archive \"" + fileName + "\" file!", (Throwable)e);
                result = result + "Failed to archive \"" + fileName + "\" file due to: " + e + "\n";
            }
        }
        return result;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] readFromFile(String fileName, long offset, int length) {
        block11: {
            block10: {
                in = null;
                try {
                    try {
                        in = new FileInputStream(fileName);
                        in.skip(offset);
                        buffer = new byte[length];
                        readed = in.read(buffer);
                        if (readed != length) {
                            result = new byte[readed];
                            System.arraycopy(buffer, 0, result, 0, readed);
                            var9_11 = result;
                            var11_12 = null;
                            break block10;
                        }
                        var8_10 = buffer;
                        break block11;
                    }
                    catch (Exception e) {
                        var7_8 = null;
                        var11_14 = null;
                        try {
                            in.close();
                            return var7_8;
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        return var7_8;
                    }
                }
                catch (Throwable var10_20) {
                    var11_15 = null;
                    try {}
                    catch (IOException e) {
                        throw var10_20;
                    }
                    in.close();
                    throw var10_20;
                }
            }
            ** try [egrp 2[TRYBLOCK] [2 : 100->108)] { 
lbl39:
            // 1 sources

            in.close();
            return var9_11;
lbl41:
            // 1 sources

            catch (IOException e) {
                // empty catch block
            }
            return var9_11;
        }
        var11_13 = null;
        ** try [egrp 2[TRYBLOCK] [2 : 100->108)] { 
lbl47:
        // 1 sources

        in.close();
        return var8_10;
lbl49:
        // 1 sources

        catch (IOException e) {
            // empty catch block
        }
        return var8_10;
    }

    public void deleteArchive(String fileName) {
        new File(fileName).delete();
    }

    public void setState(byte state, String parent, String[] descriptorNames) {
        int i = descriptorNames.length;
        while (--i >= 0) {
            LogControllerDescriptor currentDescriptor = this.mainConfiguration.getLogController(descriptorNames[i]);
            currentDescriptor.setState(state);
            currentDescriptor.setStateOwner(parent);
            switch (state) {
                case -1: {
                    if (descriptorNames[i].startsWith("/")) {
                        Category.getCategory((String)descriptorNames[i]).setEffectiveSeverity(701);
                        break;
                    }
                    Location.getLocation((String)descriptorNames[i]).setEffectiveSeverity(701);
                    break;
                }
                case 1: {
                    if (descriptorNames[i].startsWith("/")) {
                        Category.getCategory((String)descriptorNames[i]).setEffectiveSeverity(0);
                        break;
                    }
                    Location.getLocation((String)descriptorNames[i]).setEffectiveSeverity(0);
                    break;
                }
                case 0: {
                    if (descriptorNames[i].startsWith("/")) {
                        Category c = Category.getCategory((String)descriptorNames[i]);
                        c.setMinimumSeverity(currentDescriptor.getMinSeverityInt());
                        c.setMaximumSeverity(currentDescriptor.getMaxSeverityInt());
                        break;
                    }
                    Location l = Location.getLocation((String)descriptorNames[i]);
                    l.setMinimumSeverity(currentDescriptor.getMinSeverityInt());
                    l.setMaximumSeverity(currentDescriptor.getMaxSeverityInt());
                }
            }
        }
        HashMapIntObject hashMapIntObject = this.listeners;
        synchronized (hashMapIntObject) {
            EnumerationInt listenersKeys = this.listeners.keys();
            Enumeration elements = this.listeners.elements();
            while (elements.hasMoreElements()) {
                try {
                    ((LogConfiguratorListener)elements.nextElement()).stateChanged(state, parent, descriptorNames);
                    listenersKeys.nextElement();
                }
                catch (RemoteException rexc) {
                    this.listeners.remove(listenersKeys.nextElement());
                }
            }
        }
    }

    public String[] getArchiveFileNames(String logFilePattern) {
        return this.archivator.getArchiveFileNames(logFilePattern);
    }

    public long getTotalArchiveSize() {
        return this.archivator.getArchivesSize();
    }

    public long getTotalFileSize() {
        long size = 0L;
        String[] fileNames = this.getPhysicalNames();
        int i = fileNames.length;
        while (--i >= 0) {
            size += this.getFileSize(fileNames[i]);
        }
        return size / 1024L;
    }

    public String getArchiveLogDirectory() {
        return this.archivator.getArchiveLogDirectory();
    }

    public static String[] getArchiveFileNames(String archiveLogDirectory, String pattern) {
        return com.sap.engine.services.log_configurator.archive.Archivator.getArchiveFileNames(archiveLogDirectory, pattern);
    }

    public synchronized void receive(int clusterId, int messageType, byte[] body, int offset, int length) {
        switch (messageType) {
            case 2: {
                try {
                    this.getDefaultConfiguration(true, true, false);
                }
                catch (Exception exc) {
                    TRACER.traceThrowableT(500, "Failed to fulfil \"reset to default configuration\" request coming from cluster node with ID " + clusterId + "!", (Throwable)exc);
                }
                return;
            }
            case 1: {
                try {
                    LogConfiguration[] receivedCfg = this.deserialize(body, offset, length);
                    this.applyConfiguration(receivedCfg[0], receivedCfg[1]);
                }
                catch (Exception exc) {
                    TRACER.traceThrowableT(500, "Failed to fulfil \"apply configuration\" request coming from cluster node with ID " + clusterId + "!", (Throwable)exc);
                }
                return;
            }
            case 0: {
                try {
                    LogConfiguration[] receivedCfg = this.deserialize(body, offset, length);
                    this.applyAndStoreConfiguration(receivedCfg[0], receivedCfg[1]);
                }
                catch (Exception exc) {
                    TRACER.traceThrowableT(500, "Failed to fulfil \"persistently apply configuration\" request coming from cluster node with ID " + clusterId + "!", (Throwable)exc);
                }
                return;
            }
        }
    }

    public MessageAnswer receiveWait(int clusterId, int messageType, byte[] body, int offset, int length) throws Exception {
        return new MessageAnswer();
    }

    private byte[] serialize(LogConfiguration newSettings, LogConfiguration removedSettings) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(new LogConfiguration[]{newSettings, removedSettings});
        oos.flush();
        oos.close();
        return baos.toByteArray();
    }

    private LogConfiguration[] deserialize(byte[] data, int offset, int length) throws Exception {
        return (LogConfiguration[])new ObjectInputStream(new ByteArrayInputStream(data, offset, length)).readObject();
    }

    public byte getClusterNodeType() {
        return this.clusterNodeType;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

