/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.log_configurator;

import com.sap.engine.frame.ServiceContext;
import com.sap.engine.frame.core.thread.ThreadSystem;
import com.sap.engine.services.log_configurator.ArchiveThread;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.OverwriteLogfileEvent;
import com.sap.tc.logging.OverwriteLogfileListener;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Date;
import java.util.Iterator;

public class OverwriteLogfileListenerImpl
implements OverwriteLogfileListener {
    private static final Location CLASS_LOCATION = Location.getLocation((Class)(class$com$sap$engine$services$log_configurator$OverwriteLogfileListenerImpl == null ? (class$com$sap$engine$services$log_configurator$OverwriteLogfileListenerImpl = OverwriteLogfileListenerImpl.class$("com.sap.engine.services.log_configurator.OverwriteLogfileListenerImpl")) : class$com$sap$engine$services$log_configurator$OverwriteLogfileListenerImpl));
    private static final String PROPERTY_NAME_ENABLED = "ArchiveOldLogFiles";
    private static final String PROPERTY_DIR_NAME = "ArchivesDirectory";
    private String dirName;
    private boolean enabled;
    private ServiceContext sc;
    static /* synthetic */ Class class$com$sap$engine$services$log_configurator$OverwriteLogfileListenerImpl;

    public OverwriteLogfileListenerImpl(ServiceContext sc) {
        String enabledStr;
        this.sc = sc;
        this.dirName = sc.getServiceState().getProperty(PROPERTY_DIR_NAME, "./log/archive");
        new File(this.dirName).mkdirs();
        if (!this.dirName.endsWith("/") && !this.dirName.endsWith("\\")) {
            this.dirName = this.dirName + '/';
        }
        this.enabled = (enabledStr = sc.getServiceState().getProperty(PROPERTY_NAME_ENABLED, "ON")).equalsIgnoreCase("ON") || enabledStr.equalsIgnoreCase("YES") || enabledStr.equalsIgnoreCase("TRUE");
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void handleEvent(OverwriteLogfileEvent evt) {
        if (!this.enabled) {
            CLASS_LOCATION.logT(400, "The information from file log '" + evt.getFileName() + "' will be lost - archiving old file logs is disabled.");
            return;
        }
        String[] fileNames = new String[evt.getFileCnt()];
        Iterator fileNamesIterator = evt.getFileLog().calculateFileNames().iterator();
        String time = "." + new Date(System.currentTimeMillis()).toString().replace(':', '.').replace(' ', '_');
        long[] fileTimes = new long[evt.getFileCnt()];
        int i = 0;
        while (i < fileNames.length) {
            fileNames[i] = (String)fileNamesIterator.next();
            File currentFile = new File(fileNames[i]);
            fileTimes[i] = currentFile.lastModified();
            fileNames[i] = this.patternToFileName(fileNames[i]);
            String newLogFileName = fileNames[i] + '.' + fileTimes[i];
            fileNames[i] = currentFile.renameTo(new File(newLogFileName)) ? newLogFileName : null;
            ++i;
        }
        ArchiveThread at = new ArchiveThread(fileNames, this.dirName + evt.getFileLog().getPattern().replace(':', '_').replace('/', '_') + time + ".zip", fileTimes);
        ThreadSystem threadSystem = this.sc.getCoreContext().getThreadSystem();
        threadSystem.startThread((Runnable)at, true);
    }

    private String patternToFileName(String pattern) {
        return pattern.replace(':', '_').replace('/', '_').replace('\\', '_');
    }

    public String[] getAllArchives(String pattern) {
        String[] result = new File(this.dirName).list(new ArchivesFilter(this.patternToFileName(pattern)));
        int i = 0;
        while (i < result.length) {
            result[i] = this.dirName + result[i];
            ++i;
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class ArchivesFilter
    implements FilenameFilter {
        String pattern;

        public ArchivesFilter(String pattern) {
            this.pattern = pattern;
        }

        public boolean accept(File dir, String name) {
            return name.indexOf(this.pattern) != -1 && name.endsWith(".zip");
        }
    }
}

