/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.log_configurator;

import com.sap.engine.lib.util.ArrayInt;
import com.sap.engine.lib.util.HashMapIntObject;
import com.sap.tc.logging.FileLog;
import com.sap.tc.logging.Log;
import com.sap.tc.logging.LogRecord;
import java.io.IOException;
import java.util.Enumeration;

public class MultiFileLog
extends Log {
    private HashMapIntObject logs;
    private String zipDirectory = null;

    public MultiFileLog(String zipDirectory) {
        this.zipDirectory = zipDirectory;
        this.removeFilters();
        this.setEffectiveSeverity(0);
        this.logs = new HashMapIntObject();
    }

    public String getEncoding() {
        return null;
    }

    public void setEncoding(String encoding) {
    }

    protected void closeInt() throws IOException {
    }

    protected void flushInt() throws IOException {
    }

    protected void writeInt(String s) throws IOException {
    }

    public void close() {
    }

    public void flush() {
        Enumeration e = this.logs.elements();
        while (e.hasMoreElements()) {
            ((Log)e.nextElement()).flush();
        }
    }

    public LogRecord write(LogRecord record) {
        Log log = (Log)this.logs.get(record.getSeverity() % 100);
        if (log == null) {
            return null;
        }
        return log.write(record);
    }

    public void addLog(int level, Log log) {
        if (log != null) {
            this.logs.put(level, (Object)log);
        }
    }

    public Log getLog(int level) {
        return (Log)this.logs.get(level);
    }

    public FileLog getFileLog(int level) {
        return (FileLog)this.logs.get(level);
    }

    public void removeLog(int level) {
        this.logs.remove(level);
    }

    public void removeAllLogs() {
        this.logs.clear();
    }

    public String getZipDirectory() {
        return this.zipDirectory;
    }

    public int[] removeFileLogLevels(FileLog fileLog) {
        ArrayInt result = new ArrayInt();
        int[] levels = this.logs.getAllKeys();
        int i = 0;
        while (i < levels.length) {
            if (((FileLog)this.logs.get(levels[i])).equals((Object)fileLog)) {
                result.addElement(levels[i]);
                this.removeLog(levels[i]);
            }
            ++i;
        }
        if (result.size() == 0) {
            return null;
        }
        return result.toArray();
    }
}

