/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.model.web.impl;

import com.tssap.j2ee.core.providers.web.WebModelMetaInfo;
import com.tssap.j2ee.core.utils.FileUtils;
import com.tssap.j2ee.model.IJ2eeProject;
import com.tssap.j2ee.model.J2eeCreateException;
import com.tssap.j2ee.model.impl.J2EEProject;
import com.tssap.j2ee.model.web.IClientSource;
import com.tssap.j2ee.model.web.IFilter;
import com.tssap.j2ee.model.web.IFilterCreationData;
import com.tssap.j2ee.model.web.IHtmlFile;
import com.tssap.j2ee.model.web.IHtmlFileCreationData;
import com.tssap.j2ee.model.web.IJsp;
import com.tssap.j2ee.model.web.IJspCreationData;
import com.tssap.j2ee.model.web.IListener;
import com.tssap.j2ee.model.web.IListenerCreationData;
import com.tssap.j2ee.model.web.IResource;
import com.tssap.j2ee.model.web.IServerSource;
import com.tssap.j2ee.model.web.IWebProject;
import com.tssap.j2ee.model.web.impl.Filter;
import com.tssap.j2ee.model.web.impl.HtmlFile;
import com.tssap.j2ee.model.web.impl.Jsp;
import com.tssap.j2ee.model.web.impl.Listener;
import com.tssap.j2ee.model.web.impl.Resource;
import com.tssap.j2ee.model.web.impl.ServerSource;
import com.tssap.j2ee.model.web.servlet.IServlet;
import com.tssap.j2ee.model.web.servlet.IServletCreationData;
import com.tssap.j2ee.model.web.servlet.impl.Servlet;
import com.tssap.j2ee.util.core.CompConstants;
import com.tssap.j2ee.util.file.FileUtil;
import com.tssap.selena.internal.core.providers.java.NameUtil;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.ReferenceEnumeration;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IPackageFragment;

public class WebProject
extends J2EEProject
implements IWebProject {
    private static final TracerI TRACER = TracingManager.getTracer((Class)(class$com$tssap$j2ee$model$web$impl$WebProject == null ? (class$com$tssap$j2ee$model$web$impl$WebProject = WebProject.class$("com.tssap.j2ee.model.web.impl.WebProject")) : class$com$tssap$j2ee$model$web$impl$WebProject));
    private IServerSource[] cachedServerSources = null;
    private IClientSource[] cachedClientSources = null;
    static /* synthetic */ Class class$com$tssap$j2ee$model$web$impl$WebProject;

    public WebProject(IProject prj) {
        super(prj, 3);
    }

    public IServerSource[] getServerSources() {
        if (this.cachedServerSources != null) {
            return this.cachedServerSources;
        }
        IServerSource[] ret = new IServerSource[]{};
        ArrayList<IServerSource> array = new ArrayList<IServerSource>();
        array.addAll(Arrays.asList(this.getServerSources(1)));
        array.addAll(Arrays.asList(this.getServerSources(2)));
        array.addAll(Arrays.asList(this.getServerSources(3)));
        if (!array.isEmpty()) {
            ret = array.toArray(ret);
        }
        if (this.isCaching()) {
            this.cachedServerSources = ret;
        }
        return ret;
    }

    public IServerSource[] getServerSources(int type) {
        UniqueName registryUIN;
        Model model = this.getModel();
        switch (type) {
            case 1: {
                registryUIN = WebModelMetaInfo.FILTER_REGISTRY;
                break;
            }
            case 2: {
                registryUIN = WebModelMetaInfo.LISTENER_REGISTRY;
                break;
            }
            case 3: {
                registryUIN = WebModelMetaInfo.SERVLET_REGISTRY;
                break;
            }
            default: {
                throw new IllegalStateException("Asked for ServerSources of unknown type: " + type);
            }
        }
        ReferenceCollection registry = model.findReferenceCollection(registryUIN);
        if (registry == null) {
            return new IServerSource[0];
        }
        ReferenceEnumeration refs = registry.references();
        ArrayList<Filter> array = new ArrayList<Filter>();
        while (refs.hasMoreElements()) {
            ServerSource source;
            Reference ref = refs.next();
            Entity ent = ref.getEntity();
            switch (type) {
                case 1: {
                    source = new Filter(ent);
                    break;
                }
                case 2: {
                    int listenerType;
                    if ("com.tssap.j2ee.core.web.HttpSessionAttributeListener".equals(ent.getPropertyValue("$metaclass"))) {
                        listenerType = 0;
                    } else if ("com.tssap.j2ee.core.web.HttpSessionListener".equals(ent.getPropertyValue("$metaclass"))) {
                        listenerType = 1;
                    } else if ("com.tssap.j2ee.core.web.ServletContextAttributeListener".equals(ent.getPropertyValue("$metaclass"))) {
                        listenerType = 2;
                    } else if ("com.tssap.j2ee.core.web.ServletContextListener".equals(ent.getPropertyValue("$metaclass"))) {
                        listenerType = 3;
                    } else if ("com.tssap.j2ee.core.web.HttpSessionActivationListener".equals(ent.getPropertyValue("$metaclass"))) {
                        listenerType = 5;
                    } else if ("com.tssap.j2ee.core.web.HttpSessionBindingListener".equals(ent.getPropertyValue("$metaclass"))) {
                        listenerType = 4;
                    } else {
                        throw new IllegalStateException("In Listener registry found object of unknown listener listenerType: " + ent.getPropertyValue("$metaclass"));
                    }
                    source = new Listener(ent, listenerType);
                    break;
                }
                case 3: {
                    source = new Servlet(ent);
                    break;
                }
                default: {
                    throw new IllegalStateException("Asked for ServerSources of unknown type: " + type);
                }
            }
            array.add((Filter)source);
        }
        IServerSource[] result = new IServerSource[array.size()];
        if (!array.isEmpty()) {
            result = array.toArray(result);
        }
        return result;
    }

    public IServerSource getServerSource(String name) {
        IServerSource[] all = this.getServerSources();
        int i = 0;
        while (i < all.length) {
            IServerSource iServerSource = all[i];
            if (name.equals(iServerSource.getName())) {
                return iServerSource;
            }
            ++i;
        }
        return null;
    }

    public IClientSource[] getClientSources() throws Exception {
        if (this.cachedClientSources != null) {
            return this.cachedClientSources;
        }
        IClientSource[] ret = new IClientSource[]{};
        ArrayList<IClientSource> array = new ArrayList<IClientSource>();
        array.addAll(Arrays.asList(this.getClientSources(11)));
        array.addAll(Arrays.asList(this.getClientSources(10)));
        array.addAll(Arrays.asList(this.getClientSources(12)));
        if (!array.isEmpty()) {
            ret = array.toArray(ret);
        }
        if (this.isCaching()) {
            this.cachedClientSources = ret;
        }
        return ret;
    }

    public IClientSource[] getClientSources(int type) throws Exception {
        ArrayList array = new ArrayList();
        switch (type) {
            case 10: {
                array = this.getJspsByUIN();
                break;
            }
            case 11: {
                ArrayList htmls = new ArrayList();
                IFolder folder = this.getProject().getFolder("webContent");
                if (folder == null || !folder.exists()) {
                    return new IClientSource[0];
                }
                FileUtil.getIterativFilesToFolder((IFolder)folder, htmls);
                Iterator it = ((AbstractList)htmls).iterator();
                while (it.hasNext()) {
                    Object res = it.next();
                    if (!(res instanceof IFile) || !this.hasHTMLExtension((IFile)res)) continue;
                    array.add(new HtmlFile((IFile)res));
                }
                break;
            }
            case 12: {
                IFolder folder = this.getProject().getFolder("webContent");
                if (folder == null || !folder.exists()) {
                    return new IClientSource[0];
                }
                ArrayList resources = new ArrayList();
                FileUtil.getIterativFilesToFolder((IFolder)folder, resources);
                Iterator it = ((AbstractList)resources).iterator();
                while (it.hasNext()) {
                    IFile tmpFile = (IFile)it.next();
                    if (this.hasHTMLExtension(tmpFile) || "jsp".equalsIgnoreCase(tmpFile.getFileExtension())) continue;
                    array.add(this.createResource(tmpFile));
                }
                break;
            }
            default: {
                throw new IllegalStateException("Asked for ClientSources of unknown type: " + type);
            }
        }
        IClientSource[] result = new IClientSource[array.size()];
        if (!array.isEmpty()) {
            result = array.toArray(result);
        }
        return result;
    }

    private boolean hasHTMLExtension(IFile file) {
        String ext = file.getFileExtension();
        return ext != null && (ext.equalsIgnoreCase("html") || ext.equalsIgnoreCase("htm") || ext.equalsIgnoreCase("xhtml") || ext.equalsIgnoreCase("xhtm"));
    }

    public IClientSource getClientSource(String name) throws Exception {
        IClientSource[] all = this.getClientSources();
        int i = 0;
        while (i < all.length) {
            IClientSource iClientSource = all[i];
            if (name.equals(iClientSource.getName())) {
                return iClientSource;
            }
            ++i;
        }
        return null;
    }

    public IJsp createJsp(IJspCreationData jspsource) throws J2eeCreateException {
        Model model = this.getModel();
        Entity template = model.createEntityTemplate();
        template.setPropertyValue("$file", jspsource.getJspFileName());
        if (!model.canCreateChildEntity("com.tssap.j2ee.core.web.JSP", template)) {
            throw new J2eeCreateException("Creation of JSP was rejected by Selena provider - canCreate returned 'false'");
        }
        Entity result = model.createChildEntity("com.tssap.j2ee.core.web.JSP", template);
        if (result == null) {
            throw new J2eeCreateException("Creation error of JSP: result is null");
        }
        return new Jsp(result);
    }

    public IServlet createServlet(IServletCreationData servletSource) throws J2eeCreateException {
        Model model = this.getModel();
        Entity template = model.createEntityTemplate();
        template.setPropertyValue("$name", servletSource.getServletName());
        if (servletSource.getServletType() == 1) {
            template.setPropertyValue("httpServlet", Boolean.TRUE.toString());
        }
        if (servletSource.getInitMethod()) {
            template.setPropertyValue("init", Boolean.TRUE.toString());
        }
        if (servletSource.getDestroyMethod()) {
            template.setPropertyValue("destroy", Boolean.TRUE.toString());
        }
        if (servletSource.useSingleThreadModel()) {
            template.setPropertyValue("singleThreaded", Boolean.TRUE.toString());
        }
        if (servletSource.getDoDeleteMethod()) {
            template.setPropertyValue("doDelete", Boolean.TRUE.toString());
        }
        if (servletSource.getDoGetMethod()) {
            template.setPropertyValue("doGet", Boolean.TRUE.toString());
        }
        if (servletSource.getDoHeadMethod()) {
            template.setPropertyValue("doHead", Boolean.TRUE.toString());
        }
        if (servletSource.getDoOptionsMethod()) {
            template.setPropertyValue("doOptions", Boolean.TRUE.toString());
        }
        if (servletSource.getDoPostMethod()) {
            template.setPropertyValue("doPost", Boolean.TRUE.toString());
        }
        if (servletSource.getDoPutMethod()) {
            template.setPropertyValue("doPut", Boolean.TRUE.toString());
        }
        if (servletSource.getDoTraceMethod()) {
            template.setPropertyValue("doTrace", Boolean.TRUE.toString());
        }
        if (servletSource.getServletPackage() == null) {
            throw new J2eeCreateException("PackageFragment is not specified");
        }
        UniqueName packageName = NameUtil.getPackageUniqueName((IPackageFragment)servletSource.getServletPackage());
        Entity packageEntity = model.findEntity(packageName);
        if (packageEntity == null) {
            throw new J2eeCreateException("Unable to find package for the servlet");
        }
        if (!packageEntity.canCreateChildEntity("com.tssap.j2ee.core.web.Servlet", template)) {
            throw new J2eeCreateException("Creation of Servlet was rejected by Selena provider - canCreate returned 'false'");
        }
        Entity result = packageEntity.createChildEntity("com.tssap.j2ee.core.web.Servlet", template);
        if (result == null) {
            throw new J2eeCreateException("Creation error of Servlet: result is null");
        }
        return new Servlet(result);
    }

    public IListener createListener(IListenerCreationData listenerSource) throws J2eeCreateException {
        String metaclass;
        Model model = this.getModel();
        Entity template = model.createEntityTemplate();
        template.setPropertyValue("$name", listenerSource.getListenerClassName());
        template.setPropertyValue("baseClass", listenerSource.getListenerSuperClass());
        if (listenerSource.getListenerPackage() == null) {
            throw new J2eeCreateException("PackageFragment is not specified");
        }
        UniqueName packageName = NameUtil.getPackageUniqueName((IPackageFragment)listenerSource.getListenerPackage());
        Entity packageEntity = model.findEntity(packageName);
        if (packageEntity == null) {
            throw new J2eeCreateException("Unable to find package for the listener");
        }
        switch (listenerSource.getListenerType()) {
            case 1: {
                metaclass = "com.tssap.j2ee.core.web.HttpSessionListener";
                break;
            }
            case 0: {
                metaclass = "com.tssap.j2ee.core.web.HttpSessionAttributeListener";
                break;
            }
            case 3: {
                metaclass = "com.tssap.j2ee.core.web.ServletContextListener";
                break;
            }
            case 2: {
                metaclass = "com.tssap.j2ee.core.web.ServletContextAttributeListener";
                break;
            }
            case 5: {
                metaclass = "com.tssap.j2ee.core.web.HttpSessionActivationListener";
                break;
            }
            case 4: {
                metaclass = "com.tssap.j2ee.core.web.HttpSessionBindingListener";
                break;
            }
            default: {
                metaclass = "garbage";
            }
        }
        if (!packageEntity.canCreateChildEntity(metaclass, template)) {
            throw new J2eeCreateException("Creation of Listener was rejected by Selena provider - canCreate returned 'false'");
        }
        Entity result = packageEntity.createChildEntity(metaclass, template);
        if (result == null) {
            throw new J2eeCreateException("Creation error of Listner: result is null");
        }
        return new Listener(result, listenerSource.getListenerType());
    }

    public IFilter createFilter(IFilterCreationData filterSource) throws J2eeCreateException {
        Model model = this.getModel();
        Entity template = model.createEntityTemplate();
        template.setPropertyValue("$name", filterSource.getFilterClassName());
        template.setPropertyValue("baseClass", filterSource.getFilterSuperClass());
        if (filterSource.getFilterPackage() == null) {
            throw new J2eeCreateException("PackageFragment is not specified");
        }
        UniqueName packageName = NameUtil.getPackageUniqueName((IPackageFragment)filterSource.getFilterPackage());
        Entity packageEntity = model.findEntity(packageName);
        if (packageEntity == null) {
            throw new J2eeCreateException("Unable to find package for the filter");
        }
        if (!packageEntity.canCreateChildEntity("com.tssap.j2ee.core.web.Filter", template)) {
            throw new J2eeCreateException("Creation of Filter was rejected by Selena provider - canCreate returned 'false'");
        }
        Entity result = packageEntity.createChildEntity("com.tssap.j2ee.core.web.Filter", template);
        if (result == null) {
            throw new J2eeCreateException("Creation error of Filter: result is null");
        }
        return new Filter(result);
    }

    public IResource createResource(IFile file) {
        return new Resource(file);
    }

    public IHtmlFile createHtmlFile(IHtmlFileCreationData htmlSource) throws J2eeCreateException {
        IPath containerPath = htmlSource.getHtmlLocationFolder();
        String html = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">\n\r<HTML>\n\r<HEAD>\n\r<TITLE> New Document </TITLE>\n\r<META NAME=\"Generator\" CONTENT=\"TSSAP HTML Generator\">\n\r<META NAME=\"Author\" CONTENT=\"\">\n\r<META NAME=\"Keywords\" CONTENT=\"\">\n\r<META NAME=\"Description\" CONTENT=\"\">\n\r</HEAD>\n\r<BODY BGCOLOR=\"#FFFFFF\">\n\r</BODY>\n\r</HTML>";
        StringBufferInputStream is = new StringBufferInputStream(html);
        IFile newFile = null;
        try {
            newFile = FileUtils.createFile((IPath)containerPath, (String)htmlSource.getHtmlFileName(), (InputStream)is, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            if (e.getStatus().getCode() == 374) {
                throw new J2eeCreateException("Creation error of HTML File: File with this name already exists!", e);
            }
            TRACER.warning("Creation of html file failed", (Throwable)e);
        }
        if (newFile == null) {
            throw new J2eeCreateException("Creation error of HTML File: result is null");
        }
        return new HtmlFile(newFile);
    }

    public IJ2eeProject[] getReferencingProjects(int type) {
        System.err.println("WebProject:getReferencingProjects(type) - is not implemented yet");
        return null;
    }

    private ArrayList getJspsByUIN() {
        Model model = this.getModel();
        UniqueName registryUIN = WebModelMetaInfo.JSP_REGISTRY;
        ArrayList<Jsp> array = new ArrayList<Jsp>();
        ReferenceCollection registry = model.findReferenceCollection(registryUIN);
        if (registry == null) {
            return array;
        }
        ReferenceEnumeration refs = registry.references();
        while (refs.hasMoreElements()) {
            Reference ref = refs.next();
            Entity ent = ref.getEntity();
            Jsp source = new Jsp(ent);
            array.add(source);
        }
        return array;
    }

    public IFile getDefAssemblyPublicPart() {
        IFile ppFile = this.getProject().getFile(CompConstants.APP_WEBMODULE_FILE);
        if (ppFile != null && ppFile.exists()) {
            return ppFile;
        }
        return null;
    }

    public String getDefAssemblyPublicPartName() {
        return "war";
    }

    public void clearCache() {
        super.clearCache();
        this.cachedClientSources = null;
        this.cachedServerSources = null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

