/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.model.web.impl;

import com.tssap.j2ee.model.DeleteFailedException;
import com.tssap.j2ee.model.J2eeProjectManager;
import com.tssap.j2ee.model.web.IResource;
import com.tssap.j2ee.model.web.IWebProject;
import com.tssap.j2ee.model.web.impl.ClientSource;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.extension.filefolder.FileAndFolderManagement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class Resource
extends ClientSource
implements IResource {
    private IFile resFile;

    public Resource(Entity file) {
        super(file);
        this.resFile = this.retrieveFileFromEntity(file);
    }

    public Resource(IFile file) {
        super(null);
        this.resFile = file;
    }

    public IFile getFile() {
        return this.resFile;
    }

    public int getType() {
        return 12;
    }

    public void delete() throws DeleteFailedException {
        try {
            this.resFile.delete(true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            throw new DeleteFailedException("Can't delete Resource: " + e.getMessage());
        }
    }

    public String getName() {
        return this.resFile.getName();
    }

    public IWebProject getProject() {
        return J2eeProjectManager.getWebModule(this.resFile.getProject());
    }

    public void setDefaultName(String name) {
        System.err.println("Resource:setDefaultName(name) - is not implemented yet");
    }

    private IFile retrieveFileFromEntity(Entity entity) {
        Object dataSource = FileAndFolderManagement.getInstance().getDataSource(entity.getUniqueName());
        if (dataSource instanceof IFile) {
            return (IFile)dataSource;
        }
        return null;
    }
}

