/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.model.web.impl;

import com.tssap.j2ee.model.DeleteFailedException;
import com.tssap.j2ee.model.J2eeProjectManager;
import com.tssap.j2ee.model.web.IHtmlFile;
import com.tssap.j2ee.model.web.IWebProject;
import com.tssap.j2ee.model.web.impl.ClientSource;
import com.tssap.selena.model.elements.Entity;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class HtmlFile
extends ClientSource
implements IHtmlFile {
    private IFile htmlFile;

    public HtmlFile(Entity file) {
        super(file);
        this.htmlFile = HtmlFile.retrieveFileFromEntity(file);
    }

    public HtmlFile(IFile file) {
        super(null);
        this.htmlFile = file;
    }

    public IFile getFile() {
        if (this.htmlFile == null) {
            this.htmlFile = HtmlFile.retrieveFileFromEntity(this.getSelenaEntity());
        }
        return this.htmlFile;
    }

    public int getType() {
        return 11;
    }

    public void delete() throws DeleteFailedException {
        try {
            this.getFile().delete(true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            throw new DeleteFailedException("Can't delete HTML: " + e.getMessage());
        }
    }

    public String getName() {
        return this.getFile().getName();
    }

    public IWebProject getProject() {
        return J2eeProjectManager.getWebModule(this.getFile().getProject());
    }

    public void setDefaultName(String name) {
        System.err.println("HtmlFile:setDefaultName(name) - is not implemented yet");
    }

    private static IFile retrieveFileFromEntity(Entity entity) {
        Object dataSource = entity.getObjectPropertyValue("FileAndFolderDataSource");
        if (dataSource instanceof IFile) {
            return (IFile)dataSource;
        }
        return null;
    }
}

